/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.qom;

import java.util.List;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Ordering;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.jcr.api.query.qom.Limit;
import org.modeshape.jcr.query.qom.JcrColumn;
import org.modeshape.jcr.query.qom.JcrLimit;
import org.modeshape.jcr.query.qom.JcrOrdering;
import org.modeshape.jcr.query.qom.JcrQueryCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrSetQuery
extends SetQuery
implements org.modeshape.jcr.api.query.qom.SetQuery,
JcrQueryCommand {
    private static final long serialVersionUID = 1L;

    public JcrSetQuery(JcrQueryCommand left, SetQuery.Operation operation, JcrQueryCommand right, boolean all) {
        super((QueryCommand)left, operation, (QueryCommand)right, all, null, (org.modeshape.graph.query.model.Limit)JcrLimit.NONE);
    }

    public JcrSetQuery(JcrQueryCommand left, SetQuery.Operation operation, JcrQueryCommand right, boolean all, List<? extends JcrOrdering> orderings, JcrLimit limit) {
        super((QueryCommand)left, operation, (QueryCommand)right, all, orderings, (org.modeshape.graph.query.model.Limit)(limit != null ? limit : JcrLimit.NONE));
    }

    public JcrQueryCommand left() {
        return (JcrQueryCommand)super.left();
    }

    public List<? extends JcrColumn> columns() {
        return super.columns();
    }

    public List<? extends JcrOrdering> orderings() {
        return super.orderings();
    }

    public JcrQueryCommand right() {
        return (JcrQueryCommand)super.right();
    }

    public JcrLimit limits() {
        return (JcrLimit)super.limits();
    }

    public Limit getLimits() {
        return this.limits();
    }

    public JcrQueryCommand getLeft() {
        return this.left();
    }

    public JcrQueryCommand getRight() {
        return this.right();
    }

    public String getOperation() {
        switch (this.operation()) {
            case UNION: {
                return "jcr.set.type.union";
            }
            case INTERSECT: {
                return "jcr.set.type.intersect";
            }
            case EXCEPT: {
                return "jcr.set.type.except";
            }
        }
        assert (false);
        return null;
    }

    public Column[] getColumns() {
        List<? extends JcrColumn> columns = this.columns();
        return columns.toArray(new Column[columns.size()]);
    }

    public Ordering[] getOrderings() {
        List<? extends JcrOrdering> orderings = this.orderings();
        return orderings.toArray(new Ordering[orderings.size()]);
    }

    public JcrSetQuery withLimit(int rowLimit) {
        if (this.limits().rowLimit() == rowLimit) {
            return this;
        }
        return new JcrSetQuery(this.left(), this.operation(), this.right(), this.isAll(), this.orderings(), this.limits().withRowLimit(rowLimit));
    }

    public JcrSetQuery withOffset(int offset) {
        if (this.limits().offset() == offset) {
            return this;
        }
        return new JcrSetQuery(this.left(), this.operation(), this.right(), this.isAll(), this.orderings(), this.limits().withOffset(offset));
    }
}

