/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.ValueFactory;

@NotThreadSafe
abstract class AbstractJcrProperty
extends AbstractJcrItem
implements javax.jcr.Property,
Comparable<javax.jcr.Property> {
    private final AbstractJcrNode node;
    private final Name name;
    private int propertyType;
    private volatile CachedDefinition cachedDefn;

    AbstractJcrProperty(AbstractJcrNode node, Name name, int propertyType) {
        super(node.session());
        assert (node != null);
        assert (name != null);
        this.node = node;
        this.name = name;
        this.propertyType = propertyType;
    }

    final void setPropertyDefinitionId(PropertyDefinitionId propDefnId, int nodeTypesVersion) {
        this.cachedDefn = new CachedDefinition(propDefnId, nodeTypesVersion);
    }

    final void releasePropertyDefinitionId() {
        this.cachedDefn = null;
    }

    final PropertyDefinitionId propertyDefinitionId() throws ItemNotFoundException, ConstraintViolationException, InvalidItemStateException {
        CachedDefinition defn = this.cachedDefn;
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            Name primaryType = this.node.getPrimaryTypeName();
            Set<Name> mixinTypes = this.node.getMixinTypeNames();
            PropertyDefinitionId id = this.node.propertyDefinitionFor(this.property(), primaryType, mixinTypes, nodeTypes).getId();
            this.setPropertyDefinitionId(id, nodeTypes.getVersion());
            return id;
        }
        return defn.propDefnId;
    }

    final JcrPropertyDefinition propertyDefinition() throws ItemNotFoundException, ConstraintViolationException, InvalidItemStateException {
        CachedDefinition defn = this.cachedDefn;
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            Name primaryType = this.node.getPrimaryTypeName();
            Set<Name> mixinTypes = this.node.getMixinTypeNames();
            JcrPropertyDefinition propDefn = this.node.propertyDefinitionFor(this.property(), primaryType, mixinTypes, nodeTypes);
            PropertyDefinitionId id = propDefn.getId();
            this.setPropertyDefinitionId(id, nodeTypes.getVersion());
            return propDefn;
        }
        return nodeTypes.getPropertyDefinition(defn.propDefnId);
    }

    final CachedNode cachedNode() throws ItemNotFoundException, InvalidItemStateException {
        return this.node.node();
    }

    final MutableCachedNode mutable() {
        return this.node.mutable();
    }

    final SessionCache sessionCache() {
        return this.node.sessionCache();
    }

    final PropertyFactory propertyFactory() {
        return this.node.session().propertyFactory();
    }

    final Property property() throws ItemNotFoundException, InvalidItemStateException {
        return this.cachedNode().getProperty(this.name, this.sessionCache());
    }

    final JcrValue createValue(Object value) {
        return new JcrValue(this.session().context().getValueFactories(), this.propertyType, value);
    }

    final JcrValue createValue(Object value, int propertyType) {
        return new JcrValue(this.session().context().getValueFactories(), this.propertyType, value);
    }

    public JcrSession getSession() {
        return this.node.getSession();
    }

    protected final void checkForLock() throws LockException, RepositoryException {
        Lock parentLock;
        if (this.getParent().isLocked() && !this.getParent().getLock().isLockOwningSession() && (parentLock = this.getParent().getLock()) != null && parentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.node.location()}));
        }
    }

    protected final void checkForCheckedOut() throws VersionException, RepositoryException {
        if (!this.node.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
    }

    public final void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull((Object)visitor, (String)"visitor");
        this.checkSession();
        visitor.visit((javax.jcr.Property)this);
    }

    final Name name() {
        return this.name;
    }

    @Override
    Path path() throws RepositoryException {
        return this.session().pathFactory().create(this.node.path(), this.name);
    }

    public int getType() throws RepositoryException {
        this.checkSession();
        return this.propertyType;
    }

    public final JcrPropertyDefinition getDefinition() throws RepositoryException {
        this.checkSession();
        return this.propertyDefinition();
    }

    public final String getName() {
        return this.name.getString(this.namespaces());
    }

    @Override
    public final AbstractJcrNode getParent() {
        return this.node;
    }

    public final String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    public final boolean isModified() {
        try {
            this.checkSession();
            CachedNode node = this.cachedNode();
            return node instanceof MutableCachedNode && ((MutableCachedNode)node).isPropertyModified(this.sessionCache(), this.name);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNew() {
        try {
            this.checkSession();
            CachedNode node = this.cachedNode();
            return node instanceof MutableCachedNode && ((MutableCachedNode)node).isPropertyNew(this.sessionCache(), this.name);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNode() {
        return false;
    }

    public final boolean isSame(Item otherItem) throws RepositoryException {
        this.checkSession();
        if (otherItem instanceof javax.jcr.Property) {
            javax.jcr.Property otherProperty = (javax.jcr.Property)otherItem;
            if (!this.getParent().isSame((Item)otherProperty.getParent())) {
                return false;
            }
            return this.getName().equals(otherProperty.getName());
        }
        return false;
    }

    public void refresh(boolean keepChanges) {
        throw new UnsupportedOperationException();
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        Lock parentLock;
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.session.checkPermission(this.path(), "remove");
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = parentNode.getLock()) != null && !parentLock.isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.getPath()}));
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
        this.node.removeProperty(this);
    }

    public abstract JcrValue[] getValues() throws ValueFormatException, RepositoryException;

    public abstract JcrValue getValue() throws ValueFormatException, RepositoryException;

    public void save() throws RepositoryException {
        this.checkSession();
        this.getParent().save();
    }

    @Override
    public int compareTo(javax.jcr.Property that) {
        if (that == this) {
            return 0;
        }
        try {
            return this.getName().compareTo(that.getName());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        ValueFactory<String> stringFactory = this.session().context().getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        try {
            Property property = this.cachedNode().getProperty(this.name, this.sessionCache());
            sb.append(this.getName()).append('=');
            if (this.isMultiple()) {
                sb.append('[');
                Iterator iter = property.iterator();
                if (iter.hasNext()) {
                    Object value = iter.next();
                    if (value instanceof Binary) {
                        sb.append("**binary-value-not-shown**");
                    } else {
                        sb.append(stringFactory.create(value));
                    }
                    if (iter.hasNext()) {
                        sb.append(',');
                    }
                }
                sb.append(']');
            } else {
                Object value = property.getFirstValue();
                if (value instanceof Binary) {
                    sb.append("**binary-value-not-shown**");
                } else {
                    sb.append(stringFactory.create(value));
                }
            }
        }
        catch (RepositoryException e) {
            sb.append(" on deleted node " + this.node.key());
        }
        return sb.toString();
    }

    @Immutable
    private static final class CachedDefinition {
        protected final PropertyDefinitionId propDefnId;
        protected final int nodeTypesVersion;

        protected CachedDefinition(PropertyDefinitionId propDefnId, int nodeTypesVersion) {
            this.propDefnId = propDefnId;
            this.nodeTypesVersion = nodeTypesVersion;
        }
    }
}

