/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;

@NotThreadSafe
final class JcrPropertyIterator
implements PropertyIterator {
    private final Iterator<? extends Property> iterator;
    private int ndx;
    private int size;

    JcrPropertyIterator(Collection<? extends Property> properties) {
        assert (properties != null);
        this.iterator = properties.iterator();
        this.size = properties.size();
    }

    public long getPosition() {
        return this.ndx;
    }

    public long getSize() {
        return this.size;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.nextProperty();
    }

    public Property nextProperty() {
        Property next = this.iterator.next();
        ++this.ndx;
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        CheckArg.isNonNegative((long)count, (String)"count");
        while (--count >= 0L) {
            this.nextProperty();
        }
    }
}

