/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Editor;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.document.Paths;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShape;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.Sequencers;
import org.modeshape.jcr.SequencingRunner;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.SystemContentInitializer;
import org.modeshape.jcr.SystemNamespaceRegistry;
import org.modeshape.jcr.TextExtractors;
import org.modeshape.jcr.api.AnonymousCredentials;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionCacheMonitor;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.query.parse.FullTextSearchParser;
import org.modeshape.jcr.query.parse.JcrQomQueryParser;
import org.modeshape.jcr.query.parse.JcrSql2QueryParser;
import org.modeshape.jcr.query.parse.JcrSqlQueryParser;
import org.modeshape.jcr.query.parse.QueryParsers;
import org.modeshape.jcr.query.xpath.XPathQueryParser;
import org.modeshape.jcr.security.AnonymousProvider;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.AuthenticationProviders;
import org.modeshape.jcr.security.JaasProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.InfinispanBinaryStore;
import org.modeshape.jcr.value.binary.UnusedBinaryChangeSetListener;

public class JcrRepository
implements Repository {
    protected static final Set<String> MISSING_JAAS_POLICIES = new CopyOnWriteArraySet<String>();
    private static final boolean AUTO_START_REPO_UPON_LOGIN = true;
    private static final String INTERNAL_WORKER_USERNAME = "<modeshape-worker>";
    protected final Logger logger;
    private final AtomicReference<RepositoryConfiguration> config = new AtomicReference();
    private final AtomicReference<String> repositoryName = new AtomicReference();
    private final Map<String, Object> descriptors;
    private final AtomicReference<RunningState> runningState = new AtomicReference();
    private final AtomicReference<JcrEngine.State> state = new AtomicReference<JcrEngine.State>(JcrEngine.State.NOT_RUNNING);
    private final Lock stateLock = new ReentrantLock();
    private final AtomicBoolean allowAutoStartDuringLogin = new AtomicBoolean(true);

    protected JcrRepository(RepositoryConfiguration configuration) throws ConfigurationException {
        ModeShape.getName();
        this.config.set(configuration);
        RepositoryConfiguration config = this.config.get();
        Problems results = configuration.validate();
        if (results.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, results.errorCount(), results.toString()});
            throw new ConfigurationException(results, msg);
        }
        this.repositoryName.set(config.getName());
        assert (this.config != null);
        assert (this.repositoryName != null);
        this.logger = Logger.getLogger(this.getClass());
        this.logger.debug("Initializing '{0}' repository", new Object[]{this.repositoryName});
        this.descriptors = new HashMap<String, Object>();
        this.initializeDescriptors();
    }

    RepositoryConfiguration repositoryConfiguration() {
        return this.config.get();
    }

    public JcrEngine.State getState() {
        return this.state.get();
    }

    public String getName() {
        return this.repositoryName.get();
    }

    public RepositoryStatistics getRepositoryStatistics() {
        return this.statistics();
    }

    void start() throws IOException, NamingException {
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Boolean> shutdown() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> future;
            Future<Boolean> future2 = future = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return JcrRepository.this.doShutdown();
                }
            });
            return future2;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Changes changes) throws IOException, NamingException {
        RepositoryConfiguration oldConfiguration = this.config.get();
        Editor copy = oldConfiguration.edit();
        ConfigurationChange configChanges = new ConfigurationChange();
        copy.apply(changes, (Editor.Observer)configChanges);
        try {
            this.stateLock.lock();
            RunningState oldState = this.runningState.get();
            this.config.set(new RepositoryConfiguration((Document)copy, copy.getString("name")));
            if (oldState != null) {
                assert (this.state.get() == JcrEngine.State.RUNNING);
                this.runningState.set(new RunningState(oldState, configChanges));
                if (!configChanges.storageChanged && configChanges.predefinedWorkspacesChanged) {
                    this.workspacesChanged();
                }
                if (configChanges.nameChanged) {
                    this.repositoryNameChanged();
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected final RunningState doStart() throws IOException, NamingException {
        try {
            this.stateLock.lock();
            RunningState state = this.runningState.get();
            if (state == null) {
                this.state.set(JcrEngine.State.STARTING);
                state = new RunningState();
                this.runningState.compareAndSet(null, state);
                this.workspacesChanged();
                this.state.set(JcrEngine.State.RUNNING);
                state.postInitialize();
            }
            RunningState runningState = state;
            return runningState;
        }
        catch (IOException e) {
            this.state.set(JcrEngine.State.NOT_RUNNING);
            throw e;
        }
        catch (NamingException e) {
            this.state.set(JcrEngine.State.NOT_RUNNING);
            throw e;
        }
        catch (RuntimeException e) {
            this.state.set(JcrEngine.State.NOT_RUNNING);
            throw e;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doShutdown() {
        if (this.state.get() == JcrEngine.State.NOT_RUNNING) {
            return true;
        }
        try {
            this.stateLock.lock();
            RunningState running = this.runningState.get();
            if (running != null) {
                this.allowAutoStartDuringLogin.set(false);
                this.state.set(JcrEngine.State.STOPPING);
                running.terminateSessions();
                running.shutdown();
                this.runningState.set(null);
            }
            this.state.set(JcrEngine.State.NOT_RUNNING);
        }
        finally {
            this.stateLock.unlock();
        }
        return true;
    }

    private final Cache<String, SchematicEntry> infinispanCache() {
        return this.database().getCache();
    }

    protected final SchematicDb database() {
        return this.runningState().database();
    }

    protected final String repositoryName() {
        return this.repositoryName.get();
    }

    protected final RepositoryCache repositoryCache() {
        return this.runningState().repositoryCache();
    }

    protected final RepositoryStatistics statistics() {
        return this.runningState().statistics();
    }

    protected final TransactionManager txnManager() {
        return this.infinispanCache().getAdvancedCache().getTransactionManager();
    }

    protected final RepositoryNodeTypeManager nodeTypeManager() {
        return this.runningState().nodeTypeManager();
    }

    protected final RepositoryQueryManager queryManager() {
        return this.runningState().queryManager();
    }

    protected final RepositoryLockManager lockManager() {
        return this.runningState().lockManager();
    }

    protected final NamespaceRegistry persistentRegistry() {
        return this.runningState().persistentRegistry();
    }

    protected final String systemWorkspaceName() {
        return this.runningState().systemWorkspaceName();
    }

    protected final String systemWorkspaceKey() {
        return this.runningState().systemWorkspaceKey();
    }

    protected final RunningState runningState() {
        RunningState running = this.runningState.get();
        if (running == null) {
            throw new IllegalStateException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{this.repositoryName()}));
        }
        return running;
    }

    final SessionCache createSystemSession(ExecutionContext context, boolean readOnly) {
        return this.repositoryCache().createSession(context, this.systemWorkspaceName(), readOnly);
    }

    public RepositoryConfiguration getConfiguration() {
        return this.config.get();
    }

    public String getDescriptor(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        JcrValue value = (JcrValue)this.descriptors.get(key);
        try {
            return value.getString();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public JcrValue getDescriptorValue(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        return (JcrValue)this.descriptors.get(key);
    }

    public JcrValue[] getDescriptorValues(String key) {
        Object value = this.descriptors.get(key);
        if (value instanceof JcrValue[]) {
            JcrValue[] values = (JcrValue[])value;
            JcrValue[] newValues = new JcrValue[values.length];
            System.arraycopy(values, 0, newValues, 0, values.length);
            return newValues;
        }
        if (value instanceof JcrValue) {
            return new JcrValue[]{(JcrValue)value};
        }
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        if (key == null) {
            return true;
        }
        return this.descriptors.get(key) instanceof JcrValue;
    }

    public boolean isStandardDescriptor(String key) {
        return STANDARD_DESCRIPTORS.contains(key);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public synchronized JcrSession login() throws RepositoryException {
        return this.login(null, null);
    }

    public synchronized JcrSession login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public synchronized JcrSession login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    public synchronized JcrSession login(Credentials credentials, String workspaceName) throws RepositoryException {
        String repoName = this.repositoryName();
        RunningState running = this.runningState.get();
        if (running == null) {
            if (this.allowAutoStartDuringLogin.get()) {
                try {
                    running = this.doStart();
                }
                catch (Throwable t) {
                    throw new RepositoryException(JcrI18n.errorStartingRepository.text(new Object[]{repoName, t.getMessage()}), t);
                }
                if (running == null) {
                    throw new RepositoryException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{repoName}));
                }
            } else {
                throw new RepositoryException(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown.text(new Object[]{repoName}));
            }
        }
        workspaceName = this.validateWorkspaceName(running, workspaceName);
        AuthenticationProviders authenticators = running.authenticators();
        Credentials anonCredentials = running.anonymousCredentials();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ExecutionContext context = running.context();
        ExecutionContext sessionContext = authenticators.authenticate(credentials, repoName, workspaceName, context, attributes);
        if (sessionContext == null && credentials != null && anonCredentials != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(JcrI18n.usingAnonymousUser.text(new Object[0]), new Object[0]);
            }
            attributes.clear();
            sessionContext = authenticators.authenticate(anonCredentials, repoName, workspaceName, context, attributes);
        }
        if (sessionContext == null) {
            throw new LoginException(JcrI18n.loginFailed.text(new Object[]{repoName, workspaceName}));
        }
        try {
            boolean readOnly = false;
            JcrSession session = new JcrSession(this, workspaceName, sessionContext, attributes, readOnly);
            session.checkPermission(workspaceName, null, "read");
            running.addSession(session, false);
            return session;
        }
        catch (AccessDeniedException ace) {
            throw new LoginException(JcrI18n.loginFailed.text(new Object[]{repoName, workspaceName}), (Throwable)ace);
        }
        catch (WorkspaceNotFoundException e) {
            throw new NoSuchWorkspaceException(e.getMessage(), (Throwable)e);
        }
    }

    private String validateWorkspaceName(RunningState runningState, String workspaceName) throws RepositoryException {
        if (workspaceName == null) {
            return runningState.defaultWorkspaceName();
        }
        if (runningState.systemWorkspaceName().equals(workspaceName)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.repositoryName(), workspaceName}));
        }
        return workspaceName;
    }

    private void initializeDescriptors() {
        ValueFactories factories = new ExecutionContext().getValueFactories();
        this.descriptors.put("level.1.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("level.2.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.locking.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.observation.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.query.sql.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.transactions.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.versioning.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.xpath.doc.order", JcrRepository.valueFor(factories, false));
        this.descriptors.put("query.xpath.pos.index", JcrRepository.valueFor(factories, true));
        this.descriptors.put("write.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("identifier.stability", JcrRepository.valueFor(factories, "identifier.stability.method.duration"));
        this.descriptors.put("option.xml.import.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.xml.export.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.unfiled.content.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.simple.versioning.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.activities.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.baselines.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.access.control.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.journaled.observation.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.retention.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.lifecycle.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.node.and.property.with.same.name.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.update.primary.node.type.supported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("option.update.mixin.node.types.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.shareable.nodes.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("option.node.type.management.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.inheritance", JcrRepository.valueFor(factories, "node.type.management.inheritance.multiple"));
        this.descriptors.put("node.type.management.primary.item.name.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.orderable.child.nodes.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.residual.definitions.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.autocreated.definitions.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.same.name.siblings.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.property.types", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.overrides.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.multivalued.properties.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.multiple.binary.properties.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.value.constraints.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("node.type.management.update.in.use.suported", JcrRepository.valueFor(factories, false));
        this.descriptors.put("query.languages", new JcrValue[]{JcrRepository.valueFor(factories, "xpath"), JcrRepository.valueFor(factories, "JCR-SQL2"), JcrRepository.valueFor(factories, "sql"), JcrRepository.valueFor(factories, "JCR-JQOM")});
        this.descriptors.put("query.stored.queries.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.full.text.search.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("query.joins", JcrRepository.valueFor(factories, "query.joins.inner.outer"));
        this.descriptors.put("jcr.specification.name", JcrRepository.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        this.descriptors.put("jcr.specification.version", JcrRepository.valueFor(factories, "2.0"));
        this.descriptors.put("jcr.repository.name", JcrRepository.valueFor(factories, ModeShape.getName()));
        this.descriptors.put("jcr.repository.vendor", JcrRepository.valueFor(factories, ModeShape.getVendor()));
        this.descriptors.put("jcr.repository.vendor.url", JcrRepository.valueFor(factories, ModeShape.getUrl()));
        this.descriptors.put("jcr.repository.version", JcrRepository.valueFor(factories, ModeShape.getVersion()));
        this.descriptors.put("option.workspace.management.supported", JcrRepository.valueFor(factories, true));
        this.descriptors.put("custom.rep.name", JcrRepository.valueFor(factories, this.repositoryName()));
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrRepository.valueFor(valueFactories, 1, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, boolean value) {
        return JcrRepository.valueFor(valueFactories, 6, value);
    }

    protected void workspacesChanged() {
        RunningState running = this.runningState();
        if (running != null) {
            Set<String> workspaceNames = running.repositoryCache().getWorkspaceNames();
            ValueFactories factories = running.context().getValueFactories();
            JcrValue[] values = new JcrValue[workspaceNames.size()];
            int i = 0;
            for (String workspaceName : workspaceNames) {
                values[i++] = JcrRepository.valueFor(factories, workspaceName);
            }
            this.descriptors.put("custom.rep.workspace.names", values);
        }
    }

    private void repositoryNameChanged() {
        this.descriptors.put("custom.rep.name", this.repositoryName());
    }

    void cleanUp() {
        RunningState running = this.runningState.get();
        if (running != null) {
            running.cleanUpLocks();
            running.cleanUpBinaryValues();
        }
    }

    Collection<Cache<?, ?>> caches() {
        InfinispanBinaryStore ispnStore;
        Cache<?, ?> binaryCache;
        RunningState running = this.runningState.get();
        if (running == null) {
            return Collections.emptyList();
        }
        ArrayList caches = new ArrayList();
        caches.add(running.database().getCache());
        BinaryStore store = running.binaryStore();
        if (store instanceof InfinispanBinaryStore && (binaryCache = (ispnStore = (InfinispanBinaryStore)store).getCache()) != null) {
            caches.add(binaryCache);
        }
        return caches;
    }

    private final class InternalSecurityContext
    implements SecurityContext {
        private final String username;

        protected InternalSecurityContext(String username) {
            this.username = username;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public String getUserName() {
            return this.username;
        }

        @Override
        public boolean hasRole(String roleName) {
            return true;
        }

        @Override
        public void logout() {
        }
    }

    protected static class SessionMonitor
    implements SessionCacheMonitor {
        private final RepositoryStatistics statistics;

        protected SessionMonitor(RepositoryStatistics statistics) {
            this.statistics = statistics;
        }

        @Override
        public void performChange(long changedNodesCount) {
            this.statistics.increment(ValueMetric.NODE_CHANGES, changedNodesCount);
        }
    }

    @Immutable
    protected class RunningState {
        private final RepositoryConfiguration config;
        private final SchematicDb database;
        private final RepositoryCache cache;
        private final AuthenticationProviders authenticators;
        private final Credentials anonymousCredentialsIfSuppliedCredentialsFail;
        private final String defaultWorkspaceName;
        private final String systemWorkspaceName;
        private final String systemWorkspaceKey;
        private final RepositoryNodeTypeManager nodeTypes;
        private final RepositoryLockManager lockManager;
        private final TransactionManager txnMgr;
        private final String jndiName;
        private final SystemNamespaceRegistry persistentRegistry;
        private final ExecutionContext context;
        private final ExecutionContext internalWorkerContext;
        private final ReadWriteLock activeSessionLock = new ReentrantReadWriteLock();
        private final WeakHashMap<JcrSession, Object> activeSessions = new WeakHashMap();
        private final WeakHashMap<JcrSession, Object> internalSessions = new WeakHashMap();
        private final RepositoryStatistics statistics;
        private final BinaryStore binaryStore;
        private final ScheduledExecutorService statsRollupService;
        private final Sequencers sequencers;
        private final Executor sequencingQueue;
        private final QueryParsers queryParsers;
        private final RepositoryQueryManager repositoryQueryManager;
        private final ExecutorService indexingExecutor;
        private final TextExtractors extractors;

        protected RunningState() throws IOException, NamingException {
            this(null, null);
        }

        protected RunningState(RunningState other, ConfigurationChange change) throws IOException, NamingException {
            List<RepositoryConfiguration.Component> extractorComponents;
            this.config = JcrRepository.this.repositoryConfiguration();
            ExecutionContext tempContext = new ExecutionContext();
            if (other != null && !change.monitoringChanged) {
                this.statistics = other.statistics;
                this.statsRollupService = other.statsRollupService;
            } else {
                RepositoryStatistics repositoryStatistics = this.statistics = other != null ? other.statistics : new RepositoryStatistics(tempContext);
                if (this.config.getMonitoring().enabled()) {
                    NamedThreadFactory cronThreadFactory = new NamedThreadFactory("modeshape-stats");
                    this.statsRollupService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)cronThreadFactory);
                    this.statistics.start(this.statsRollupService);
                } else {
                    this.statsRollupService = null;
                }
            }
            JcrRepository.this.logger.debug("Starting '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            this.systemWorkspaceName = "system";
            this.systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
            this.defaultWorkspaceName = other != null && !change.workspacesChanged ? other.defaultWorkspaceName : this.config.getDefaultWorkspaceName();
            if (other != null) {
                if (change.storageChanged) {
                    JcrRepository.this.logger.warn(JcrI18n.storageRelatedConfigurationChangesWillTakeEffectAfterShutdown, new Object[]{JcrRepository.this.getName()});
                }
                if (change.binaryStorageChanged) {
                    JcrRepository.this.logger.warn(JcrI18n.storageRelatedConfigurationChangesWillTakeEffectAfterShutdown, new Object[]{JcrRepository.this.getName()});
                }
                this.database = other.database;
                this.txnMgr = other.txnMgr;
                this.cache = other.cache;
                this.context = other.context;
                if (change.largeValueChanged) {
                    RepositoryConfiguration.BinaryStorage binaryStorage = this.config.getBinaryStorage();
                    this.cache.setLargeValueSizeInBytes(binaryStorage.getMinimumBinarySizeInBytes());
                    this.context.getBinaryStore().setMinimumBinarySizeInBytes(binaryStorage.getMinimumBinarySizeInBytes());
                }
                if (change.workspacesChanged) {
                    for (String workspaceName : this.config.getPredefinedWorkspaceNames()) {
                        this.cache.createWorkspace(workspaceName);
                    }
                }
                this.binaryStore = other.binaryStore;
                this.internalWorkerContext = other.internalWorkerContext;
                this.nodeTypes = other.nodeTypes.with(this, true, true);
                this.lockManager = other.lockManager.with(this);
                this.cache.register(this.lockManager);
                other.cache.unregister(other.lockManager);
                this.persistentRegistry = other.persistentRegistry;
            } else {
                CacheContainer container = this.config.getCacheContainer();
                String cacheName = this.config.getCacheName();
                this.database = Schematic.get((CacheContainer)container, (String)cacheName);
                assert (this.database != null);
                this.txnMgr = this.database.getCache().getAdvancedCache().getTransactionManager();
                RepositoryConfiguration.BinaryStorage binaryStorageConfig = this.config.getBinaryStorage();
                this.binaryStore = binaryStorageConfig.getBinaryStore();
                tempContext = tempContext.with(this.binaryStore);
                this.persistentRegistry = new SystemNamespaceRegistry(this);
                this.context = tempContext.with(this.persistentRegistry);
                this.persistentRegistry.setContext(this.context);
                this.internalWorkerContext = this.context.with(new InternalSecurityContext(JcrRepository.INTERNAL_WORKER_USERNAME));
                SessionMonitor monitor = this.statsRollupService != null ? new SessionMonitor(this.statistics) : null;
                this.cache = new RepositoryCache(this.context, this.database, this.config, this.txnMgr, new SystemContentInitializer(), monitor);
                assert (this.cache != null);
                this.nodeTypes = new RepositoryNodeTypeManager(this, true, true);
                this.cache.register(this.nodeTypes);
                this.lockManager = new RepositoryLockManager(this);
                this.cache.register(this.lockManager);
                this.cache.register(new UnusedBinaryChangeSetListener(this.binaryStore));
                this.persistentRegistry.refreshFromSystem();
                this.lockManager.refreshFromSystem();
                if (!this.nodeTypes.refreshFromSystem()) {
                    try {
                        CndImporter importer = new CndImporter(this.context, true);
                        importer.importBuiltIns((Problems)new SimpleProblems());
                        this.nodeTypes.registerNodeTypes(importer.getNodeTypeDefinitions(), false, true, true);
                    }
                    catch (RepositoryException re) {
                        throw new IllegalStateException("Could not load node type definition files", re);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("Could not access node type definition files", ioe);
                    }
                }
                this.persistentRegistry.register(JcrNamespaceRegistry.STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX);
                this.statistics.set(ValueMetric.WORKSPACE_COUNT, this.cache.getWorkspaceNames().size());
            }
            if (other != null && !change.securityChanged) {
                this.authenticators = other.authenticators;
                this.anonymousCredentialsIfSuppliedCredentialsFail = other.anonymousCredentialsIfSuppliedCredentialsFail;
            } else {
                AtomicBoolean useAnonymouOnFailedLogins = new AtomicBoolean();
                this.authenticators = this.createAuthenticationProviders(useAnonymouOnFailedLogins);
                AnonymousCredentials anonymousCredentials = this.anonymousCredentialsIfSuppliedCredentialsFail = useAnonymouOnFailedLogins.get() ? new AnonymousCredentials() : null;
            }
            if (other != null && !change.extractorsChanged) {
                extractorComponents = this.config.getQuery().getTextExtractors();
                this.extractors = new TextExtractors(this, extractorComponents);
            } else {
                extractorComponents = this.config.getQuery().getTextExtractors();
                this.extractors = new TextExtractors(this, extractorComponents);
            }
            this.binaryStore.setTextExtractor(this.extractors);
            if (other != null && !change.sequencingChanged) {
                this.sequencingQueue = other.sequencingQueue;
                this.sequencers = other.sequencers.with(this);
                if (!this.sequencers.isEmpty()) {
                    this.cache.register(this.sequencers);
                }
                this.cache.unregister(other.sequencers);
            } else {
                Sequencers.WorkQueue queue = null;
                List<RepositoryConfiguration.Component> sequencerComponents = this.config.getSequencing().getSequencers();
                if (sequencerComponents.isEmpty()) {
                    this.sequencingQueue = null;
                    this.sequencers = new Sequencers(this, sequencerComponents, this.cache.getWorkspaceNames(), queue);
                } else {
                    Executor sequencingQueue;
                    String threadPool = this.config.getSequencing().getThreadPoolName();
                    this.sequencingQueue = sequencingQueue = this.context.getThreadPool(threadPool);
                    queue = new Sequencers.WorkQueue(){

                        @Override
                        public void submit(Sequencers.SequencingWorkItem work) {
                            sequencingQueue.execute(new SequencingRunner(JcrRepository.this, work));
                        }
                    };
                    this.sequencers = new Sequencers(this, sequencerComponents, this.cache.getWorkspaceNames(), queue);
                    this.cache.register(this.sequencers);
                }
            }
            if (other != null && !change.indexingChanged) {
                this.indexingExecutor = other.indexingExecutor;
                this.queryParsers = other.queryParsers;
            } else {
                String indexThreadPoolName = this.config.getQuery().getThreadPoolName();
                this.indexingExecutor = (ExecutorService)this.context.getThreadPool(indexThreadPoolName);
                this.queryParsers = new QueryParsers(new JcrSql2QueryParser(), new XPathQueryParser(), new FullTextSearchParser(), new JcrSqlQueryParser(), new JcrQomQueryParser());
            }
            RepositoryConfiguration.QuerySystem query = this.config.getQuery();
            Properties backendProps = query.getIndexingBackendProperties();
            Properties indexingProps = query.getIndexingProperties();
            Properties indexStorageProps = query.getIndexStorageProperties();
            this.repositoryQueryManager = new RepositoryQueryManager(this, this.config.getQuery(), this.indexingExecutor, backendProps, indexingProps, indexStorageProps);
            assert (this.queryParsers.getParserFor("xpath") != null);
            assert (this.queryParsers.getParserFor("sql") != null);
            assert (this.queryParsers.getParserFor("JCR-SQL2") != null);
            assert (this.queryParsers.getParserFor("JCR-JQOM") != null);
            assert (this.queryParsers.getParserFor("search") != null);
            if (other != null && !change.jndiChanged) {
                this.jndiName = other.jndiName;
            } else {
                this.jndiName = this.config.getJndiName();
                this.bindIntoJndi();
                if (other != null) {
                    other.unbindFromJndi();
                }
            }
        }

        protected final void postInitialize() {
            this.sequencers.initialize();
        }

        protected final Sequencers sequencers() {
            return this.sequencers;
        }

        private final ClassLoader classLoader() {
            return this.database.getCache().getConfiguration().getClassLoader();
        }

        private final ClassLoader classLoader(String classLoaderName, ClassLoader defaultLoader) {
            if (classLoaderName != null && (classLoaderName = classLoaderName.trim()).length() == 0) {
                classLoaderName = null;
            }
            if (classLoaderName == null) {
                return defaultLoader;
            }
            ClassLoader loader = this.context.getClassLoader(classLoaderName);
            return loader != null ? loader : defaultLoader;
        }

        final String name() {
            return JcrRepository.this.repositoryName();
        }

        final ExecutionContext context() {
            return this.context;
        }

        final ExecutionContext internalWorkerContext() {
            return this.internalWorkerContext;
        }

        final RepositoryCache repositoryCache() {
            return this.cache;
        }

        final QueryParsers queryParsers() {
            return this.queryParsers;
        }

        final RepositoryQueryManager queryManager() {
            return this.repositoryQueryManager;
        }

        private final Cache<String, SchematicEntry> infinispanCache() {
            return this.database().getCache();
        }

        protected final SchematicDb database() {
            return this.database;
        }

        protected final BinaryStore binaryStore() {
            return this.binaryStore;
        }

        protected final TransactionManager txnManager() {
            return this.infinispanCache().getAdvancedCache().getTransactionManager();
        }

        protected final RepositoryNodeTypeManager nodeTypeManager() {
            return this.nodeTypes;
        }

        protected final RepositoryLockManager lockManager() {
            return this.lockManager;
        }

        protected final String systemWorkspaceName() {
            return this.systemWorkspaceName;
        }

        protected final String systemWorkspaceKey() {
            return this.systemWorkspaceKey;
        }

        protected final String defaultWorkspaceName() {
            return this.defaultWorkspaceName;
        }

        protected final NamespaceRegistry persistentRegistry() {
            return this.persistentRegistry;
        }

        protected final AuthenticationProviders authenticators() {
            return this.authenticators;
        }

        protected final RepositoryStatistics statistics() {
            return this.statistics;
        }

        protected final Credentials anonymousCredentials() {
            return this.anonymousCredentialsIfSuppliedCredentialsFail;
        }

        private AuthenticationProviders createAuthenticationProviders(AtomicBoolean useAnonymouOnFailedLogins) {
            RepositoryConfiguration.Security securityConfig;
            AuthenticationProviders authenticators;
            block11: {
                String policyName;
                authenticators = new AuthenticationProviders();
                securityConfig = this.config.getSecurity();
                RepositoryConfiguration.JaasSecurity jaasSecurity = securityConfig.getJaas();
                if (jaasSecurity != null && (policyName = jaasSecurity.getPolicyName()) != null && policyName.trim().length() != 0) {
                    try {
                        JaasProvider jaasProvider = new JaasProvider(policyName);
                        authenticators = authenticators.with(jaasProvider);
                    }
                    catch (SecurityException e) {
                        if (MISSING_JAAS_POLICIES.add(policyName)) {
                            JcrRepository.this.logger.warn(JcrI18n.loginConfigNotFound, new Object[]{policyName, "security/policyName", JcrRepository.this.repositoryName()});
                        }
                    }
                    catch (javax.security.auth.login.LoginException e) {
                        if (!MISSING_JAAS_POLICIES.add(policyName)) break block11;
                        JcrRepository.this.logger.warn(JcrI18n.loginConfigNotFound, new Object[]{policyName, "security/policyName", JcrRepository.this.repositoryName()});
                    }
                }
            }
            ClassLoader defaultClassLoader = this.classLoader();
            for (RepositoryConfiguration.Component component : securityConfig.getCustomProviders()) {
                try {
                    Object value;
                    ClassLoader cl = this.classLoader(component.getClasspath(), defaultClassLoader);
                    AuthenticationProvider provider = (AuthenticationProvider)component.createInstance(cl);
                    authenticators = authenticators.with(provider);
                    if (!(provider instanceof AnonymousProvider) || !Boolean.TRUE.equals(value = component.getDocument().get("useOnFailedLogin"))) continue;
                    useAnonymouOnFailedLogins.set(true);
                }
                catch (Throwable t) {
                    JcrRepository.this.logger.error(t, JcrI18n.unableToInitializeAuthenticationProvider, new Object[]{component.getName(), JcrRepository.this.repositoryName(), t.getMessage()});
                }
            }
            RepositoryConfiguration.AnonymousSecurity anonSecurity = securityConfig.getAnonymous();
            if (anonSecurity != null) {
                Set<String> anonRoles = anonSecurity.getAnonymousRoles();
                if (!anonRoles.isEmpty()) {
                    String anonUsername = anonSecurity.getAnonymousUsername();
                    AnonymousProvider anonProvider = new AnonymousProvider(anonUsername, anonRoles);
                    authenticators = authenticators.with(anonProvider);
                    JcrRepository.this.logger.debug("Enabling anonymous authentication and authorization.", new Object[0]);
                }
                if (anonSecurity.useAnonymousOnFailedLogings()) {
                    useAnonymouOnFailedLogins.set(true);
                }
            }
            return authenticators;
        }

        final SessionCache createSystemSession(ExecutionContext context, boolean readOnly) {
            return this.cache.createSession(context, this.systemWorkspaceName(), readOnly);
        }

        protected void shutdown() {
            this.unbindFromJndi();
            if (this.sequencingQueue != null) {
                this.sequencers().shutdown();
                this.context().releaseThreadPool(this.sequencingQueue);
            }
            if (!this.internalSessions.isEmpty()) {
                try {
                    for (int counter = 200; counter > 0 && !this.internalSessions.isEmpty(); --counter) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected void bindIntoJndi() {
            if (this.jndiName != null && this.jndiName.trim().length() != 0) {
                try {
                    InitialContext ic = new InitialContext();
                    ic.bind(this.jndiName, (Object)JcrRepository.this);
                }
                catch (NoInitialContextException e) {
                    JcrRepository.this.logger.debug("No JNDI found, so not registering '{0}' repository", new Object[]{JcrRepository.this.getName()});
                }
                catch (NamingException e) {
                    JcrRepository.this.logger.error((Throwable)e, JcrI18n.unableToBindToJndi, new Object[]{this.config.getName(), this.jndiName, e.getMessage()});
                }
            }
        }

        protected void unbindFromJndi() {
            if (this.jndiName != null && this.jndiName.trim().length() != 0) {
                try {
                    InitialContext ic = new InitialContext();
                    ic.unbind(this.jndiName);
                }
                catch (NoInitialContextException e) {
                    JcrRepository.this.logger.debug("No JNDI found, so not registering '{0}' repository", new Object[]{JcrRepository.this.getName()});
                }
                catch (NamingException e) {
                    JcrRepository.this.logger.debug((Throwable)e, "Error while unregistering the '{0}' repository from the '{1}' name in JNDI", new Object[]{this.config.getName(), this.jndiName});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSession(JcrSession session, boolean internal) {
            WeakHashMap<JcrSession, Object> sessions = internal ? this.internalSessions : this.activeSessions;
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                sessions.put(session, null);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int activeSessinCount() {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                int n = this.activeSessions.size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSession(JcrSession session) {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                if (this.activeSessions.remove(session) == null) {
                    this.internalSessions.remove(session);
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminateSessions() {
            Lock lock = this.activeSessionLock.writeLock();
            try {
                lock.lock();
                for (JcrSession session : this.activeSessions.keySet()) {
                    session.terminate(false);
                }
                this.activeSessions.clear();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUpLocks() {
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Starting lock cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
            try {
                HashSet<String> activeSessionIds = new HashSet<String>();
                Lock lock = this.activeSessionLock.writeLock();
                try {
                    lock.lock();
                    Iterator<Map.Entry<JcrSession, Object>> iter = this.activeSessions.entrySet().iterator();
                    while (iter.hasNext()) {
                        JcrSession session = iter.next().getKey();
                        if (!session.isLive()) continue;
                        activeSessionIds.add(session.sessionId());
                    }
                }
                finally {
                    lock.unlock();
                }
                SessionCache systemSession = this.createSystemSession(this.context(), false);
                SystemContent system = new SystemContent(systemSession);
                system.cleanUpLocks(activeSessionIds);
                system.save();
            }
            catch (Throwable e) {
                JcrRepository.this.logger.error(e, JcrI18n.errorDuringGarbageCollection, new Object[]{e.getMessage()});
            }
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Finishing lock cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
        }

        void cleanUpBinaryValues() {
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Starting binary value cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
            try {
                this.binaryStore.removeValuesUnusedLongerThan(RepositoryConfiguration.UNUSED_BINARY_VALUE_AGE_IN_MILLIS, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                JcrRepository.this.logger.error(e, JcrI18n.errorDuringGarbageCollection, new Object[]{e.getMessage()});
            }
            if (JcrRepository.this.logger.isDebugEnabled()) {
                JcrRepository.this.logger.debug("Finishing binary value cleanup in the '{0}' repository", new Object[]{JcrRepository.this.repositoryName()});
            }
        }

        protected Session loginInternalSession() throws RepositoryException {
            return this.loginInternalSession(this.defaultWorkspaceName());
        }

        protected JcrSession loginInternalSession(String workspaceName) throws RepositoryException {
            try {
                boolean readOnly = false;
                RunningState running = JcrRepository.this.runningState();
                ExecutionContext sessionContext = running.internalWorkerContext();
                Map<String, Object> attributes = Collections.emptyMap();
                JcrSession session = new JcrSession(JcrRepository.this, workspaceName, sessionContext, attributes, readOnly);
                running.addSession(session, true);
                return session;
            }
            catch (WorkspaceNotFoundException e) {
                throw new NoSuchWorkspaceException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected class WorkspaceListener
    implements ChangeSetListener {
        protected WorkspaceListener() {
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (changeSet == null || !JcrRepository.this.repositoryCache().getKey().equals(changeSet.getRepositoryKey())) {
                return;
            }
            String workspaceName = changeSet.getWorkspaceName();
            if (workspaceName == null) {
                boolean changed = false;
                for (Change change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        changed = true;
                        continue;
                    }
                    if (!(change instanceof WorkspaceRemoved)) continue;
                    changed = true;
                }
                if (changed) {
                    JcrRepository.this.workspacesChanged();
                }
            }
        }
    }

    protected static class ConfigurationChange
    implements Editor.Observer {
        private final Path SECURITY_PATH = Paths.path((String)"security");
        private final Path QUERY_PATH = Paths.path((String)"query");
        private final Path SEQUENCING_PATH = Paths.path((String)"sequencing");
        private final Path EXTRACTORS_PATH = Paths.path((String[])new String[]{"query", "extractors"});
        private final Path STORAGE_PATH = Paths.path((String)"storage");
        private final Path BINARY_STORAGE_PATH = Paths.path((String[])new String[]{"storage", "binaryStorage"});
        private final Path WORKSPACES_PATH = Paths.path((String)"workspaces");
        private final Path PREDEFINED_PATH = Paths.path((String[])new String[]{"workspaces", "predefined"});
        private final Path JNDI_PATH = Paths.path((String)"jndiName");
        private final Path MINIMUM_BINARY_SIZE_IN_BYTES_PATH = Paths.path((String[])new String[]{"storage", "binaryStorage", "minimumBinarySizeInBytes"});
        private final Path NAME_PATH = Paths.path((String)"name");
        private final Path MONITORING_PATH = Paths.path((String)"monitoring");
        private final Path[] IGNORE_PATHS = new Path[]{this.STORAGE_PATH, this.BINARY_STORAGE_PATH};
        protected boolean securityChanged = false;
        protected boolean sequencingChanged = false;
        protected boolean extractorsChanged = false;
        protected boolean storageChanged = false;
        protected boolean binaryStorageChanged = false;
        protected boolean indexingChanged = false;
        protected boolean workspacesChanged = false;
        protected boolean predefinedWorkspacesChanged = false;
        protected boolean jndiChanged = false;
        protected boolean largeValueChanged = false;
        protected boolean nameChanged = false;
        protected boolean monitoringChanged = false;

        protected ConfigurationChange() {
        }

        public void setArrayValue(Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void addArrayValue(Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void removeArrayValue(Path path, Array.Entry entry) {
            this.checkForChanges(path);
        }

        public void clear(Path path) {
            this.checkForChanges(path);
        }

        public void put(Path parentPath, String field, Object newValue) {
            this.checkForChanges(parentPath.with(field));
        }

        public void remove(Path path, String field) {
            this.checkForChanges(path.with(field));
        }

        private void checkForChanges(Path path) {
            for (Path ignorePath : this.IGNORE_PATHS) {
                if (!path.equals(ignorePath)) continue;
                return;
            }
            if (!this.largeValueChanged && path.equals(this.MINIMUM_BINARY_SIZE_IN_BYTES_PATH)) {
                this.largeValueChanged = true;
            } else if (!this.binaryStorageChanged && path.startsWith(this.BINARY_STORAGE_PATH)) {
                this.binaryStorageChanged = true;
            } else if (!this.storageChanged && path.startsWith(this.STORAGE_PATH)) {
                this.storageChanged = true;
            }
            if (!this.sequencingChanged && path.startsWith(this.SEQUENCING_PATH)) {
                this.sequencingChanged = true;
            }
            if (!this.extractorsChanged && path.startsWith(this.EXTRACTORS_PATH)) {
                this.extractorsChanged = true;
            }
            if (!this.securityChanged && path.startsWith(this.SECURITY_PATH)) {
                this.securityChanged = true;
            }
            if (!this.workspacesChanged && path.startsWith(this.WORKSPACES_PATH) && !path.startsWith(this.PREDEFINED_PATH)) {
                this.workspacesChanged = true;
            }
            if (!this.predefinedWorkspacesChanged && path.startsWith(this.PREDEFINED_PATH)) {
                this.predefinedWorkspacesChanged = true;
            }
            if (!this.indexingChanged && path.startsWith(this.QUERY_PATH) && !path.startsWith(this.EXTRACTORS_PATH)) {
                this.indexingChanged = true;
            }
            if (!this.jndiChanged && path.equals(this.JNDI_PATH)) {
                this.jndiChanged = true;
            }
            if (!this.nameChanged && path.equals(this.NAME_PATH)) {
                this.nameChanged = true;
            }
            if (!this.monitoringChanged && path.equals(this.MONITORING_PATH)) {
                this.monitoringChanged = true;
            }
        }
    }

    public static final class QueryLanguage {
        public static final String XPATH = "xpath";
        public static final String JCR_SQL = "sql";
        public static final String JCR_SQL2 = "JCR-SQL2";
        public static final String JCR_JQOM = "JCR-JQOM";
        public static final String SEARCH = "search";
    }
}

