/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.schematic.document.ParsingException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoryFactory;

@ThreadSafe
public class JcrRepositoryFactory
implements RepositoryFactory {
    private static final Logger LOG = Logger.getLogger(JcrRepositoryFactory.class);
    private static final JcrEngine ENGINE = new JcrEngine();
    @Deprecated
    public static final String URL = "org.modeshape.jcr.URL";
    @Deprecated
    public static final String REPOSITORY_NAME_PARAM = "repositoryName";

    public static Future<Boolean> shutdownAll() {
        return ENGINE.shutdown();
    }

    public Repository getRepository(Map parameters) {
        LOG.debug("Trying to load ModeShape JCR Repository with parameters: " + parameters, new Object[0]);
        if (parameters == null) {
            return null;
        }
        Object rawUrl = parameters.get(URL);
        if (rawUrl == null) {
            LOG.debug("No parameter found with key: org.modeshape.jcr.URL", new Object[0]);
            return null;
        }
        URL url = null;
        url = rawUrl instanceof URL ? (URL)rawUrl : this.urlFor(rawUrl.toString(), null);
        if (url == null) {
            return null;
        }
        return this.getRepository(url, parameters);
    }

    protected Repository getRepository(URL url, Map<String, String> parameters) {
        if ("jndi".equals(url.getProtocol())) {
            Repository repository = this.getRepositoryFromJndi(url.getPath(), parameters);
            if (repository != null) {
                return repository;
            }
        } else {
            return this.getRepositoryFromConfigFile(url);
        }
        LOG.debug("Could not load or find a ModeShape repository using the URL '{1}'", new Object[]{url});
        return null;
    }

    private JcrEngine getEngine() {
        switch (ENGINE.getState()) {
            case NOT_RUNNING: {
                ENGINE.start();
                break;
            }
            case STOPPING: {
                try {
                    ENGINE.shutdown().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
        return ENGINE;
    }

    private JcrRepository getRepositoryFromConfigFile(URL configUrl) {
        assert (configUrl != null);
        try {
            if ("file".equals(configUrl.getProtocol())) {
                try {
                    configUrl = new URL(configUrl.getProtocol(), configUrl.getHost(), configUrl.getPort(), configUrl.getPath());
                }
                catch (MalformedURLException mfe) {
                    throw new IllegalStateException(mfe);
                }
            }
            String configKey = configUrl.toString();
            JcrEngine engine = this.getEngine();
            if (engine.getRepositoryKeys().contains(configKey)) {
                try {
                    return engine.getRepository(configKey);
                }
                catch (NoSuchRepositoryException e) {
                    // empty catch block
                }
            }
            RepositoryConfiguration config = null;
            if ("file".equals(configUrl.getProtocol())) {
                try {
                    config = RepositoryConfiguration.read(configUrl);
                }
                catch (ParsingException e) {
                    try {
                        String path = this.classpathResource(configUrl);
                        if (path.length() == 0) {
                            throw e;
                        }
                        config = RepositoryConfiguration.read(path);
                    }
                    catch (Throwable t) {
                        throw e;
                    }
                }
            } else if ("classpath".equals(configUrl.getProtocol())) {
                String path = this.classpathResource(configUrl);
                config = RepositoryConfiguration.read(path);
            } else {
                config = RepositoryConfiguration.read(configUrl);
            }
            String configName = config.getName();
            if (engine.getRepositoryNames().contains(configName)) {
                try {
                    return engine.getRepository(configName);
                }
                catch (NoSuchRepositoryException e) {
                    // empty catch block
                }
            }
            JcrRepository repository = engine.deploy(config);
            repository.start();
            return repository;
        }
        catch (RepositoryException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
        catch (IOException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
        catch (NamingException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
    }

    private String classpathResource(URL url) {
        String path = url.getPath();
        while (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        return path.length() != 0 ? path : null;
    }

    private Hashtable<String, String> hashtable(Map<String, String> map) {
        assert (map != null);
        Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hash.put(entry.getKey(), entry.getValue());
        }
        return hash;
    }

    private Repository getRepositoryFromJndi(String jndiName, Map<String, String> parameters) {
        String repoName;
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        if ((repoName = parameters.get(REPOSITORY_NAME_PARAM)) != null && repoName.trim().length() == 0) {
            repoName = null;
        }
        try {
            InitialContext ic = new InitialContext(this.hashtable(parameters));
            Object ob = ic.lookup(jndiName);
            if (ob instanceof JcrEngine) {
                JcrEngine engine = (JcrEngine)ob;
                switch (engine.getState()) {
                    case NOT_RUNNING: 
                    case STOPPING: {
                        LOG.error(JcrI18n.engineAtJndiLocationIsNotRunning, new Object[]{jndiName});
                        return null;
                    }
                }
                if (repoName == null && engine.getRepositories().size() == 1) {
                    repoName = engine.getRepositories().keySet().iterator().next();
                }
                if (repoName != null && (repoName = repoName.trim()).length() != 0) {
                    try {
                        JcrRepository repository = engine.getRepository(repoName);
                        switch (repository.getState()) {
                            case RUNNING: 
                            case STARTING: {
                                return repository;
                            }
                        }
                        LOG.error(JcrI18n.repositoryIsNotRunningOrHasBeenShutDownInEngineAtJndiLocation, new Object[]{repoName, jndiName});
                        return null;
                    }
                    catch (NoSuchRepositoryException e) {
                        LOG.warn(JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repoName, jndiName});
                        return null;
                    }
                }
                LOG.warn(JcrI18n.missingRepositoryNameInUrlContainingJndiLocationOfEngine, new Object[]{jndiName, REPOSITORY_NAME_PARAM});
            } else if (ob instanceof Repositories) {
                Repositories repos = (Repositories)ob;
                try {
                    return repos.getRepository(repoName);
                }
                catch (RepositoryException e) {
                    LOG.warn(JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repoName, jndiName});
                }
            } else if (ob instanceof Repository) {
                return (Repository)ob;
            }
            return null;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public Future<Boolean> shutdown() {
        return ENGINE.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return ENGINE.shutdown().get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e, JcrI18n.errorShuttingDownJcrRepositoryFactory, new Object[0]);
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Repository getRepository(String jcrUrl, String repositoryName) throws RepositoryException {
        URL url = this.urlFor(jcrUrl, repositoryName);
        if (url == null) {
            return null;
        }
        return this.getRepository(url, null);
    }

    public Repository getRepository(String repositoryName) throws RepositoryException {
        return this.getEngine().getRepository(repositoryName);
    }

    public Set<String> getRepositoryNames() {
        return this.getEngine().getRepositoryNames();
    }

    private URL urlFor(String jcrUrl, String repoName) {
        if (jcrUrl == null || jcrUrl.isEmpty()) {
            throw new IllegalStateException(JcrI18n.invalidJcrUrl.text(new Object[]{jcrUrl}));
        }
        try {
            if (repoName != null) {
                repoName = repoName.trim();
                String queryParam = "?repositoryName=";
                if (repoName.length() != 0 && !jcrUrl.contains(queryParam)) {
                    jcrUrl = jcrUrl + queryParam + repoName;
                }
            }
            return new URL(jcrUrl.toString());
        }
        catch (MalformedURLException mue) {
            LOG.debug("Could not parse URL: " + mue.getMessage(), new Object[0]);
            return null;
        }
    }

    static {
        ENGINE.start();
    }
}

