/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrNode;

@NotThreadSafe
class JcrSharedNode
extends JcrNode {
    private AbstractJcrNode original;
    private AbstractJcrNode proxy;

    JcrSharedNode(AbstractJcrNode proxy, AbstractJcrNode original) {
        super(proxy.session, original.key());
        this.proxy = proxy;
        this.original = original;
        assert (proxy.session == original.session) : "Only able to share nodes within the same session";
        assert (!proxy.isRoot()) : "The root node can never be a shared node";
        assert (!original.isRoot()) : "The root node can never be shareable";
    }

    AbstractJcrNode proxyNode() {
        return this.proxy;
    }

    AbstractJcrNode originalNode() {
        return this.original;
    }

    @Override
    boolean isShareable() {
        return this.original != null;
    }

    @Override
    boolean isShared() {
        return true;
    }
}

