/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSystemNode;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

@ThreadSafe
final class JcrVersionHistoryNode
extends JcrSystemNode
implements VersionHistory {
    JcrVersionHistoryNode(JcrSession session, NodeKey key) {
        super(session, key);
    }

    @Override
    AbstractJcrNode.Type type() {
        return AbstractJcrNode.Type.VERSION_HISTORY;
    }

    protected final AbstractJcrNode versionLabels() throws RepositoryException {
        return this.childNode(JcrLexicon.VERSION_LABELS, AbstractJcrNode.Type.NODE);
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        return new JcrVersionIterator(this.getNodes());
    }

    public JcrVersionNode getRootVersion() throws RepositoryException {
        return (JcrVersionNode)this.childNode(JcrLexicon.ROOT_VERSION, AbstractJcrNode.Type.VERSION);
    }

    public JcrVersionNode getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            return (JcrVersionNode)this.getNode(versionName);
        }
        catch (PathNotFoundException pnfe) {
            throw new VersionException(JcrI18n.invalidVersionName.text(new Object[]{versionName, this.getPath()}));
        }
    }

    public JcrVersionNode getVersionByLabel(String label) throws VersionException, RepositoryException {
        try {
            AbstractJcrProperty prop = this.versionLabels().getProperty(label);
            return (JcrVersionNode)prop.getNode();
        }
        catch (PathNotFoundException e) {
            throw new VersionException(JcrI18n.invalidVersionLabel.text(new Object[]{label, this.getPath()}));
        }
        catch (ItemNotFoundException e) {
            throw new VersionException(JcrI18n.labeledNodeNotFound.text(new Object[]{label, this.getPath()}));
        }
    }

    public String[] getVersionLabels() throws RepositoryException {
        PropertyIterator iter = this.versionLabels().getProperties();
        String[] labels = new String[(int)iter.getSize()];
        int i = 0;
        while (iter.hasNext()) {
            labels[i] = iter.nextProperty().getName();
            ++i;
        }
        return labels;
    }

    private Set<String> versionLabelsFor(Version version) throws RepositoryException {
        if (!version.getParent().equals(this)) {
            throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), this.getPath()}));
        }
        String versionId = version.getIdentifier();
        PropertyIterator iter = this.versionLabels().getProperties();
        if (iter.getSize() == 0L) {
            return Collections.emptySet();
        }
        HashSet<String> labels = new HashSet<String>();
        while (iter.hasNext()) {
            javax.jcr.Property prop = iter.nextProperty();
            if (!versionId.equals(prop.getString())) continue;
            labels.add(prop.getName());
        }
        return labels;
    }

    public String[] getVersionLabels(Version version) throws RepositoryException {
        Set<String> labels = this.versionLabelsFor(version);
        return labels.toArray(new String[labels.size()]);
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getProperty(JcrLexicon.VERSIONABLE_UUID).getString();
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        return this.versionLabels().hasProperty(label);
    }

    public boolean hasVersionLabel(Version version, String label) throws RepositoryException {
        return this.versionLabelsFor(version).contains(label);
    }

    public void removeVersion(String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        JcrVersionNode version = this.getVersion(versionName);
        assert (version.getParent() == this);
        PropertyIterator iter = version.getReferences();
        while (iter.hasNext()) {
            AbstractJcrProperty prop = (AbstractJcrProperty)iter.next();
            AbstractJcrNode referrer = prop.getParent();
            if (referrer.isRoot()) {
                throw new ReferentialIntegrityException(JcrI18n.cannotRemoveVersion.text(new Object[]{prop.getPath()}));
            }
            if (this.equals(referrer)) continue;
            throw new ReferentialIntegrityException(JcrI18n.cannotRemoveVersion.text(new Object[]{prop.getPath()}));
        }
        String versionId = version.getIdentifier();
        AbstractJcrProperty predecessors = version.getProperty(JcrLexicon.PREDECESSORS);
        AbstractJcrProperty successors = version.getProperty(JcrLexicon.SUCCESSORS);
        HashSet<JcrValue> addedValues = new HashSet<JcrValue>();
        for (JcrValue predecessorValue : predecessors.getValues()) {
            addedValues.clear();
            ArrayList<JcrValue> newNodeSuccessors = new ArrayList<JcrValue>();
            AbstractJcrNode predecessor = this.session().getNodeByIdentifier(predecessorValue.getString());
            JcrValue[] nodeSuccessors = predecessor.getProperty(JcrLexicon.SUCCESSORS).getValues();
            this.addValuesNotInSet(nodeSuccessors, newNodeSuccessors, versionId, addedValues);
            this.addValuesNotInSet(successors.getValues(), newNodeSuccessors, versionId, addedValues);
            Value[] newSuccessors = newNodeSuccessors.toArray(new JcrValue[newNodeSuccessors.size()]);
            predecessor.setProperty(JcrLexicon.SUCCESSORS, newSuccessors, 9, false);
            addedValues.clear();
        }
        for (JcrValue successorUuid : successors.getValues()) {
            addedValues.clear();
            ArrayList<JcrValue> newNodePredecessors = new ArrayList<JcrValue>();
            AbstractJcrNode successor = this.session().getNodeByIdentifier(successorUuid.getString());
            JcrValue[] nodePredecessors = successor.getProperty(JcrLexicon.PREDECESSORS).getValues();
            this.addValuesNotInSet(nodePredecessors, newNodePredecessors, versionId, addedValues);
            this.addValuesNotInSet(predecessors.getValues(), newNodePredecessors, versionId, addedValues);
            Value[] newPredecessors = newNodePredecessors.toArray(new JcrValue[newNodePredecessors.size()]);
            successor.setProperty(JcrLexicon.PREDECESSORS, newPredecessors, 9, false);
        }
        SessionCache system = this.session.createSystemCache(false);
        this.mutable().removeChild(system, this.key);
        system.destroy(this.key);
        system.save();
    }

    private void addValuesNotInSet(JcrValue[] values, List<JcrValue> newValues, String versionUuid, Set<JcrValue> exceptIn) throws RepositoryException {
        for (JcrValue value : values) {
            if (versionUuid.equals(value.getString()) || exceptIn.contains(value)) continue;
            exceptIn.add(value);
            newValues.add(value);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        AbstractJcrNode versionLabels = this.versionLabels();
        JcrVersionNode version = this.getVersion(versionName);
        try {
            versionLabels.getProperty(label);
            if (!moveLabel) {
                throw new VersionException(JcrI18n.versionLabelAlreadyExists.text(new Object[]{label}));
            }
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        SessionCache system = this.session.createSystemCache(false);
        Property ref = this.session.propertyFactory().create(this.nameFrom(label), version.key());
        versionLabels.mutable().setProperty(system, ref);
        system.save();
    }

    public void removeVersionLabel(String label) throws VersionException, RepositoryException {
        AbstractJcrNode versionLabels = this.versionLabels();
        Name propName = null;
        try {
            propName = versionLabels.getProperty(label).name();
        }
        catch (PathNotFoundException pnfe) {
            throw new VersionException(JcrI18n.invalidVersionLabel.text(new Object[]{label, this.getPath()}));
        }
        SessionCache system = this.session.createSystemCache(false);
        versionLabels.mutable().removeProperty(system, propName);
        system.save();
    }

    public NodeIterator getAllFrozenNodes() throws RepositoryException {
        return new FrozenNodeIterator(this.getAllVersions());
    }

    public NodeIterator getAllLinearFrozenNodes() throws RepositoryException {
        return new FrozenNodeIterator(this.getAllLinearVersions());
    }

    public VersionIterator getAllLinearVersions() throws RepositoryException {
        AbstractJcrNode existingNode = this.session().getNodeByIdentifier(this.getVersionableIdentifier());
        if (existingNode == null) {
            return this.getAllVersions();
        }
        assert (existingNode.isNodeType(JcrMixLexicon.VERSIONABLE));
        LinkedList<JcrVersionNode> versions = new LinkedList<JcrVersionNode>();
        for (JcrVersionNode baseVersion = existingNode.getBaseVersion(); baseVersion != null; baseVersion = baseVersion.getLinearPredecessor()) {
            versions.addFirst(baseVersion);
        }
        return new LinearVersionIterator(versions, versions.size());
    }

    public String getVersionableIdentifier() throws RepositoryException {
        return this.getVersionableUUID();
    }

    @NotThreadSafe
    static final class FrozenNodeIterator
    implements NodeIterator {
        private final VersionIterator versions;

        FrozenNodeIterator(VersionIterator versionIter) {
            this.versions = versionIter;
        }

        public boolean hasNext() {
            return this.versions.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Node nextNode() {
            try {
                return this.versions.nextVersion().getFrozenNode();
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
        }

        public long getPosition() {
            return this.versions.getPosition();
        }

        public long getSize() {
            return this.versions.getSize();
        }

        public void skip(long skipNum) {
            this.versions.skip(skipNum);
        }
    }

    @NotThreadSafe
    static class LinearVersionIterator
    implements VersionIterator {
        private final Iterator<? extends Version> versions;
        private final int size;
        private int pos;

        protected LinearVersionIterator(Iterable<? extends Version> versions, int size) {
            this.versions = versions.iterator();
            this.size = size;
            this.pos = 0;
        }

        public long getPosition() {
            return this.pos;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            while (skipNum-- > 0L && this.versions.hasNext()) {
                this.versions.next();
                ++this.pos;
            }
        }

        public Version nextVersion() {
            return this.versions.next();
        }

        public boolean hasNext() {
            return this.versions.hasNext();
        }

        public Object next() {
            return this.nextVersion();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    static class JcrVersionIterator
    implements VersionIterator {
        private final NodeIterator nodeIterator;
        private Version next;
        private int position = 0;

        public JcrVersionIterator(NodeIterator nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        public Version nextVersion() {
            Version next = this.next;
            if (next != null) {
                this.next = null;
                return next;
            }
            next = this.nextVersionIfPossible();
            if (next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return next;
        }

        private JcrVersionNode nextVersionIfPossible() {
            while (this.nodeIterator.hasNext()) {
                Name nodeName;
                AbstractJcrNode node = (AbstractJcrNode)this.nodeIterator.nextNode();
                try {
                    nodeName = node.segment().getName();
                }
                catch (RepositoryException re) {
                    throw new IllegalStateException(re);
                }
                if (JcrLexicon.VERSION_LABELS.equals(nodeName)) continue;
                return (JcrVersionNode)node;
            }
            return null;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.nodeIterator.getSize() - 1L;
        }

        public void skip(long count) {
            while (count-- > 0L) {
                this.nextVersion();
            }
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.nextVersionIfPossible();
            return this.next != null;
        }

        public Object next() {
            return this.nextVersion();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

