/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.modeshape.common.collection.UnmodifiableProperties;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;

public final class ModeShape {
    private static final Properties bundleProperties = ModeShape.loadBundleProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadBundleProperties() {
        InputStream stream = null;
        try {
            stream = JcrRepository.class.getClassLoader().getResourceAsStream("org/modeshape/jcr/repository.properties");
            assert (stream != null);
            Properties props = new Properties();
            props.load(stream);
            UnmodifiableProperties unmodifiableProperties = new UnmodifiableProperties(props);
            return unmodifiableProperties;
        }
        catch (IOException e) {
            throw new IllegalStateException(JcrI18n.failedToReadPropertiesFromManifest.text(new Object[]{e.getLocalizedMessage()}), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                }
                finally {
                    stream = null;
                }
            }
        }
    }

    public static final String getName() {
        return bundleProperties.getProperty("name");
    }

    public static final String getVendor() {
        return bundleProperties.getProperty("vendor");
    }

    public static final String getUrl() {
        return bundleProperties.getProperty("url");
    }

    public static final String getVersion() {
        return bundleProperties.getProperty("version");
    }

    static {
        Logger.getLogger(JcrRepository.class).info(JcrI18n.initializing, new Object[]{ModeShape.getName(), ModeShape.getVersion()});
    }
}

