/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.SecureHash;

@Immutable
public final class NodeKey
implements Serializable,
Comparable<NodeKey> {
    private static final long serialVersionUID = 1L;
    protected static final int SOURCE_LENGTH = 7;
    protected static final int WORKSPACE_LENGTH = 7;
    private static final int SOURCE_START_INDEX = 0;
    private static final int SOURCE_END_INDEX = 7;
    private static final int WORKSPACE_START_INDEX = 7;
    private static final int WORKSPACE_END_INDEX = 14;
    private static final int IDENTIFIER_START_INDEX = 14;
    private final String key;
    private transient String sourceKey;
    private transient String workspaceKey;
    private transient String identifier;

    public static boolean isValidFormat(String key) {
        return key.length() > 14;
    }

    public NodeKey(String key) {
        assert (key != null);
        assert (key.length() > 14);
        this.key = key;
    }

    public NodeKey(String sourceKey, String workspaceKey, String identifier) {
        assert (sourceKey != null);
        assert (workspaceKey != null);
        assert (identifier != null);
        assert (sourceKey.length() == 7);
        assert (workspaceKey.length() == 7);
        assert (workspaceKey.length() > 0);
        this.key = sourceKey + workspaceKey + identifier;
    }

    public String getSourceKey() {
        if (this.sourceKey == null) {
            this.sourceKey = this.key.substring(0, 7);
        }
        return this.sourceKey;
    }

    public String getWorkspaceKey() {
        if (this.workspaceKey == null) {
            this.workspaceKey = this.key.substring(7, 14);
        }
        return this.workspaceKey;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.key.substring(14);
        }
        return this.identifier;
    }

    public String getIdentifierHash() {
        return NodeKey.sha1(this.getIdentifier());
    }

    @Override
    public int compareTo(NodeKey that) {
        if (that == this) {
            return 0;
        }
        return this.key.compareTo(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeKey) {
            NodeKey that = (NodeKey)obj;
            return this.key.equals(that.key);
        }
        return false;
    }

    public String toString() {
        return this.key;
    }

    public NodeKey withRandomId() {
        return new NodeKey(this.getSourceKey(), this.getWorkspaceKey(), UUID.randomUUID().toString());
    }

    public NodeKey withId(String identifier) {
        return new NodeKey(this.getSourceKey(), this.getWorkspaceKey(), identifier);
    }

    public NodeKey withWorkspaceKey(String workspaceKey) {
        return new NodeKey(this.getSourceKey(), workspaceKey, this.getIdentifier());
    }

    public NodeKey withWorkspaceKeyAndId(String workspaceKey, String identifier) {
        return new NodeKey(this.getSourceKey(), workspaceKey, identifier);
    }

    public NodeKey withSourceKeyAndId(String sourceKey, String identifier) {
        return new NodeKey(sourceKey, this.getWorkspaceKey(), identifier);
    }

    public static String keyForSourceName(String name) {
        return NodeKey.sha1(name).substring(0, 7);
    }

    public static String keyForWorkspaceName(String name) {
        return NodeKey.sha1(name).substring(0, 7);
    }

    private static String sha1(String name) {
        try {
            byte[] sha1 = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])name.getBytes());
            return SecureHash.asHexString((byte[])sha1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }
}

