/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.ListMultimap;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.value.Name;

@ThreadSafe
public class MutableChildReferences
extends AbstractChildReferences {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ListMultimap<Name, ChildReference> childReferences = LinkedListMultimap.create();
    private final Map<NodeKey, ChildReference> childReferencesByKey = new HashMap<NodeKey, ChildReference>();

    protected MutableChildReferences() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            long l = this.childReferencesByKey.size();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount(Name name) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            int n = this.childReferences.get((Object)name).size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
        if (context == null) {
            context = new ChildReferences.SingleNameContext();
        }
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            List childrenWithSameName = this.childReferences.get((Object)name);
            if (childrenWithSameName.isEmpty()) {
                ChildReference childReference = null;
                return childReference;
            }
            for (ChildReference childWithSameName : childrenWithSameName) {
                int index = context.consume(childWithSameName.getName(), childWithSameName.getKey());
                if (index != snsIndex) continue;
                ChildReference childReference = childWithSameName.with(index);
                return childReference;
            }
            ChildReference childReference = null;
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
        if (context == null) {
            context = new ChildReferences.SingleNameContext();
        }
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            ChildReference ref = this.childReferencesByKey.get(key);
            if (ref != null) {
                List childrenWithSameName = this.childReferences.get((Object)ref.getName());
                assert (childrenWithSameName != null);
                assert (childrenWithSameName.size() != 0);
                for (ChildReference child : childrenWithSameName) {
                    int index = context.consume(child.getName(), child.getKey());
                    if (!key.equals(child.getKey())) continue;
                    ChildReference childReference = child.with(index);
                    return childReference;
                }
            }
            ChildReference childReference = ref;
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildReference getChild(NodeKey key) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            ChildReference childReference = this.childReferencesByKey.get(key);
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ChildReference> iterator() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<ChildReference> iterator = this.childReferences.values().iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ChildReference> iterator(Name name) {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<ChildReference> iterator = this.childReferences.get((Object)name).iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NodeKey> getAllKeys() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator<NodeKey> iterator = new HashSet<NodeKey>(this.childReferencesByKey.keySet()).iterator();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(NodeKey key, Name name) {
        ChildReference reference = new ChildReference(key, name, 1);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.childReferences.put((Object)reference.getName(), (Object)reference);
            this.childReferencesByKey.put(reference.getKey(), reference);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Iterable<ChildReference> references) {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            for (ChildReference reference : references) {
                reference = reference.with(1);
                this.childReferences.put((Object)reference.getName(), (Object)reference);
                this.childReferencesByKey.put(reference.getKey(), reference);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildReference remove(NodeKey key) {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            ChildReference existing = this.childReferencesByKey.remove(key);
            if (existing != null) {
                this.childReferences.remove((Object)existing.getName(), (Object)existing);
            }
            ChildReference childReference = existing;
            return childReference;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("appended: ");
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            Iterator iter = this.childReferences.values().iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
        }
        finally {
            lock.unlock();
        }
        return sb;
    }
}

