/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.NamespaceRegistry;

@Immutable
public class QueryContext {
    private final ExecutionContext context;
    private final NodeCache nodeCache;
    private final TypeSystem typeSystem;
    private final PlanHints hints;
    private final Schemata schemata;
    private final Problems problems;
    private final Map<String, Object> variables;
    private final String workspaceName;

    public QueryContext(ExecutionContext context, NodeCache nodeCache, String workspaceName, Schemata schemata, PlanHints hints, Problems problems, Map<String, Object> variables) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)schemata, (String)"schemata");
        this.context = context;
        this.nodeCache = nodeCache;
        this.workspaceName = workspaceName;
        this.typeSystem = context.getValueFactories().getTypeSystem();
        this.hints = hints != null ? hints : new PlanHints();
        this.schemata = schemata;
        this.problems = problems != null ? problems : new SimpleProblems();
        Map<String, Object> map = this.variables = variables != null ? new HashMap<String, Object>(variables) : new HashMap();
        assert (this.typeSystem != null);
        assert (this.hints != null);
        assert (this.schemata != null);
        assert (this.problems != null);
        assert (this.variables != null);
    }

    public QueryContext(ExecutionContext context, NodeCache nodeCache, String workspaceName, Schemata schemata, PlanHints hints, Problems problems) {
        this(context, nodeCache, workspaceName, schemata, hints, problems, null);
    }

    public QueryContext(ExecutionContext context, NodeCache nodeCache, String workspaceName, Schemata schemata) {
        this(context, nodeCache, workspaceName, schemata, null, null, null);
    }

    protected QueryContext(QueryContext original) {
        this(original.context, original.nodeCache, original.workspaceName, original.schemata, original.hints, original.problems, original.variables);
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.context.getNamespaceRegistry();
    }

    public NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public final PlanHints getHints() {
        return this.hints;
    }

    public final Problems getProblems() {
        return this.problems;
    }

    public Schemata getSchemata() {
        return this.schemata;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryContext) {
            QueryContext that = (QueryContext)obj;
            if (!this.typeSystem.equals(that.getTypeSystem())) {
                return false;
            }
            if (!this.schemata.equals(that.getSchemata())) {
                return false;
            }
            return ((Object)this.variables).equals(that.getVariables());
        }
        return false;
    }

    public QueryContext with(Schemata schemata) {
        CheckArg.isNotNull((Object)schemata, (String)"schemata");
        return new QueryContext(this.context, this.nodeCache, this.workspaceName, schemata, this.hints, this.problems, this.variables);
    }

    public QueryContext with(PlanHints hints) {
        CheckArg.isNotNull((Object)hints, (String)"hints");
        return new QueryContext(this.context, this.nodeCache, this.workspaceName, this.schemata, hints, this.problems, this.variables);
    }

    public QueryContext with(Problems problems) {
        return new QueryContext(this.context, this.nodeCache, this.workspaceName, this.schemata, this.hints, problems, this.variables);
    }

    public QueryContext with(Map<String, Object> variables) {
        return new QueryContext(this.context, this.nodeCache, this.workspaceName, this.schemata, this.hints, this.problems, variables);
    }
}

