/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.lucene.FieldUtil;
import org.modeshape.jcr.value.Binary;
import org.modeshape.jcr.value.Reference;

public class NodeInfoBridge
implements FieldBridge {
    private static final Integer TRUE_INT = new Integer(1);
    private static final Integer FALSE_INT = new Integer(0);
    private static final LuceneOptions NON_ANALYZED_OPTIONS = new LuceneOptionsImpl(Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO, null);

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Map properties = (Map)value;
        AtomicReference<Set<String>> sha1s = new AtomicReference<Set<String>>();
        AtomicReference<Set<String>> strongRefs = new AtomicReference<Set<String>>();
        AtomicReference<Set<String>> weakRefs = new AtomicReference<Set<String>>();
        for (Map.Entry property : properties.entrySet()) {
            String propName = (String)property.getKey();
            Object propValue = property.getValue();
            if (propValue instanceof Object[]) {
                for (Object arrayValue : (Object[])propValue) {
                    this.addField(propName, arrayValue, document, sha1s, strongRefs, weakRefs);
                }
                continue;
            }
            this.addField(propName, propValue, document, sha1s, strongRefs, weakRefs);
        }
        this.addField("::binRef", sha1s, document);
        this.addField("::sref", strongRefs, document);
        this.addField("::wref", weakRefs, document);
    }

    protected final void addField(String name, AtomicReference<Set<String>> valuesRef, Document document) {
        Set<String> values = valuesRef.get();
        if (values != null) {
            assert (!values.isEmpty());
            for (String value : values) {
                NON_ANALYZED_OPTIONS.addFieldToDocument(name, value, document);
            }
        }
    }

    protected final void addField(String name, Object value, Document document, AtomicReference<Set<String>> sha1s, AtomicReference<Set<String>> strongRefs, AtomicReference<Set<String>> weakRefs) {
        if (value instanceof String) {
            NON_ANALYZED_OPTIONS.addFieldToDocument(name, (String)value, document);
        } else if (value instanceof Boolean) {
            Boolean bValue = (Boolean)value;
            Integer iValue = bValue != false ? TRUE_INT : FALSE_INT;
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, (Object)iValue, document);
        } else if (value instanceof Integer) {
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, value, document);
        } else if (value instanceof Long) {
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, value, document);
        } else if (value instanceof Float) {
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, value, document);
        } else if (value instanceof Double) {
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, value, document);
        } else if (value instanceof BigDecimal) {
            String strValue = FieldUtil.decimalToString((BigDecimal)value);
            NON_ANALYZED_OPTIONS.addFieldToDocument(name, strValue, document);
        } else if (value instanceof Binary) {
            Binary binary = (Binary)value;
            String sha1 = binary.getHexHash();
            this.addValueTo(sha1, sha1s);
            NON_ANALYZED_OPTIONS.addFieldToDocument(name, sha1, document);
        } else if (value instanceof DateTime) {
            DateTime timestamp = (DateTime)value;
            NON_ANALYZED_OPTIONS.addNumericFieldToDocument(name, (Object)timestamp.getMillisecondsInUtc(), document);
        } else if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String strRef = ref.getString();
            if (ref.isWeak()) {
                this.addValueTo(strRef, weakRefs);
            } else {
                this.addValueTo(strRef, strongRefs);
            }
            NON_ANALYZED_OPTIONS.addFieldToDocument(name, strRef, document);
        }
    }

    protected final void addValueTo(String value, AtomicReference<Set<String>> ref) {
        assert (value != null);
        assert (value.length() != 0);
        Set<String> values = ref.get();
        if (values == null) {
            values = new HashSet<String>();
            ref.set(values);
        }
        values.add(value);
    }
}

