/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.optimize.AddAccessNodes;
import org.modeshape.jcr.query.optimize.AddJoinConditionColumnsToSources;
import org.modeshape.jcr.query.optimize.ChooseJoinAlgorithm;
import org.modeshape.jcr.query.optimize.CopyCriteria;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.PushProjects;
import org.modeshape.jcr.query.optimize.PushSelectCriteria;
import org.modeshape.jcr.query.optimize.RaiseVariableName;
import org.modeshape.jcr.query.optimize.ReplaceViews;
import org.modeshape.jcr.query.optimize.RewriteAsRangeCriteria;
import org.modeshape.jcr.query.optimize.RewriteIdentityJoins;
import org.modeshape.jcr.query.optimize.RewritePathAndNameCriteria;
import org.modeshape.jcr.query.optimize.RewritePseudoColumns;
import org.modeshape.jcr.query.optimize.RightOuterToLeftOuterJoins;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class RuleBasedOptimizer
implements Optimizer {
    private static final Logger LOGGER = Logger.getLogger(RuleBasedOptimizer.class);

    @Override
    public PlanNode optimize(QueryContext context, PlanNode plan) {
        LinkedList<OptimizerRule> rules = new LinkedList<OptimizerRule>();
        this.populateRuleStack(rules, context.getHints());
        Problems problems = context.getProblems();
        while (rules.peek() != null && !problems.hasErrors()) {
            OptimizerRule nextRule = rules.poll();
            LOGGER.debug("Running query optimizer rule {0}", new Object[]{nextRule});
            plan = nextRule.execute(context, plan, rules);
        }
        return plan;
    }

    protected void populateRuleStack(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
        ruleStack.addFirst(RewritePathAndNameCriteria.INSTANCE);
        if (hints.hasSubqueries) {
            ruleStack.addFirst(RaiseVariableName.INSTANCE);
        }
        ruleStack.addFirst(RewriteAsRangeCriteria.INSTANCE);
        if (hints.hasJoin) {
            ruleStack.addFirst(AddJoinConditionColumnsToSources.INSTANCE);
            ruleStack.addFirst(ChooseJoinAlgorithm.USE_ONLY_NESTED_JOIN_ALGORITHM);
            ruleStack.addFirst(RewriteIdentityJoins.INSTANCE);
        }
        ruleStack.addFirst(PushProjects.INSTANCE);
        ruleStack.addFirst(PushSelectCriteria.INSTANCE);
        ruleStack.addFirst(AddAccessNodes.INSTANCE);
        ruleStack.addFirst(RightOuterToLeftOuterJoins.INSTANCE);
        ruleStack.addFirst(CopyCriteria.INSTANCE);
        if (hints.hasView) {
            ruleStack.addFirst(ReplaceViews.INSTANCE);
        }
        ruleStack.addFirst(RewritePseudoColumns.INSTANCE);
    }
}

