/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.Binary;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueComparators;

@Immutable
public enum PropertyType {
    STRING("String", ValueComparators.STRING_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), String.class, new Class[0]),
    BINARY("Binary", ValueComparators.BINARY_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Binary.class, new Class[0]),
    LONG("Long", ValueComparators.LONG_COMPARATOR, (Canonicalizer)new LongCanonicalizer(), Long.class, Integer.class, Short.class),
    DOUBLE("Double", ValueComparators.DOUBLE_COMPARATOR, (Canonicalizer)new DoubleCanonicalizer(), Double.class, Float.class),
    DECIMAL("Decimal", ValueComparators.DECIMAL_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), BigDecimal.class, new Class[0]),
    DATE("Date", ValueComparators.DATE_TIME_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), DateTime.class, new Class[0]),
    BOOLEAN("Boolean", ValueComparators.BOOLEAN_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Boolean.class, new Class[0]),
    NAME("Name", ValueComparators.NAME_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Name.class, new Class[0]),
    PATH("Path", ValueComparators.PATH_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Path.class, new Class[0]),
    UUID("UUID", ValueComparators.UUID_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), UUID.class, new Class[0]),
    REFERENCE("Reference", ValueComparators.REFERENCE_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Reference.class, new Class[0]),
    WEAKREFERENCE("WeakReference", ValueComparators.REFERENCE_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Reference.class, new Class[0]),
    URI("URI", ValueComparators.URI_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), URI.class, new Class[0]),
    OBJECT("Object", ValueComparators.OBJECT_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Object.class, new Class[0]);

    private static final List<PropertyType> ALL_PROPERTY_TYPES;
    private static final Map<String, PropertyType> PROPERTY_TYPE_BY_LOWERCASE_NAME;
    private final String name;
    private final Comparator<?> comparator;
    private final Canonicalizer canonicalizer;
    private final Class<?> valueClass;
    private final Set<Class<?>> castableValueClasses;
    private final TypeChecker typeChecker;

    private PropertyType(String name, Comparator<?> comparator, Canonicalizer canonicalizer, Class<?> valueClass, Class<?> ... castableClasses) {
        this(name, comparator, canonicalizer, valueClass, (TypeChecker)null, castableClasses);
    }

    private PropertyType(String name, Comparator<?> comparator, Canonicalizer canonicalizer, Class<?> valueClass, TypeChecker typeChecker, Class<?> ... castableClasses) {
        this.name = name;
        this.comparator = comparator;
        this.canonicalizer = canonicalizer;
        this.valueClass = valueClass;
        this.castableValueClasses = castableClasses != null && castableClasses.length != 0 ? Collections.unmodifiableSet(new HashSet(Arrays.asList(castableClasses))) : Collections.emptySet();
        this.typeChecker = typeChecker != null ? typeChecker : new ClassBasedTypeChecker(this.valueClass);
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getName() {
        return this.name;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public Object getCanonicalValue(Object value) {
        return this.canonicalizer.canonicalizeValue(value);
    }

    public final boolean isTypeFor(Object value) {
        if (this.typeChecker.isTypeFor(value)) {
            return true;
        }
        for (Class<?> valueClass : this.castableValueClasses) {
            if (!valueClass.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public final boolean isTypeForEach(Iterable<?> values) {
        for (Object value : values) {
            if (this.isTypeFor(value)) continue;
            return false;
        }
        return true;
    }

    public final boolean isTypeForEach(Iterator<?> values) {
        while (values.hasNext()) {
            Object value = values.next();
            if (this.isTypeFor(value)) continue;
            return false;
        }
        return true;
    }

    public static PropertyType discoverType(Object value) {
        if (value == null) {
            throw new IllegalArgumentException(GraphI18n.unableToDiscoverPropertyTypeForNullValue.text(new Object[0]));
        }
        for (PropertyType type : PropertyType.values()) {
            if (type == OBJECT || !type.isTypeFor(value)) continue;
            return type;
        }
        return OBJECT;
    }

    public static PropertyType discoverType(Class<?> clazz) {
        CheckArg.isNotNull(clazz, (String)"clazz");
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        block6: for (PropertyType type : PropertyType.values()) {
            if (type.valueClass.equals(clazz)) {
                return type;
            }
            switch (type) {
                case LONG: {
                    if (Long.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Short.TYPE.equals(clazz)) {
                        return type;
                    }
                    if (!Integer.class.equals(clazz) && !Short.class.equals(clazz)) continue block6;
                    return type;
                }
                case DOUBLE: {
                    if (Double.TYPE.equals(clazz) || Float.TYPE.equals(clazz)) {
                        return type;
                    }
                    if (!Float.class.equals(clazz)) continue block6;
                    return type;
                }
                case BOOLEAN: {
                    if (!Boolean.TYPE.equals(clazz)) continue block6;
                    return type;
                }
            }
        }
        for (PropertyType type : PropertyType.values()) {
            if (!clazz.isAssignableFrom(type.valueClass)) continue;
            return type;
        }
        return null;
    }

    public static Iterator<PropertyType> iterator() {
        return ALL_PROPERTY_TYPES.iterator();
    }

    public static PropertyType valueFor(String typeNameInAnyCase) {
        PropertyType type = PROPERTY_TYPE_BY_LOWERCASE_NAME.get(typeNameInAnyCase);
        return type != null ? type : STRING;
    }

    static {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        HashMap<String, PropertyType> byLowerCaseName = new HashMap<String, PropertyType>();
        for (PropertyType type : PropertyType.values()) {
            types.add(type);
            byLowerCaseName.put(type.getName().toLowerCase(), type);
        }
        byLowerCaseName.put("undefined", OBJECT);
        ALL_PROPERTY_TYPES = Collections.unmodifiableList(types);
        PROPERTY_TYPE_BY_LOWERCASE_NAME = Collections.unmodifiableMap(byLowerCaseName);
    }

    protected static final class ClassBasedTypeChecker
    implements TypeChecker {
        private final Class<?> valueClass;

        protected ClassBasedTypeChecker(Class<?> valueClass) {
            this.valueClass = valueClass;
            assert (this.valueClass != null);
        }

        @Override
        public boolean isTypeFor(Object value) {
            return this.valueClass.isInstance(value);
        }
    }

    protected static final class WeakReferenceTypeChecker
    implements TypeChecker {
        protected WeakReferenceTypeChecker() {
        }

        @Override
        public boolean isTypeFor(Object value) {
            return value instanceof Reference && ((Reference)value).isWeak();
        }
    }

    protected static final class StrongReferenceTypeChecker
    implements TypeChecker {
        protected StrongReferenceTypeChecker() {
        }

        @Override
        public boolean isTypeFor(Object value) {
            return value instanceof Reference && !((Reference)value).isWeak();
        }
    }

    private static interface TypeChecker {
        public boolean isTypeFor(Object var1);
    }

    protected static final class DoubleCanonicalizer
    implements Canonicalizer {
        protected DoubleCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            if (value instanceof Float) {
                return new Double(((Float)value).floatValue());
            }
            return value;
        }
    }

    protected static final class LongCanonicalizer
    implements Canonicalizer {
        protected LongCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            if (value instanceof Integer) {
                return new Long(((Integer)value).intValue());
            }
            if (value instanceof Short) {
                return new Long(((Short)value).shortValue());
            }
            return value;
        }
    }

    protected static final class ObjectCanonicalizer
    implements Canonicalizer {
        protected ObjectCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            return value;
        }
    }

    private static interface Canonicalizer {
        public Object canonicalizeValue(Object var1);
    }
}

