/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import javax.jcr.RepositoryException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.value.Binary;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.ValueComparators;

@Immutable
public abstract class AbstractBinary
implements Binary {
    protected static final byte[] EMPTY_CONTENT = new byte[0];
    private static final long serialVersionUID = 1L;
    private final BinaryKey key;

    public static BinaryKey keyFor(byte[] sha1) {
        try {
            byte[] hash = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])sha1);
            return new BinaryKey(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    protected AbstractBinary(BinaryKey key) {
        this.key = key;
        assert (this.key != null);
    }

    public int read(byte[] b, long position) throws IOException, RepositoryException {
        if (this.getSize() <= position) {
            return -1;
        }
        InputStream stream = null;
        Throwable error = null;
        try {
            long skipped;
            stream = this.getStream();
            for (long skip = position; skip > 0L; skip -= skipped) {
                skipped = stream.skip(skip);
                if (skipped > 0L) continue;
                int n = -1;
                return n;
            }
            int n = stream.read(b);
            return n;
        }
        catch (RepositoryException e) {
            error = e;
            throw e;
        }
        catch (IOException e) {
            error = e;
            throw e;
        }
        finally {
            block20: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (RuntimeException t) {
                        if (error == null) {
                            throw t;
                        }
                    }
                    catch (IOException t) {
                        if (error != null) break block20;
                        throw t;
                    }
                }
            }
        }
    }

    @Override
    public BinaryKey getKey() {
        return this.key;
    }

    public byte[] getHash() {
        return this.key.toBytes();
    }

    public String getHexHash() {
        return this.key.toString();
    }

    public void dispose() {
    }

    @Override
    public int compareTo(Binary o) {
        if (o == this) {
            return 0;
        }
        return ValueComparators.BINARY_COMPARATOR.compare(this, o);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary that = (Binary)obj;
            return ValueComparators.BINARY_COMPARATOR.compare(this, that) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("binary (");
        sb.append(this.getReadableSize());
        sb.append(", SHA1=");
        sb.append(this.getHexHash());
        sb.append(')');
        return sb.toString();
    }

    public String getReadableSize() {
        long size = this.getSize();
        float decimalInKb = (float)size / 1024.0f;
        if (decimalInKb < 1.0f) {
            return Long.toString(size) + "B";
        }
        float decimalInMb = decimalInKb / 1024.0f;
        if (decimalInMb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInKb) + "KB";
        }
        float decimalInGb = decimalInMb / 1024.0f;
        if (decimalInGb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInMb) + "MB";
        }
        float decimalInTb = decimalInGb / 1024.0f;
        if (decimalInTb < 1.0f) {
            return new DecimalFormat("#,##0.00").format(decimalInGb) + "GB";
        }
        return new DecimalFormat("#,##0.00").format(decimalInTb) + "TB";
    }
}

