/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.jcr.text.NoOpTextExtractor;
import org.modeshape.jcr.text.TextExtractor;
import org.modeshape.jcr.value.binary.BinaryStore;

@ThreadSafe
public abstract class AbstractBinaryStore
implements BinaryStore {
    private static final long LARGE_SIZE = 0x2000000L;
    private static final long MEDIUM_FILE_SIZE = 0x100000L;
    private static final long SMALL_FILE_SIZE = 32768L;
    private static final long TINY_FILE_SIZE = 1024L;
    private static final int LARGE_BUFFER_SIZE = 0x100000;
    protected static final int MEDIUM_BUFFER_SIZE = 65536;
    private static final int SMALL_BUFFER_SIZE = 4096;
    private static final int TINY_BUFFER_SIZE = 2048;
    private final AtomicLong minBinarySizeInBytes = new AtomicLong(4096L);
    private volatile TextExtractor extractor = NoOpTextExtractor.INSTANCE;
    private volatile MimeTypeDetector detector = ExtensionBasedMimeTypeDetector.INSTANCE;

    public static int bestBufferSize(long fileSize) {
        assert (fileSize >= 0L);
        if (fileSize < 1024L) {
            return (int)fileSize + 2;
        }
        if (fileSize < 32768L) {
            return 2048;
        }
        if (fileSize < 0x100000L) {
            return 4096;
        }
        if (fileSize < 0x2000000L) {
            return 65536;
        }
        return 0x100000;
    }

    @Override
    public long getMinimumBinarySizeInBytes() {
        return this.minBinarySizeInBytes.get();
    }

    @Override
    public void setMinimumBinarySizeInBytes(long minSizeInBytes) {
        CheckArg.isNonNegative((long)minSizeInBytes, (String)"minSizeInBytes");
        this.minBinarySizeInBytes.set(minSizeInBytes);
    }

    @Override
    public void setTextExtractor(TextExtractor textExtractor) {
        this.extractor = textExtractor != null ? textExtractor : NoOpTextExtractor.INSTANCE;
    }

    @Override
    public void setMimeTypeDetector(MimeTypeDetector mimeTypeDetector) {
        this.detector = mimeTypeDetector != null ? mimeTypeDetector : ExtensionBasedMimeTypeDetector.INSTANCE;
    }

    protected final TextExtractor extractor() {
        return this.extractor;
    }

    protected final MimeTypeDetector detector() {
        return this.detector;
    }
}

