/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.FileLocks;
import org.modeshape.jcr.value.binary.NamedLocks;

public final class SharedLockingInputStream
extends InputStream {
    private final BinaryKey key;
    private final File file;
    private final NamedLocks lockManager;
    private InputStream stream;
    private Lock processLock;
    private FileLocks.WrappedLock fileLock;

    public SharedLockingInputStream(BinaryKey key, File file, NamedLocks lockManager) {
        assert (key != null);
        assert (file != null);
        this.key = key;
        this.file = file;
        this.lockManager = lockManager;
    }

    protected void open() throws IOException {
        if (this.stream == null) {
            if (this.lockManager != null) {
                this.processLock = this.lockManager.readLock(this.key.toString());
            }
            this.fileLock = FileLocks.get().readLock(this.file);
            this.stream = new BufferedInputStream(new FileInputStream(this.file), AbstractBinaryStore.bestBufferSize(this.file.length()));
        }
    }

    @Override
    public int available() throws IOException {
        try {
            this.open();
            return this.stream.available();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.stream = null;
                if (this.fileLock != null) {
                    try {
                        this.fileLock.unlock();
                    }
                    finally {
                        this.fileLock = null;
                        if (this.processLock != null) {
                            try {
                                this.processLock.unlock();
                            }
                            finally {
                                this.processLock = null;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof File) {
            return this.file.equals(obj);
        }
        if (obj instanceof BinaryKey) {
            return this.key.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.open();
            this.stream.mark(readlimit);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        try {
            this.open();
            return this.stream.markSupported();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.open();
            int result = this.stream.read(b, off, len);
            if (result == -1) {
                this.close();
            }
            return result;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            this.open();
            int result = this.stream.read(b);
            if (result == -1) {
                this.close();
            }
            return result;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            this.open();
            int result = this.stream.read();
            if (result == -1) {
                this.close();
            }
            return result;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.stream != null) {
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw e;
            }
            catch (RuntimeException e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            this.open();
            return this.stream.skip(n);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.key.toString();
    }
}

