/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.xml.sax.SAXException;

public class JndiRepositoryFactory
implements ObjectFactory {
    private static final String CONFIG_FILE = "configFile";
    private static final String CONFIG_FILES = "configFiles";
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final JcrEngine engine = new JcrEngine();
    protected static final Logger log = Logger.getLogger(JndiRepositoryFactory.class);

    static Future<Boolean> shutdown() {
        return engine.shutdown();
    }

    private static synchronized JcrRepository getRepository(String configFileName, String repositoryName, Context nameCtx, final Name jndiName) throws IOException, RepositoryException, NamingException {
        block13: {
            if (repositoryName != null) {
                engine.start();
                try {
                    JcrRepository repository = engine.getRepository(repositoryName);
                    switch (repository.getState()) {
                        case STARTING: 
                        case RUNNING: {
                            return repository;
                        }
                    }
                    log.error(JcrI18n.repositoryIsNotRunningOrHasBeenShutDown, new Object[]{repositoryName});
                    return null;
                }
                catch (NoSuchRepositoryException e) {
                    if (configFileName != null) break block13;
                    throw e;
                }
            }
        }
        RepositoryConfiguration config = RepositoryConfiguration.read(configFileName);
        if (repositoryName == null) {
            repositoryName = config.getName();
        } else if (!repositoryName.equals(config.getName())) {
            log.error(JcrI18n.repositoryNameDoesNotMatchConfigurationName, new Object[]{repositoryName, config.getName(), configFileName});
        }
        JcrRepository repository = engine.deploy(config);
        try {
            engine.startRepository(repository.getName()).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RepositoryException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RepositoryException(e.getCause());
        }
        if (nameCtx instanceof EventContext) {
            EventContext evtCtx = (EventContext)nameCtx;
            NamespaceChangeListener listener = new NamespaceChangeListener(){

                @Override
                public void namingExceptionThrown(NamingExceptionEvent evt) {
                    evt.getException().printStackTrace();
                }

                @Override
                public void objectAdded(NamingEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void objectRemoved(NamingEvent evt) {
                    Object oldObject = evt.getOldBinding().getObject();
                    if (!(oldObject instanceof JcrRepository)) {
                        return;
                    }
                    JcrRepository repository = (JcrRepository)oldObject;
                    String repoName = repository.getName();
                    try {
                        engine.shutdownRepository(repoName).get();
                    }
                    catch (NoSuchRepositoryException e) {
                    }
                    catch (InterruptedException ie) {
                        log.error((Throwable)ie, JcrI18n.errorWhileShuttingDownRepositoryInJndi, new Object[]{repoName, jndiName});
                    }
                    catch (ExecutionException e) {
                        log.error(e.getCause(), JcrI18n.errorWhileShuttingDownRepositoryInJndi, new Object[]{repoName, jndiName});
                    }
                    finally {
                        engine.shutdown(false);
                    }
                }

                @Override
                public void objectRenamed(NamingEvent evt) {
                }
            };
            evtCtx.addNamingListener(jndiName, 0, (NamingListener)listener);
        }
        return repository;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws IOException, SAXException, RepositoryException, NamingException {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        RefAddr repositoryName = ref.get(REPOSITORY_NAME);
        String repoName = repositoryName != null ? repositoryName.getContent().toString() : null;
        RefAddr configFileRef = ref.get(CONFIG_FILE);
        String configFile = configFileRef != null ? configFileRef.getContent().toString() : null;
        RefAddr configFilesRef = ref.get(CONFIG_FILES);
        Set<String> configFiles = configFilesRef != null ? this.parseStrings(configFilesRef.getContent().toString()) : null;
        engine.start();
        if (repoName != null && configFile != null) {
            return JndiRepositoryFactory.getRepository(configFile, repoName, nameCtx, name);
        }
        if (configFiles != null) {
            for (String file : configFiles) {
                JndiRepositoryFactory.getRepository(file, null, nameCtx, name);
            }
            return engine;
        }
        return null;
    }

    protected Set<String> parseStrings(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()) == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String strValue : value.split(",")) {
            if (strValue == null || (strValue = strValue.trim()) == null) continue;
            result.add(strValue);
        }
        return result;
    }
}

