/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.modeshape.jcr.query.lucene.CompareQuery;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class ComparePathQuery
extends CompareQuery<Path> {
    private static final long serialVersionUID = 1L;
    protected static final CompareQuery.Evaluator<Path> PATH_IS_LESS_THAN = new CompareQuery.Evaluator<Path>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_GREATER_THAN = new CompareQuery.Evaluator<Path>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };
    private final boolean caseSensitive;

    public static ComparePathQuery createQueryForNodesWithPathGreaterThan(Path constraintPath, String fieldName, ValueFactories factories, boolean caseSensitive) {
        return new ComparePathQuery(fieldName, constraintPath, factories.getPathFactory(), factories.getStringFactory(), PATH_IS_GREATER_THAN, caseSensitive);
    }

    public static ComparePathQuery createQueryForNodesWithPathGreaterThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, boolean caseSensitive) {
        return new ComparePathQuery(fieldName, constraintPath, factories.getPathFactory(), factories.getStringFactory(), PATH_IS_GREATER_THAN_OR_EQUAL_TO, caseSensitive);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThan(Path constraintPath, String fieldName, ValueFactories factories, boolean caseSensitive) {
        return new ComparePathQuery(fieldName, constraintPath, factories.getPathFactory(), factories.getStringFactory(), PATH_IS_LESS_THAN, caseSensitive);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, boolean caseSensitive) {
        return new ComparePathQuery(fieldName, constraintPath, factories.getPathFactory(), factories.getStringFactory(), PATH_IS_LESS_THAN_OR_EQUAL_TO, caseSensitive);
    }

    protected ComparePathQuery(String fieldName, Path constraintPath, ValueFactory<Path> pathFactory, ValueFactory<String> stringFactory, CompareQuery.Evaluator<Path> evaluator, boolean caseSensitive) {
        super(fieldName, constraintPath, pathFactory, stringFactory, evaluator);
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected Path readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        if (!this.caseSensitive) {
            valueString = valueString.toLowerCase();
        }
        return (Path)this.valueTypeFactory.create(valueString);
    }

    public Object clone() {
        return new ComparePathQuery(this.fieldName, (Path)this.constraintValue, this.valueTypeFactory, (ValueFactory<String>)this.stringFactory, this.evaluator, this.caseSensitive);
    }
}

