/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.Sequencers;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.change.RecordingChanges;

final class SequencingRunner
implements Runnable {
    private final JcrRepository repository;
    private final Sequencers.SequencingWorkItem work;
    protected static final String DERIVED_NODE_TYPE_NAME = "mode:derived";
    protected static final String DERIVED_FROM_PROPERTY_NAME = "mode:derivedFrom";

    protected SequencingRunner(JcrRepository repository, Sequencers.SequencingWorkItem work) {
        this.repository = repository;
        this.work = work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block33: {
            JcrSession inputSession = null;
            JcrSession outputSession = null;
            JcrRepository.RunningState state = this.repository.runningState();
            RepositoryStatistics stats = state.statistics();
            Sequencer sequencer = null;
            String sequencerName = null;
            try {
                inputSession = state.loginInternalSession(this.work.getInputWorkspaceName());
                outputSession = this.work.getOutputWorkspaceName() != null && !this.work.getOutputWorkspaceName().equals(this.work.getInputWorkspaceName()) ? state.loginInternalSession(this.work.getOutputWorkspaceName()) : inputSession;
                sequencer = state.sequencers().getSequencer(this.work.getSequencerId());
                if (sequencer == null) {
                    return;
                }
                sequencerName = sequencer.getName();
                AbstractJcrNode selectedNode = inputSession.getNode(this.work.getSelectedPath());
                AbstractJcrItem inputItem = inputSession.getItem(this.work.getInputPath());
                Property changedProperty = null;
                if (inputItem instanceof Property) {
                    changedProperty = (Property)inputItem;
                } else {
                    Node changedNode = (Node)inputItem;
                    changedProperty = changedNode.getProperty(this.work.getChangedPropertyName());
                }
                assert (changedProperty != null);
                if (sequencer.hasAcceptedMimeTypes()) {
                    javax.jcr.Binary binary;
                    Property property;
                    Node parent = changedProperty.getParent();
                    String mimeType = null;
                    if (parent.hasProperty("jcr:mimeType")) {
                        property = parent.getProperty("jcr:mimeType");
                        if (!property.isMultiple()) {
                            mimeType = property.getString();
                        }
                    } else if (parent.getName().equals("jcr:content")) {
                        try {
                            parent = parent.getParent();
                            if (parent.hasProperty("jcr:mimeType") && !(property = parent.getProperty("jcr:mimeType")).isMultiple()) {
                                mimeType = property.getString();
                            }
                        }
                        catch (ItemNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (mimeType == null && !changedProperty.isMultiple() && changedProperty.getType() == 2 && (binary = changedProperty.getBinary()) instanceof Binary) {
                        mimeType = ((Binary)binary).getMimeType(parent.getName());
                    }
                    if (mimeType != null && !sequencer.isAccepted(mimeType)) {
                        return;
                    }
                }
                AbstractJcrNode outputNode = null;
                String primaryType = null;
                if (this.work.getSelectedPath().equals(this.work.getOutputPath())) {
                    outputNode = selectedNode.getName().equals("jcr:content") ? selectedNode.getParent() : selectedNode;
                    primaryType = selectedNode.getPrimaryNodeType().getName();
                } else {
                    AbstractJcrNode parentOfOutput = null;
                    try {
                        parentOfOutput = outputSession.getNode(this.work.getOutputPath());
                    }
                    catch (PathNotFoundException e) {
                        JcrTools tools = new JcrTools();
                        parentOfOutput = tools.findOrCreateNode((Session)outputSession, this.work.getOutputPath());
                    }
                    String outputNodeName = this.computeOutputNodeName(selectedNode);
                    this.removeExistingOutputNodes(parentOfOutput, outputNodeName, this.work.getSelectedPath());
                    outputNode = parentOfOutput.isNew() && parentOfOutput.getName().equals(outputNodeName) ? parentOfOutput : (AbstractJcrNode)parentOfOutput.addNode(outputNodeName, "nt:unstructured");
                    outputNode.addMixin(DERIVED_NODE_TYPE_NAME);
                    outputNode.setProperty(DERIVED_FROM_PROPERTY_NAME, this.work.getSelectedPath());
                }
                DateTime now = outputSession.dateFactory().create();
                Sequencers.SequencingContext context = new Sequencers.SequencingContext(now, outputSession.getValueFactory(), outputSession.context().getMimeTypeDetector());
                if (!inputSession.isLive() || inputSession != outputSession && !outputSession.isLive()) break block33;
                long start = System.nanoTime();
                try {
                    if (sequencer.execute(changedProperty, (Node)outputNode, (Sequencer.Context)context)) {
                        if (selectedNode == outputNode && !selectedNode.getPrimaryNodeType().getName().equals(primaryType)) {
                            String msg = RepositoryI18n.sequencersMayNotChangeThePrimaryTypeOfTheSelectedNode.text(new Object[0]);
                            throw new RepositoryException(msg);
                        }
                        List<AbstractJcrNode> outputNodes = this.findOutputNodes(outputNode);
                        this.setCreatedByIfNecessary(outputSession, outputNodes);
                        outputSession.save();
                        this.fireSequencingEvent(selectedNode, outputNodes, outputSession, sequencerName);
                        long durationInNanos = System.nanoTime() - start;
                        HashMap<String, String> payload = new HashMap<String, String>();
                        payload.put("sequencerName", sequencer.getClass().getName());
                        payload.put("sequencedPath", changedProperty.getPath());
                        payload.put("outputPath", outputNode.getPath());
                        stats.recordDuration(DurationMetric.SEQUENCER_EXECUTION_TIME, durationInNanos, TimeUnit.NANOSECONDS, payload);
                    }
                }
                catch (Throwable t) {
                    this.fireSequencingFailureEvent(selectedNode, inputSession, t, sequencerName);
                    throw t;
                }
            }
            catch (Throwable t) {
                Logger logger = Logger.getLogger(this.getClass());
                if (this.work.getOutputWorkspaceName() != null) {
                    logger.error(t, (I18nResource)RepositoryI18n.errorWhileSequencingNodeIntoWorkspace, new Object[]{sequencerName, state.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath(), this.work.getOutputWorkspaceName()});
                } else {
                    logger.error(t, (I18nResource)RepositoryI18n.errorWhileSequencingNode, new Object[]{sequencerName, state.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath()});
                }
            }
            finally {
                stats.increment(ValueMetric.SEQUENCED_COUNT);
                stats.decrement(ValueMetric.SEQUENCER_QUEUE_SIZE);
                if (inputSession != null && inputSession.isLive()) {
                    inputSession.logout();
                }
                if (outputSession != null && outputSession != inputSession && outputSession.isLive()) {
                    outputSession.logout();
                }
            }
        }
    }

    private void setCreatedByIfNecessary(JcrSession outputSession, List<AbstractJcrNode> outputNodes) throws RepositoryException {
        for (AbstractJcrNode node : outputNodes) {
            if (!node.isNodeType(JcrMixLexicon.CREATED)) continue;
            node.setProperty(JcrLexicon.CREATED_BY, outputSession.getValueFactory().createValue(this.work.getUserId()), true, true);
        }
    }

    private void fireSequencingEvent(AbstractJcrNode sequencedNode, List<AbstractJcrNode> outputNodes, JcrSession outputSession, String sequencerName) throws RepositoryException {
        RecordingChanges sequencingChanges = new RecordingChanges(outputSession.context().getProcessId(), outputSession.getRepository().repositoryKey(), outputSession.workspaceName());
        for (AbstractJcrNode outputNode : outputNodes) {
            sequencingChanges.nodeSequenced(sequencedNode.key(), sequencedNode.path(), outputNode.key(), outputNode.path(), this.work.getOutputPath(), this.work.getUserId(), this.work.getSelectedPath(), sequencerName);
        }
        this.repository.changeBus().notify(sequencingChanges);
    }

    private void fireSequencingFailureEvent(AbstractJcrNode sequencedNode, JcrSession inputSession, Throwable cause, String sequencerName) throws RepositoryException {
        assert (sequencedNode != null);
        assert (inputSession != null);
        RecordingChanges sequencingChanges = new RecordingChanges(inputSession.context().getProcessId(), inputSession.getRepository().repositoryKey(), inputSession.workspaceName());
        sequencingChanges.nodeSequencingFailure(sequencedNode.key(), sequencedNode.path(), this.work.getOutputPath(), this.work.getUserId(), this.work.getSelectedPath(), sequencerName, cause);
        this.repository.changeBus().notify(sequencingChanges);
    }

    private List<AbstractJcrNode> findOutputNodes(AbstractJcrNode rootOutputNode) throws RepositoryException {
        if (rootOutputNode.isNew()) {
            return Arrays.asList(rootOutputNode);
        }
        ArrayList<AbstractJcrNode> nodes = new ArrayList<AbstractJcrNode>();
        NodeIterator childrenIt = rootOutputNode.getNodes();
        while (childrenIt.hasNext()) {
            Node child = childrenIt.nextNode();
            if (!child.isNew()) continue;
            nodes.add((AbstractJcrNode)child);
        }
        return nodes;
    }

    protected final String computeOutputNodeName(Node selectedNode) throws RepositoryException {
        String selectedNodeName = selectedNode.getName();
        if (selectedNodeName.equals("jcr:content")) {
            try {
                return selectedNode.getParent().getName();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return selectedNodeName;
    }

    protected final void removeExistingOutputNodes(Node parentOfOutput, String outputNodeName, String selectedPath) throws RepositoryException {
        NodeIterator outputIter = parentOfOutput.getNodes(outputNodeName);
        while (outputIter.hasNext()) {
            String derivedFrom;
            Node outputNode = outputIter.nextNode();
            if (!outputNode.isNodeType(DERIVED_NODE_TYPE_NAME) || !outputNode.hasProperty(DERIVED_FROM_PROPERTY_NAME) || !selectedPath.equals(derivedFrom = outputNode.getProperty(DERIVED_FROM_PROPERTY_NAME).getPath())) continue;
            outputNode.remove();
        }
    }
}

