/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValueFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
class XmlNodeTypeReader
extends DefaultHandler {
    private static final String NODE_TYPE = "nodeType";
    private static final String PROPERTY_DEFINITION = "propertyDefinition";
    private static final String CHILD_NODE_DEFINITION = "childNodeDefinition";
    private static final String SUPERTYPES = "supertypes";
    private static final String REQUIRED_PRIMARY_TYPES = "requiredPrimaryTypes";
    private static final String DEFAULT_VALUES = "defaultValues";
    private static final String VALUE_CONSTRAINTS = "valueConstraints";
    private static final String SUPERTYPE = "supertype";
    private static final String REQUIRED_PRIMARY_TYPE = "requiredPrimaryType";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String VALUE_CONSTRAINT = "valueConstraint";
    protected JcrSession session;
    private final NodeTypeManager nodeTypeManager;
    private List<NodeTypeTemplate> nodeTypes = new ArrayList<NodeTypeTemplate>();
    private final Map<String, CharHandler> charHandlers = new HashMap<String, CharHandler>();
    private CharHandler charHandler;
    protected NodeTypeTemplate currentNodeType;
    protected PropertyDefinitionTemplate currentPropDefn;
    protected NodeDefinitionTemplate currentChildDefn;
    private NamespaceRegistry namespaces;

    XmlNodeTypeReader(JcrSession session) throws RepositoryException {
        this.session = session;
        this.nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        this.namespaces = this.session.getWorkspace().getNamespaceRegistry();
        SupertypeNameHandler supertypeHandler = new SupertypeNameHandler();
        RequiredPrimaryTypeHandler requiredPrimaryTypeHandler = new RequiredPrimaryTypeHandler();
        DefaultValueHandler defaultHandler = new DefaultValueHandler();
        ConstraintHandler constraintHandler = new ConstraintHandler();
        this.charHandlers.put(SUPERTYPES, supertypeHandler);
        this.charHandlers.put(REQUIRED_PRIMARY_TYPES, requiredPrimaryTypeHandler);
        this.charHandlers.put(DEFAULT_VALUES, defaultHandler);
        this.charHandlers.put(VALUE_CONSTRAINTS, constraintHandler);
        this.charHandlers.put(SUPERTYPE, supertypeHandler);
        this.charHandlers.put(REQUIRED_PRIMARY_TYPE, requiredPrimaryTypeHandler);
        this.charHandlers.put(DEFAULT_VALUE, defaultHandler);
        this.charHandlers.put(VALUE_CONSTRAINT, constraintHandler);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            try {
                this.namespaces.getPrefix(uri);
            }
            catch (NamespaceException e) {
                this.namespaces.registerNamespace(prefix, uri);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String value = null;
        try {
            if (NODE_TYPE.equals(localName)) {
                this.currentNodeType = this.nodeTypeManager.createNodeTypeTemplate();
                value = atts.getValue("name");
                if (value != null) {
                    this.currentNodeType.setName(value);
                }
                if ((value = atts.getValue("isMixin")) != null) {
                    this.currentNodeType.setMixin(this.bool(value));
                }
                if ((value = atts.getValue("hasOrderableChildNodes")) != null) {
                    this.currentNodeType.setOrderableChildNodes(this.bool(value));
                }
                if ((value = atts.getValue("primaryItemName")) != null) {
                    this.currentNodeType.setPrimaryItemName(value);
                }
            } else if (PROPERTY_DEFINITION.equals(localName)) {
                this.currentPropDefn = this.nodeTypeManager.createPropertyDefinitionTemplate();
                this.currentChildDefn = null;
                value = atts.getValue("name");
                if (value != null) {
                    this.currentPropDefn.setName(value);
                }
                if ((value = atts.getValue("requiredType")) != null) {
                    this.currentPropDefn.setRequiredType(this.type(value));
                }
                if ((value = atts.getValue("autoCreated")) != null) {
                    this.currentPropDefn.setAutoCreated(this.bool(value));
                }
                if ((value = atts.getValue("mandatory")) != null) {
                    this.currentPropDefn.setMandatory(this.bool(value));
                }
                if ((value = atts.getValue("onParentVersion")) != null) {
                    this.currentPropDefn.setOnParentVersion(this.opv(value));
                }
                if ((value = atts.getValue("protected")) != null) {
                    this.currentPropDefn.setProtected(this.bool(value));
                }
                if ((value = atts.getValue("multiple")) != null) {
                    this.currentPropDefn.setMultiple(this.bool(value));
                }
            } else if (CHILD_NODE_DEFINITION.equals(localName)) {
                this.currentChildDefn = this.nodeTypeManager.createNodeDefinitionTemplate();
                this.currentPropDefn = null;
                value = atts.getValue("name");
                if (value != null) {
                    this.currentChildDefn.setName(value);
                }
                if ((value = atts.getValue("defaultPrimaryType")) != null) {
                    this.currentChildDefn.setDefaultPrimaryTypeName(value);
                }
                if ((value = atts.getValue("autoCreated")) != null) {
                    this.currentChildDefn.setAutoCreated(this.bool(value));
                }
                if ((value = atts.getValue("mandatory")) != null) {
                    this.currentChildDefn.setMandatory(this.bool(value));
                }
                if ((value = atts.getValue("onParentVersion")) != null) {
                    this.currentChildDefn.setOnParentVersion(this.opv(value));
                }
                if ((value = atts.getValue("protected")) != null) {
                    this.currentChildDefn.setProtected(this.bool(value));
                }
                if ((value = atts.getValue("sameNameSiblings")) != null) {
                    this.currentChildDefn.setSameNameSiblings(this.bool(value));
                }
            }
            this.charHandler = this.charHandlers.get(localName);
            if (this.charHandler != null) {
                this.charHandler.incrementStack();
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.charHandler != null) {
            try {
                if (this.charHandler.finish()) {
                    this.charHandler = null;
                }
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        if (NODE_TYPE.equals(localName)) {
            this.nodeTypes.add(this.currentNodeType);
            this.currentNodeType = null;
        } else if (PROPERTY_DEFINITION.equals(localName)) {
            this.currentNodeType.getPropertyDefinitionTemplates().add(this.currentPropDefn);
            this.currentPropDefn = null;
        } else if (CHILD_NODE_DEFINITION.equals(localName)) {
            this.currentNodeType.getNodeDefinitionTemplates().add(this.currentChildDefn);
            this.currentChildDefn = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.charHandler != null) {
            String value = new String(ch, start, length);
            this.charHandler.characters(value);
        }
    }

    protected boolean bool(String value) {
        return Boolean.parseBoolean(value);
    }

    protected int type(String value) {
        return PropertyType.valueFromName((String)value);
    }

    protected int opv(String value) {
        return OnParentVersionAction.valueFromName((String)value);
    }

    public List<NodeTypeDefinition> getNodeTypeDefinitions() {
        return Collections.unmodifiableList(new ArrayList<NodeTypeTemplate>(this.nodeTypes));
    }

    protected class ConstraintHandler
    extends CharHandler {
        protected ConstraintHandler() {
        }

        @Override
        protected void doFinish() {
            XmlNodeTypeReader.this.currentPropDefn.setValueConstraints(this.getStringValues());
        }
    }

    protected class DefaultValueHandler
    extends CharHandler {
        protected DefaultValueHandler() {
        }

        @Override
        protected void doFinish() throws RepositoryException {
            XmlNodeTypeReader.this.currentPropDefn.setDefaultValues(this.getJcrValues());
        }
    }

    protected class RequiredPrimaryTypeHandler
    extends CharHandler {
        protected RequiredPrimaryTypeHandler() {
        }

        @Override
        protected void doFinish() throws RepositoryException {
            XmlNodeTypeReader.this.currentChildDefn.setRequiredPrimaryTypeNames(this.getStringValues());
        }
    }

    protected class SupertypeNameHandler
    extends CharHandler {
        protected SupertypeNameHandler() {
        }

        @Override
        protected void doFinish() throws RepositoryException {
            XmlNodeTypeReader.this.currentNodeType.setDeclaredSuperTypeNames(this.getStringValues());
        }
    }

    protected abstract class CharHandler {
        private Set<String> values = new LinkedHashSet<String>();
        private int stack = 0;

        protected CharHandler() {
        }

        public void characters(String chars) {
            if (chars == null) {
                return;
            }
            if ((chars = chars.trim()).length() == 0) {
                return;
            }
            this.values.add(chars);
        }

        public void incrementStack() {
            ++this.stack;
        }

        public boolean finish() throws RepositoryException {
            if (--this.stack < 1) {
                this.doFinish();
                this.stack = 0;
                return true;
            }
            return false;
        }

        protected abstract void doFinish() throws RepositoryException;

        protected final String[] getStringValues() {
            Set<String> values = this.values;
            this.values = new LinkedHashSet<String>();
            return values.toArray(new String[values.size()]);
        }

        protected final Value[] getJcrValues() throws RepositoryException {
            Value[] values = new Value[this.values.size()];
            JcrValueFactory factory = XmlNodeTypeReader.this.session.getValueFactory();
            int i = 0;
            for (String value : this.values) {
                values[i++] = factory.createValue(value);
            }
            this.values = new LinkedHashSet<String>();
            return values;
        }
    }
}

