/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.WorkspaceCache;

public abstract class Transactions {
    protected final TransactionManager txnMgr;
    protected final SessionEnvironment.MonitorFactory monitorFactory;

    protected Transactions(SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
        this.monitorFactory = monitorFactory;
        this.txnMgr = txnMgr;
    }

    public abstract Transaction begin() throws NotSupportedException, SystemException;

    public void updateCache(WorkspaceCache workspace, ChangeSet changes) {
        if (changes != null && changes.size() != 0) {
            workspace.changed(changes);
        }
    }

    protected SessionEnvironment.Monitor newMonitor() {
        return this.monitorFactory.createMonitor();
    }

    protected class SimpleTransaction
    extends BaseTransaction {
        protected SimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.txnMgr.rollback();
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.txnMgr.commit();
            this.executeFunctions();
        }
    }

    protected abstract class BaseTransaction
    implements Transaction {
        protected final TransactionManager txnMgr;
        private List<TransactionFunction> functions;

        protected BaseTransaction(TransactionManager txnMgr) {
            this.txnMgr = txnMgr;
        }

        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return Transactions.this.newMonitor();
        }

        protected void executeFunctions() {
            if (this.functions != null) {
                for (TransactionFunction function : this.functions) {
                    function.transactionComplete();
                }
            }
        }

        @Override
        public void uponCompletion(TransactionFunction function) {
            if (this.functions == null) {
                this.functions = Collections.singletonList(function);
            } else {
                if (this.functions.size() == 1) {
                    this.functions = new LinkedList<TransactionFunction>(this.functions);
                }
                this.functions.add(function);
            }
        }
    }

    public static interface TransactionFunction {
        public void transactionComplete();
    }

    public static interface Transaction
    extends SessionEnvironment.MonitorFactory {
        @Override
        public SessionEnvironment.Monitor createMonitor();

        public void uponCompletion(TransactionFunction var1);

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException;

        public void rollback() throws IllegalStateException, SecurityException, SystemException;
    }
}

