/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.text.TextExtractor;
import org.modeshape.jcr.api.text.TextExtractorOutput;

@Immutable
public final class TextExtractors
extends TextExtractor {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final List<TextExtractor> extractors = new ArrayList<TextExtractor>();
    private final boolean stopAfterFirst;

    public TextExtractors(JcrRepository.RunningState repository, Collection<RepositoryConfiguration.Component> components) {
        this.stopAfterFirst = true;
        for (RepositoryConfiguration.Component component : components) {
            try {
                TextExtractor extractor = (TextExtractor)component.createInstance(((Object)((Object)this)).getClass().getClassLoader());
                this.setLogger(ExtensionLogger.getLogger(extractor.getClass()));
                this.extractors.add(extractor);
            }
            catch (Throwable t) {
                String desc = component.getName();
                String repoName = repository.name();
                Logger.getLogger(((Object)((Object)this)).getClass()).error(t, (I18nResource)JcrI18n.unableToInitializeTextExtractor, new Object[]{desc, repoName, t.getMessage()});
            }
        }
    }

    public int size() {
        return this.extractors.size();
    }

    public boolean supportsMimeType(String mimeType) {
        for (TextExtractor extractor : this.extractors) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            return true;
        }
        return false;
    }

    public void extractFrom(InputStream stream, TextExtractorOutput output, TextExtractor.Context context) throws IOException {
        if (stream == null) {
            return;
        }
        if (stream.markSupported()) {
            stream.mark(Integer.MAX_VALUE);
        }
        String mimeType = context.getMimeType();
        for (TextExtractor extractor : this.extractors) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            extractor.extractFrom(stream, output, context);
            if (this.stopAfterFirst || !stream.markSupported()) break;
            stream.reset();
        }
    }
}

