/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.Changes;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeChanged;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.NodeSequenced;
import org.modeshape.jcr.cache.change.NodeSequencingFailure;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class RecordingChanges
implements Changes,
ChangeSet {
    private static final long serialVersionUID = 1L;
    private final String processKey;
    private final String repositoryKey;
    private final String workspaceName;
    private final Queue<Change> events = new ConcurrentLinkedQueue<Change>();
    private Set<NodeKey> nodeKeys = Collections.emptySet();
    private Map<String, String> userData = Collections.emptyMap();
    private String userId;
    private DateTime timestamp;

    public RecordingChanges(String processKey, String repositoryKey) {
        this(processKey, repositoryKey, null);
    }

    public RecordingChanges(String processKey, String repositoryKey, String workspaceName) {
        this.processKey = processKey;
        this.repositoryKey = repositoryKey;
        this.workspaceName = workspaceName;
        assert (this.processKey != null);
        assert (this.repositoryKey != null);
    }

    @Override
    public void workspaceAdded(String workspaceName) {
        this.events.add(new WorkspaceAdded(workspaceName));
    }

    @Override
    public void workspaceRemoved(String workspaceName) {
        this.events.add(new WorkspaceRemoved(workspaceName));
    }

    @Override
    public void nodeCreated(NodeKey key, NodeKey parentKey, Path path, Map<Name, Property> properties) {
        this.events.add(new NodeAdded(key, parentKey, path, properties));
    }

    @Override
    public void nodeRemoved(NodeKey key, NodeKey parentKey, Path path) {
        this.events.add(new NodeRemoved(key, parentKey, path));
    }

    @Override
    public void nodeRenamed(NodeKey key, Path newPath, Path.Segment oldName) {
        this.events.add(new NodeRenamed(key, newPath, oldName));
    }

    @Override
    public void nodeMoved(NodeKey key, NodeKey newParent, NodeKey oldParent, Path newPath, Path oldPath) {
        this.events.add(new NodeMoved(key, newParent, oldParent, newPath, oldPath));
    }

    @Override
    public void nodeReordered(NodeKey key, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath) {
        this.events.add(new NodeReordered(key, parent, newPath, oldPath, reorderedBeforePath));
    }

    @Override
    public void nodeChanged(NodeKey key, Path path) {
        this.events.add(new NodeChanged(key, path));
    }

    @Override
    public void nodeSequenced(NodeKey sequencedNodeKey, Path sequencedNodePath, NodeKey outputNodeKey, Path outputNodePath, String outputPath, String userId, String selectedPath, String sequencerName) {
        this.events.add(new NodeSequenced(sequencedNodeKey, sequencedNodePath, outputNodeKey, outputNodePath, outputPath, userId, selectedPath, sequencerName));
    }

    @Override
    public void nodeSequencingFailure(NodeKey sequencedNodeKey, Path sequencedNodePath, String outputPath, String userId, String selectedPath, String sequencerName, Throwable cause) {
        this.events.add(new NodeSequencingFailure(sequencedNodeKey, sequencedNodePath, outputPath, userId, selectedPath, sequencerName, cause));
    }

    @Override
    public void propertyAdded(NodeKey key, Path nodePath, Property property) {
        this.events.add(new PropertyAdded(key, nodePath, property));
    }

    @Override
    public void propertyRemoved(NodeKey key, Path nodePath, Property property) {
        this.events.add(new PropertyRemoved(key, nodePath, property));
    }

    @Override
    public void propertyChanged(NodeKey key, Path nodePath, Property newProperty, Property oldProperty) {
        this.events.add(new PropertyChanged(key, nodePath, newProperty, oldProperty));
    }

    @Override
    public void binaryValueNoLongerUsed(BinaryKey key) {
        this.events.add(new BinaryValueUnused(key));
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty() && this.nodeKeys.isEmpty();
    }

    @Override
    public Iterator<Change> iterator() {
        return this.events.iterator();
    }

    @Override
    public Set<NodeKey> changedNodes() {
        return this.nodeKeys;
    }

    public void setChangedNodes(Set<NodeKey> keys) {
        if (keys != null) {
            this.nodeKeys = Collections.unmodifiableSet(new HashSet<NodeKey>(keys));
        }
    }

    public void freeze(String userId, Map<String, String> userData, DateTime timestamp) {
        this.userId = userId;
        if (userData != null) {
            this.userData = Collections.unmodifiableMap(userData);
        }
        this.timestamp = timestamp;
    }

    @Override
    public String getProcessKey() {
        return this.processKey;
    }

    @Override
    public String getRepositoryKey() {
        return this.repositoryKey;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, String> getUserData() {
        return this.userData;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Save by ").append(this.getUserId()).append(" at ").append(this.getTimestamp()).append(" with user data = ").append(this.userData).append("\n");
        for (Change change : this) {
            sb.append("  ").append(change).append("\n");
        }
        return sb.toString();
    }
}

