/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.validate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.validate.ImmutableTable;
import org.modeshape.jcr.query.validate.Schemata;

@Immutable
class ImmutableView
extends ImmutableTable
implements Schemata.View {
    private final QueryCommand definition;

    protected ImmutableView(SelectorName name, Iterable<Schemata.Column> columns, boolean extraColumns, QueryCommand definition) {
        super(name, columns, extraColumns);
        this.definition = definition;
    }

    protected ImmutableView(SelectorName name, Iterable<Schemata.Column> columns, boolean extraColumns, QueryCommand definition, Iterable<Schemata.Column> ... keyColumns) {
        super(name, columns, extraColumns, keyColumns);
        this.definition = definition;
    }

    protected ImmutableView(SelectorName name, Map<String, Schemata.Column> columnsByName, List<Schemata.Column> columns, boolean extraColumns, QueryCommand definition, Set<Schemata.Key> keys) {
        super(name, columnsByName, columns, keys, extraColumns, columnsByName, columns);
        this.definition = definition;
    }

    protected ImmutableView(SelectorName name, Map<String, Schemata.Column> columnsByName, List<Schemata.Column> columns, boolean extraColumns, QueryCommand definition, Set<Schemata.Key> keys, Map<String, Schemata.Column> selectStarColumnsByName, List<Schemata.Column> selectStarColumns) {
        super(name, columnsByName, columns, keys, extraColumns, selectStarColumnsByName, selectStarColumns);
        this.definition = definition;
    }

    @Override
    public QueryCommand getDefinition() {
        return this.definition;
    }

    @Override
    public ImmutableView withColumnNotInSelectStar(String name) {
        ImmutableTable result = super.withColumnNotInSelectStar(name);
        if (result == this) {
            return this;
        }
        return new ImmutableView(result.getName(), result.getColumnsByName(), result.getColumns(), result.hasExtraColumns(), this.definition, result.getKeySet(), result.getSelectAllColumnsByName(), result.getSelectAllColumns());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName().name());
        sb.append('(');
        boolean first = true;
        for (Schemata.Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(") AS '");
        sb.append(Visitors.readable(this.definition));
        sb.append('\'');
        if (!this.getKeys().isEmpty()) {
            sb.append(" with keys ");
            first = true;
            for (Schemata.Key key : this.getKeys()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(key);
            }
        }
        return sb.toString();
    }
}

