/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.OnParentVersionAction;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrChildNodeIterator;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrEmptyPropertyIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrMultiValueProperty;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeIterator;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyIterator;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNodeCache;
import org.modeshape.jcr.JcrSingleNodeIterator;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundInParentException;
import org.modeshape.jcr.cache.PropertyTypeUtil;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.NodeKeyReference;

@ThreadSafe
abstract class AbstractJcrNode
extends AbstractJcrItem
implements Node {
    protected static final Pattern WILDCARD_PATTERN = Pattern.compile(".*");
    private static final Set<Name> INTERNAL_NODE_TYPE_NAMES = Collections.singleton(ModeShapeLexicon.SHARE);
    protected final NodeKey key;
    private final ConcurrentMap<Name, AbstractJcrProperty> jcrProperties = new ConcurrentHashMap<Name, AbstractJcrProperty>();
    private volatile CachedDefinition cachedDefn;

    protected AbstractJcrNode(JcrSession session, NodeKey key) {
        super(session);
        this.key = key;
    }

    abstract boolean isRoot();

    abstract Type type();

    protected void checkNodeTypeCanBeModified() throws RepositoryException {
    }

    protected SessionCache sessionCache() {
        return this.session.cache();
    }

    protected final NodeKey key() {
        return this.key;
    }

    protected final CachedNode node() throws ItemNotFoundException, InvalidItemStateException {
        CachedNode node = this.sessionCache().getNode(this.key);
        if (node == null) {
            if (this.sessionCache().isDestroyed(this.key)) {
                throw new InvalidItemStateException("The node with key " + this.key + " has been removed in this session.");
            }
            throw new ItemNotFoundException("The node with key " + this.key + " no longer exists.");
        }
        return node;
    }

    protected final MutableCachedNode mutable() {
        return this.sessionCache().mutable(this.key);
    }

    protected NodeKey parentKey() throws RepositoryException {
        return this.node().getParentKey(this.sessionCache());
    }

    protected final MutableCachedNode mutableParent() throws RepositoryException {
        SessionCache cache = this.sessionCache();
        return cache.mutable(this.parentKey());
    }

    @Override
    Path path() throws ItemNotFoundException, InvalidItemStateException {
        return this.node().getPath(this.sessionCache());
    }

    protected final String location() {
        try {
            return this.getPath();
        }
        catch (Throwable t) {
            return this.key.toString();
        }
    }

    protected Name name() throws RepositoryException {
        return this.node().getName(this.sessionCache());
    }

    protected Path.Segment segment() throws RepositoryException {
        return this.node().getSegment(this.sessionCache());
    }

    protected final boolean isForeign() {
        return this.session().isForeignKey(this.key());
    }

    protected final boolean isInTheSameProcessAs(String otherProcessId) {
        return this.session().context().getProcessId().equalsIgnoreCase(otherProcessId);
    }

    public final String getIdentifier() {
        return this.session().nodeIdentifier(this.key());
    }

    final String identifierPath() throws RepositoryException {
        return "[" + this.getIdentifier() + "]";
    }

    public final JcrSession getSession() {
        return this.session();
    }

    public AbstractJcrProperty getProperty(String relativePath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        this.checkSession();
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        Name propertyName = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            assert (!path.isIdentifier());
            if (path.size() > 1) {
                try {
                    AbstractJcrItem item = this.session.findItem(this.key, path);
                    if (item instanceof AbstractJcrProperty) {
                        return (AbstractJcrProperty)item;
                    }
                }
                catch (ItemNotFoundException e) {
                    I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                    throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.location(), this.workspaceName()}));
                }
                I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.location(), this.workspaceName()}));
            }
            propertyName = path.getLastSegment().getName();
        } else {
            propertyName = this.nameFrom(relativePath);
        }
        AbstractJcrProperty result = this.getProperty(propertyName);
        if (result != null) {
            return result;
        }
        I18n msg = JcrI18n.pathNotFoundRelativeTo;
        throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.location(), this.workspaceName()}));
    }

    final AbstractJcrProperty getProperty(Name propertyName) throws RepositoryException {
        AbstractJcrProperty prop = (AbstractJcrProperty)this.jcrProperties.get(propertyName);
        if (prop == null) {
            AbstractJcrProperty newJcrProperty;
            Set<Name> mixinTypes;
            Name primaryType;
            SessionCache cache;
            CachedNode node = this.node();
            Property p = node.getProperty(propertyName, cache = this.sessionCache());
            if (p != null && (prop = this.createJcrProperty(p, primaryType = node.getPrimaryType(cache), mixinTypes = node.getMixinTypes(cache))) != null && (newJcrProperty = this.jcrProperties.putIfAbsent(propertyName, prop)) != null) {
                prop = newJcrProperty;
            }
        } else {
            SessionCache cache;
            CachedNode node = this.node();
            if (!node.hasProperty(propertyName, cache = this.sessionCache())) {
                this.jcrProperties.remove(propertyName);
                prop = null;
            }
        }
        return prop;
    }

    private final AbstractJcrProperty createJcrProperty(Property property, Name primaryTypeName, Set<Name> mixinTypeNames) throws ConstraintViolationException {
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        JcrPropertyDefinition defn = this.propertyDefinitionFor(property, primaryTypeName, mixinTypeNames, nodeTypes);
        int jcrPropertyType = defn.getRequiredType();
        jcrPropertyType = this.determineBestPropertyTypeIfUndefined(jcrPropertyType, property);
        AbstractJcrProperty prop = null;
        prop = property.isSingle() ? new JcrSingleValueProperty(this, property.getName(), jcrPropertyType) : new JcrMultiValueProperty(this, property.getName(), jcrPropertyType);
        prop.setPropertyDefinitionId(defn.getId(), nodeTypes.getVersion());
        return prop;
    }

    private final int determineBestPropertyTypeIfUndefined(int actualPropertyType, Property property) {
        if (actualPropertyType == 0) {
            return PropertyTypeUtil.jcrPropertyTypeFor(property);
        }
        return actualPropertyType;
    }

    final ValueFactories factories() {
        return this.context().getValueFactories();
    }

    final String readable(Object obj) {
        return this.session.stringFactory().create(obj);
    }

    final String readable(Collection<?> obj) {
        ValueFactory<String> stringFactory = this.session.stringFactory();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<?> iter = obj.iterator();
        if (iter.hasNext()) {
            sb.append(stringFactory.create(iter.next()));
            while (iter.hasNext()) {
                sb.append(',');
                sb.append(stringFactory.create(iter.next()));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    final JcrPropertyDefinition propertyDefinitionFor(Property property, Name primaryType, Set<Name> mixinTypes, RepositoryNodeTypeManager.NodeTypes nodeTypes) throws ConstraintViolationException {
        boolean skipProtected;
        boolean single = property.isSingle();
        JcrPropertyDefinition defn = this.findBestPropertyDefinition(primaryType, mixinTypes, property, single, skipProtected = false, false, nodeTypes);
        if (defn != null) {
            return defn;
        }
        defn = this.findBestPropertyDefinition(primaryType, mixinTypes, property, single, skipProtected, true, nodeTypes);
        String pName = this.readable(property.getName());
        String loc = this.location();
        if (defn != null) {
            I18n msg = JcrI18n.propertyNoLongerSatisfiesConstraints;
            throw new ConstraintViolationException(msg.text(new Object[]{pName, loc, defn.getName(), defn.getDeclaringNodeType().getName()}));
        }
        CachedNode node = this.sessionCache().getNode(this.key);
        String ptype = this.readable(node.getPrimaryType(this.sessionCache()));
        String mixins = this.readable(node.getMixinTypes(this.sessionCache()));
        String pstr = property.getString(this.session.namespaces());
        throw new ConstraintViolationException(JcrI18n.propertyNoLongerHasValidDefinition.text(new Object[]{pstr, loc, ptype, mixins}));
    }

    final JcrPropertyDefinition findBestPropertyDefinition(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Property property, boolean isSingle, boolean skipProtected, boolean skipConstraints, RepositoryNodeTypeManager.NodeTypes nodeTypes) {
        JcrPropertyDefinition definition = null;
        int propertyType = PropertyTypeUtil.jcrPropertyTypeFor(property);
        ValueFactories factories = this.context().getValueFactories();
        if (isSingle) {
            Object value = property.getFirstValue();
            JcrValue jcrValue = new JcrValue(factories, propertyType, value);
            definition = nodeTypes.findPropertyDefinition(this.session, primaryTypeNameOfParent, mixinTypeNamesOfParent, property.getName(), jcrValue, true, skipProtected);
        } else {
            Value[] jcrValues = new Value[property.size()];
            int index = 0;
            for (Object value : property) {
                jcrValues[index++] = new JcrValue(factories, propertyType, value);
            }
            definition = nodeTypes.findPropertyDefinition(this.session, primaryTypeNameOfParent, mixinTypeNamesOfParent, property.getName(), jcrValues, skipProtected);
        }
        if (definition != null) {
            return definition;
        }
        return null;
    }

    final boolean hasProperty(Name name) throws RepositoryException {
        if (this.jcrProperties.containsKey(name)) {
            return true;
        }
        return this.node().hasProperty(name, this.sessionCache());
    }

    boolean removeProperty(AbstractJcrProperty property) {
        if (this.jcrProperties.remove(property.name(), property)) {
            this.mutable().removeProperty(this.sessionCache(), property.name());
            return true;
        }
        return false;
    }

    boolean isReferenceable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.REFERENCEABLE);
    }

    boolean isLockable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.LOCKABLE);
    }

    boolean isShareable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.SHAREABLE);
    }

    boolean isShared() {
        return false;
    }

    final JcrValue valueFrom(int propertyType, Object value) {
        return new JcrValue(this.context().getValueFactories(), propertyType, value);
    }

    final JcrValue valueFrom(String value) {
        return this.session.valueFactory().createValue(value);
    }

    final JcrValue valueFrom(UUID value) {
        Reference ref = (Reference)this.context().getValueFactories().getReferenceFactory().create(value);
        return this.valueFrom(9, ref);
    }

    final JcrValue valueFrom(Calendar value) {
        DateTime dateTime = (DateTime)this.context().getValueFactories().getDateFactory().create(value);
        return this.valueFrom(5, dateTime);
    }

    final JcrValue valueFrom(InputStream value) {
        BinaryValue binary = (BinaryValue)this.context().getValueFactories().getBinaryFactory().create(value);
        return this.valueFrom(2, binary);
    }

    final JcrValue valueFrom(Binary value) {
        return this.valueFrom(2, value);
    }

    final JcrValue valueFrom(Node value) throws RepositoryException {
        if (!(value instanceof AbstractJcrNode)) {
            throw new IllegalArgumentException("Invalid node type (expected a ModeShape node): " + value.getClass().toString());
        }
        AbstractJcrNode node = (AbstractJcrNode)value;
        if (!this.isInTheSameProcessAs(node.session().context().getProcessId())) {
            throw new RepositoryException(JcrI18n.nodeNotInTheSameSession.text(new Object[]{node.path()}));
        }
        NodeKey key = ((AbstractJcrNode)value).key();
        Reference ref = this.session.context().getValueFactories().getReferenceFactory().create(key, ((AbstractJcrNode)value).isForeign());
        return this.valueFrom(9, ref);
    }

    final JcrValue[] valuesFrom(int propertyType, Object[] values) {
        int len = values.length;
        ValueFactories factories = this.context().getValueFactories();
        ArrayList<JcrValue> results = new ArrayList<JcrValue>(len);
        for (int i = 0; i != len; ++i) {
            if (values[i] == null) continue;
            results.add(new JcrValue(factories, propertyType, values[i]));
        }
        return results.toArray(new JcrValue[results.size()]);
    }

    final JcrVersionManager versionManager() {
        return this.session.workspace().versionManager();
    }

    protected final void checkForLock() throws LockException, RepositoryException {
        Lock lock = this.getLockIfExists();
        if (lock != null && !lock.isLockOwningSession() && lock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location()}));
        }
    }

    protected final void checkForCheckedOut() throws VersionException, RepositoryException {
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.location()}));
        }
    }

    protected final long childCount() throws RepositoryException {
        return this.node().getChildReferences(this.sessionCache()).size();
    }

    protected final long childCount(Name name) throws RepositoryException {
        return this.node().getChildReferences(this.sessionCache()).getChildCount(name);
    }

    protected final AbstractJcrNode childNode(Name name, Type expectedType) throws PathNotFoundException, ItemNotFoundException, InvalidItemStateException {
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(name);
        if (ref == null) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{this.readable(name), this.location(), this.session.workspaceName()});
            throw new PathNotFoundException(msg);
        }
        return this.session().node(ref.getKey(), expectedType, this.key());
    }

    protected final AbstractJcrNode childNode(Path.Segment segment, Type expectedType) throws PathNotFoundException, ItemNotFoundException, InvalidItemStateException {
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(segment);
        if (ref == null) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{this.readable(segment), this.location(), this.session.workspaceName()});
            throw new PathNotFoundException(msg);
        }
        return this.session().node(ref.getKey(), expectedType, this.key());
    }

    public boolean hasNode(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        this.checkSession();
        if (relativePath.equals(".")) {
            return true;
        }
        if (relativePath.equals("..")) {
            return !this.isRoot();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        Path.Segment segment = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            if (path.size() == 1) {
                if (path.getLastSegment().isSelfReference()) {
                    return true;
                }
                if (path.getLastSegment().isParentReference()) {
                    return !this.isRoot();
                }
            }
            if (path.size() > 1) {
                try {
                    return this.session().node(this.node(), path) != null;
                }
                catch (PathNotFoundException e) {
                    return false;
                }
            }
            segment = path.getLastSegment();
        } else {
            segment = this.segmentFrom(relativePath);
        }
        assert (!segment.isIdentifier());
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(segment);
        return ref != null;
    }

    public AbstractJcrNode getNode(String relativePath) throws PathNotFoundException, RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        this.checkSession();
        if (relativePath.equals(".")) {
            return this;
        }
        if (relativePath.equals("..")) {
            return this.getParent();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        Path.Segment segment = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            if (path.size() == 1) {
                if (path.getLastSegment().isSelfReference()) {
                    return this;
                }
                if (path.getLastSegment().isParentReference()) {
                    return this.getParent();
                }
            }
            if (path.size() > 1) {
                return this.session().node(this.node(), path);
            }
            segment = path.getLastSegment();
        } else {
            segment = this.segmentFrom(relativePath);
        }
        assert (!segment.isIdentifier());
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(segment);
        if (ref == null) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{this.readable(segment), this.location(), this.session.workspaceName()});
            throw new PathNotFoundException(msg);
        }
        try {
            return this.session().node(ref.getKey(), null, this.key());
        }
        catch (ItemNotFoundException e) {
            String msg = JcrI18n.pathNotFoundRelativeTo.text(new Object[]{relativePath, this.location(), this.workspaceName()});
            throw new PathNotFoundException(msg);
        }
    }

    AbstractJcrNode getNode(Name childName) throws PathNotFoundException, RepositoryException {
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(childName);
        if (ref == null) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{this.readable(childName), this.location(), this.session.workspaceName()});
            throw new PathNotFoundException(msg);
        }
        return this.session().node(ref.getKey(), null, this.key());
    }

    AbstractJcrNode getNodeIfExists(Name childName) throws RepositoryException {
        ChildReference ref = this.node().getChildReferences(this.sessionCache()).getChild(childName);
        return ref != null ? this.session().node(ref.getKey(), null, this.key()) : null;
    }

    public NodeIterator getNodes() throws RepositoryException {
        ChildReferences childReferences = this.node().getChildReferences(this.sessionCache());
        if (childReferences.isEmpty()) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        return new JcrChildNodeIterator((JcrChildNodeIterator.NodeResolver)new ChildNodeResolver(this.session, this.key()), childReferences);
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        CheckArg.isNotNull((Object)namePattern, (String)"namePattern");
        this.checkSession();
        namePattern = namePattern.trim();
        if (namePattern.length() == 0) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        if ("*".equals(namePattern)) {
            return this.getNodes();
        }
        return this.getNodes(namePattern.split("[|]"));
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        CheckArg.isNotNull((Object)nameGlobs, (String)"nameGlobs");
        if (nameGlobs.length == 0) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        List<?> patterns = AbstractJcrNode.createPatternsFor(nameGlobs);
        Iterator<ChildReference> iter = null;
        if (patterns.size() == 1 && patterns.get(0) instanceof String) {
            Name literal = this.nameFrom((String)patterns.get(0));
            iter = this.node().getChildReferences(this.sessionCache()).iterator(literal);
        } else {
            NamespaceRegistry registry = this.session.namespaces();
            iter = this.node().getChildReferences(this.sessionCache()).iterator(patterns, registry);
        }
        return new JcrChildNodeIterator((JcrChildNodeIterator.NodeResolver)new ChildNodeResolver(this.session, this.key()), iter);
    }

    protected static List<?> createPatternsFor(String[] namePatterns) throws RepositoryException {
        LinkedList<Object> patterns = new LinkedList<Object>();
        for (String stringPattern : namePatterns) {
            int length = (stringPattern = stringPattern.trim()).length();
            if (length == 0) continue;
            if (stringPattern.indexOf("*") == -1) {
                patterns.add(stringPattern);
                continue;
            }
            StringBuilder sb = new StringBuilder(length);
            block6: for (int i = 0; i != length; ++i) {
                char c = stringPattern.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '[': 
                    case ']': 
                    case '|': {
                        String msg = JcrI18n.invalidNamePattern.text(new Object[]{Character.valueOf(c), stringPattern});
                        throw new RepositoryException(msg);
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '?': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '}': {
                        sb.append("\\");
                        sb.append(c);
                        continue block6;
                    }
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            String escapedString = sb.toString();
            Pattern pattern = Pattern.compile(escapedString);
            patterns.add(pattern);
        }
        return patterns;
    }

    public AbstractJcrNode addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkSession();
        return this.addNode(relPath, null, null);
    }

    public AbstractJcrNode addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        this.checkSession();
        return this.addNode(relPath, primaryNodeTypeName, null);
    }

    final AbstractJcrNode addNode(String relPath, String primaryNodeTypeName, NodeKey desiredKey) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Name childPrimaryTypeName = null;
        try {
            childPrimaryTypeName = (Name)this.session.nameFactory().create(primaryNodeTypeName);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(JcrI18n.invalidNodeTypeNameParameter.text(new Object[]{primaryNodeTypeName, "primaryNodeTypeName"}));
        }
        Path path = null;
        try {
            path = (Path)this.session.pathFactory().create(relPath);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
        }
        if (path.size() == 0 || path.isIdentifier() || path.getLastSegment().getIndex() > 1 || relPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
        }
        if (path.size() > 1) {
            Path parentPath = path.getParent();
            try {
                AbstractJcrItem parent = this.session.findItem(this, parentPath);
                if (parent instanceof AbstractJcrNode) {
                    Name childName = path.getLastSegment().getName();
                    this.session.checkPermission(path, "add_node");
                    return ((AbstractJcrNode)parent).addChildNode(childName, childPrimaryTypeName, desiredKey);
                }
                if (parent instanceof AbstractJcrProperty) {
                    throw new ConstraintViolationException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
                }
            }
            catch (ItemNotFoundException e) {
                throw new PathNotFoundException(e.getMessage(), e.getCause());
            }
            catch (RepositoryException e) {
                throw e;
            }
        }
        this.session.checkPermission(path, "add_node");
        Name childName = path.getLastSegment().getName();
        return this.addChildNode(childName, childPrimaryTypeName, desiredKey);
    }

    final AbstractJcrNode addChildNode(Name childName, Name childPrimaryNodeTypeName, NodeKey desiredKey) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkNodeTypeCanBeModified();
        this.session.checkPermission(this.getPath(), "add_node");
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location()}));
        }
        SessionCache cache = this.sessionCache();
        CachedNode node = this.node();
        int numExistingSns = node.getChildReferences(cache).getChildCount(childName);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        JcrNodeDefinition childDefn = this.validateChildNodeDefinition(childName, childPrimaryNodeTypeName, true);
        if (childPrimaryNodeTypeName == null) {
            childPrimaryNodeTypeName = childDefn.getDefaultPrimaryType().getInternalName();
        }
        if (!this.isCheckedOut() && childDefn.getOnParentVersion() != 5) {
            Path parentPath = this.path();
            String parentPathStr = this.readable(parentPath);
            int sns = numExistingSns + 1;
            String segment = this.readable(this.session.pathFactory().createSegment(childName, sns));
            String opv = OnParentVersionAction.nameFromValue((int)childDefn.getOnParentVersion());
            I18n msg = JcrI18n.cannotCreateChildOnCheckedInNodeSinceOpvOfChildDefinitionIsNotIgnore;
            throw new VersionException(msg.text(new Object[]{segment, this.readable(parentPathStr), childDefn.getName(), opv}));
        }
        PropertyFactory propFactory = this.session.propertyFactory();
        Property ptProp = propFactory.create(JcrLexicon.PRIMARY_TYPE, childPrimaryNodeTypeName);
        if (JcrNtLexicon.UNSTRUCTURED.equals(childPrimaryNodeTypeName)) {
            MutableCachedNode newChild = this.mutable().createChild(cache, desiredKey, childName, ptProp, new Property[0]);
            AbstractJcrNode jcrNode = this.session.node(newChild.getKey(), null, this.key());
            jcrNode.setNodeDefinitionId(childDefn.getId(), nodeTypes.getVersion());
            return jcrNode;
        }
        RepositoryNodeTypeManager.NodeTypes capabilities = this.session.repository().nodeTypeManager().getNodeTypes();
        int sns = numExistingSns + 1;
        LinkedList<Property> props = this.autoCreatePropertiesFor(childName, sns, childPrimaryNodeTypeName, propFactory, capabilities);
        MutableCachedNode newChild = null;
        if (props != null) {
            props.addFirst(ptProp);
            newChild = this.mutable().createChild(cache, desiredKey, childName, props);
        } else {
            newChild = this.mutable().createChild(cache, desiredKey, childName, ptProp, new Property[0]);
        }
        AbstractJcrNode jcrNode = this.session.node(newChild.getKey(), null, this.key());
        jcrNode.setNodeDefinitionId(childDefn.getId(), nodeTypes.getVersion());
        jcrNode.autoCreateChildren(childPrimaryNodeTypeName, capabilities);
        return jcrNode;
    }

    JcrNodeDefinition validateChildNodeDefinition(Name childName, Name childPrimaryNodeTypeName, boolean skipProtected) throws ItemNotFoundException, InvalidItemStateException, ItemExistsException, ConstraintViolationException, NoSuchNodeTypeException {
        int sns;
        JcrNodeDefinition childDefn;
        SessionCache cache = this.sessionCache();
        CachedNode node = this.node();
        Name primaryTypeName = node.getPrimaryType(cache);
        Set<Name> mixins = node.getMixinTypes(cache);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session().nodeTypes();
        int numExistingSns = node.getChildReferences(cache).getChildCount(childName);
        if (childPrimaryNodeTypeName != null) {
            if (INTERNAL_NODE_TYPE_NAMES.contains(childPrimaryNodeTypeName)) {
                String workspaceName = this.workspaceName();
                String childPath = this.readable(this.session.pathFactory().create(this.path(), childName, numExistingSns + 1));
                String msg = JcrI18n.unableToCreateNodeWithInternalPrimaryType.text(new Object[]{childPrimaryNodeTypeName, childPath, workspaceName});
                throw new ConstraintViolationException(msg);
            }
            JcrNodeType primaryType = nodeTypes.getNodeType(childPrimaryNodeTypeName);
            if (primaryType == null) {
                Path pathForChild = this.session.pathFactory().create(this.path(), childName, numExistingSns + 1);
                I18n msg = JcrI18n.unableToCreateNodeWithPrimaryTypeThatDoesNotExist;
                throw new NoSuchNodeTypeException(msg.text(new Object[]{childPrimaryNodeTypeName, pathForChild, this.workspaceName()}));
            }
            if (primaryType.isMixin()) {
                I18n msg = JcrI18n.cannotUseMixinTypeAsPrimaryType;
                throw new ConstraintViolationException(msg.text(new Object[]{primaryType.getName()}));
            }
            if (primaryType.isAbstract()) {
                I18n msg = JcrI18n.primaryTypeCannotBeAbstract;
                throw new ConstraintViolationException(msg.text(new Object[]{primaryType.getName()}));
            }
        }
        if ((childDefn = nodeTypes.findChildNodeDefinition(primaryTypeName, mixins, childName, childPrimaryNodeTypeName, sns = numExistingSns + 1, skipProtected)) == null) {
            String childPath = this.readable(this.session.pathFactory().create(this.path(), childName, sns));
            if (numExistingSns > 0) {
                childDefn = nodeTypes.findChildNodeDefinition(primaryTypeName, mixins, childName, childPrimaryNodeTypeName, 0, skipProtected);
                String workspaceName = this.workspaceName();
                if (childDefn != null) {
                    String msg = JcrI18n.noSnsDefinitionForNode.text(new Object[]{childPath, workspaceName});
                    throw new ItemExistsException(msg);
                }
            }
            String repoName = this.session.repository().repositoryName();
            String msg = JcrI18n.nodeDefinitionCouldNotBeDeterminedForNode.text(new Object[]{childPath, this.workspaceName(), repoName});
            throw new ConstraintViolationException(msg);
        }
        if (childPrimaryNodeTypeName == null && childDefn.getDefaultPrimaryType() == null) {
            String childPath = this.readable(this.session.pathFactory().create(this.path(), childName, sns));
            I18n msg = JcrI18n.unableToCreateNodeWithNoDefaultPrimaryTypeOnChildNodeDefinition;
            String nodeTypeName = childDefn.getDeclaringNodeType().getName();
            throw new NoSuchNodeTypeException(msg.text(new Object[]{childDefn.getName(), nodeTypeName, childPath, this.workspaceName()}));
        }
        return childDefn;
    }

    protected LinkedList<Property> autoCreatePropertiesFor(Name nodeName, int snsIndex, Name primaryType, PropertyFactory propertyFactory, RepositoryNodeTypeManager.NodeTypes capabilities) {
        Collection<JcrPropertyDefinition> autoPropDefns = capabilities.getAutoCreatedPropertyDefinitions(primaryType);
        if (autoPropDefns.isEmpty()) {
            return null;
        }
        LinkedList<Property> props = new LinkedList<Property>();
        for (JcrPropertyDefinition defn : autoPropDefns) {
            Name propName = defn.getInternalName();
            if (!defn.hasDefaultValues()) continue;
            Object[] defaultValues = defn.getRawDefaultValues();
            Property prop = null;
            prop = defn.isMultiple() ? propertyFactory.create(propName, defaultValues) : propertyFactory.create(propName, defaultValues[0]);
            props.add(prop);
        }
        return props;
    }

    protected void autoCreateChildren(Name primaryType, RepositoryNodeTypeManager.NodeTypes capabilities) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Collection<JcrNodeDefinition> autoChildDefns = capabilities.getAutoCreatedChildNodeDefinitions(primaryType);
        if (!autoChildDefns.isEmpty()) {
            HashSet childNames = new HashSet();
            for (JcrNodeDefinition defn : autoChildDefns) {
                Name childName;
                assert (!defn.isResidual());
                if (defn.isProtected() || childNames.contains(childName = defn.getInternalName())) continue;
                JcrNodeType childPrimaryType = defn.getDefaultPrimaryType();
                this.addChildNode(childName, childPrimaryType.getInternalName(), null);
            }
        }
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.checkSession();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            String msg = JcrI18n.notOrderable.text(new Object[]{this.getPrimaryNodeType().getName(), this.location()});
            throw new UnsupportedRepositoryOperationException(msg);
        }
        Path srcPath = (Path)this.session.pathFactory().create(srcChildRelPath);
        if (srcPath.isAbsolute() || srcPath.size() != 1) {
            throw new ItemNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcChildRelPath, "destChildRelPath"}));
        }
        this.session.checkPermission(srcPath.getParent(), "add_node");
        SessionCache cache = this.session.cache();
        ChildReferences childRefs = this.node().getChildReferences(cache);
        ChildReference srcRef = childRefs.getChild(srcPath.getLastSegment());
        if (srcRef == null) {
            String workspaceName = this.workspaceName();
            throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{srcChildRelPath, workspaceName}));
        }
        NodeKey destKey = null;
        if (destChildRelPath != null) {
            Path destPath = (Path)this.session.pathFactory().create(destChildRelPath);
            if (destPath.isAbsolute() || destPath.size() != 1) {
                throw new ItemNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destChildRelPath, "destChildRelPath"}));
            }
            if (srcPath.isSameAs(destPath)) {
                return;
            }
            ChildReference destRef = childRefs.getChild(destPath.getLastSegment());
            if (destRef == null) {
                String workspaceName = this.workspaceName();
                throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{destChildRelPath, workspaceName}));
            }
            destKey = destRef.getKey();
        }
        this.mutable().reorderChild(cache, srcRef.getKey(), destKey);
    }

    public AbstractJcrProperty setProperty(String name, Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        JcrValue jcrValue = (JcrValue)value;
        if (jcrValue.value() == null) {
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{name}));
        }
        return this.setProperty(this.nameFrom(name), jcrValue, false, false);
    }

    public AbstractJcrProperty setProperty(String name, Value value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        JcrValue jcrValue = (JcrValue)value;
        if (jcrValue.value() == null) {
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{name}));
        }
        return this.setProperty(this.nameFrom(name), jcrValue.asType(type), false, false);
    }

    public AbstractJcrProperty setProperty(String name, Value[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        if (values.length == 0) {
            values = new JcrValue[]{};
        } else {
            for (Value value : values) {
                JcrValue jcrValue = (JcrValue)value;
                if (jcrValue == null || jcrValue.value() != null) continue;
                throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{name}));
            }
        }
        return this.setProperty(this.nameFrom(name), values, 0, false);
    }

    public AbstractJcrProperty setProperty(String name, Value[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        if (values.length == 0) {
            values = new JcrValue[]{};
        } else {
            for (Value value : values) {
                JcrValue jcrValue = (JcrValue)value;
                if (jcrValue == null || jcrValue.value() != null) continue;
                throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{name}));
            }
        }
        return this.setProperty(this.nameFrom(name), values, type, false);
    }

    public AbstractJcrProperty setProperty(String name, String[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valuesFrom(1, values), 0, false);
    }

    public AbstractJcrProperty setProperty(String name, String[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valuesFrom(type, values), 0, false);
    }

    public AbstractJcrProperty setProperty(String name, String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valueFrom(1, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, String value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valueFrom(type, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valueFrom(value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, Binary value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        return this.setProperty(this.nameFrom(name), this.valueFrom(2, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        return this.setProperty(this.nameFrom(name), this.valueFrom(6, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        return this.setProperty(this.nameFrom(name), this.valueFrom(4, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, BigDecimal value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        return this.setProperty(this.nameFrom(name), this.valueFrom(12, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        return this.setProperty(this.nameFrom(name), this.valueFrom(3, value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valueFrom(value), false, false);
    }

    public AbstractJcrProperty setProperty(String name, Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingProperty(this.nameFrom(name));
        }
        return this.setProperty(this.nameFrom(name), this.valueFrom(value), false, false);
    }

    final AbstractJcrProperty removeExistingProperty(Name name) throws VersionException, LockException, RepositoryException {
        AbstractJcrProperty existing = this.getProperty(name);
        if (existing != null) {
            existing.remove();
            return existing;
        }
        return null;
    }

    final AbstractJcrProperty setProperty(Name name, JcrValue value, boolean skipReferenceValidation, boolean skipProtectedValidation) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        AbstractJcrProperty jcrProp;
        AbstractJcrProperty otherProp;
        assert (value != null);
        assert (value.value() != null);
        this.checkForLock();
        this.checkNodeTypeCanBeModified();
        this.session.checkPermission(this.path(), "set_property");
        AbstractJcrProperty existing = this.getProperty(name);
        if (existing != null) {
            if (existing.isMultiple()) {
                I18n msg = JcrI18n.unableToSetMultiValuedPropertyUsingSingleValue;
                throw new javax.jcr.ValueFormatException(msg.text(new Object[]{this.readable(name), this.location(), this.workspaceName()}));
            }
            if (!skipProtectedValidation && existing.getDefinition().isProtected()) {
                String text = JcrI18n.cannotSetProtectedPropertyValue.text(new Object[]{value, name, this.location(), this.workspaceName()});
                throw new ConstraintViolationException(text);
            }
            existing.setValue(value);
            return existing;
        }
        SessionCache cache = this.sessionCache();
        MutableCachedNode node = this.mutable();
        Name primaryType = node.getPrimaryType(cache);
        Set<Name> mixinTypes = node.getMixinTypes(cache);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        JcrPropertyDefinition defn = null;
        boolean skipProtected = !skipProtectedValidation;
        defn = nodeTypes.findPropertyDefinition(this.session, primaryType, mixinTypes, name, value, true, skipProtected, true);
        if (defn == null) {
            defn = nodeTypes.findPropertyDefinition(this.session, primaryType, mixinTypes, name, value, true, skipProtected, false);
            String propName = this.readable(name);
            if (defn != null) {
                String defnName = defn.getName();
                String nodeTypeName = defn.getDeclaringNodeType().getName();
                I18n msg = JcrI18n.valueViolatesConstraintsOnDefinition;
                throw new ConstraintViolationException(msg.text(new Object[]{propName, value.getString(), this.location(), defnName, nodeTypeName}));
            }
            I18n msg = JcrI18n.noPropertyDefinition;
            throw new ConstraintViolationException(msg.text(new Object[]{propName, this.location(), this.readable(primaryType), this.readable(mixinTypes)}));
        }
        int requiredType = defn.getRequiredType();
        if (!(requiredType != 9 && requiredType != 10 || skipReferenceValidation || defn.canCastToTypeAndSatisfyConstraints(value, this.session))) {
            String propName = this.readable(name);
            String defnName = defn.getName();
            String nodeTypeName = defn.getDeclaringNodeType().getName();
            I18n i18n = JcrI18n.weakReferenceValueViolatesConstraintsOnDefinition;
            if (requiredType == 9) {
                i18n = JcrI18n.referenceValueViolatesConstraintsOnDefinition;
            }
            throw new ConstraintViolationException(i18n.text(new Object[]{propName, value.getString(), this.location(), defnName, nodeTypeName}));
        }
        if (!this.isCheckedOut() && defn.getOnParentVersion() != 5) {
            String path = this.getParent().getPath();
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{path}));
        }
        if (requiredType == 0) {
            requiredType = value.getType();
        }
        if (requiredType != value.getType()) {
            value = value.asType(requiredType);
        }
        if ((otherProp = this.jcrProperties.putIfAbsent(name, jcrProp = new JcrSingleValueProperty(this, name, requiredType))) != null) {
            jcrProp = otherProp;
        }
        Property newProperty = this.session.propertyFactory().create(name, value.value());
        node.setProperty(cache, newProperty);
        return jcrProp;
    }

    final AbstractJcrProperty setProperty(Name name, Value[] values, int jcrPropertyType, boolean skipReferenceValidation) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values, jcrPropertyType, false, skipReferenceValidation);
    }

    final AbstractJcrProperty setProperty(Name name, Value[] values, int jcrPropertyType, boolean skipProtectedValidation, boolean skipReferenceValidation) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        AbstractJcrProperty existing;
        assert (values != null);
        this.checkForLock();
        this.checkForCheckedOut();
        this.checkNodeTypeCanBeModified();
        this.session.checkPermission(this.path(), "set_property");
        values = this.compactValues(values);
        this.checkAllValuesHaveTheSameType(values, name);
        if (jcrPropertyType != 0) {
            int len = values.length;
            JcrValue[] newValues = null;
            if (len == 0) {
                newValues = JcrMultiValueProperty.EMPTY_VALUES;
            } else {
                ArrayList<JcrValue> valuesWithDesiredType = new ArrayList<JcrValue>(len);
                for (int i = 0; i != len; ++i) {
                    JcrValue value = (JcrValue)values[i];
                    value = value.asType(jcrPropertyType);
                    valuesWithDesiredType.add(value);
                }
                newValues = valuesWithDesiredType.isEmpty() ? JcrMultiValueProperty.EMPTY_VALUES : valuesWithDesiredType.toArray(new JcrValue[valuesWithDesiredType.size()]);
            }
            values = newValues;
        }
        if ((existing = this.getProperty(name)) != null) {
            if (!existing.isMultiple()) {
                I18n msg = JcrI18n.unableToSetSingleValuedPropertyUsingMultipleValues;
                throw new javax.jcr.ValueFormatException(msg.text(new Object[]{this.readable(name), this.location(), this.workspaceName()}));
            }
            existing.setValue(values);
            return existing;
        }
        SessionCache cache = this.sessionCache();
        MutableCachedNode node = this.mutable();
        Name primaryType = node.getPrimaryType(cache);
        Set<Name> mixinTypes = node.getMixinTypes(cache);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        JcrPropertyDefinition defn = null;
        defn = nodeTypes.findPropertyDefinition(this.session, primaryType, mixinTypes, name, values, !skipProtectedValidation, skipReferenceValidation);
        if (defn == null) {
            defn = nodeTypes.findPropertyDefinition(this.session, primaryType, mixinTypes, name, values, !skipProtectedValidation, false);
            String propName = this.readable(name);
            if (defn != null) {
                String defnName = defn.getName();
                String nodeTypeName = defn.getDeclaringNodeType().getName();
                I18n msg = JcrI18n.valueViolatesConstraintsOnDefinition;
                throw new ConstraintViolationException(msg.text(new Object[]{propName, this.readable(values), this.location(), defnName, nodeTypeName}));
            }
            defn = nodeTypes.findPropertyDefinition(this.session, primaryType, mixinTypes, name, values[0], true, false);
            if (defn == null) {
                I18n msg = JcrI18n.unableToSetSingleValuedPropertyUsingMultipleValues;
                throw new javax.jcr.ValueFormatException(msg.text(new Object[]{this.readable(name), this.location(), this.workspaceName()}));
            }
            I18n msg = JcrI18n.noPropertyDefinition;
            throw new ConstraintViolationException(msg.text(new Object[]{propName, this.location(), this.readable(primaryType), this.readable(mixinTypes)}));
        }
        int requiredType = defn.getRequiredType();
        if (!(skipReferenceValidation || requiredType != 9 && requiredType != 10 || defn.canCastToTypeAndSatisfyConstraints(values, this.session))) {
            String propName = this.readable(name);
            String defnName = defn.getName();
            String nodeTypeName = defn.getDeclaringNodeType().getName();
            I18n i18n = JcrI18n.weakReferenceValueViolatesConstraintsOnDefinition;
            if (requiredType == 9) {
                i18n = JcrI18n.referenceValueViolatesConstraintsOnDefinition;
            }
            throw new ConstraintViolationException(i18n.text(new Object[]{propName, this.readable(values), this.location(), defnName, nodeTypeName}));
        }
        if (requiredType == 0 && values.length > 0) {
            requiredType = values[0].getType();
        }
        AbstractJcrProperty jcrProp = new JcrMultiValueProperty(this, name, requiredType);
        jcrProp.setPropertyDefinitionId(defn.getId(), nodeTypes.getVersion());
        AbstractJcrProperty otherProp = this.jcrProperties.putIfAbsent(name, jcrProp);
        if (otherProp != null) {
            if (!jcrProp.isMultiple()) {
                this.jcrProperties.put(name, jcrProp);
            }
            jcrProp = otherProp;
        }
        int numValues = values.length;
        Object[] objValues = new Object[numValues];
        int propertyType = defn.getRequiredType();
        if (propertyType == 0 || propertyType == jcrPropertyType) {
            for (int i = 0; i != numValues; ++i) {
                objValues[i] = ((JcrValue)values[i]).value();
            }
        } else {
            try {
                PropertyType msType = PropertyTypeUtil.modePropertyTypeFor(propertyType);
                ValueFactory<?> factory = this.context().getValueFactories().getValueFactory(msType);
                for (int i = 0; i != numValues; ++i) {
                    objValues[i] = factory.create(((JcrValue)values[i]).value());
                }
            }
            catch (ValueFormatException e) {
                throw new javax.jcr.ValueFormatException(e.getMessage());
            }
        }
        Property newProperty = this.session.propertyFactory().create(name, objValues);
        node.setProperty(cache, newProperty);
        return jcrProp;
    }

    private Value[] compactValues(Value[] inputValues) {
        if (inputValues == null) {
            return null;
        }
        ArrayList<Value> compactedList = new ArrayList<Value>();
        for (Value inputValue : inputValues) {
            if (inputValue == null) continue;
            compactedList.add(inputValue);
        }
        return compactedList.toArray(new Value[0]);
    }

    private void checkAllValuesHaveTheSameType(Value[] values, Name name) throws javax.jcr.ValueFormatException {
        int valueType = -1;
        for (Value value : values) {
            if (value == null) continue;
            if (valueType == -1) {
                valueType = value.getType();
                continue;
            }
            if (value.getType() == valueType) continue;
            String msg = JcrI18n.allPropertyValuesMustHaveSameType.text(new Object[]{this.readable(name), values, javax.jcr.PropertyType.nameFromValue((int)valueType), this.location(), this.workspaceName()});
            throw new javax.jcr.ValueFormatException(msg);
        }
    }

    final Collection<AbstractJcrProperty> findJcrProperties(Iterator<Property> propertyIterator) throws AccessDeniedException, RepositoryException {
        try {
            LinkedList<AbstractJcrProperty> result = new LinkedList<AbstractJcrProperty>();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.next();
                Name propertyName = property.getName();
                AbstractJcrProperty jcrProp = this.getProperty(propertyName);
                if (jcrProp == null) continue;
                result.add(jcrProp);
            }
            return result;
        }
        catch (AccessControlException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.checkSession();
        Iterator<Property> iter = this.node().getProperties(this.sessionCache());
        return new JcrPropertyIterator(this.findJcrProperties(iter));
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        if ((namePattern = namePattern.trim()).length() == 0) {
            return JcrEmptyPropertyIterator.INSTANCE;
        }
        if ("*".equals(namePattern)) {
            return this.getProperties();
        }
        return this.getProperties(namePattern.split("[|]"));
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        CheckArg.isNotNull((Object)nameGlobs, (String)"nameGlobs");
        if (nameGlobs.length == 0) {
            return JcrEmptyPropertyIterator.INSTANCE;
        }
        List<?> patterns = AbstractJcrNode.createPatternsFor(nameGlobs);
        if (patterns.size() == 1 && patterns.get(0) instanceof String) {
            Name literal = this.nameFrom((String)patterns.get(0));
            AbstractJcrProperty prop = this.getProperty(literal);
            if (prop == null) {
                return JcrEmptyPropertyIterator.INSTANCE;
            }
            return new JcrPropertyIterator(Collections.singletonList(prop));
        }
        Iterator<Property> propIter = this.node().getProperties(patterns, this.sessionCache());
        return new JcrPropertyIterator(this.findJcrProperties(propIter));
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.checkSession();
        JcrNodeType primaryType = this.getPrimaryNodeType();
        String primaryItemNameString = primaryType.getPrimaryItemName();
        if (primaryItemNameString == null) {
            I18n msg = JcrI18n.noPrimaryItemNameDefinedOnPrimaryType;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), this.location(), this.workspaceName()}));
        }
        try {
            Path primaryItemPath = (Path)this.context().getValueFactories().getPathFactory().create(primaryItemNameString);
            if (primaryItemPath.size() == 1 && !primaryItemPath.isAbsolute()) {
                try {
                    return this.session.node(this.node(), primaryItemPath);
                }
                catch (PathNotFoundException e) {
                    return this.getProperty(primaryItemPath.getLastSegment().getName());
                }
            }
            I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.location(), this.workspaceName()}));
        }
        catch (javax.jcr.ValueFormatException error) {
            I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.location(), this.workspaceName()}));
        }
        catch (PathNotFoundException error) {
            I18n msg = JcrI18n.primaryItemDoesNotExist;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.location(), this.workspaceName()}));
        }
    }

    @Deprecated
    public final String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isReferenceable()) {
            throw new UnsupportedRepositoryOperationException();
        }
        return this.getIdentifier();
    }

    public int getIndex() throws RepositoryException {
        return this.node().getSegment(this.sessionCache()).getIndex();
    }

    public final PropertyIterator getReferences() throws RepositoryException {
        return this.getReferences(null);
    }

    public final PropertyIterator getReferences(String propertyName) throws RepositoryException {
        this.checkSession();
        return this.propertiesOnOtherNodesReferencingThis(propertyName, 9);
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.getWeakReferences(null);
    }

    public PropertyIterator getWeakReferences(String propertyName) throws RepositoryException {
        this.checkSession();
        return this.propertiesOnOtherNodesReferencingThis(propertyName, 10);
    }

    protected PropertyIterator getAllReferences() throws RepositoryException {
        ArrayList<javax.jcr.Property> allReferences = new ArrayList<javax.jcr.Property>();
        PropertyIterator strongRefIterator = this.getReferences();
        while (strongRefIterator.hasNext()) {
            allReferences.add(strongRefIterator.nextProperty());
        }
        PropertyIterator weakRefIterator = this.getReferences();
        while (weakRefIterator.hasNext()) {
            allReferences.add(weakRefIterator.nextProperty());
        }
        return new JcrPropertyIterator(allReferences);
    }

    protected PropertyIterator propertiesOnOtherNodesReferencingThis(String propertyName, int referenceType) throws RepositoryException {
        assert (referenceType == 9 || referenceType == 10);
        if (!this.isReferenceable()) {
            return JcrEmptyPropertyIterator.INSTANCE;
        }
        CachedNode.ReferenceType refType = referenceType == 9 ? CachedNode.ReferenceType.STRONG : CachedNode.ReferenceType.WEAK;
        NodeIterator iter = this.referringNodes(refType);
        if (!iter.hasNext()) {
            return JcrEmptyPropertyIterator.INSTANCE;
        }
        String id = this.getIdentifier();
        LinkedList<javax.jcr.Property> references = new LinkedList<javax.jcr.Property>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            PropertyIterator propIter = node.getProperties();
            block1: while (propIter.hasNext()) {
                javax.jcr.Property prop = propIter.nextProperty();
                if (prop.getType() != referenceType || propertyName != null && !propertyName.equals(prop.getName())) continue;
                if (prop.getDefinition().isMultiple()) {
                    for (Value value : prop.getValues()) {
                        if (!id.equals(value.getString())) continue;
                        references.add(prop);
                        continue block1;
                    }
                    continue;
                }
                Value value = prop.getValue();
                if (!id.equals(value.getString())) continue;
                references.add(prop);
            }
        }
        if (references.isEmpty()) {
            return JcrEmptyPropertyIterator.INSTANCE;
        }
        return new JcrPropertyIterator(references);
    }

    protected final NodeIterator referringNodes(CachedNode.ReferenceType referenceType) throws RepositoryException {
        if (!this.isReferenceable()) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        Set<NodeKey> keys = this.node().getReferrers(this.sessionCache(), referenceType);
        if (keys.isEmpty()) {
            return JcrEmptyNodeIterator.INSTANCE;
        }
        return new JcrNodeIterator(this.session(), keys.iterator(), keys.size(), null);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relPath, (String)"relPath");
        this.checkSession();
        if (relPath.indexOf(47) >= 0 || relPath.startsWith("[")) {
            try {
                this.getProperty(relPath);
                return true;
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
        if (relPath.startsWith(".")) {
            if (relPath.length() == 1) {
                return false;
            }
            if (relPath.equals("..")) {
                return false;
            }
        }
        return this.node().hasProperty(this.nameFrom(relPath), this.sessionCache());
    }

    public boolean hasNodes() throws RepositoryException {
        return !this.node().getChildReferences(this.sessionCache()).isEmpty();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.node().hasProperties(this.sessionCache());
    }

    public JcrNodeType getPrimaryNodeType() throws RepositoryException {
        this.checkSession();
        return this.session().nodeTypeManager().getNodeType(this.node().getPrimaryType(this.sessionCache()));
    }

    Name getPrimaryTypeName() throws ItemNotFoundException, InvalidItemStateException {
        return this.node().getPrimaryType(this.sessionCache());
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.checkSession();
        JcrNodeTypeManager nodeTypeManager = this.session().nodeTypeManager();
        LinkedList<JcrNodeType> mixinNodeTypes = new LinkedList<JcrNodeType>();
        for (Name mixinTypeName : this.node().getMixinTypes(this.sessionCache())) {
            JcrNodeType nodeType = nodeTypeManager.getNodeType(mixinTypeName);
            if (nodeType == null) continue;
            mixinNodeTypes.add(nodeType);
        }
        return mixinNodeTypes.toArray(new NodeType[mixinNodeTypes.size()]);
    }

    Set<Name> getMixinTypeNames() throws ItemNotFoundException, InvalidItemStateException {
        return this.node().getMixinTypes(this.sessionCache());
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(this.nameFrom(nodeTypeName));
    }

    public final boolean isNodeType(Name nodeTypeName) throws RepositoryException {
        this.checkSession();
        SessionCache cache = this.sessionCache();
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session().nodeTypes();
        try {
            CachedNode node = this.node();
            Name primaryTypeName = node.getPrimaryType(cache);
            JcrNodeType primaryType = nodeTypes.getNodeType(primaryTypeName);
            if (primaryType.isNodeType(nodeTypeName)) {
                return true;
            }
            Set<Name> mixinTypes = node.getMixinTypes(cache);
            for (Name mixinTypeName : mixinTypes) {
                JcrNodeType mixinType = nodeTypes.getNodeType(mixinTypeName);
                if (mixinType == null || !mixinType.isNodeType(nodeTypeName)) continue;
                return true;
            }
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        return false;
    }

    private void autoCreateItemsFor(JcrNodeType nodeType) throws InvalidItemStateException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        MutableCachedNode node = this.mutable();
        SessionCache cache = this.sessionCache();
        for (JcrPropertyDefinition propDefn : nodeType.allPropertyDefinitions()) {
            Value[] defaultValues;
            Name propName;
            Property autoCreatedProp;
            if (!propDefn.isAutoCreated() || propDefn.isProtected() || (autoCreatedProp = node.getProperty(propName = propDefn.getInternalName(), cache)) != null || (defaultValues = propDefn.getDefaultValues()) == null) continue;
            if (propDefn.isMultiple()) {
                this.setProperty(propDefn.getInternalName(), defaultValues, propDefn.getRequiredType(), true);
                continue;
            }
            assert (propDefn.getDefaultValues().length == 1);
            this.setProperty(propDefn.getInternalName(), (JcrValue)defaultValues[0], false, false);
        }
        for (JcrNodeDefinition nodeDefn : nodeType.allChildNodeDefinitions()) {
            if (!nodeDefn.isAutoCreated() || nodeDefn.isProtected()) continue;
            Name nodeName = nodeDefn.getInternalName();
            ChildReferences refs = node.getChildReferences(cache);
            if (refs.getChildCount(nodeName) != 0) continue;
            JcrNodeType defaultPrimaryType = nodeDefn.getDefaultPrimaryType();
            assert (defaultPrimaryType != null);
            Name primaryType = defaultPrimaryType.getInternalName();
            this.addChildNode(nodeName, primaryType, null);
        }
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        boolean skipProtected;
        int numExistingSns;
        Set<Name> mixins;
        CheckArg.isNotZeroLength((String)nodeTypeName, (String)"nodeTypeName");
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.session.checkPermission(this.path(), "set_property");
        if (this.isRoot()) {
            throw new ConstraintViolationException(JcrI18n.setPrimaryTypeOnRootNodeIsNotSupported.text(new Object[0]));
        }
        Name newPrimaryTypeName = this.nameFrom(nodeTypeName);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        if (newPrimaryTypeName.equals(this.getPrimaryTypeName())) {
            return;
        }
        JcrNodeType newPrimaryType = nodeTypes.getNodeType(newPrimaryTypeName);
        if (newPrimaryType == null) {
            throw new NoSuchNodeTypeException(JcrI18n.typeNotFound.text(new Object[]{newPrimaryType}));
        }
        if (newPrimaryType.isMixin()) {
            throw new ConstraintViolationException(JcrI18n.cannotUseMixinTypeAsPrimaryType.text(new Object[]{nodeTypeName}));
        }
        if (newPrimaryType.isAbstract()) {
            throw new ConstraintViolationException(JcrI18n.primaryTypeCannotBeAbstract.text(new Object[]{newPrimaryType}));
        }
        SessionCache cache = this.sessionCache();
        CachedNode node = this.node();
        Name oldPrimaryType = node.getPrimaryType(cache);
        Set<Name> mixinTypeNames = node.getMixinTypes(cache);
        Iterator<Property> iter = node.getProperties(cache);
        while (iter.hasNext()) {
            Property prop = iter.next();
            try {
                this.createJcrProperty(prop, newPrimaryTypeName, mixinTypeNames);
            }
            catch (ConstraintViolationException e) {
                String propName = this.readable(prop.getName());
                I18n msg = JcrI18n.unableToChangePrimaryTypeDueToPropertyDefinition;
                throw new ConstraintViolationException(msg.text(new Object[]{this.location(), oldPrimaryType, newPrimaryTypeName, propName}), (Throwable)e);
            }
        }
        Name nodeName = node.getName(cache);
        CachedNode parent = this.getParent().node();
        Name primaryType = parent.getPrimaryType(cache);
        JcrNodeDefinition childDefn = nodeTypes.findChildNodeDefinition(primaryType, mixins = parent.getMixinTypes(cache), nodeName, newPrimaryTypeName, numExistingSns = parent.getChildReferences(cache).getChildCount(nodeName), skipProtected = true);
        if (childDefn == null) {
            String ptype = this.readable(primaryType);
            String mtypes = this.readable(parent.getMixinTypes(cache));
            I18n msg = JcrI18n.unableToChangePrimaryTypeDueToParentsChildDefinition;
            throw new ConstraintViolationException(msg.text(new Object[]{this.location(), oldPrimaryType, newPrimaryTypeName, ptype, mtypes}));
        }
        this.setNodeDefinitionId(childDefn.getId(), nodeTypes.getVersion());
        boolean wasReferenceable = this.isReferenceable();
        MutableCachedNode mutable = this.mutable();
        mutable.setProperty(cache, this.session.propertyFactory().create(JcrLexicon.PRIMARY_TYPE, newPrimaryTypeName));
        if (wasReferenceable && !this.isReferenceable()) {
            mutable.removeProperty(cache, JcrLexicon.UUID);
        }
        this.autoCreateItemsFor(newPrimaryType);
        for (AbstractJcrProperty prop : this.jcrProperties.values()) {
            prop.releasePropertyDefinitionId();
        }
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        CheckArg.isNotZeroLength((String)mixinName, (String)"mixinName");
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        Path path = this.path();
        this.session.checkPermission(path, "set_property");
        if (!this.canAddMixin(mixinName)) {
            throw new ConstraintViolationException(JcrI18n.cannotAddMixin.text(new Object[]{mixinName}));
        }
        if (this.isNodeType(mixinName)) {
            return;
        }
        boolean wasReferenceable = this.isReferenceable();
        Name mixinTypeName = this.nameFrom(mixinName);
        SessionCache cache = this.sessionCache();
        MutableCachedNode mutable = this.mutable();
        mutable.addMixin(cache, mixinTypeName);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        JcrNodeType mixinType = nodeTypes.getNodeType(mixinTypeName);
        if (!wasReferenceable && mixinType.isNodeType(JcrMixLexicon.REFERENCEABLE)) {
            Property uuidProp = this.session.propertyFactory().create(JcrLexicon.UUID, this.getIdentifier());
            mutable.setProperty(cache, uuidProp);
        }
        this.autoCreateItemsFor(mixinType);
        for (AbstractJcrProperty prop : this.jcrProperties.values()) {
            prop.releasePropertyDefinitionId();
        }
        this.updateMixinsProperty();
    }

    private void updateMixinsProperty() throws RepositoryException {
        MutableCachedNode mutable = this.mutable();
        ArrayList<Name> currentMixins = new ArrayList<Name>(mutable.getMixinTypes(this.sessionCache()));
        Value[] mixinValues = this.session.valueFactory().createValues(currentMixins, 7);
        AbstractJcrProperty mixinProperty = (AbstractJcrProperty)this.jcrProperties.get(JcrLexicon.MIXIN_TYPES);
        if (mixinProperty == null) {
            mixinProperty = new JcrMultiValueProperty(this, JcrLexicon.MIXIN_TYPES, 7);
            this.jcrProperties.put(JcrLexicon.MIXIN_TYPES, mixinProperty);
        }
        mixinProperty.setValue(mixinValues);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeIterator shared;
        long numShared;
        CheckArg.isNotZeroLength((String)mixinName, (String)"mixinName");
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.session.checkPermission(this.path(), "set_property");
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveFromProtectedNode.text(new Object[]{this.getPath()}));
        }
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        Name removedMixinName = this.nameFrom(mixinName);
        if (!this.isNodeType(mixinName)) {
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(new Object[]{mixinName, this.location()}));
        }
        if (JcrMixLexicon.SHAREABLE.equals(removedMixinName) && this.isShareable() && (numShared = (shared = this.getSharedSet()).getSize()) > 1L) {
            Node sharedNode;
            StringBuilder paths = new StringBuilder();
            if (shared.hasNext()) {
                sharedNode = shared.nextNode();
                paths.append(sharedNode.getPath());
            }
            while (shared.hasNext()) {
                paths.append(", ");
                sharedNode = shared.nextNode();
                paths.append(sharedNode.getPath());
            }
            String msg = JcrI18n.cannotRemoveShareableMixinThatIsShared.text(new Object[]{this.location(), numShared, paths});
            throw new ConstraintViolationException(msg);
        }
        SessionCache cache = this.sessionCache();
        CachedNode cachedNode = this.node();
        Name primaryTypeName = cachedNode.getPrimaryType(cache);
        HashSet<Name> newMixinNames = new HashSet<Name>(cachedNode.getMixinTypes(cache));
        if (!newMixinNames.remove(removedMixinName)) {
            return;
        }
        PropertyIterator iter = this.getProperties();
        while (iter.hasNext()) {
            JcrPropertyDefinition match;
            javax.jcr.Property property = iter.nextProperty();
            if (!mixinName.equals(property.getDefinition().getDeclaringNodeType().getName()) || (match = property.getDefinition().isMultiple() ? nodeTypes.findPropertyDefinition(this.session, primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValues(), true) : nodeTypes.findPropertyDefinition(this.session, primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValue(), true, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noPropertyDefinition.text(new Object[]{property.getName(), this.location(), this.readable(primaryTypeName), this.readable(newMixinNames)}));
        }
        iter = this.getNodes();
        while (iter.hasNext()) {
            JcrNodeDefinition match;
            AbstractJcrNode child = (AbstractJcrNode)iter.nextNode();
            int snsCount = (int)this.childCount(child.name());
            if (!mixinName.equals(child.getDefinition().getDeclaringNodeType().getName()) || (match = nodeTypes.findChildNodeDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, child.getPrimaryNodeType().getInternalName(), snsCount, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noChildNodeDefinition.text(new Object[]{child.getName(), this.location(), this.readable(primaryTypeName), this.readable(newMixinNames)}));
        }
        boolean wasReferenceable = this.isReferenceable();
        MutableCachedNode mutable = this.mutable();
        mutable.removeMixin(cache, removedMixinName);
        if (wasReferenceable && !this.isReferenceable()) {
            mutable.removeProperty(cache, JcrLexicon.UUID);
        }
        for (AbstractJcrProperty prop : this.jcrProperties.values()) {
            prop.releasePropertyDefinitionId();
        }
        NodeIterator iter2 = this.getNodes();
        while (iter2.hasNext()) {
            AbstractJcrNode child = (AbstractJcrNode)iter2.nextNode();
            child.releaseNodeDefinitionId();
        }
        this.updateMixinsProperty();
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        CheckArg.isNotEmpty((String)mixinName, (String)"mixinName");
        JcrNodeType mixinType = this.session().nodeTypeManager().getNodeType(mixinName);
        if (!mixinType.isMixin()) {
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        if (!this.isCheckedOut()) {
            return false;
        }
        if (this.getDefinition().isProtected()) {
            return false;
        }
        if (mixinType.isAbstract()) {
            return false;
        }
        if (!mixinType.isMixin()) {
            return false;
        }
        if (this.isNodeType(mixinType.getInternalName())) {
            return true;
        }
        for (JcrPropertyDefinition propDefn : mixinType.propertyDefinitions()) {
            Name propName = propDefn.getInternalName();
            AbstractJcrProperty existingProp = this.getProperty(propName);
            if (existingProp == null || !(propDefn.isMultiple() ? !propDefn.canCastToTypeAndSatisfyConstraints(existingProp.getValues(), this.session()) : !propDefn.canCastToTypeAndSatisfyConstraints(existingProp.getValue(), this.session()))) continue;
            return false;
        }
        HashSet<Name> mixinChildNodeNames = new HashSet<Name>();
        for (JcrNodeDefinition nodeDefinition : mixinType.childNodeDefinitions()) {
            mixinChildNodeNames.add(nodeDefinition.getInternalName());
        }
        CachedNode node = this.node();
        NodeCache cache = this.cache();
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session.nodeTypes();
        for (Name nodeName : mixinChildNodeNames) {
            ChildReferences refs = node.getChildReferences(this.cache());
            int snsCount = refs.getChildCount(nodeName);
            if (snsCount == 0) continue;
            Iterator<ChildReference> iter = refs.iterator(nodeName);
            while (iter.hasNext()) {
                ChildReference ref = iter.next();
                CachedNode child = cache.getNode(ref);
                Name childPrimaryType = child.getPrimaryType(cache);
                boolean skipProtected = true;
                JcrNodeDefinition childDefn = nodeTypes.findChildNodeDefinition(mixinType.getInternalName(), null, nodeName, childPrimaryType, snsCount, skipProtected);
                if (childDefn != null) continue;
                return false;
            }
        }
        return true;
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.checkSession();
        return this.nodeDefinition();
    }

    final void setNodeDefinitionId(NodeDefinitionId nodeDefnId, int nodeTypeVersion) {
        this.cachedDefn = new CachedDefinition(nodeDefnId, nodeTypeVersion);
    }

    final void releaseNodeDefinitionId() {
        this.cachedDefn = null;
    }

    NodeDefinitionId nodeDefinitionId() throws ItemNotFoundException, ConstraintViolationException, RepositoryException {
        CachedDefinition defn = this.cachedDefn;
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session().nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            boolean skipProtected;
            int numExistingSnsInParent;
            Set<Name> parentMixins;
            assert (!this.isRoot());
            CachedNode parent = this.getParent().node();
            SessionCache cache = this.sessionCache();
            Name nodeName = this.name();
            Name primaryType = this.node().getPrimaryType(cache);
            Name parentPrimaryType = parent.getPrimaryType(cache);
            JcrNodeDefinition childDefn = nodeTypes.findChildNodeDefinition(parentPrimaryType, parentMixins = parent.getMixinTypes(cache), nodeName, primaryType, numExistingSnsInParent = parent.getChildReferences(cache).getChildCount(nodeName), skipProtected = true);
            if (childDefn == null) {
                throw new ConstraintViolationException(JcrI18n.noChildNodeDefinition.text(new Object[]{nodeName, this.getParent().location(), this.readable(parentPrimaryType), this.readable(parentMixins)}));
            }
            NodeDefinitionId id = childDefn.getId();
            this.setNodeDefinitionId(id, nodeTypes.getVersion());
            return id;
        }
        return defn.nodeDefnId;
    }

    final NodeDefinition nodeDefinition() throws ItemNotFoundException, ConstraintViolationException, RepositoryException {
        CachedDefinition defn = this.cachedDefn;
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.session().nodeTypes();
        if (defn == null || nodeTypes.getVersion() > defn.nodeTypesVersion) {
            boolean skipProtected;
            int numExistingSnsInParent;
            Set<Name> parentMixins;
            assert (!this.isRoot());
            CachedNode parent = this.getParent().node();
            SessionCache cache = this.sessionCache();
            Name nodeName = this.name();
            Name primaryType = this.node().getPrimaryType(cache);
            Name parentPrimaryType = parent.getPrimaryType(cache);
            JcrNodeDefinition childDefn = nodeTypes.findChildNodeDefinition(parentPrimaryType, parentMixins = parent.getMixinTypes(cache), nodeName, primaryType, numExistingSnsInParent = parent.getChildReferences(cache).getChildCount(nodeName), skipProtected = false);
            if (childDefn == null) {
                throw new ConstraintViolationException(JcrI18n.noChildNodeDefinition.text(new Object[]{nodeName, this.getParent().location(), this.readable(parentPrimaryType), this.readable(parentMixins)}));
            }
            NodeDefinitionId id = childDefn.getId();
            this.setNodeDefinitionId(id, nodeTypes.getVersion());
            return childDefn;
        }
        return nodeTypes.getChildNodeDefinition(defn.nodeDefnId);
    }

    private void checkNotProtected() throws ConstraintViolationException, RepositoryException {
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(new Object[]{this.getPath()}));
        }
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.versionManager().checkin(this);
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, ActivityViolationException, RepositoryException {
        this.versionManager().checkout(this);
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.versionManager().doneMerge(this, version);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.versionManager().cancelMerge(this, version);
    }

    public void update(String srcWorkspace) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"srcWorkspace");
        this.session().getWorkspace().validateCrossWorkspaceAction(srcWorkspace);
        if (this.workspaceName().equalsIgnoreCase(srcWorkspace)) {
            return;
        }
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        this.checkNotProtected();
        Path srcPath = null;
        try {
            srcPath = this.correspondingNodePath(srcWorkspace);
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        JcrSession sourceSession = this.session.spawnSession(srcWorkspace, true);
        AbstractJcrNode sourceNode = sourceSession.node(srcPath);
        if (this.session.lockManager().isLocked(sourceNode) && !this.session.lockManager().hasLockToken(sourceNode.getLock().getLockToken())) {
            throw new LockException(srcPath.toString());
        }
        Path dstPath = this.path();
        if (this.isLocked() && !this.session.lockManager().hasLockToken(this.getLock().getLockToken())) {
            throw new LockException(dstPath.toString());
        }
        JcrSession cloneSession = this.session.spawnSession(false);
        this.getSession().getWorkspace().deepClone(sourceSession, sourceNode.key(), cloneSession, this.key());
        this.session().refresh(false);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"srcWorkspace");
        this.checkNotProtected();
        return this.versionManager().merge(this, srcWorkspace, bestEffort, false);
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.checkSession();
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        return this.correspondingNodePath(workspaceName).getString(namespaces);
    }

    protected final Path correspondingNodePath(String workspaceName) throws NoSuchWorkspaceException, ItemNotFoundException, RepositoryException {
        assert (workspaceName != null);
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        AbstractJcrNode referenceableRoot = this;
        while (!referenceableRoot.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(namespaces))) {
            referenceableRoot = referenceableRoot.getParent();
        }
        Path relativePath = this.path().equals(referenceableRoot.path()) ? null : this.path().relativeTo(referenceableRoot.path());
        NodeKey key = referenceableRoot.key();
        String systemWsKey = this.session.getRepository().systemWorkspaceKey();
        String workspaceKey = systemWsKey.equals(key.getWorkspaceKey()) ? systemWsKey : NodeKey.keyForWorkspaceName(workspaceName);
        NodeKey nodeKey = new NodeKey(key.getSourceKey(), workspaceKey, key.getIdentifier());
        return this.session.getPathForCorrespondingNode(workspaceName, nodeKey, relativePath);
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        if (this.isShareable()) {
            return this.sharedSet().getSharedNodes();
        }
        return new JcrSingleNodeIterator(this);
    }

    JcrSharedNodeCache.SharedSet sharedSet() {
        return this.session.shareableNodeCache().getSharedSet(this);
    }

    void addSharedNode(AbstractJcrNode shareableNode, Name newNodeName) throws RepositoryException {
        assert (this.session == shareableNode.session);
        this.session.checkPermission(this.getPath(), "add_node");
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location()}));
        }
        SessionCache cache = this.sessionCache();
        MutableCachedNode node = this.mutable();
        int numExistingSns = node.getChildReferences(cache).getChildCount(newNodeName);
        JcrNodeDefinition childDefn = this.validateChildNodeDefinition(newNodeName, shareableNode.getPrimaryTypeName(), true);
        if (!this.isCheckedOut() && childDefn.getOnParentVersion() != 5) {
            Path parentPath = this.path();
            String parentPathStr = this.readable(parentPath);
            int sns = numExistingSns + 1;
            String segment = this.readable(this.session.pathFactory().createSegment(newNodeName, sns));
            String opv = OnParentVersionAction.nameFromValue((int)childDefn.getOnParentVersion());
            I18n msg = JcrI18n.cannotCreateChildOnCheckedInNodeSinceOpvOfChildDefinitionIsNotIgnore;
            throw new VersionException(msg.text(new Object[]{segment, this.readable(parentPathStr), childDefn.getName(), opv}));
        }
        NodeKey childKey = shareableNode.key();
        node.linkChild(cache, childKey, newNodeName);
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        JcrSharedNodeCache.SharedSet sharedSet;
        if (this.isShareable() && (sharedSet = this.sharedSet()).getSize() != 1) {
            NodeIterator sharedSetNodes = sharedSet.getSharedNodes();
            ArrayList<AbstractJcrNode> shared = new ArrayList<AbstractJcrNode>();
            while (sharedSetNodes.hasNext()) {
                AbstractJcrNode nodeInSharedSet = (AbstractJcrNode)sharedSetNodes.nextNode();
                try {
                    AbstractJcrNode parent = nodeInSharedSet.getParent();
                    parent.checkForLock();
                    Path path = nodeInSharedSet.path();
                    this.session.checkPermission(path, "remove");
                    if (nodeInSharedSet == this) continue;
                    shared.add(nodeInSharedSet);
                }
                catch (ItemNotFoundException e) {
                    throw new InvalidItemStateException((Throwable)e);
                }
            }
            for (AbstractJcrNode nodeInSharedSet : shared) {
                nodeInSharedSet.doRemove();
            }
        }
        this.doRemove();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeDefinition defn;
        int opv;
        this.checkSession();
        AbstractJcrNode parent = null;
        try {
            parent = this.getParent();
        }
        catch (ItemNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
        Path path = null;
        try {
            parent.checkForLock();
            path = this.path();
            this.session.checkPermission(path, "remove");
        }
        catch (NodeNotFoundInParentException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
        if (!parent.isCheckedOut() && (opv = (defn = this.getDefinition()).getOnParentVersion()) != 5) {
            String opvStr = OnParentVersionAction.nameFromValue((int)opv);
            I18n msg = JcrI18n.cannotRemoveChildOnCheckedInNodeSinceOpvOfChildDefinitionIsNotIgnore;
            throw new VersionException(msg.text(new Object[]{path, defn.getName(), opvStr}));
        }
        this.doRemove();
    }

    protected abstract void doRemove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException;

    public boolean isCheckedOut() throws RepositoryException {
        SessionCache cache = this.sessionCache();
        ValueFactory<Boolean> booleanFactory = this.session.context().getValueFactories().getBooleanFactory();
        for (AbstractJcrNode node = this; node != null; node = node.getParent()) {
            NodeDefinition defn = node.getDefinition();
            if (defn.getOnParentVersion() == 5) {
                return true;
            }
            if (node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                Property prop = node.node().getProperty(JcrLexicon.IS_CHECKED_OUT, cache);
                return prop == null || booleanFactory.create(prop.getFirstValue()) != false;
            }
            if (node.isRoot()) break;
        }
        return true;
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.restore(this.getVersionHistory().getVersion(versionName), removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        try {
            this.checkNotProtected();
        }
        catch (ConstraintViolationException cve) {
            throw new UnsupportedRepositoryOperationException((Throwable)cve);
        }
        this.versionManager().restoreAtAbsPath(this.getPath(), version, removeExisting, false);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.checkNotProtected();
        PathFactory pathFactory = this.session.pathFactory();
        Path relPathAsPath = (Path)pathFactory.create(relPath);
        if (relPathAsPath.isAbsolute()) {
            throw new RepositoryException(JcrI18n.invalidRelativePath.text(new Object[]{relPath}));
        }
        Path actualPath = pathFactory.create(this.path(), relPathAsPath).getCanonicalPath();
        this.versionManager().restoreAtAbsPath(this.session.stringFactory().create(actualPath), version, removeExisting, false);
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.restore(this.getVersionHistory().getVersionByLabel(versionLabel), removeExisting);
    }

    public JcrVersionHistoryNode getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.versionManager().getVersionHistory(this);
    }

    public JcrVersionNode getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkSession();
        if (!this.hasProperty(JcrLexicon.BASE_VERSION)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        NodeKey baseVersionKey = ((NodeKeyReference)this.getProperty(JcrLexicon.BASE_VERSION).getValue().value()).getNodeKey();
        return (JcrVersionNode)this.session().node(baseVersionKey, null);
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.session.lockManager().lock(this, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public final Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.session.lockManager().getLock(this);
    }

    protected final Lock getLockIfExists() throws UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        return this.session.lockManager().getLockIfExists(this);
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.session.lockManager().unlock(this);
    }

    public boolean holdsLock() {
        return this.session.lockManager().holdsLock(this);
    }

    public boolean isLocked() throws RepositoryException {
        return this.session.lockManager().isLocked(this);
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean isNode() {
        return true;
    }

    public boolean isNew() {
        try {
            CachedNode node = this.node();
            return node instanceof MutableCachedNode && ((MutableCachedNode)node).isNew();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isModified() {
        try {
            CachedNode node = this.node();
            if (node instanceof MutableCachedNode) {
                MutableCachedNode mutable = (MutableCachedNode)node;
                return !mutable.isNew() && mutable.hasChanges();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        if (otherItem == this) {
            return true;
        }
        if (otherItem instanceof AbstractJcrNode) {
            NodeKey thatKey = ((AbstractJcrNode)otherItem).key();
            if (!this.key.equals(thatKey)) {
                return false;
            }
            return super.isSameRepository(otherItem);
        }
        return false;
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull((Object)visitor, (String)"visitor");
        this.checkSession();
        visitor.visit((Node)this);
    }

    @Deprecated
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.session.save(this);
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        CachedNode node = this.node();
        if (!keepChanges) {
            this.session.cache().clear(node);
        }
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.removeShare();
    }

    final boolean canAddNode(String relPath, String primaryNodeTypeName) throws RepositoryException {
        CheckArg.isNotEmpty((String)relPath, (String)relPath);
        this.checkSession();
        Path path = null;
        try {
            path = (Path)this.session().pathFactory().create(relPath);
        }
        catch (ValueFormatException e) {
            return false;
        }
        if (path.size() == 0) {
            return false;
        }
        if (path.isIdentifier()) {
            return false;
        }
        if (path.getLastSegment().getIndex() > 1 || relPath.endsWith("]")) {
            return false;
        }
        if (path.size() > 1) {
            Path parentPath = path.getParent();
            try {
                AbstractJcrNode other = this.session.node(this.node(), parentPath);
                return other.canAddNode(primaryNodeTypeName);
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return this.canAddNode(primaryNodeTypeName);
    }

    private final boolean canAddNode(String primaryNodeTypeName) throws RepositoryException {
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            return false;
        }
        if (primaryNodeTypeName != null) {
            if (!this.session().nodeTypeManager().hasNodeType(primaryNodeTypeName)) {
                return false;
            }
            JcrNodeType nodeType = this.session().nodeTypeManager().getNodeType(primaryNodeTypeName);
            if (nodeType.isAbstract()) {
                return false;
            }
            if (nodeType.isMixin()) {
                return false;
            }
            if (INTERNAL_NODE_TYPE_NAMES.contains(nodeType.getInternalName())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        try {
            PropertyIterator iter = this.getProperties();
            StringBuffer propertyBuff = new StringBuffer();
            while (iter.hasNext()) {
                AbstractJcrProperty prop = (AbstractJcrProperty)iter.nextProperty();
                propertyBuff.append(prop).append(", ");
            }
            return this.getPath() + " {" + propertyBuff.toString() + "}";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected boolean containsChangesWithExternalDependencies() throws RepositoryException {
        Set<NodeKey> allChanges = this.sessionCache().getChangedNodeKeys();
        Set<NodeKey> changesAtOrBelowThis = this.sessionCache().getChangedNodeKeysAtOrBelow(this.node());
        this.removeReferrerChanges(allChanges, changesAtOrBelowThis);
        return !changesAtOrBelowThis.containsAll(allChanges);
    }

    private void removeReferrerChanges(Set<NodeKey> allChanges, Set<NodeKey> changesAtOrBelowThis) throws RepositoryException {
        Iterator<NodeKey> allChangesIt = allChanges.iterator();
        while (allChangesIt.hasNext()) {
            NodeKey changedNodeKey = allChangesIt.next();
            if (changesAtOrBelowThis.contains(changedNodeKey)) continue;
            MutableCachedNode changedNodeOutsideBranch = this.session().cache().mutable(changedNodeKey);
            AbstractJcrNode changedNode = null;
            try {
                changedNode = this.session().node(changedNodeKey, null);
            }
            catch (ItemNotFoundException e) {
                allChangesIt.remove();
                continue;
            }
            boolean isShareable = changedNode.isShareable();
            if (isShareable) {
                allChangesIt.remove();
                continue;
            }
            boolean isReferenceable = changedNode.isReferenceable();
            if (!isReferenceable) continue;
            Set<NodeKey> changedReferrers = changedNodeOutsideBranch.getChangedReferrerNodes();
            for (NodeKey changedNodeInBranchKey : changesAtOrBelowThis) {
                if (!changedReferrers.contains(changedNodeInBranchKey)) continue;
                allChangesIt.remove();
            }
        }
    }

    protected static final class ChildNodeResolver
    implements JcrChildNodeIterator.NodeResolver {
        private final JcrSession session;
        private final NodeKey parentKey;

        protected ChildNodeResolver(JcrSession session, NodeKey parentKey) {
            this.session = session;
            this.parentKey = parentKey;
        }

        @Override
        public Node nodeFrom(ChildReference ref) {
            try {
                return this.session.node(ref.getKey(), null, this.parentKey);
            }
            catch (RepositoryException e) {
                return null;
            }
        }
    }

    @Immutable
    private static final class CachedDefinition {
        protected final NodeDefinitionId nodeDefnId;
        protected final int nodeTypesVersion;

        protected CachedDefinition(NodeDefinitionId nodeDefnId, int nodeTypesVersion) {
            this.nodeDefnId = nodeDefnId;
            this.nodeTypesVersion = nodeTypesVersion;
        }
    }

    static enum Type {
        ROOT,
        NODE,
        SYSTEM,
        VERSION,
        VERSION_HISTORY;

        private static final Map<Name, Type> DEFAULT_TYPE_BY_NAME;

        public static Type typeForPrimaryType(Name primaryType) {
            return DEFAULT_TYPE_BY_NAME.get(primaryType);
        }

        static {
            HashMap<Name, Type> byName = new HashMap<Name, Type>();
            byName.put(ModeShapeLexicon.ROOT, ROOT);
            byName.put(ModeShapeLexicon.SYSTEM, SYSTEM);
            byName.put(JcrNtLexicon.VERSION_HISTORY, VERSION_HISTORY);
            byName.put(JcrNtLexicon.VERSION_LABELS, SYSTEM);
            byName.put(JcrNtLexicon.VERSION, VERSION);
            byName.put(ModeShapeLexicon.NODE_TYPES, SYSTEM);
            byName.put(JcrNtLexicon.NODE_TYPE, SYSTEM);
            byName.put(JcrNtLexicon.PROPERTY_DEFINITION, SYSTEM);
            byName.put(JcrNtLexicon.CHILD_NODE_DEFINITION, SYSTEM);
            byName.put(ModeShapeLexicon.NAMESPACES, SYSTEM);
            byName.put(ModeShapeLexicon.NAMESPACE, SYSTEM);
            byName.put(ModeShapeLexicon.LOCKS, SYSTEM);
            byName.put(ModeShapeLexicon.LOCK, SYSTEM);
            DEFAULT_TYPE_BY_NAME = Collections.unmodifiableMap(byName);
        }
    }
}

