/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.HashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.NodeTypeExistsException;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.parse.BasicSqlQueryParser;
import org.modeshape.jcr.query.parse.QueryParser;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactory;

@ThreadSafe
class RepositoryNodeTypeManager
implements ChangeSetListener {
    private final JcrRepository.RunningState repository;
    private final ExecutionContext context;
    private final String systemWorkspaceName;
    private final Path nodeTypesPath;
    private final NameFactory nameFactory;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ReadWriteLock nodeTypesLock = new ReentrantReadWriteLock();
    private volatile NodeTypes nodeTypesCache;
    private final QueryParser queryParser;
    private final boolean includeColumnsForInheritedProperties;
    private final boolean includePseudoColumnsInSelectStar;
    private volatile NodeTypeSchemata schemata;

    RepositoryNodeTypeManager(JcrRepository.RunningState repository, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        this.repository = repository;
        this.context = repository.context();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.systemWorkspaceName = this.repository.repositoryCache().getSystemWorkspaceName();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        this.nodeTypesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.NODE_TYPES);
        this.nodeTypesCache = new NodeTypes(this.context);
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.includePseudoColumnsInSelectStar = includePseudoColumnsInSelectStar;
        this.queryParser = new BasicSqlQueryParser();
    }

    RepositoryNodeTypeManager with(JcrRepository.RunningState repository, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        assert (this.systemWorkspaceName.equals(repository.repositoryCache().getSystemWorkspaceName()));
        PathFactory pathFactory = repository.context().getValueFactories().getPathFactory();
        Path nodeTypesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, JcrLexicon.NODE_TYPES);
        assert (this.nodeTypesPath.equals(nodeTypesPath));
        RepositoryNodeTypeManager result = new RepositoryNodeTypeManager(repository, includeColumnsForInheritedProperties, includePseudoColumnsInSelectStar);
        result.nodeTypesCache = result.nodeTypesCache.with(this.nodeTypesCache.getAllNodeTypes());
        return result;
    }

    protected final ValueFactory<String> strings() {
        return this.context.getValueFactories().getStringFactory();
    }

    public NodeTypes getNodeTypes() {
        return this.nodeTypesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNodeType(Collection<Name> nodeTypeNames, boolean failIfNodeTypesAreUsed) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        CheckArg.isNotNull(nodeTypeNames, (String)"nodeTypeNames");
        if (nodeTypeNames.isEmpty()) {
            return;
        }
        if (failIfNodeTypesAreUsed) {
            long start = System.nanoTime();
            for (Name nodeTypeName : nodeTypeNames) {
                if (!this.isNodeTypeInUse(nodeTypeName)) continue;
                String name = nodeTypeName.getString(this.context.getNamespaceRegistry());
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterInUseType.text(new Object[]{name}));
            }
            long time = TimeUnit.MILLISECONDS.convert(Math.abs(System.nanoTime() - start), TimeUnit.NANOSECONDS);
            this.logger.debug("{0} milliseconds to check if any of these node types are unused before unregistering them: {1}", new Object[]{time, nodeTypeNames});
        }
        try {
            ArrayList<JcrNodeType> removedNodeTypes = new ArrayList<JcrNodeType>(nodeTypeNames.size());
            this.nodeTypesLock.writeLock().lock();
            NodeTypes nodeTypes = this.nodeTypesCache;
            for (Name nodeTypeName : nodeTypeNames) {
                if (nodeTypeName == null) {
                    throw new NoSuchNodeTypeException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                String name = nodeTypeName.getString(this.context.getNamespaceRegistry());
                JcrNodeType foundNodeType = nodeTypes.getNodeType(nodeTypeName);
                if (foundNodeType == null) {
                    throw new NoSuchNodeTypeException(JcrI18n.noSuchNodeType.text(new Object[]{name}));
                }
                removedNodeTypes.add(foundNodeType);
                for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
                    if (nodeTypeNames.contains(nodeType.getInternalName())) continue;
                    for (JcrNodeType supertype : nodeType.supertypes()) {
                        if (!nodeTypeName.equals(supertype.getInternalName())) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterSupertype.text(new Object[]{name, supertype.getName()}));
                    }
                    for (JcrNodeDefinition childNode : nodeType.childNodeDefinitions()) {
                        JcrNodeType defaultPrimaryType = childNode.getDefaultPrimaryType();
                        if (defaultPrimaryType != null && name.equals(defaultPrimaryType.getName())) {
                            throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterDefaultPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                        }
                        if (!childNode.requiredPrimaryTypeNameSet().contains(nodeTypeName)) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterRequiredPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                    }
                }
            }
            NodeTypes newNodeTypes = nodeTypes.without(removedNodeTypes);
            SessionCache system = this.repository.createSystemSession(this.context, false);
            for (JcrNodeType nodeType : removedNodeTypes) {
                system.destroy(nodeType.key());
            }
            system.save();
            this.nodeTypesCache = newNodeTypes;
            this.schemata = null;
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    NodeTypeSchemata getRepositorySchemata() {
        if (this.schemata != null) {
            return this.schemata;
        }
        this.schemata = new NodeTypeSchemata(this.context, this.nodeTypesCache, this.includeColumnsForInheritedProperties, this.includePseudoColumnsInSelectStar);
        return this.schemata;
    }

    void signalNamespaceChanges() {
        this.schemata = null;
    }

    boolean isNodeTypeInUse(Name nodeTypeName) throws InvalidQueryException {
        String nodeTypeString = nodeTypeName.getString(this.context.getNamespaceRegistry());
        String expression = "SELECT * from [" + nodeTypeString + "] LIMIT 1";
        TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
        QueryCommand command = this.queryParser.parseQuery(expression, typeSystem);
        assert (command != null) : "Could not parse " + expression;
        NodeTypeSchemata schemata = this.getRepositorySchemata();
        RepositoryCache repoCache = this.repository.repositoryCache();
        RepositoryQueryManager queryManager = this.repository.queryManager();
        Set<String> workspaceNames = repoCache.getWorkspaceNames();
        Map<String, NodeCache> overridden = null;
        CancellableQuery query = queryManager.query(this.context, repoCache, workspaceNames, overridden, command, schemata, null, null);
        try {
            QueryResults result = query.getResults();
            return result.getRowCount() > 0;
        }
        catch (RepositoryException e) {
            this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorCheckingNodeTypeUsage, new Object[]{nodeTypeName, e.getLocalizedMessage()});
            return true;
        }
    }

    JcrNodeType registerNodeType(NodeTypeDefinition ntd) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        return this.registerNodeType(ntd, true);
    }

    JcrNodeType registerNodeType(NodeTypeDefinition ntd, boolean failIfNodeTypeExists) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        assert (ntd != null);
        List<JcrNodeType> result = this.registerNodeTypes(Collections.singletonList(ntd), failIfNodeTypeExists, false, true);
        return result.isEmpty() ? null : result.get(0);
    }

    List<JcrNodeType> registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypeDefns) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        return this.registerNodeTypes(nodeTypeDefns, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JcrNodeType> registerNodeTypes(Iterable<NodeTypeDefinition> nodeTypeDefns, boolean failIfNodeTypeDefinitionsExist, boolean skipIfNodeTypeDefinitionExists, boolean persist) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        if (nodeTypeDefns == null) {
            return Collections.emptyList();
        }
        ArrayList<JcrNodeType> typesPendingRegistration = new ArrayList<JcrNodeType>();
        try {
            this.nodeTypesLock.writeLock().lock();
            NodeTypes nodeTypes = this.nodeTypesCache;
            for (Object nodeTypeDefn : nodeTypeDefns) {
                Name internalName;
                if (nodeTypeDefn instanceof JcrNodeTypeTemplate) {
                    nodeTypeDefn = ((JcrNodeTypeTemplate)nodeTypeDefn).with(this.context);
                }
                if ((internalName = (Name)nodeTypes.nameFactory().create(nodeTypeDefn.getName())) == null || internalName.getLocalName().length() == 0) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                boolean found = nodeTypes.hasNodeType(internalName);
                if (found && failIfNodeTypeDefinitionsExist) {
                    String name = nodeTypeDefn.getName();
                    throw new NodeTypeExistsException(internalName, JcrI18n.nodeTypeAlreadyExists.text(new Object[]{name}));
                }
                if (found && skipIfNodeTypeDefinitionExists) continue;
                List<JcrNodeType> supertypes = nodeTypes.supertypesFor((NodeTypeDefinition)nodeTypeDefn, (Collection<JcrNodeType>)typesPendingRegistration);
                JcrNodeType nodeType = this.nodeTypeFrom((NodeTypeDefinition)nodeTypeDefn, supertypes);
                typesPendingRegistration.add(nodeType);
                nodeTypes.validate(nodeType, supertypes, typesPendingRegistration);
            }
            if (!typesPendingRegistration.isEmpty()) {
                for (JcrNodeType nodeType : typesPendingRegistration) {
                    for (JcrNodeDefinition nodeDef : nodeType.getDeclaredChildNodeDefinitions()) {
                        Name[] requiredPrimaryTypeNames = nodeDef.requiredPrimaryTypeNames();
                        JcrNodeType[] requiredPrimaryTypes = new JcrNodeType[requiredPrimaryTypeNames.length];
                        int i = 0;
                        for (Name primaryTypeName : requiredPrimaryTypeNames) {
                            JcrNodeType requiredPrimaryType = nodeTypes.findTypeInMapOrList(primaryTypeName, typesPendingRegistration);
                            if (requiredPrimaryType == null) {
                                String msg = JcrI18n.invalidPrimaryTypeName.text(new Object[]{primaryTypeName, nodeType.getName()});
                                throw new RepositoryException(msg);
                            }
                            requiredPrimaryTypes[i++] = requiredPrimaryType;
                        }
                    }
                }
                SystemContent system = null;
                if (persist) {
                    SessionCache systemCache = this.repository.createSystemSession(this.context, false);
                    system = new SystemContent(systemCache);
                }
                for (JcrNodeType nodeType : typesPendingRegistration) {
                    if (system == null) continue;
                    system.store(nodeType, true);
                }
                NodeTypes newNodeTypes = nodeTypes.with(typesPendingRegistration);
                if (system != null) {
                    system.save();
                }
                this.nodeTypesCache = newNodeTypes;
                this.schemata = null;
            }
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
        return typesPendingRegistration;
    }

    private JcrNodeType nodeTypeFrom(NodeTypeDefinition nodeType, List<JcrNodeType> supertypes) throws RepositoryException {
        PropertyDefinition[] propDefns = nodeType.getDeclaredPropertyDefinitions();
        NodeDefinition[] childDefns = nodeType.getDeclaredChildNodeDefinitions();
        ArrayList<JcrPropertyDefinition> properties = new ArrayList<JcrPropertyDefinition>();
        ArrayList<JcrNodeDefinition> childNodes = new ArrayList<JcrNodeDefinition>();
        if (propDefns != null) {
            for (PropertyDefinition propertyDefinition : propDefns) {
                properties.add(this.propertyDefinitionFrom(propertyDefinition));
            }
        }
        if (childDefns != null) {
            for (PropertyDefinition propertyDefinition : childDefns) {
                childNodes.add(this.childNodeDefinitionFrom((NodeDefinition)propertyDefinition));
            }
        }
        Name name = (Name)this.nameFactory.create(nodeType.getName());
        Name primaryItemName = (Name)this.nameFactory.create(nodeType.getPrimaryItemName());
        boolean mixin = nodeType.isMixin();
        boolean bl = nodeType.isAbstract();
        boolean queryable = nodeType.isQueryable();
        boolean orderableChildNodes = nodeType.hasOrderableChildNodes();
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrNodeType(prototypeKey, this.context, null, this, name, supertypes, primaryItemName, childNodes, properties, mixin, bl, queryable, orderableChildNodes);
    }

    private JcrPropertyDefinition propertyDefinitionFrom(PropertyDefinition propDefn) throws RepositoryException {
        Name propertyName = (Name)this.nameFactory.create(propDefn.getName());
        int onParentVersionBehavior = propDefn.getOnParentVersion();
        int requiredType = propDefn.getRequiredType();
        boolean mandatory = propDefn.isMandatory();
        boolean multiple = propDefn.isMultiple();
        boolean autoCreated = propDefn.isAutoCreated();
        boolean isProtected = propDefn.isProtected();
        boolean fullTextSearchable = propDefn.isFullTextSearchable();
        boolean queryOrderable = propDefn.isQueryOrderable();
        Value[] defaultValues = propDefn.getDefaultValues();
        JcrValue[] jcrDefaultValues = null;
        if (defaultValues != null) {
            jcrDefaultValues = new JcrValue[defaultValues.length];
            for (int i = 0; i != defaultValues.length; ++i) {
                Value value = defaultValues[i];
                jcrDefaultValues[i] = new JcrValue(this.context.getValueFactories(), value);
            }
        }
        String[] valueConstraints = propDefn.getValueConstraints();
        String[] queryOperators = propDefn.getAvailableQueryOperators();
        if (valueConstraints == null) {
            valueConstraints = new String[]{};
        }
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrPropertyDefinition(this.context, null, prototypeKey, propertyName, onParentVersionBehavior, autoCreated, mandatory, isProtected, jcrDefaultValues, requiredType, valueConstraints, multiple, fullTextSearchable, queryOrderable, queryOperators);
    }

    private JcrNodeDefinition childNodeDefinitionFrom(NodeDefinition childNodeDefn) {
        Name[] requiredTypes;
        Name childNodeName = (Name)this.nameFactory.create(childNodeDefn.getName());
        Name defaultPrimaryTypeName = (Name)this.nameFactory.create(childNodeDefn.getDefaultPrimaryTypeName());
        int onParentVersion = childNodeDefn.getOnParentVersion();
        boolean mandatory = childNodeDefn.isMandatory();
        boolean allowsSns = childNodeDefn.allowsSameNameSiblings();
        boolean autoCreated = childNodeDefn.isAutoCreated();
        boolean isProtected = childNodeDefn.isProtected();
        String[] requiredTypeNames = childNodeDefn.getRequiredPrimaryTypeNames();
        if (requiredTypeNames != null) {
            ArrayList names = new ArrayList(requiredTypeNames.length);
            for (String typeName : requiredTypeNames) {
                names.add(this.nameFactory.create(typeName));
            }
            requiredTypes = names.toArray(new Name[names.size()]);
        } else {
            requiredTypes = new Name[]{};
        }
        NodeKey prototypeKey = this.repository.repositoryCache().getSystemKey();
        return new JcrNodeDefinition(this.context, null, prototypeKey, childNodeName, onParentVersion, autoCreated, mandatory, isProtected, allowsSns, defaultPrimaryTypeName, requiredTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(ChangeSet changeSet) {
        if (!this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
            return;
        }
        if (this.context.getProcessId().equals(changeSet.getProcessKey())) {
            return;
        }
        HashSet<Name> nodeTypesToRefresh = null;
        HashSet<Name> nodeTypesToDelete = null;
        for (Change change : changeSet) {
            PropertyChanged propChanged;
            Path changedPath;
            Name nodeTypeName;
            if (change instanceof NodeAdded) {
                NodeAdded added = (NodeAdded)change;
                Path addedPath = added.getPath();
                if (!this.nodeTypesPath.isAncestorOf(addedPath)) continue;
                nodeTypeName = addedPath.getSegment(2).getName();
                if (nodeTypesToRefresh == null) {
                    nodeTypesToRefresh = new HashSet<Name>();
                }
                nodeTypesToRefresh.add(nodeTypeName);
                continue;
            }
            if (change instanceof NodeRemoved) {
                NodeRemoved removed = (NodeRemoved)change;
                Path removedPath = removed.getPath();
                if (!this.nodeTypesPath.isAncestorOf(removedPath)) continue;
                nodeTypeName = removedPath.getSegment(2).getName();
                if (removedPath.size() == 3) {
                    if (nodeTypesToDelete == null) {
                        nodeTypesToDelete = new HashSet<Name>();
                    }
                    nodeTypesToDelete.add(nodeTypeName);
                    continue;
                }
                if (nodeTypesToDelete != null && nodeTypesToDelete.contains(nodeTypeName)) continue;
                if (nodeTypesToRefresh == null) {
                    nodeTypesToRefresh = new HashSet();
                }
                nodeTypesToRefresh.add(nodeTypeName);
                continue;
            }
            if (!(change instanceof PropertyChanged) || !this.nodeTypesPath.isAncestorOf(changedPath = (propChanged = (PropertyChanged)change).getPathToNode())) continue;
            nodeTypeName = changedPath.getSegment(2).getName();
            if (nodeTypesToRefresh == null) {
                nodeTypesToRefresh = new HashSet();
            }
            nodeTypesToRefresh.add(nodeTypeName);
        }
        if (nodeTypesToRefresh == null && nodeTypesToDelete == null) {
            return;
        }
        this.nodeTypesLock.writeLock().lock();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, false);
            SystemContent system = new SystemContent(systemCache);
            List<NodeTypeDefinition> nodeTypes = system.readNodeTypes(nodeTypesToRefresh);
            this.registerNodeTypes(nodeTypes, false, false, false);
            this.unregisterNodeType(nodeTypesToDelete, false);
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingNodeTypes, new Object[]{this.repository.name()});
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshFromSystem() {
        this.nodeTypesLock.writeLock().lock();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, true);
            SystemContent system = new SystemContent(systemCache);
            List<NodeTypeDefinition> nodeTypes = system.readAllNodeTypes();
            if (nodeTypes.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.registerNodeTypes(nodeTypes, false, false, false);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingNodeTypes, new Object[]{this.repository.name()});
            boolean bl = false;
            return bl;
        }
        finally {
            this.nodeTypesLock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.getNodeTypes().toString();
    }

    @Immutable
    public static final class NodeTypes {
        private final Map<Name, JcrNodeType> nodeTypes = new HashMap<Name, JcrNodeType>();
        private final Map<PropertyDefinitionId, JcrPropertyDefinition> propertyDefinitions = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        private final Map<NodeDefinitionId, JcrNodeDefinition> childNodeDefinitions = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        private final Collection<JcrNodeType> unmodifiableNodeTypes;
        private final Collection<JcrNodeType> unmodifiableMixinNodeTypes;
        private final Collection<JcrNodeType> unmodifiablePrimaryNodeTypes;
        private final Set<Name> unmodifiableNodeTypeNames;
        private final Set<Name> unmodifiableMixinTypeNames;
        private final int nodeTypesVersion;
        private final JcrNodeDefinition ntUnstructuredSnsChildDefinition;
        private final JcrNodeDefinition ntUnstructuredSingleChildDefinition;
        private final ExecutionContext context;
        private final NameFactory nameFactory;
        private static final Set<Name> fullyDefinedNodeTypes = new HashSet<Name>();
        private final Set<Name> createdNodeTypeNames = new HashSet<Name>();
        private final Set<Name> lastModifiedNodeTypeNames = new HashSet<Name>();
        private final Set<Name> etagNodeTypeNames = new HashSet<Name>();
        private final Set<Name> versionableNodeTypeNames = new HashSet<Name>();
        private final Multimap<Name, JcrPropertyDefinition> mandatoryPropertiesNodeTypes = HashMultimap.create();
        private final Multimap<Name, JcrNodeDefinition> mandatoryChildrenNodeTypes = HashMultimap.create();
        private final Multimap<Name, JcrPropertyDefinition> autoCreatedPropertiesNodeTypes = HashMultimap.create();
        private final Multimap<Name, JcrNodeDefinition> autoCreatedChildrenNodeTypes = HashMultimap.create();

        protected NodeTypes(ExecutionContext context) {
            this(context, null, 0);
        }

        protected NodeTypes(ExecutionContext context, Iterable<JcrNodeType> nodeTypes, int version) {
            this.nodeTypesVersion = version;
            this.context = context;
            this.nameFactory = context.getValueFactories().getNameFactory();
            HashSet<Name> mixinNames = new HashSet<Name>();
            ArrayList<JcrNodeType> mixins = new ArrayList<JcrNodeType>();
            ArrayList<JcrNodeType> primaries = new ArrayList<JcrNodeType>();
            if (nodeTypes != null) {
                JcrNodeType ntUnstructured = null;
                for (JcrNodeType nodeType : nodeTypes) {
                    Name name = nodeType.getInternalName();
                    this.nodeTypes.put(name, nodeType);
                    for (JcrNodeDefinition childDefinition : nodeType.childNodeDefinitions()) {
                        this.childNodeDefinitions.put(childDefinition.getId(), childDefinition);
                    }
                    for (JcrPropertyDefinition propertyDefinition : nodeType.propertyDefinitions()) {
                        this.propertyDefinitions.put(propertyDefinition.getId(), propertyDefinition);
                    }
                    if (nodeType.isMixin()) {
                        mixins.add(nodeType);
                        mixinNames.add(name);
                    } else {
                        primaries.add(nodeType);
                    }
                    if (name.equals(JcrNtLexicon.UNSTRUCTURED)) {
                        ntUnstructured = nodeType;
                    }
                    boolean fullyDefined = true;
                    if (nodeType.isNodeType(JcrMixLexicon.CREATED)) {
                        this.createdNodeTypeNames.add(name);
                        fullyDefined = false;
                    }
                    if (nodeType.isNodeType(JcrMixLexicon.LAST_MODIFIED)) {
                        this.lastModifiedNodeTypeNames.add(name);
                        fullyDefined = false;
                    }
                    if (nodeType.isNodeType(JcrMixLexicon.ETAG)) {
                        this.etagNodeTypeNames.add(name);
                        fullyDefined = false;
                    }
                    if (nodeType.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                        this.versionableNodeTypeNames.add(name);
                        fullyDefined = false;
                    }
                    for (JcrPropertyDefinition propDefn : nodeType.allPropertyDefinitions()) {
                        if (propDefn.isMandatory() && !propDefn.isProtected()) {
                            this.mandatoryPropertiesNodeTypes.put((Object)name, (Object)propDefn);
                            fullyDefined = false;
                        }
                        if (!propDefn.isAutoCreated() || propDefn.isProtected()) continue;
                        this.autoCreatedPropertiesNodeTypes.put((Object)name, (Object)propDefn);
                    }
                    for (JcrNodeDefinition childDefn : nodeType.allChildNodeDefinitions()) {
                        if (childDefn.isMandatory() && !childDefn.isProtected()) {
                            this.mandatoryChildrenNodeTypes.put((Object)name, (Object)childDefn);
                            fullyDefined = false;
                        }
                        if (!childDefn.isAutoCreated() || childDefn.isProtected()) continue;
                        this.autoCreatedChildrenNodeTypes.put((Object)name, (Object)childDefn);
                    }
                    if (!fullyDefined) continue;
                    fullyDefinedNodeTypes.add(name);
                }
                assert (ntUnstructured != null);
                Collection<JcrNodeDefinition> childDefns = ntUnstructured.allChildNodeDefinitions(JcrNodeType.RESIDUAL_NAME, true);
                assert (childDefns.size() == 1);
                this.ntUnstructuredSnsChildDefinition = childDefns.iterator().next();
                assert (this.ntUnstructuredSnsChildDefinition != null);
                childDefns = ntUnstructured.allChildNodeDefinitions(JcrNodeType.RESIDUAL_NAME, false);
                assert (childDefns.size() == 1);
                this.ntUnstructuredSingleChildDefinition = childDefns.iterator().next();
                assert (this.ntUnstructuredSingleChildDefinition != null);
            } else {
                this.ntUnstructuredSnsChildDefinition = null;
                this.ntUnstructuredSingleChildDefinition = null;
            }
            this.unmodifiableNodeTypes = Collections.unmodifiableCollection(this.nodeTypes.values());
            this.unmodifiableNodeTypeNames = Collections.unmodifiableSet(this.nodeTypes.keySet());
            this.unmodifiableMixinTypeNames = Collections.unmodifiableSet(mixinNames);
            this.unmodifiableMixinNodeTypes = Collections.unmodifiableList(mixins);
            this.unmodifiablePrimaryNodeTypes = Collections.unmodifiableList(primaries);
        }

        protected NodeTypes without(Collection<JcrNodeType> removedNodeTypes) {
            if (removedNodeTypes.isEmpty()) {
                return this;
            }
            HashSet<JcrNodeType> nodeTypes = new HashSet<JcrNodeType>(this.nodeTypes.values());
            nodeTypes.removeAll(removedNodeTypes);
            return new NodeTypes(this.context, nodeTypes, this.getVersion() + 1);
        }

        protected NodeTypes with(Collection<JcrNodeType> addedNodeTypes) {
            if (addedNodeTypes.isEmpty()) {
                return this;
            }
            HashSet<JcrNodeType> nodeTypes = new HashSet<JcrNodeType>(this.nodeTypes.values());
            nodeTypes.addAll(addedNodeTypes);
            return new NodeTypes(this.context, nodeTypes, this.getVersion() + 1);
        }

        protected final NameFactory nameFactory() {
            return this.nameFactory;
        }

        public int getVersion() {
            return this.nodeTypesVersion;
        }

        public boolean isFullyDefinedType(Name primaryTypeName, Set<Name> mixinTypeNames) {
            if (!fullyDefinedNodeTypes.contains(primaryTypeName)) {
                return false;
            }
            if (!mixinTypeNames.isEmpty()) {
                for (Name nodeTypeName : mixinTypeNames) {
                    if (fullyDefinedNodeTypes.contains(nodeTypeName)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean isCreated(Name primaryType, Set<Name> mixinTypes) {
            if (this.createdNodeTypeNames.contains(primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.createdNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
            return false;
        }

        public boolean isLastModified(Name primaryType, Set<Name> mixinTypes) {
            if (this.lastModifiedNodeTypeNames.contains(primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.lastModifiedNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
            return false;
        }

        public boolean isETag(Name primaryType, Set<Name> mixinTypes) {
            if (this.etagNodeTypeNames.contains(primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.etagNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
            return false;
        }

        public boolean isVersionable(Name primaryType, Set<Name> mixinTypes) {
            if (primaryType != null && this.versionableNodeTypeNames.contains(primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.versionableNodeTypeNames.contains(mixinType)) continue;
                return true;
            }
            return false;
        }

        public boolean hasMandatoryPropertyDefinitions(Name primaryType, Set<Name> mixinTypes) {
            if (this.mandatoryPropertiesNodeTypes.containsKey((Object)primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.mandatoryPropertiesNodeTypes.containsKey((Object)mixinType)) continue;
                return true;
            }
            return false;
        }

        public boolean hasMandatoryChildNodeDefinitions(Name primaryType, Set<Name> mixinTypes) {
            if (this.mandatoryChildrenNodeTypes.containsKey((Object)primaryType)) {
                return true;
            }
            for (Name mixinType : mixinTypes) {
                if (!this.mandatoryChildrenNodeTypes.containsKey((Object)mixinType)) continue;
                return true;
            }
            return false;
        }

        public Collection<JcrPropertyDefinition> getMandatoryPropertyDefinitions(Name primaryType, Set<Name> mixinTypes) {
            if (mixinTypes.isEmpty()) {
                return this.mandatoryPropertiesNodeTypes.get((Object)primaryType);
            }
            HashSet<JcrPropertyDefinition> defn = new HashSet<JcrPropertyDefinition>();
            defn.addAll(this.mandatoryPropertiesNodeTypes.get((Object)primaryType));
            for (Name mixinType : mixinTypes) {
                defn.addAll(this.mandatoryPropertiesNodeTypes.get((Object)mixinType));
            }
            return defn;
        }

        public Collection<JcrNodeDefinition> getMandatoryChildNodeDefinitions(Name primaryType, Set<Name> mixinTypes) {
            if (mixinTypes.isEmpty()) {
                return this.mandatoryChildrenNodeTypes.get((Object)primaryType);
            }
            HashSet<JcrNodeDefinition> defn = new HashSet<JcrNodeDefinition>();
            defn.addAll(this.mandatoryChildrenNodeTypes.get((Object)primaryType));
            for (Name mixinType : mixinTypes) {
                defn.addAll(this.mandatoryChildrenNodeTypes.get((Object)mixinType));
            }
            return defn;
        }

        public Collection<JcrPropertyDefinition> getAutoCreatedPropertyDefinitions(Name nodeType) {
            return this.autoCreatedPropertiesNodeTypes.get((Object)nodeType);
        }

        public Collection<JcrNodeDefinition> getAutoCreatedChildNodeDefinitions(Name nodeType) {
            return this.autoCreatedChildrenNodeTypes.get((Object)nodeType);
        }

        public Collection<JcrNodeType> getAllNodeTypes() {
            return this.unmodifiableNodeTypes;
        }

        public Set<Name> getAllNodeTypeNames() {
            return this.unmodifiableNodeTypeNames;
        }

        public Collection<JcrNodeType> getMixinNodeTypes() {
            return this.unmodifiableMixinNodeTypes;
        }

        public boolean isMixin(Name nodeTypeName) {
            return this.unmodifiableMixinTypeNames.contains(nodeTypeName);
        }

        public Collection<JcrNodeType> getPrimaryNodeTypes() {
            return this.unmodifiablePrimaryNodeTypes;
        }

        public JcrPropertyDefinition getPropertyDefinition(PropertyDefinitionId id) {
            return this.propertyDefinitions.get(id);
        }

        public Collection<JcrPropertyDefinition> getAllPropertyDefinitions() {
            return this.propertyDefinitions.values();
        }

        public JcrNodeDefinition getChildNodeDefinition(NodeDefinitionId id) {
            return this.childNodeDefinitions.get(id);
        }

        JcrNodeType getNodeType(Name nodeTypeName) {
            return this.nodeTypes.get(nodeTypeName);
        }

        boolean hasNodeType(Name nodeTypeName) {
            return this.nodeTypes.containsKey(nodeTypeName);
        }

        JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected) {
            return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, propertyName, value, checkMultiValuedDefinitions, skipProtected, true);
        }

        JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected, boolean checkTypeAndConstraints) {
            int type;
            boolean setToEmpty = value == null;
            boolean matchedOnName = false;
            JcrNodeType primaryType = this.getNodeType(primaryTypeName);
            if (primaryType != null) {
                int type2;
                for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (value != null);
                    type2 = definition.getRequiredType();
                    if (type2 == 9 && type2 == value.getType()) {
                        return definition;
                    }
                    if (type2 == 10 && type2 == value.getType()) {
                        return definition;
                    }
                    if (type2 != 0 && type2 != value.getType()) continue;
                    if (!checkTypeAndConstraints) {
                        return definition;
                    }
                    if (!definition.satisfiesConstraints(value, session)) continue;
                    return definition;
                }
                if (matchedOnName) {
                    if (value != null) {
                        for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            type2 = definition.getRequiredType();
                            if (type2 == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type2 == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                    if (checkMultiValuedDefinitions) {
                        for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            if (setToEmpty) {
                                if (definition.isMandatory()) continue;
                                return definition;
                            }
                            assert (value != null);
                            type2 = definition.getRequiredType();
                            if (type2 == 9 && type2 == value.getType()) {
                                return definition;
                            }
                            if (type2 == 10 && type2 == value.getType()) {
                                return definition;
                            }
                            if (type2 != 0 && type2 != value.getType()) continue;
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.satisfiesConstraints(value, session)) continue;
                            return definition;
                        }
                        if (value != null) {
                            for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                                if (skipProtected && definition.isProtected()) {
                                    return null;
                                }
                                assert (definition.getRequiredType() != 0);
                                type2 = definition.getRequiredType();
                                if (type2 == 9 && definition.canCastToType(value)) {
                                    return definition;
                                }
                                if (type2 == 10 && definition.canCastToType(value)) {
                                    return definition;
                                }
                                if (!checkTypeAndConstraints) {
                                    return definition;
                                }
                                if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                                return definition;
                            }
                        }
                    }
                    return null;
                }
            }
            LinkedList<JcrNodeType> mixinTypes = null;
            if (mixinTypeNames != null) {
                mixinTypes = new LinkedList<JcrNodeType>();
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    mixinTypes.add(mixinType);
                    for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type = definition.getRequiredType();
                        if (type == 9 && type == value.getType()) {
                            return definition;
                        }
                        if (type == 10 && type == value.getType()) {
                            return definition;
                        }
                        if (type != 0 && type != value.getType()) continue;
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(value, session)) continue;
                        return definition;
                    }
                    if (!matchedOnName) continue;
                    if (value != null) {
                        for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type = definition.getRequiredType();
                            if (type == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                    if (checkMultiValuedDefinitions) {
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            if (setToEmpty) {
                                if (definition.isMandatory()) continue;
                                return definition;
                            }
                            assert (value != null);
                            type = definition.getRequiredType();
                            if (type == 9 && type == value.getType()) {
                                return definition;
                            }
                            if (type == 10 && type == value.getType()) {
                                return definition;
                            }
                            if (type != 0 && type != value.getType()) continue;
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.satisfiesConstraints(value, session)) continue;
                            return definition;
                        }
                        if (value != null) {
                            for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                                matchedOnName = true;
                                if (skipProtected && definition.isProtected()) {
                                    return null;
                                }
                                assert (definition.getRequiredType() != 0);
                                type = definition.getRequiredType();
                                if (type == 9 && definition.canCastToType(value)) {
                                    return definition;
                                }
                                if (type == 10 && definition.canCastToType(value)) {
                                    return definition;
                                }
                                if (!checkTypeAndConstraints) {
                                    return definition;
                                }
                                if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                                return definition;
                            }
                        }
                    }
                    return null;
                }
            }
            if (checkMultiValuedDefinitions) {
                if (primaryType != null) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        int type3 = definition.getRequiredType();
                        if (type3 == 9 && type3 == value.getType()) {
                            return definition;
                        }
                        if (type3 == 10 && type3 == value.getType()) {
                            return definition;
                        }
                        if (type3 != 0 && type3 != value.getType()) continue;
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(value, session)) continue;
                        return definition;
                    }
                    if (value != null) {
                        for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                            matchedOnName = true;
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            int type4 = definition.getRequiredType();
                            if (type4 == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type4 == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                }
                if (matchedOnName) {
                    return null;
                }
                if (mixinTypeNames != null) {
                    mixinTypes = new LinkedList();
                    for (Name mixinTypeName : mixinTypeNames) {
                        JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                        if (mixinType == null) continue;
                        mixinTypes.add(mixinType);
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            matchedOnName = true;
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            if (setToEmpty) {
                                if (definition.isMandatory()) continue;
                                return definition;
                            }
                            assert (value != null);
                            type = definition.getRequiredType();
                            if (type == 9 && type == value.getType()) {
                                return definition;
                            }
                            if (type == 10 && type == value.getType()) {
                                return definition;
                            }
                            if (type != 0 && type != value.getType()) continue;
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.satisfiesConstraints(value, session)) continue;
                            return definition;
                        }
                        if (value == null) continue;
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            matchedOnName = true;
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type = definition.getRequiredType();
                            if (type == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (type == 10 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value, session)) continue;
                            return definition;
                        }
                    }
                }
                if (matchedOnName) {
                    return null;
                }
            }
            if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, value, checkMultiValuedDefinitions, skipProtected, checkTypeAndConstraints);
            }
            return null;
        }

        JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected) {
            return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, propertyName, values, skipProtected, true);
        }

        JcrPropertyDefinition findPropertyDefinition(JcrSession session, Name primaryTypeName, Collection<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected, boolean checkTypeAndConstraints) {
            boolean setToEmpty = values == null;
            int propertyType = values == null || values.length == 0 ? 1 : values[0].getType();
            boolean matchedOnName = false;
            JcrNodeType primaryType = this.getNodeType(primaryTypeName);
            if (primaryType != null) {
                for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (values != null);
                    int type = definition.getRequiredType();
                    boolean typeMatches = values.length == 0 || type == 0 || type == propertyType;
                    if (!typeMatches) continue;
                    if (type == 9) {
                        return definition;
                    }
                    if (type == 10) {
                        return definition;
                    }
                    if (!checkTypeAndConstraints) {
                        return definition;
                    }
                    if (!definition.satisfiesConstraints(values, session)) continue;
                    return definition;
                }
                if (matchedOnName) {
                    if (values != null && values.length != 0) {
                        for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                                return definition;
                            }
                            if (definition.getRequiredType() == 10 && definition.canCastToType(values)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(values, session)) continue;
                            return definition;
                        }
                    }
                    return null;
                }
            }
            LinkedList<JcrNodeType> mixinTypes = null;
            if (mixinTypeNames != null) {
                mixinTypes = new LinkedList<JcrNodeType>();
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    mixinTypes.add(mixinType);
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (values != null);
                        int type = definition.getRequiredType();
                        boolean typeMatches = values.length == 0 || type == 0 || type == propertyType;
                        if (!typeMatches) continue;
                        if (type == 9) {
                            return definition;
                        }
                        if (type == 10) {
                            return definition;
                        }
                        if (!checkTypeAndConstraints) {
                            return definition;
                        }
                        if (!definition.satisfiesConstraints(values, session)) continue;
                        return definition;
                    }
                    if (!matchedOnName) continue;
                    if (values != null && values.length != 0) {
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                                return definition;
                            }
                            if (definition.getRequiredType() == 10 && definition.canCastToType(values)) {
                                return definition;
                            }
                            if (!checkTypeAndConstraints) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(values, session)) continue;
                            return definition;
                        }
                    }
                    return null;
                }
            }
            if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.findPropertyDefinition(session, primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, values, skipProtected, checkTypeAndConstraints);
            }
            return null;
        }

        private List<JcrPropertyDefinition> findPropertyDefinitions(List<Name> typeNamesToCheck, Name propertyName, PropertyCardinality typeToCheck, List<JcrNodeType> pendingTypes) {
            assert (typeNamesToCheck != null);
            Collection<JcrPropertyDefinition> propDefs = null;
            ArrayList<JcrPropertyDefinition> matchingDefs = new ArrayList<JcrPropertyDefinition>();
            for (Name typeNameToCheck : typeNamesToCheck) {
                JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
                if (typeName == null) continue;
                switch (typeToCheck) {
                    case SINGLE_VALUED_ONLY: {
                        propDefs = typeName.allSingleValuePropertyDefinitions(propertyName);
                        break;
                    }
                    case MULTI_VALUED_ONLY: {
                        propDefs = typeName.allMultiValuePropertyDefinitions(propertyName);
                        break;
                    }
                    case ANY: {
                        propDefs = typeName.allPropertyDefinitions(propertyName);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Should be unreachable: " + (Object)((Object)typeToCheck));
                    }
                }
                if (propDefs.isEmpty()) continue;
                matchingDefs.addAll(propDefs);
            }
            return matchingDefs;
        }

        boolean canRemoveProperty(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name propertyName, boolean skipProtected) {
            JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
            if (primaryType != null) {
                for (JcrPropertyDefinition definition : primaryType.allPropertyDefinitions(propertyName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
            if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
                for (Name mixinTypeName : mixinTypeNamesOfParent) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    for (JcrPropertyDefinition definition : mixinType.allPropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) continue;
                        return !definition.isMandatory();
                    }
                }
            }
            if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.canRemoveProperty(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
            }
            return false;
        }

        boolean canRemoveItem(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name itemName, boolean skipProtected) {
            JcrNodeType mixinType;
            JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
            if (primaryType != null) {
                for (JcrPropertyDefinition jcrPropertyDefinition : primaryType.allPropertyDefinitions(itemName)) {
                    if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                    return !jcrPropertyDefinition.isMandatory();
                }
            }
            if (primaryType != null) {
                for (JcrNodeDefinition jcrNodeDefinition : primaryType.allChildNodeDefinitions(itemName)) {
                    if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                    return !jcrNodeDefinition.isMandatory();
                }
            }
            if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
                for (Name name : mixinTypeNamesOfParent) {
                    mixinType = this.getNodeType(name);
                    if (mixinType == null) continue;
                    for (JcrPropertyDefinition jcrPropertyDefinition : mixinType.allPropertyDefinitions(itemName)) {
                        if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                        return !jcrPropertyDefinition.isMandatory();
                    }
                }
            }
            if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
                for (Name name : mixinTypeNamesOfParent) {
                    mixinType = this.getNodeType(name);
                    if (mixinType == null) continue;
                    for (JcrNodeDefinition jcrNodeDefinition : mixinType.allChildNodeDefinitions(itemName)) {
                        if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                        return !jcrNodeDefinition.isMandatory();
                    }
                }
            }
            if (!itemName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.canRemoveItem(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
            }
            return false;
        }

        protected final JcrNodeDefinition findChildNodeDefinitionForUnstructured(boolean requireSns) {
            return requireSns ? this.ntUnstructuredSnsChildDefinition : this.ntUnstructuredSingleChildDefinition;
        }

        JcrNodeDefinition findChildNodeDefinition(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, Name childPrimaryNodeType, int numberOfExistingChildrenWithSameName, boolean skipProtected) {
            boolean requireSns;
            JcrNodeType childType = childPrimaryNodeType != null ? this.getNodeType(childPrimaryNodeType) : null;
            boolean bl = requireSns = numberOfExistingChildrenWithSameName > 1;
            if ((mixinTypeNamesOfParent == null || mixinTypeNamesOfParent.isEmpty()) && JcrNtLexicon.UNSTRUCTURED.equals(primaryTypeNameOfParent)) {
                return this.findChildNodeDefinitionForUnstructured(requireSns);
            }
            JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
            if (primaryType != null) {
                for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName, requireSns)) {
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (!definition.allowsChildWithType(childType)) continue;
                    return definition;
                }
            }
            if (mixinTypeNamesOfParent != null) {
                for (Name mixinTypeName : mixinTypeNamesOfParent) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName, requireSns)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (!definition.allowsChildWithType(childType)) continue;
                        return definition;
                    }
                }
            }
            if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.findChildNodeDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, childPrimaryNodeType, numberOfExistingChildrenWithSameName, skipProtected);
            }
            return null;
        }

        private List<JcrNodeDefinition> findChildNodeDefinitions(List<Name> typeNamesToCheck, Name childNodeName, NodeCardinality typesToCheck, List<JcrNodeType> pendingTypes) {
            assert (typeNamesToCheck != null);
            Collection<JcrNodeDefinition> nodeDefs = null;
            ArrayList<JcrNodeDefinition> matchingDefs = new ArrayList<JcrNodeDefinition>();
            for (Name typeNameToCheck : typeNamesToCheck) {
                JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
                if (typeName == null) continue;
                switch (typesToCheck) {
                    case NO_SAME_NAME_SIBLINGS: {
                        nodeDefs = typeName.allChildNodeDefinitions(childNodeName, false);
                        break;
                    }
                    case SAME_NAME_SIBLINGS: {
                        nodeDefs = typeName.allChildNodeDefinitions(childNodeName, true);
                        break;
                    }
                    case ANY: {
                        nodeDefs = typeName.allChildNodeDefinitions(childNodeName);
                    }
                }
                assert (nodeDefs != null);
                for (JcrNodeDefinition definition : nodeDefs) {
                    if (NodeCardinality.NO_SAME_NAME_SIBLINGS == typesToCheck && definition.allowsSameNameSiblings()) continue;
                    matchingDefs.add(definition);
                }
            }
            return matchingDefs;
        }

        boolean canRemoveAllChildren(Name primaryTypeNameOfParent, Collection<Name> mixinTypeNamesOfParent, Name childName, boolean skipProtected) {
            JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
            if (primaryType != null) {
                for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
            if (mixinTypeNamesOfParent != null) {
                for (Name mixinTypeName : mixinTypeNamesOfParent) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName)) {
                        if (skipProtected && definition.isProtected()) continue;
                        return !definition.isMandatory();
                    }
                }
            }
            if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
                return this.canRemoveAllChildren(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
            }
            return false;
        }

        protected JcrNodeType findTypeInMapOrList(Name typeName, Collection<JcrNodeType> pendingList) {
            for (JcrNodeType pendingNodeType : pendingList) {
                if (!pendingNodeType.getInternalName().equals(typeName)) continue;
                return pendingNodeType;
            }
            return this.nodeTypes.get(typeName);
        }

        protected List<JcrNodeType> supertypesFor(NodeTypeDefinition nodeType, Collection<JcrNodeType> pendingTypes) throws RepositoryException {
            Name nodeName;
            assert (nodeType != null);
            LinkedList<JcrNodeType> supertypes = new LinkedList<JcrNodeType>();
            boolean isMixin = nodeType.isMixin();
            boolean needsPrimaryAncestor = !isMixin;
            String nodeTypeName = nodeType.getName();
            for (String supertypeNameStr : nodeType.getDeclaredSupertypeNames()) {
                Name supertypeName = (Name)this.nameFactory.create(supertypeNameStr);
                JcrNodeType supertype = this.findTypeInMapOrList(supertypeName, pendingTypes);
                if (supertype == null) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidSupertypeName.text(new Object[]{supertypeNameStr, nodeTypeName}));
                }
                needsPrimaryAncestor &= supertype.isMixin();
                supertypes.add(supertype);
            }
            if (needsPrimaryAncestor && !JcrNtLexicon.BASE.equals(nodeName = (Name)this.nameFactory.create(nodeTypeName))) {
                JcrNodeType ntBase = this.findTypeInMapOrList(JcrNtLexicon.BASE, pendingTypes);
                assert (ntBase != null);
                supertypes.add(0, ntBase);
            }
            return supertypes;
        }

        final Collection<JcrNodeType> subtypesFor(JcrNodeType nodeType) {
            LinkedList<JcrNodeType> subtypes = new LinkedList<JcrNodeType>();
            for (JcrNodeType type : this.nodeTypes.values()) {
                if (!type.supertypes().contains(nodeType)) continue;
                subtypes.add(type);
            }
            return subtypes;
        }

        final Collection<JcrNodeType> declaredSubtypesFor(JcrNodeType nodeType) {
            CheckArg.isNotNull((Object)nodeType, (String)"nodeType");
            String nodeTypeName = nodeType.getName();
            LinkedList<JcrNodeType> subtypes = new LinkedList<JcrNodeType>();
            for (JcrNodeType type : this.nodeTypes.values()) {
                if (!Arrays.asList(type.getDeclaredSupertypeNames()).contains(nodeTypeName)) continue;
                subtypes.add(type);
            }
            return subtypes;
        }

        private void validate(List<JcrNodeType> supertypes, String nodeName) throws RepositoryException {
            assert (supertypes != null);
            HashMap<PropertyDefinitionId, JcrPropertyDefinition> props = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
            for (JcrNodeType supertype : supertypes) {
                for (JcrPropertyDefinition property : supertype.propertyDefinitions()) {
                    String propTypeName;
                    String oldPropTypeName;
                    JcrPropertyDefinition oldProp = props.put(new PropertyDefinitionId(property.getInternalName(), property.getInternalName(), 0, property.isMultiple()), property);
                    if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldPropTypeName, propTypeName, "property", property.getName()}));
                }
            }
            HashMap<NodeDefinitionId, JcrNodeDefinition> childNodes = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
            for (JcrNodeType supertype : supertypes) {
                for (JcrNodeDefinition childNode : supertype.childNodeDefinitions()) {
                    String childNodeTypeName;
                    String oldNodeTypeName;
                    JcrNodeDefinition oldNode = childNodes.put(new NodeDefinitionId(childNode.getInternalName(), childNode.getInternalName(), new Name[0]), childNode);
                    if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldNodeTypeName, childNodeTypeName, "child node", childNode.getName()}));
                }
            }
        }

        protected void validate(JcrNodeType nodeType, List<JcrNodeType> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
            Name nodeTypeName = nodeType.getInternalName();
            this.validate(supertypes, nodeTypeName.getString(this.context.getNamespaceRegistry()));
            ArrayList<Name> supertypeNames = new ArrayList<Name>(supertypes.size());
            for (JcrNodeType supertype : supertypes) {
                supertypeNames.add(supertype.getInternalName());
            }
            boolean foundExact = false;
            boolean foundResidual = false;
            Name primaryItemName = nodeType.getInternalPrimaryItemName();
            for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
                this.validate(jcrNodeDefinition, supertypeNames, pendingTypes);
                if (jcrNodeDefinition.isResidual()) {
                    foundResidual = true;
                }
                if (primaryItemName == null || !primaryItemName.equals(jcrNodeDefinition.getInternalName())) continue;
                foundExact = true;
            }
            for (JcrItemDefinition jcrItemDefinition : nodeType.getDeclaredPropertyDefinitions()) {
                this.validate((JcrPropertyDefinition)jcrItemDefinition, supertypeNames, pendingTypes);
                if (jcrItemDefinition.isResidual()) {
                    foundResidual = true;
                }
                if (primaryItemName == null || !primaryItemName.equals(jcrItemDefinition.getInternalName())) continue;
                if (foundExact) {
                    throw new RepositoryException(JcrI18n.ambiguousPrimaryItemName.text(new Object[]{primaryItemName}));
                }
                foundExact = true;
            }
            if (primaryItemName != null && !foundExact && !foundResidual) {
                throw new RepositoryException(JcrI18n.invalidPrimaryItemName.text(new Object[]{primaryItemName}));
            }
        }

        private void validate(JcrNodeDefinition node, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
            if (node.isAutoCreated() && !node.isProtected() && node.defaultPrimaryTypeName() == null) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedNodesNeedDefaults.text(new Object[]{node.getName()}));
            }
            boolean residual = "*".equals(node.getName());
            if (node.isMandatory() && residual) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.residualNodeDefinitionsCannotBeMandatory.text(new Object[]{node.getName()}));
            }
            if (node.isAutoCreated() && residual) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.residualNodeDefinitionsCannotBeAutoCreated.text(new Object[]{node.getName()}));
            }
            Name nodeName = (Name)this.context.getValueFactories().getNameFactory().create(node.getName());
            nodeName = nodeName == null ? JcrNodeType.RESIDUAL_NAME : nodeName;
            List<JcrNodeDefinition> ancestors = this.findChildNodeDefinitions(supertypes, nodeName, NodeCardinality.ANY, pendingTypes);
            for (JcrNodeDefinition ancestor : ancestors) {
                if (ancestor.isProtected()) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "child node"}));
                }
                if (ancestor.isMandatory() && !node.isMandatory()) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "child node"}));
                }
                Name[] requiredPrimaryTypeNames = ancestor.requiredPrimaryTypeNames();
                for (int i = 0; i < requiredPrimaryTypeNames.length; ++i) {
                    JcrNodeType apt = this.findTypeInMapOrList(requiredPrimaryTypeNames[i], pendingTypes);
                    if (apt == null) {
                        I18n msg = JcrI18n.couldNotFindDefinitionOfRequiredPrimaryType;
                        throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{requiredPrimaryTypeNames[i], node.getName(), node.getDeclaringNodeType()}));
                    }
                    boolean found = false;
                    for (Name name : node.requiredPrimaryTypeNames()) {
                        JcrNodeType npt = this.findTypeInMapOrList(name, pendingTypes);
                        if (!npt.isNodeType(apt.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found || JcrNodeType.RESIDUAL_NAME.equals(node.name)) continue;
                    I18n msg = JcrI18n.cannotRedefineChildNodeWithIncompatibleDefinition;
                    throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{nodeName, apt.getName(), node.getDeclaringNodeType()}));
                }
            }
        }

        private void validate(JcrPropertyDefinition prop, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
            assert (prop != null);
            assert (supertypes != null);
            assert (pendingTypes != null);
            boolean residual = "*".equals(prop.getName());
            if (prop.isMandatory() && !prop.isProtected() && residual) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.residualPropertyDefinitionsCannotBeMandatory.text(new Object[]{prop.getName()}));
            }
            if (prop.isAutoCreated() && residual) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.residualPropertyDefinitionsCannotBeAutoCreated.text(new Object[]{prop.getName()}));
            }
            JcrValue[] defaultValues = prop.getDefaultValues();
            if (prop.isAutoCreated() && !prop.isProtected() && (defaultValues == null || defaultValues.length == 0)) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedPropertyNeedsDefault.text(new Object[]{prop.getName(), prop.getDeclaringNodeType().getName()}));
            }
            if (!prop.isMultiple() && defaultValues != null && defaultValues.length > 1) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.singleValuedPropertyNeedsSingleValuedDefault.text(new Object[]{prop.getName(), prop.getDeclaringNodeType().getName()}));
            }
            Name propName = (Name)this.context.getValueFactories().getNameFactory().create(prop.getName());
            propName = propName == null ? JcrNodeType.RESIDUAL_NAME : propName;
            List<JcrPropertyDefinition> ancestors = this.findPropertyDefinitions(supertypes, propName, prop.isMultiple() ? PropertyCardinality.MULTI_VALUED_ONLY : PropertyCardinality.SINGLE_VALUED_ONLY, pendingTypes);
            for (JcrPropertyDefinition ancestor : ancestors) {
                if (ancestor.isProtected()) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "property"}));
                }
                if (ancestor.isMandatory() && !prop.isMandatory()) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "property"}));
                }
                if (ancestor.getValueConstraints() != null && !Arrays.equals(ancestor.getValueConstraints(), prop.getValueConstraints())) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.constraintsChangedInSubtype.text(new Object[]{propName, ancestor.getDeclaringNodeType().getName()}));
                }
                if (this.isAlwaysSafeConversion(prop.getRequiredType(), ancestor.getRequiredType())) continue;
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotRedefineProperty.text(new Object[]{propName, PropertyType.nameFromValue((int)prop.getRequiredType()), ancestor.getDeclaringNodeType().getName(), PropertyType.nameFromValue((int)ancestor.getRequiredType())}));
            }
        }

        private boolean isAlwaysSafeConversion(int fromType, int toType) {
            if (fromType == toType) {
                return true;
            }
            switch (toType) {
                case 6: {
                    return fromType == 2 || fromType == 1;
                }
                case 5: {
                    return fromType == 4 || fromType == 3;
                }
                case 4: {
                    return fromType == 3;
                }
                case 3: {
                    return fromType == 4;
                }
                case 8: {
                    return fromType == 7;
                }
                case 7: 
                case 9: 
                case 10: {
                    return false;
                }
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            throw new IllegalStateException("Unexpected state: " + toType);
        }

        public String toString() {
            return this.getAllNodeTypes().toString();
        }
    }

    private static enum NodeCardinality {
        NO_SAME_NAME_SIBLINGS,
        SAME_NAME_SIBLINGS,
        ANY;

    }

    private static enum PropertyCardinality {
        SINGLE_VALUED_ONLY,
        MULTI_VALUED_ONLY,
        ANY;

    }
}

