/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class Database {
    private Connection connection;

    public Database(Connection connection) {
        this.connection = connection;
    }

    private long now() {
        return new Date().getTime();
    }

    public PreparedStatement insertContentSQL(BinaryKey key, InputStream stream) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("insert into content_store(cid, usage_time, payload, usage) values(?,?,?,1)");
            sql.setString(1, key.toString());
            sql.setTimestamp(2, new Timestamp(this.now()));
            sql.setBinaryStream(3, stream);
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveContentSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("select payload from content_store where cid =?");
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement markUnusedSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("update content_store set usage=0, timestamp=? where cid =?");
            sql.setTimestamp(1, new Timestamp(this.now()));
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement removeExpiredContentSQL(long deadline) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("delete from content_store where usage_time < ?");
            sql.setTimestamp(1, new Timestamp(deadline));
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveMimeTypeSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("select mime_type from content_store where cid = ?");
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateMimeTypeSQL(BinaryKey key, String mimeType) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("update content_store set mime_type= ? where cid = ?");
            sql.setString(1, mimeType);
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveExtTextSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("select ext_text from content_store where cid = ?");
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateExtTextSQL(BinaryKey key, String text) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("update content_store set ext_text= ? where cid = ?");
            sql.setString(1, text);
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static void execute(PreparedStatement sql) throws BinaryStoreException {
        try {
            sql.execute();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static ResultSet executeQuery(PreparedStatement sql) throws BinaryStoreException {
        try {
            return sql.executeQuery();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static void executeUpdate(PreparedStatement sql) throws BinaryStoreException {
        try {
            sql.executeUpdate();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static InputStream asStream(ResultSet rs) throws BinaryStoreException {
        try {
            boolean hasRaw = rs.first();
            if (!hasRaw) {
                return null;
            }
            return rs.getBinaryStream(1);
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static String asString(ResultSet rs) throws BinaryStoreException {
        try {
            boolean hasRaw = rs.first();
            if (!hasRaw) {
                throw new BinaryStoreException("The content has been deleted");
            }
            return rs.getString(1);
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public boolean tableExists() throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("select * from content_store");
            Database.execute(sql);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void createTable() throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("create table content_store (cid varchar(255) not null,mime_type varchar(255),ext_text varchar(1000),usage integer,usage_time timestamp,payload " + this.blobType(this.connection, 0) + "," + "primary key(cid))");
            Database.execute(sql);
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
    }

    protected String blobType(Connection connection, int size) throws BinaryStoreException {
        try {
            String name = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (name.toLowerCase().contains("mysql")) {
                return String.format("LONGBLOB", size);
            }
            if (name.contains("postgres")) {
                return "oid";
            }
            if (name.contains("derby")) {
                return String.format("blolb", size);
            }
            if (!name.contains("hsql") && !name.toLowerCase().contains("hypersonic")) {
                if (name.contains("h2")) {
                    return "blob";
                }
                if (name.contains("sqlite")) {
                    return "blob";
                }
                if (name.contains("db2")) {
                    return "blob";
                }
                if (name.contains("informix")) {
                    return "blob";
                }
                if (name.contains("interbase")) {
                    return "blob subtype 0";
                }
                if (name.contains("firebird")) {
                    return "blob subtype 0";
                }
                if (name.contains("sqlserver") || name.toLowerCase().contains("microsoft")) {
                    return "blob";
                }
                if (!name.contains("access")) {
                    if (name.contains("oracle")) {
                        return "blob";
                    }
                    if (name.contains("adaptive")) {
                        // empty if block
                    }
                }
            }
            return "";
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }
}

