/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.schematic.document.ParsingException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.RepositoryFactory;

@ThreadSafe
public class JcrRepositoryFactory
implements RepositoryFactory {
    private static final Logger LOG = Logger.getLogger(JcrRepositoryFactory.class);
    private static final ModeShapeEngine ENGINE = new ModeShapeEngine();
    @Deprecated
    public static final String URL = "org.modeshape.jcr.URL";
    public static final String REPOSITORY_NAME_PARAM = "repositoryName";

    public static Future<Boolean> shutdownAll() {
        return ENGINE.shutdown();
    }

    public Repository getRepository(Map parameters) {
        LOG.debug("Trying to load ModeShape JCR Repository with parameters: " + parameters, new Object[0]);
        if (parameters == null) {
            return null;
        }
        Object rawUrl = parameters.get(URL);
        if (rawUrl == null) {
            LOG.debug("No parameter found with key: org.modeshape.jcr.URL", new Object[0]);
            return null;
        }
        URL url = null;
        url = rawUrl instanceof URL ? (URL)rawUrl : this.urlFor(rawUrl.toString(), null);
        if (url == null) {
            return null;
        }
        String repositoryName = this.getRepositoryNameFrom(url, parameters);
        return this.getRepository(url, repositoryName, parameters);
    }

    protected Repository getRepository(URL url, String repositoryName, Map<String, Object> parameters) {
        if ("jndi".equals(url.getProtocol())) {
            Repository repository = this.getRepositoryFromJndi(url.getPath(), repositoryName, parameters);
            if (repository != null) {
                return repository;
            }
        } else {
            JcrRepository repo = this.getRepositoryFromConfigFile(url);
            if (repositoryName == null || repo.getName().equals(repositoryName)) {
                return repo;
            }
        }
        LOG.debug("Could not load or find a ModeShape repository named '{0}' using the URL '{1}' and params: {2}", new Object[]{repositoryName, url, parameters});
        return null;
    }

    private ModeShapeEngine getEngine() {
        switch (ENGINE.getState()) {
            case NOT_RUNNING: {
                ENGINE.start();
                break;
            }
            case STOPPING: {
                try {
                    ENGINE.shutdown().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
                break;
            }
        }
        return ENGINE;
    }

    protected String getRepositoryNameFrom(URL url, Map<String, Object> parameters) {
        Object repoName = parameters.get("org.modeshape.jcr.RepositoryName");
        if (repoName != null) {
            return repoName.toString();
        }
        String query = url.getQuery();
        if (query != null) {
            for (String keyValuePair : query.split("&")) {
                String[] splitPair = keyValuePair.split("=");
                if (splitPair.length != 2 || !REPOSITORY_NAME_PARAM.equals(splitPair[0])) continue;
                return splitPair[1];
            }
        }
        return null;
    }

    private JcrRepository getRepositoryFromConfigFile(URL configUrl) {
        assert (configUrl != null);
        try {
            if ("file".equals(configUrl.getProtocol())) {
                try {
                    configUrl = new URL(configUrl.getProtocol(), configUrl.getHost(), configUrl.getPort(), configUrl.getPath());
                }
                catch (MalformedURLException mfe) {
                    throw new IllegalStateException(mfe);
                }
            }
            String configKey = configUrl.toString();
            ModeShapeEngine engine = this.getEngine();
            if (engine.getRepositoryKeys().contains(configKey)) {
                try {
                    return engine.getRepository(configKey);
                }
                catch (NoSuchRepositoryException e) {
                    // empty catch block
                }
            }
            RepositoryConfiguration config = null;
            if ("file".equals(configUrl.getProtocol())) {
                try {
                    config = RepositoryConfiguration.read(configUrl);
                }
                catch (ParsingException e) {
                    try {
                        String path = this.classpathResource(configUrl);
                        if (path.length() == 0) {
                            throw e;
                        }
                        config = RepositoryConfiguration.read(path);
                    }
                    catch (Throwable t) {
                        throw e;
                    }
                }
            } else if ("classpath".equals(configUrl.getProtocol())) {
                String path = this.classpathResource(configUrl);
                config = RepositoryConfiguration.read(path);
            } else {
                config = RepositoryConfiguration.read(configUrl);
            }
            String configName = config.getName();
            if (engine.getRepositoryNames().contains(configName)) {
                try {
                    return engine.getRepository(configName);
                }
                catch (NoSuchRepositoryException e) {
                    // empty catch block
                }
            }
            JcrRepository repository = engine.deploy(config);
            repository.start();
            return repository;
        }
        catch (RepositoryException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
        catch (IOException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
        catch (NamingException err) {
            LOG.debug((Throwable)err, "Unable to start repository for configuration file at '{0}': {1}", new Object[]{configUrl, err.getMessage()});
            return null;
        }
    }

    private String classpathResource(URL url) {
        String path = url.getPath();
        while (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        return path.length() != 0 ? path : null;
    }

    private Hashtable<String, String> hashtable(Map<String, Object> map) {
        assert (map != null);
        Hashtable<String, String> hash = new Hashtable<String, String>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            hash.put(entry.getKey(), value != null ? value.toString() : null);
        }
        return hash;
    }

    private Repository getRepositoryFromJndi(String jndiName, String repositoryName, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        try {
            InitialContext ic = new InitialContext(this.hashtable(parameters));
            Object ob = ic.lookup(jndiName);
            if (ob instanceof ModeShapeEngine) {
                ModeShapeEngine engine = (ModeShapeEngine)ob;
                switch (engine.getState()) {
                    case NOT_RUNNING: 
                    case STOPPING: {
                        LOG.error((I18nResource)JcrI18n.engineAtJndiLocationIsNotRunning, new Object[]{jndiName});
                        return null;
                    }
                }
                if (repositoryName == null && engine.getRepositories().size() == 1) {
                    repositoryName = engine.getRepositories().keySet().iterator().next();
                }
                if (repositoryName != null && (repositoryName = repositoryName.trim()).length() != 0) {
                    try {
                        JcrRepository repository = engine.getRepository(repositoryName);
                        switch (repository.getState()) {
                            case RUNNING: 
                            case STARTING: {
                                return repository;
                            }
                        }
                        LOG.error((I18nResource)JcrI18n.repositoryIsNotRunningOrHasBeenShutDownInEngineAtJndiLocation, new Object[]{repositoryName, jndiName});
                        return null;
                    }
                    catch (NoSuchRepositoryException e) {
                        LOG.warn((I18nResource)JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repositoryName, jndiName});
                        return null;
                    }
                }
            } else if (ob instanceof Repositories) {
                Repositories repos = (Repositories)ob;
                try {
                    return repos.getRepository(repositoryName);
                }
                catch (RepositoryException e) {
                    LOG.warn((I18nResource)JcrI18n.repositoryNotFoundInEngineAtJndiLocation, new Object[]{repositoryName, jndiName});
                }
            } else if (ob instanceof Repository) {
                return (Repository)ob;
            }
            return null;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public Future<Boolean> shutdown() {
        return ENGINE.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return ENGINE.shutdown().get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownJcrRepositoryFactory, new Object[0]);
            return false;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Repository getRepository(String jcrUrl, String repositoryName) throws RepositoryException {
        URL url = this.urlFor(jcrUrl, repositoryName);
        if (url == null) {
            return null;
        }
        return this.getRepository(url, repositoryName, null);
    }

    public Repository getRepository(String repositoryName) throws RepositoryException {
        return this.getEngine().getRepository(repositoryName);
    }

    public Set<String> getRepositoryNames() {
        return this.getEngine().getRepositoryNames();
    }

    private URL urlFor(String jcrUrl, String repoName) {
        if (jcrUrl == null || jcrUrl.isEmpty()) {
            throw new IllegalStateException(JcrI18n.invalidJcrUrl.text(new Object[]{jcrUrl}));
        }
        try {
            if (repoName != null) {
                repoName = repoName.trim();
                String queryParam = "?repositoryName=";
                if (repoName.length() != 0 && !jcrUrl.contains(queryParam)) {
                    jcrUrl = jcrUrl + queryParam + repoName;
                }
            }
            return new URL(jcrUrl.toString());
        }
        catch (MalformedURLException mue) {
            LOG.debug("Could not parse URL: " + mue.getMessage(), new Object[0]);
            return null;
        }
    }

    static {
        ENGINE.start();
    }
}

