/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.SecureHash;
import org.modeshape.common.util.StringUtil;

@Immutable
public class BinaryKey
implements Serializable,
Comparable<BinaryKey> {
    private static final long serialVersionUID = 1L;
    private final String key;

    public static BinaryKey keyFor(byte[] content) {
        try {
            byte[] hash = SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])content);
            return new BinaryKey(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public BinaryKey(String key) {
        assert (key != null);
        assert (key.length() > 0);
        this.key = key;
    }

    public BinaryKey(byte[] hash) {
        this(StringUtil.getHexString((byte[])hash));
    }

    public byte[] toBytes() {
        return StringUtil.fromHexString((String)this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BinaryKey) {
            BinaryKey that = (BinaryKey)obj;
            return this.key.equals(that.key);
        }
        return false;
    }

    @Override
    public int compareTo(BinaryKey other) {
        if (other == this) {
            return 0;
        }
        return this.key.compareTo(other.key);
    }

    public String toString() {
        return this.key;
    }
}

