/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.value.binary.infinispan.RetryOperation;

class ChunkOutputStream
extends OutputStream {
    protected final Logger logger = Logger.getLogger(this.getClass());
    public static final int CHUNKSIZE = 0x100000;
    protected final Cache<String, byte[]> blobCache;
    protected final String keyPrefix;
    private ByteArrayOutputStream chunkBuffer;
    private boolean closed;
    protected int chunkIndex;

    public ChunkOutputStream(Cache<String, byte[]> blobCache, String keyPrefix) {
        this.blobCache = blobCache;
        this.keyPrefix = keyPrefix;
        this.chunkBuffer = new ByteArrayOutputStream(1024);
    }

    public int getNumberChunks() {
        return this.chunkIndex;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.chunkBuffer.size() == 0x100000) {
            this.storeBufferInBLOBCache();
        }
        this.chunkBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len + this.chunkBuffer.size() <= 0x100000) {
            this.chunkBuffer.write(b, off, len);
        } else {
            int storeLength = 0x100000 - this.chunkBuffer.size();
            this.write(b, off, storeLength);
            this.storeBufferInBLOBCache();
            this.write(b, off + storeLength, len - storeLength);
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("Close. Buffer size at close: {0}", new Object[]{this.chunkBuffer.size()});
        if (this.closed) {
            this.logger.debug("Stream already closed.", new Object[0]);
            return;
        }
        this.closed = true;
        if (this.chunkBuffer.size() > 0) {
            this.storeBufferInBLOBCache();
        }
    }

    private void storeBufferInBLOBCache() throws IOException {
        final byte[] chunk = this.chunkBuffer.toByteArray();
        new RetryOperation(){

            @Override
            protected void call() {
                String chunkKey = ChunkOutputStream.this.keyPrefix + "-" + ChunkOutputStream.this.chunkIndex;
                ChunkOutputStream.this.logger.debug("Store chunk {0}", new Object[]{chunkKey});
                ChunkOutputStream.this.blobCache.put((Object)chunkKey, (Object)chunk);
            }
        }.doTry();
        ++this.chunkIndex;
        this.chunkBuffer.reset();
    }
}

