/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.ObservationManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.JcrContentHandler;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrQueryManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryManager;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSharedNodeCache;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.value.InvalidPathException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@ThreadSafe
class JcrWorkspace
implements Workspace {
    private final JcrSession session;
    private final String workspaceName;
    private final Lock lock = new ReentrantLock();
    private JcrNodeTypeManager nodeTypeManager;
    private JcrLockManager lockManager;
    private JcrNamespaceRegistry workspaceRegistry;
    private JcrVersionManager versionManager;
    private JcrQueryManager queryManager;
    private JcrObservationManager observationManager;
    private JcrRepositoryManager repositoryManager;

    JcrWorkspace(JcrSession session, String workspaceName) {
        this.session = session;
        this.workspaceName = workspaceName;
    }

    final JcrRepository repository() {
        return this.session.repository();
    }

    final ExecutionContext context() {
        return this.session.context();
    }

    public final JcrSession getSession() {
        return this.session;
    }

    public final String getName() {
        return this.workspaceName;
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        this.session.checkLive();
        this.copy(this.workspaceName, srcAbsPath, destAbsPath);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        this.validateCrossWorkspaceAction(srcWorkspace);
        PathFactory pathFactory = this.session.pathFactory();
        Path srcPath = null;
        try {
            srcPath = (Path)pathFactory.create(srcAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
        }
        Path destPath = null;
        try {
            destPath = (Path)pathFactory.create(destAbsPath);
        }
        catch (ValueFormatException e) {
            throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
        }
        if (!destPath.isIdentifier() && destAbsPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
        }
        try {
            JcrSession copySession = this.session.spawnSession(false);
            AbstractJcrNode parentNode = null;
            Name newNodeName = null;
            if (destPath.isIdentifier()) {
                AbstractJcrNode existingDestNode = copySession.node(destPath);
                parentNode = existingDestNode.getParent();
                newNodeName = existingDestNode.segment().getName();
            } else {
                parentNode = copySession.node(destPath.getParent());
                newNodeName = destPath.getLastSegment().getName();
            }
            JcrSession sourceSession = this.session.spawnSession(srcWorkspace, true);
            AbstractJcrNode sourceNode = sourceSession.node(srcPath);
            if (this.session.lockManager().isLocked(sourceNode) && !this.session.lockManager().hasLockToken(sourceNode.getLock().getLockToken())) {
                throw new LockException(srcAbsPath);
            }
            AbstractJcrNode copy = parentNode.addChildNode(newNodeName, sourceNode.getPrimaryTypeName(), null);
            Map<NodeKey, NodeKey> nodeKeyCorrespondence = copy.mutable().deepCopy(copySession.cache(), sourceNode.node(), sourceSession.cache());
            copySession.initOriginalVersionKeys();
            Set<NodeKey> srcNodeKeys = nodeKeyCorrespondence.keySet();
            for (NodeKey sourceKey : srcNodeKeys) {
                AbstractJcrNode srcNode = sourceSession.node(sourceKey, null);
                NodeKey dstNodeKey = nodeKeyCorrespondence.get(sourceKey);
                AbstractJcrNode dstNode = copySession.node(dstNodeKey, null);
                if (srcNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    copySession.setOriginalVersionKey(dstNodeKey, srcNode.getBaseVersion().key());
                }
                if (!dstNode.isNodeType(JcrMixLexicon.REFERENCEABLE) || !dstNode.hasProperty(JcrLexicon.UUID)) continue;
                JcrValue identifierValue = dstNode.valueFactory().createValue(dstNode.getIdentifier());
                dstNode.setProperty(JcrLexicon.UUID, identifierValue, true, true);
                PropertyIterator incomingReferencesIterator = dstNode.getAllReferences();
                while (incomingReferencesIterator.hasNext()) {
                    Property incomingRef = incomingReferencesIterator.nextProperty();
                    NodeKey referringNodeKey = ((AbstractJcrNode)incomingRef.getParent()).key();
                    boolean isReferrerWithinSubgraph = srcNodeKeys.contains(referringNodeKey);
                    if (!isReferrerWithinSubgraph) continue;
                    incomingRef.setValue((Node)copySession.node(dstNodeKey, null));
                }
            }
            copySession.save();
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException((Throwable)ace);
        }
        catch (InvalidPathException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        block26: {
            CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
            CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
            this.validateCrossWorkspaceAction(srcWorkspace);
            boolean sameWorkspace = this.getName().equals(srcWorkspace);
            if (sameWorkspace && removeExisting) {
                this.move(srcAbsPath, destAbsPath);
                return;
            }
            PathFactory pathFactory = this.session.pathFactory();
            Path srcPath = null;
            try {
                srcPath = (Path)pathFactory.create(srcAbsPath);
            }
            catch (ValueFormatException e) {
                throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{srcAbsPath, "srcAbsPath"}), (Throwable)e);
            }
            Path destPath = null;
            try {
                destPath = (Path)pathFactory.create(destAbsPath);
            }
            catch (ValueFormatException e) {
                throw new PathNotFoundException(JcrI18n.invalidPathParameter.text(new Object[]{destAbsPath, "destAbsPath"}), (Throwable)e);
            }
            if (!sameWorkspace && !destPath.isIdentifier() && destAbsPath.endsWith("]")) {
                throw new RepositoryException(JcrI18n.pathCannotHaveSameNameSiblingIndex.text(new Object[]{destAbsPath}));
            }
            try {
                JcrSession cloneSession = this.session.spawnSession(false);
                AbstractJcrNode parentNode = null;
                Name newNodeName = null;
                if (destPath.isIdentifier()) {
                    AbstractJcrNode existingDestNode = cloneSession.node(destPath);
                    parentNode = existingDestNode.getParent();
                    newNodeName = existingDestNode.segment().getName();
                } else {
                    parentNode = cloneSession.node(destPath.getParent());
                    newNodeName = destPath.getLastSegment().getName();
                }
                JcrSession sourceSession = null;
                sourceSession = sameWorkspace ? cloneSession : this.session.spawnSession(srcWorkspace, true);
                AbstractJcrNode sourceNode = sourceSession.node(srcPath);
                if (this.session.lockManager().isLocked(sourceNode) && !this.session.lockManager().hasLockToken(sourceNode.getLock().getLockToken())) {
                    throw new LockException(srcAbsPath);
                }
                if (sameWorkspace && sourceNode.isShareable()) {
                    assert (!removeExisting);
                    if (destPath.isAtOrBelow(srcPath)) {
                        throw new RepositoryException(JcrI18n.unableToShareNodeWithinSubgraph.text(new Object[]{srcAbsPath, destAbsPath}));
                    }
                    Path destParent = destPath.getParent();
                    if (destParent.isSameAs(srcPath.getParent())) {
                        String msg = JcrI18n.unableToShareNodeWithinSameParent.text(new Object[]{srcAbsPath, destAbsPath, destParent});
                        throw new UnsupportedRepositoryOperationException(msg);
                    }
                    JcrSharedNodeCache.SharedSet sharedSet = sourceNode.sharedSet();
                    AbstractJcrNode existingShare = sharedSet.getSharedNodeAtOrBelow(destParent);
                    if (existingShare != null) {
                        String msg = JcrI18n.shareAlreadyExistsWithinParent.text(new Object[]{destAbsPath, existingShare.getPath()});
                        throw new RepositoryException(msg);
                    }
                    parentNode.addSharedNode(sourceNode, newNodeName);
                    cloneSession.save();
                    break block26;
                }
                SessionCache sourceCache = sourceSession.cache();
                Set<NodeKey> sourceKeys = sourceCache.getNodeKeysAtAndBelow(sourceNode.key());
                for (NodeKey srcKey : sourceKeys) {
                    try {
                        boolean hasAnyPendingChanges;
                        AbstractJcrNode srcNode = sourceSession.node(srcKey, null);
                        NodeKey cloneKey = parentNode.key().withId(srcNode.key().getIdentifier());
                        AbstractJcrNode cloneSessionNode = null;
                        try {
                            cloneSessionNode = cloneSession.node(cloneKey, null);
                        }
                        catch (ItemNotFoundException e) {
                            continue;
                        }
                        if (cloneSessionNode.nodeDefinition().isMandatory()) {
                            throw new ConstraintViolationException(JcrI18n.cannotRemoveNodeFromClone.text(new Object[]{cloneSessionNode.getPath(), cloneSessionNode.getIdentifier()}));
                        }
                        boolean bl = hasAnyPendingChanges = !this.session.cache().getChangedNodeKeysAtOrBelow(cloneSessionNode.node()).isEmpty();
                        if (hasAnyPendingChanges) {
                            throw new RepositoryException(JcrI18n.cannotRemoveNodeFromCloneDueToChangesInSession.text(new Object[]{cloneSessionNode.getPath(), cloneSessionNode.getIdentifier()}));
                        }
                        if (!removeExisting) {
                            throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{srcKey, this.workspaceName, cloneSessionNode.getPath()}));
                        }
                        cloneSessionNode.remove();
                    }
                    catch (PathNotFoundException e) {}
                }
                NodeKey cloneKey = parentNode.key().withId(sourceNode.key().getIdentifier());
                parentNode.addChildNode(newNodeName, sourceNode.getPrimaryTypeName(), cloneKey);
                this.deepClone(sourceSession, sourceNode.key(), cloneSession, cloneKey);
            }
            catch (ItemNotFoundException e) {
                throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (AccessControlException ace) {
                throw new AccessDeniedException((Throwable)ace);
            }
            catch (InvalidPathException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void validateCrossWorkspaceAction(String srcWorkspace) throws RepositoryException {
        CheckArg.isNotEmpty((String)srcWorkspace, (String)"srcWorkspace");
        this.session.checkLive();
        this.session.checkPermission(srcWorkspace, null, "read");
        this.session.checkPermission(this.getName(), null, "read");
        JcrRepository repository = this.repository();
        if (!repository.hasWorkspace(srcWorkspace)) {
            throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{repository.getName(), srcWorkspace}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkLive();
        CheckArg.isNotEmpty((String)srcAbsPath, (String)"srcAbsPath");
        CheckArg.isNotEmpty((String)destAbsPath, (String)"destAbsPath");
        JcrSession session = this.session.spawnSession(false);
        try {
            session.move(srcAbsPath, destAbsPath);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkLive();
        this.versionManager().restore(versions, removeExisting);
    }

    public JcrLockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.lockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrLockManager lockManager() {
        if (this.lockManager == null) {
            try {
                this.lock.lock();
                if (this.lockManager == null) {
                    this.lockManager = new JcrLockManager(this.session, this.repository().lockManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrQueryManager getQueryManager() throws RepositoryException {
        this.session.checkLive();
        if (this.queryManager == null) {
            try {
                this.lock.lock();
                if (this.queryManager == null) {
                    this.queryManager = new JcrQueryManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.session.checkLive();
        if (this.workspaceRegistry == null) {
            try {
                this.lock.lock();
                if (this.workspaceRegistry == null) {
                    this.workspaceRegistry = new JcrNamespaceRegistry(this.repository().persistentRegistry(), this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.workspaceRegistry;
    }

    public JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.session.checkLive();
        return this.nodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrNodeTypeManager nodeTypeManager() {
        if (this.nodeTypeManager == null) {
            try {
                this.lock.lock();
                if (this.nodeTypeManager == null) {
                    this.nodeTypeManager = new JcrNodeTypeManager(this.session, this.repository().nodeTypeManager());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.nodeTypeManager;
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.observationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrObservationManager observationManager() {
        if (this.observationManager == null) {
            try {
                this.lock.lock();
                if (this.observationManager == null) {
                    this.observationManager = new JcrObservationManager(this.session, this.repository().repositoryCache(), this.repository().getRepositoryStatistics());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.observationManager;
    }

    public JcrVersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        return this.versionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrVersionManager versionManager() {
        if (this.versionManager == null) {
            try {
                this.lock.lock();
                if (this.versionManager == null) {
                    this.versionManager = new JcrVersionManager(this.session);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.versionManager;
    }

    public JcrRepositoryManager getRepositoryManager() throws AccessDeniedException, RepositoryException {
        this.session.checkLive();
        return this.repositoryManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final JcrRepositoryManager repositoryManager() {
        if (this.repositoryManager == null) {
            try {
                this.lock.lock();
                if (this.repositoryManager == null) {
                    this.repositoryManager = new JcrRepositoryManager(this);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.repositoryManager;
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        this.session.checkLive();
        JcrSession session = this.session.spawnSession(false);
        boolean saveWhenFinished = true;
        AbstractJcrNode parent = session.getNode(parentAbsPath);
        if (!parent.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parent.getPath()}));
        }
        JcrRepository repo = this.getSession().getRepository();
        boolean retainLifecycleInfo = repo.getDescriptorValue("option.lifecycle.supported").getBoolean();
        boolean retainRetentionInfo = repo.getDescriptorValue("option.retention.supported").getBoolean();
        return new JcrContentHandler(session, parent, uuidBehavior, saveWhenFinished, retainRetentionInfo, retainLifecycleInfo);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        CheckArg.isNotNull((Object)parentAbsPath, (String)"parentAbsPath");
        CheckArg.isNotNull((Object)in, (String)"in");
        this.session.checkLive();
        boolean error = false;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this.getImportContentHandler(parentAbsPath, uuidBehavior));
            parser.parse(new InputSource(in));
        }
        catch (JcrContentHandler.EnclosingSAXException ese) {
            Exception cause = ese.getException();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)((Object)cause);
            }
            throw new RepositoryException((Throwable)cause);
        }
        catch (SAXParseException se) {
            error = true;
            throw new InvalidSerializedDataException((Throwable)se);
        }
        catch (SAXException se) {
            error = true;
            throw new RepositoryException((Throwable)se);
        }
        finally {
            block16: {
                try {
                    in.close();
                }
                catch (IOException t) {
                    if (!error) {
                        throw t;
                    }
                }
                catch (RuntimeException re) {
                    if (error) break block16;
                    throw re;
                }
            }
        }
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.session.checkLive();
        HashSet<String> names = new HashSet<String>(this.session.repository().repositoryCache().getWorkspaceNames());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            try {
                this.session.checkPermission((String)iter.next(), null, "read");
            }
            catch (AccessDeniedException ace) {
                iter.remove();
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkLive();
        try {
            this.session.checkPermission(name, null, "create_workspace");
            JcrRepository repository = this.session.repository();
            if (repository.hasWorkspace(name)) {
                String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{name, this.getName()});
                throw new RepositoryException(msg);
            }
            repository.repositoryCache().createWorkspace(name);
            repository.statistics().increment(ValueMetric.WORKSPACE_COUNT);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.validateCrossWorkspaceAction(srcWorkspace);
        this.createWorkspace(name);
        JcrSession newWorkspaceSession = this.session.spawnSession(name, false);
        JcrSession srcWorkspaceSession = this.session.spawnSession(srcWorkspace, true);
        this.deepClone(srcWorkspaceSession, srcWorkspaceSession.getRootNode().key(), newWorkspaceSession, newWorkspaceSession.getRootNode().key());
    }

    protected void deepClone(JcrSession sourceSession, NodeKey sourceNodeKey, JcrSession cloneSession, NodeKey cloneNodeKey) throws RepositoryException {
        assert (!cloneSession.cache().isReadOnly());
        SessionCache sourceCache = sourceSession.cache();
        CachedNode sourceNode = sourceCache.getNode(sourceNodeKey);
        SessionCache cloneCache = cloneSession.cache();
        MutableCachedNode mutableCloneNode = cloneSession.node(cloneNodeKey, null).mutable();
        mutableCloneNode.deepClone(cloneCache, sourceNode, sourceCache);
        cloneSession.initBaseVersionKeys();
        Set<NodeKey> sourceKeys = sourceCache.getNodeKeysAtAndBelow(sourceNodeKey);
        for (NodeKey sourceKey : sourceKeys) {
            AbstractJcrNode srcNode = sourceSession.node(sourceKey, null);
            if (!srcNode.isNodeType(JcrMixLexicon.VERSIONABLE)) continue;
            cloneSession.setDesiredBaseVersionKey(sourceKey, srcNode.getBaseVersion().key());
        }
        cloneSession.save();
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        this.session.checkLive();
        try {
            JcrRepository repository = this.session.repository();
            if (!repository.repositoryCache().destroyWorkspace(name)) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNotFound.text(new Object[]{name, this.getName()}));
            }
            repository.statistics().decrement(ValueMetric.WORKSPACE_COUNT);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedRepositoryOperationException(e.getMessage());
        }
    }

    public void reindex() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        this.repository().runningState().queryManager().reindexContent(this);
    }

    public void reindex(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            this.repository().runningState().queryManager().reindexContent(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public Future<Boolean> reindexAsync() throws RepositoryException {
        this.session.checkPermission(this.workspaceName, Path.ROOT_PATH, "index_workspace");
        return this.repository().runningState().queryManager().reindexContentAsync(this);
    }

    public Future<Boolean> reindexAsync(String pathStr) throws RepositoryException {
        try {
            Path path = (Path)this.session.pathFactory().create(pathStr);
            this.session.checkPermission(this.workspaceName, path, "index_workspace");
            return this.repository().runningState().queryManager().reindexContentAsync(this, path, Integer.MAX_VALUE);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(e.getMessage());
        }
    }
}

