/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.ExtensionBasedMimeTypeDetector;

@ThreadSafe
public final class MimeTypeDetectors
extends MimeTypeDetector {
    private static final Logger LOGGER = Logger.getLogger(MimeTypeDetectors.class);
    private List<MimeTypeDetector> detectors = new ArrayList<MimeTypeDetector>();

    public MimeTypeDetectors() {
        this(null);
    }

    public MimeTypeDetectors(Environment environment) {
        ClassLoader defaultLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader classLoader = environment != null ? environment.getClassLoader(defaultLoader, "org.modeshape.extractor.tika") : defaultLoader;
        this.loadDetectors(classLoader);
    }

    private void loadDetectors(ClassLoader classLoader) {
        if (this.tryToLoadClass(classLoader, "org.apache.tika.detect.DefaultDetector", "org.modeshape.extractor.tika.TikaMimeTypeDetector")) {
            this.addDetector(classLoader, "org.modeshape.extractor.tika.TikaMimeTypeDetector");
        }
        if (this.tryToLoadClass(classLoader, "org.semanticdesktop.aperture.mime.identifier.magic.MagicMimeTypeIdentifier")) {
            this.addDetector(classLoader, "org.modeshape.jcr.mimetype.ApertureMimeTypeDetector");
        }
        this.detectors.add(ExtensionBasedMimeTypeDetector.INSTANCE);
    }

    private void addDetector(ClassLoader classLoader, String fqnClassName) {
        try {
            MimeTypeDetector detector = (MimeTypeDetector)classLoader.loadClass(fqnClassName).newInstance();
            this.detectors.add(detector);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)RepositoryI18n.unableToLoadMimeTypeDetector, new Object[]{fqnClassName, e.getMessage()});
        }
    }

    private boolean tryToLoadClass(ClassLoader classLoader, String ... fqnClassNames) {
        try {
            for (String fqnClassName : fqnClassNames) {
                Class.forName(fqnClassName, false, classLoader);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String mimeTypeOf(String name, Binary binaryValue) throws RepositoryException, IOException {
        String detectedMimeType = this.detectMimeTypeUsingDetectors(name, binaryValue);
        return detectedMimeType != null ? detectedMimeType : this.detectFallbackMimeType(binaryValue);
    }

    private String detectFallbackMimeType(Binary binaryValue) throws RepositoryException, IOException {
        return (String)this.processStream(binaryValue, (MimeTypeDetector.StreamOperation)new MimeTypeDetector.StreamOperation<String>(){

            public String execute(InputStream stream) {
                try {
                    int chr = stream.read();
                    while (chr >= 0) {
                        if (chr == 0) {
                            return "application/octet-stream";
                        }
                        chr = stream.read();
                    }
                }
                catch (IOException meansTooManyBytesRead) {
                    return "application/octet-stream";
                }
                return "text/plain";
            }
        });
    }

    private String detectMimeTypeUsingDetectors(String name, Binary binary) throws RepositoryException, IOException {
        for (MimeTypeDetector detector : this.detectors) {
            String mimeType = detector.mimeTypeOf(name, binary);
            if (mimeType == null) continue;
            return mimeType;
        }
        return null;
    }
}

