/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public final class SynchronizedTransactions
extends Transactions {
    public SynchronizedTransactions(SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
        super(monitorFactory, txnMgr);
        assert (txnMgr != null);
    }

    @Override
    public Transactions.Transaction begin() throws NotSupportedException, SystemException {
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null) {
            this.txnMgr.begin();
            return new Transactions.SimpleTransaction(this, this.txnMgr);
        }
        try {
            return new SynchronizedTransaction(this.txnMgr);
        }
        catch (RollbackException e) {
            return new RollbackOnlyTransaction();
        }
    }

    @Override
    public void updateCache(WorkspaceCache workspace, ChangeSet changes, Transactions.Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            if (transaction instanceof SynchronizedTransaction) {
                SynchronizedTransaction synched = (SynchronizedTransaction)transaction;
                synched.addUpdate(new WorkspaceUpdates(workspace, changes));
            } else if (!(transaction instanceof RollbackOnlyTransaction)) {
                workspace.changed(changes);
            }
        }
    }

    protected static final class ChangedCall
    implements Call {
        private final long count;

        protected ChangedCall(long count) {
            this.count = count;
        }

        @Override
        public void send(SessionEnvironment.Monitor monitor) {
            monitor.recordChanged(this.count);
        }
    }

    protected static final class RemoveCall
    implements Call {
        private final String workspace;
        private final Iterable<NodeKey> keys;

        protected RemoveCall(String workspace, Iterable<NodeKey> keys) {
            this.workspace = workspace;
            this.keys = keys;
        }

        @Override
        public void send(SessionEnvironment.Monitor monitor) {
            monitor.recordRemove(this.workspace, this.keys);
        }
    }

    protected static final class UpdateCall
    implements Call {
        private final String workspace;
        private final NodeKey key;
        private final Path path;
        private final Name primaryType;
        private final Set<Name> mixinTypes;
        private final Iterator<Property> properties;

        protected UpdateCall(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties) {
            this.workspace = workspace;
            this.key = key;
            this.path = path;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
            this.properties = properties;
        }

        @Override
        public void send(SessionEnvironment.Monitor monitor) {
            monitor.recordUpdate(this.workspace, this.key, this.path, this.primaryType, this.mixinTypes, this.properties);
        }
    }

    protected static final class AddCall
    implements Call {
        private final String workspace;
        private final NodeKey key;
        private final Path path;
        private final Name primaryType;
        private final Set<Name> mixinTypes;
        private final Collection<Property> properties;

        protected AddCall(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Collection<Property> properties) {
            this.workspace = workspace;
            this.key = key;
            this.path = path;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
            this.properties = properties;
        }

        @Override
        public void send(SessionEnvironment.Monitor monitor) {
            monitor.recordAdd(this.workspace, this.key, this.path, this.primaryType, this.mixinTypes, this.properties);
        }
    }

    protected static interface Call {
        public void send(SessionEnvironment.Monitor var1);
    }

    protected static final class AccumulatingMonitor
    implements SessionEnvironment.Monitor {
        private final List<Call> calls = new LinkedList<Call>();

        protected AccumulatingMonitor() {
        }

        @Override
        public void recordAdd(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Collection<Property> properties) {
            this.calls.add(new AddCall(workspace, key, path, primaryType, mixinTypes, properties));
        }

        @Override
        public void recordChanged(long changedNodesCount) {
            this.calls.add(new ChangedCall(changedNodesCount));
        }

        @Override
        public void recordRemove(String workspace, Iterable<NodeKey> keys) {
            this.calls.add(new RemoveCall(workspace, keys));
        }

        @Override
        public void recordUpdate(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties) {
            this.calls.add(new UpdateCall(workspace, key, path, primaryType, mixinTypes, properties));
        }

        protected void forward(SessionEnvironment.Monitor delegate) {
            for (Call call : this.calls) {
                call.send(delegate);
            }
            this.calls.clear();
        }
    }

    protected static final class WorkspaceUpdates {
        private final WorkspaceCache workspace;
        private final ChangeSet changes;

        protected WorkspaceUpdates(WorkspaceCache workspace, ChangeSet changes) {
            this.workspace = workspace;
            this.changes = changes;
        }

        protected void apply() {
            this.workspace.changed(this.changes);
        }
    }

    protected class RollbackOnlyTransaction
    implements Transactions.Transaction {
        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return SynchronizedTransactions.this.newMonitor();
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void uponCompletion(Transactions.TransactionFunction function) {
        }
    }

    protected class SynchronizedTransaction
    extends Transactions.BaseTransaction {
        private final Synchronization synchronization;
        private final AccumulatingMonitor monitor;
        private final List<WorkspaceUpdates> updates;
        private boolean finished;

        protected SynchronizedTransaction(TransactionManager txnMgr) throws SystemException, RollbackException {
            super(SynchronizedTransactions.this, txnMgr);
            this.updates = new LinkedList<WorkspaceUpdates>();
            this.finished = false;
            this.synchronization = new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    switch (status) {
                        case 3: {
                            SynchronizedTransaction.this.afterCommit();
                            break;
                        }
                    }
                }
            };
            txnMgr.getTransaction().registerSynchronization(this.synchronization);
            this.monitor = new AccumulatingMonitor();
        }

        protected void addUpdate(WorkspaceUpdates updates) {
            assert (updates != null);
            assert (!this.finished);
            this.updates.add(updates);
        }

        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return this.monitor;
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        protected void afterCommit() {
            this.executeFunctions();
            this.monitor.forward(SynchronizedTransactions.this.newMonitor());
            for (WorkspaceUpdates update : this.updates) {
                update.apply();
            }
            this.finished = true;
        }
    }
}

