/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.modeshape.common.logging.Logger;

class ChunkInputStream
extends InputStream {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Cache<String, byte[]> blobCache;
    private final String key;
    protected int indexInBuffer;
    protected byte[] buffer;
    private int chunkNumber;

    public ChunkInputStream(Cache<String, byte[]> blobCache, String key) {
        this.blobCache = blobCache;
        this.key = key;
    }

    @Override
    public int read() throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null || this.indexInBuffer >= this.buffer.length) {
            this.fillBuffer();
            return this.read();
        }
        return this.buffer[this.indexInBuffer++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.read(b, off, len);
        }
        if (this.indexInBuffer >= this.buffer.length) {
            return -1;
        }
        if (this.indexInBuffer + len > this.buffer.length) {
            len = this.buffer.length - this.indexInBuffer;
        }
        System.arraycopy(this.buffer, this.indexInBuffer, b, off, len);
        this.indexInBuffer += len;
        if (this.indexInBuffer >= this.buffer.length) {
            this.fillBuffer();
        }
        return len;
    }

    @Override
    public int available() {
        return this.buffer.length - this.indexInBuffer;
    }

    @Override
    public final long skip(long n) throws IOException {
        if (n <= 0L || this.indexInBuffer == -1) {
            return 0L;
        }
        if (this.buffer == null) {
            this.fillBuffer();
            return this.skip(n);
        }
        if ((long)this.buffer.length + n > (long)this.indexInBuffer) {
            n = this.buffer.length - this.indexInBuffer;
        }
        if (n < 0L) {
            return 0L;
        }
        this.indexInBuffer = (int)((long)this.indexInBuffer + n);
        return n;
    }

    private void fillBuffer() {
        this.buffer = this.nextChunk();
        if (this.buffer == null) {
            this.buffer = new byte[0];
            this.indexInBuffer = -1;
        } else {
            this.indexInBuffer = 0;
        }
    }

    protected byte[] nextChunk() {
        String chunkKey = this.key + "-" + this.chunkNumber++;
        this.logger.debug("Read chunk {0}", new Object[]{chunkKey});
        return (byte[])this.blobCache.get((Object)chunkKey);
    }
}

