/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import org.infinispan.Cache;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Json;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.BackupDocumentReader;
import org.modeshape.jcr.BackupDocumentWriter;
import org.modeshape.jcr.BackupObserver;
import org.modeshape.jcr.InfinispanUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrProblems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class BackupService {
    protected static final Logger LOGGER = Logger.getLogger(BackupService.class);
    protected static final String CHANGED_AREA_DIR_NAME = "changes";
    protected static final String BINARY_AREA_DIR_NAME = "binaries";
    protected static final String DOCUMENTS_FILENAME_PREFIX = "documents";
    protected static final String SUMMARY_FILE_NAME = "summary_of_changes.json";
    protected static final String BINARY_EXTENSION = ".bin";
    protected static final int NUM_CHARS_IN_FILENAME_SUFFIX = 6;
    public static final long DEFAULT_NUMBER_OF_DOCUMENTS_IN_BACKUP_FILES = 100000L;
    public static final boolean DEFAULT_COMPRESS = true;
    private final JcrRepository.RunningState runningState;
    private final SchematicDb documentStore;
    private final BinaryStore binaryStore;
    private final RepositoryCache repositoryCache;

    protected BackupService(JcrRepository.RunningState runningState) {
        this.runningState = runningState;
        this.documentStore = this.runningState.database();
        this.binaryStore = this.runningState.binaryStore();
        this.repositoryCache = this.runningState.repositoryCache();
    }

    protected void shutdown() {
    }

    public Problems backupRepository(File backupDirectory) throws RepositoryException {
        return this.backupRepository(backupDirectory, 100000L, true);
    }

    public Problems backupRepository(File backupDirectory, long documentsPerFile, boolean compress) throws RepositoryException {
        BackupActivity backupActivity = this.createBackupActivity(backupDirectory, documentsPerFile, compress);
        return new JcrProblems(backupActivity.execute());
    }

    public Problems restoreRepository(JcrRepository repository, File backupDirectory) throws RepositoryException {
        String backupLocString = backupDirectory.getAbsolutePath();
        LOGGER.debug("Beginning restore of '{0}' repository from {1}", new Object[]{repository.getName(), backupLocString});
        repository.prepareToRestore();
        RestoreActivity restoreActivity = this.createRestoreActivity(backupDirectory);
        JcrProblems problems = new JcrProblems(restoreActivity.execute());
        if (!problems.hasProblems()) {
            try {
                repository.completeRestore();
            }
            catch (Throwable t) {
                restoreActivity.problems.addError(JcrI18n.repositoryCannotBeRestartedAfterRestore, new Object[]{repository.getName(), t.getMessage()});
            }
        }
        LOGGER.debug("Completed restore of '{0}' repository from {1}", new Object[]{repository.getName(), backupLocString});
        return problems;
    }

    public BackupActivity createBackupActivity(File backupDirectory, long documentsPerFile, boolean compress) {
        return new BackupActivity(backupDirectory, this.documentStore, this.binaryStore, this.repositoryCache, documentsPerFile, compress);
    }

    public RestoreActivity createRestoreActivity(File backupDirectory) {
        return new RestoreActivity(backupDirectory, this.documentStore, this.binaryStore, this.repositoryCache);
    }

    @NotThreadSafe
    public static final class RestoreActivity
    extends Activity {
        protected RestoreActivity(File backupDirectory, SchematicDb documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache) {
            super(backupDirectory, documentStore, binaryStore, repositoryCache);
        }

        @Override
        public org.modeshape.common.collection.Problems execute() {
            this.removeExistingBinaryFiles();
            this.restoreBinaryFiles();
            this.removeExistingDocuments();
            this.restoreDocuments(this.backupDirectory);
            this.restoreDocuments(this.changeDirectory);
            return this.problems;
        }

        public void removeExistingBinaryFiles() {
            try {
                Iterable<BinaryKey> keys = this.binaryStore.getAllBinaryKeys();
                this.binaryStore.markAsUnused(keys);
            }
            catch (BinaryStoreException e) {
                I18n msg = JcrI18n.problemsGettingBinaryKeysFromBinaryStore;
                this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
        }

        public void removeExistingDocuments() {
            Cache cache = this.documentStore.getCache();
            try {
                cache.clear();
            }
            catch (UnsupportedOperationException e) {
                try {
                    String key;
                    InfinispanUtil.Sequence keySequence = InfinispanUtil.getAllKeys(cache);
                    while ((key = (String)keySequence.next()) != null) {
                        cache.remove((Object)key);
                    }
                }
                catch (InterruptedException e2) {
                    Thread.interrupted();
                    I18n msg = JcrI18n.interruptedWhilePerformingBackup;
                    this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e2.getMessage()});
                }
                catch (CancellationException e2) {
                    this.problems.addError(JcrI18n.backupOperationWasCancelled, new Object[]{this.repositoryName(), this.backupLocation(), e2.getMessage()});
                }
                catch (CacheLoaderException e2) {
                    I18n msg = JcrI18n.problemObtainingDocumentsToBackup;
                    this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e2.getMessage()});
                }
                catch (ExecutionException e2) {
                    I18n msg = JcrI18n.problemObtainingDocumentsToBackup;
                    this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e2.getMessage()});
                }
            }
        }

        public void restoreBinaryFiles() {
            for (File segment1Dir : this.binaryDirectory.listFiles()) {
                for (File segment2Dir : segment1Dir.listFiles()) {
                    for (File segment3Dir : segment2Dir.listFiles()) {
                        for (File binaryFile : segment3Dir.listFiles()) {
                            this.restoreBinaryFile(binaryFile);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreBinaryFile(File binaryFile) {
            I18n msg;
            if (!binaryFile.exists()) {
                return;
            }
            if (!binaryFile.canRead()) {
                I18n msg2 = JcrI18n.problemsReadingBinaryFromBackup;
                BinaryKey key = this.binaryKeyFor(binaryFile);
                this.problems.addError(msg2, new Object[]{key.toString(), this.repositoryName(), this.backupLocation()});
            }
            try {
                FileInputStream stream = new FileInputStream(binaryFile);
                try {
                    BinaryValue stored = this.binaryStore.storeValue(stream);
                    assert (stored.getKey().equals(this.binaryKeyFor(binaryFile)));
                }
                finally {
                    ((InputStream)stream).close();
                }
            }
            catch (FileNotFoundException e) {
                msg = JcrI18n.problemsReadingBinaryFromBackup;
                BinaryKey key = this.binaryKeyFor(binaryFile);
                this.problems.addError((Throwable)e, msg, new Object[]{key.toString(), this.repositoryName(), this.backupLocation()});
            }
            catch (BinaryStoreException e) {
                msg = JcrI18n.problemsRestoringBinaryFromBackup;
                BinaryKey key = this.binaryKeyFor(binaryFile);
                this.problems.addError((Throwable)((Object)e), msg, new Object[]{key.toString(), this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
            catch (IOException e) {
                msg = JcrI18n.problemsRestoringBinaryFromBackup;
                BinaryKey key = this.binaryKeyFor(binaryFile);
                this.problems.addError((Throwable)e, msg, new Object[]{key.toString(), this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
        }

        protected BinaryKey binaryKeyFor(File binaryFile) {
            String filename = binaryFile.getName();
            String sha1 = filename.replace(BackupService.BINARY_EXTENSION, "");
            return new BinaryKey(sha1);
        }

        protected void restoreDocuments(File directory) {
            Document doc;
            BackupDocumentReader reader = new BackupDocumentReader(directory, BackupService.DOCUMENTS_FILENAME_PREFIX, (org.modeshape.common.collection.Problems)this.problems);
            while ((doc = reader.read()) != null) {
                this.documentStore.put(doc);
            }
        }
    }

    @NotThreadSafe
    public static class BackupActivity
    extends Activity {
        private final BackupObserver observer;
        protected final ExecutorService changedDocumentWorker;
        protected final BlockingQueue<NodeKey> changedDocumentQueue;
        private final long documentsPerFile;
        private final boolean compress;
        private BackupDocumentWriter contentWriter;
        private BackupDocumentWriter changesWriter;

        protected BackupActivity(File backupDirectory, SchematicDb documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache, long documentsPerFile, boolean compress) {
            super(backupDirectory, documentStore, binaryStore, repositoryCache);
            CheckArg.isPositive((long)documentsPerFile, (String)"documentsPerFile");
            this.documentsPerFile = documentsPerFile;
            this.compress = compress;
            this.changedDocumentQueue = new LinkedBlockingQueue<NodeKey>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("modeshape-backup");
            this.changedDocumentWorker = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
            this.observer = new BackupObserver(this.changedDocumentQueue);
        }

        protected boolean initializeAreaOnDisk() {
            try {
                if (this.backupDirectory.exists()) {
                    if (!this.backupDirectory.isDirectory() || !this.backupDirectory.canWrite()) {
                        this.problems.addError(JcrI18n.existsAndMustBeWritableDirectory, new Object[]{this.backupLocation()});
                        return false;
                    }
                } else {
                    this.backupDirectory.mkdirs();
                }
                this.changeDirectory.mkdirs();
                this.binaryDirectory.mkdirs();
            }
            catch (RuntimeException e) {
                this.problems.addError((Throwable)e, JcrI18n.problemInitializingBackupArea, new Object[]{this.backupLocation(), e.getMessage()});
            }
            return true;
        }

        protected void writeToContentArea(SchematicEntry document) {
            this.contentWriter.write(document.asDocument());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeToContentArea(BinaryKey key, InputStream binaryContent) {
            String sha1 = key.toString();
            File first = new File(this.binaryDirectory, sha1.substring(0, 2));
            File second = new File(first, sha1.substring(2, 4));
            File third = new File(second, sha1.substring(4, 6));
            third.mkdirs();
            File file = new File(third, sha1 + BackupService.BINARY_EXTENSION);
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                try {
                    IoUtil.write((InputStream)binaryContent, (OutputStream)outputStream);
                    outputStream.flush();
                }
                finally {
                    outputStream.close();
                }
            }
            catch (Throwable t) {
                this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{file.getAbsolutePath(), t.getMessage()});
            }
        }

        protected void writeToChangedArea(SchematicEntry document) {
            LOGGER.debug("Writing document to change area of backup for {0} repository at {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            this.changesWriter.write(document.asDocument());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeToChangedArea(Iterable<BinaryKey> unusedBinaries) {
            LOGGER.debug("Writing unused binaries to change area of backup for {0} repository at {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            File file = new File(this.changeDirectory, BackupService.SUMMARY_FILE_NAME);
            try {
                EditableDocument doc = Schematic.newDocument();
                EditableArray keys = doc.setArray("unusedBinaryKeys");
                for (BinaryKey key : unusedBinaries) {
                    if (key == null) continue;
                    keys.add((Object)key.toString());
                }
                FileOutputStream outputStream = new FileOutputStream(file);
                try {
                    Json.write((Document)doc, (OutputStream)outputStream);
                    outputStream.flush();
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (Throwable t) {
                this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{file.getAbsolutePath(), t.getMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public org.modeshape.common.collection.Problems execute() {
            if (!this.initializeAreaOnDisk()) {
                return this.problems;
            }
            LOGGER.debug("Starting backup of '{0}' repository into {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            this.contentWriter = new BackupDocumentWriter(this.backupDirectory, BackupService.DOCUMENTS_FILENAME_PREFIX, this.documentsPerFile, this.compress, (org.modeshape.common.collection.Problems)this.problems);
            this.changesWriter = new BackupDocumentWriter(this.changeDirectory, BackupService.DOCUMENTS_FILENAME_PREFIX, this.documentsPerFile, this.compress, (org.modeshape.common.collection.Problems)this.problems);
            long numBinaryValues = 0L;
            try {
                I18n msg;
                final AtomicBoolean continueWritingChangedDocuments = new AtomicBoolean(true);
                final CountDownLatch changesLatch = new CountDownLatch(1);
                this.changedDocumentWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        SchematicEntry entry;
                        NodeKey key;
                        try {
                            while (continueWritingChangedDocuments.get()) {
                                key = BackupActivity.this.changedDocumentQueue.poll(1L, TimeUnit.SECONDS);
                                if (key == null) continue;
                                entry = BackupActivity.this.documentStore.get(key.toString());
                                BackupActivity.this.writeToChangedArea(entry);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                        while (!BackupActivity.this.changedDocumentQueue.isEmpty()) {
                            key = (NodeKey)BackupActivity.this.changedDocumentQueue.poll();
                            if (key == null) continue;
                            entry = BackupActivity.this.documentStore.get(key.toString());
                            BackupActivity.this.writeToChangedArea(entry);
                        }
                        changesLatch.countDown();
                    }
                });
                this.repositoryCache.register(this.observer);
                try {
                    SchematicEntry entry;
                    String key;
                    InfinispanUtil.Sequence sequence = InfinispanUtil.getAllKeys(this.documentStore.getCache());
                    while ((key = (String)sequence.next()) != null) {
                        entry = this.documentStore.get(key);
                        if (entry == null) continue;
                        this.writeToContentArea(entry);
                    }
                    NodeKey metadataKey = this.repositoryCache.getRepositoryMetadataDocumentKey();
                    entry = this.documentStore.get(metadataKey.toString());
                    this.writeToContentArea(entry);
                }
                catch (Exception e) {
                    msg = JcrI18n.problemObtainingDocumentsToBackup;
                    this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
                }
                finally {
                    try {
                        this.repositoryCache.unregister(this.observer);
                    }
                    finally {
                        continueWritingChangedDocuments.set(false);
                        this.changedDocumentWorker.shutdown();
                    }
                }
                try {
                    for (BinaryKey binaryKey : this.binaryStore.getAllBinaryKeys()) {
                        try {
                            this.writeToContentArea(binaryKey, this.binaryStore.getInputStream(binaryKey));
                        }
                        catch (BinaryStoreException e) {
                            this.problems.addError(JcrI18n.problemsWritingBinaryToBackup, new Object[]{binaryKey, this.backupLocation(), e.getMessage()});
                        }
                    }
                }
                catch (BinaryStoreException e) {
                    msg = JcrI18n.problemsGettingBinaryKeysFromBinaryStore;
                    this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
                }
                for (BinaryKey binaryKey : this.observer.getUsedBinaryKeys()) {
                    try {
                        this.writeToContentArea(binaryKey, this.binaryStore.getInputStream(binaryKey));
                    }
                    catch (BinaryStoreException e) {
                        this.problems.addError(JcrI18n.problemsWritingBinaryToBackup, new Object[]{binaryKey, this.backupLocation(), e.getMessage()});
                    }
                }
                this.writeToChangedArea(this.observer.getUnusedBinaryKeys());
                changesLatch.await(30L, TimeUnit.SECONDS);
                LOGGER.debug("Completed backup of '{0}' repository into {1} (contains {2} nodes and {3} binary values)", new Object[]{this.repositoryName(), this.backupLocation(), this.contentWriter.getDocumentCount() + this.changesWriter.getDocumentCount(), numBinaryValues});
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                I18n msg = JcrI18n.interruptedWhilePerformingBackup;
                this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
            catch (CancellationException e) {
                this.problems.addError(JcrI18n.backupOperationWasCancelled, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
            finally {
                try {
                    this.contentWriter.close();
                }
                finally {
                    this.contentWriter = null;
                    try {
                        this.changesWriter.close();
                    }
                    finally {
                        this.changesWriter = null;
                    }
                }
            }
            return this.problems;
        }
    }

    @NotThreadSafe
    public static abstract class Activity {
        protected final RepositoryCache repositoryCache;
        protected final File backupDirectory;
        protected final File changeDirectory;
        protected final File binaryDirectory;
        protected final SchematicDb documentStore;
        protected final BinaryStore binaryStore;
        protected final SimpleProblems problems;
        private final String backupLocation;

        protected Activity(File backupDirectory, SchematicDb documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache) {
            this.backupDirectory = backupDirectory;
            this.changeDirectory = new File(this.backupDirectory, BackupService.CHANGED_AREA_DIR_NAME);
            this.binaryDirectory = new File(this.backupDirectory, BackupService.BINARY_AREA_DIR_NAME);
            this.backupLocation = this.backupDirectory.getAbsolutePath();
            this.documentStore = documentStore;
            this.binaryStore = binaryStore;
            this.repositoryCache = repositoryCache;
            this.problems = new SimpleProblems();
        }

        public abstract org.modeshape.common.collection.Problems execute();

        protected final String repositoryName() {
            return this.repositoryCache.getName();
        }

        protected final String backupLocation() {
            return this.backupLocation;
        }
    }

    protected static class FieldName {
        public static final String UNUSED_BINARY_KEYS = "unusedBinaryKeys";

        protected FieldName() {
        }
    }
}

