/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinary;
import org.modeshape.jcr.value.binary.BinaryStore;

@Immutable
public class InMemoryBinaryValue
extends AbstractBinary {
    private static final long serialVersionUID = 2L;
    private final transient BinaryStore store;
    private final byte[] bytes;
    private transient String mimeType;

    public InMemoryBinaryValue(BinaryStore store, byte[] bytes) {
        super(bytes != null ? BinaryKey.keyFor(bytes) : new BinaryKey("invalid"));
        CheckArg.isNotNull((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.store = store;
    }

    public InMemoryBinaryValue(BinaryStore store, BinaryKey key, byte[] bytes) {
        super(key);
        CheckArg.isNotNull((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.store = store;
    }

    @Override
    public long getSize() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public String getMimeType() throws IOException, RepositoryException {
        if (this.mimeType == null) {
            this.mimeType = this.store.getMimeType(this, null);
        }
        return this.mimeType;
    }

    public String getMimeType(String name) throws IOException, RepositoryException {
        if (this.mimeType == null) {
            this.mimeType = this.store.getMimeType(this, name);
        }
        return this.mimeType;
    }
}

