/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.text.TextExtractorContext;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.NamedLocks;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.infinispan.ChunkInputStream;
import org.modeshape.jcr.value.binary.infinispan.ChunkOutputStream;
import org.modeshape.jcr.value.binary.infinispan.Metadata;
import org.modeshape.jcr.value.binary.infinispan.RetryOperation;

@ThreadSafe
public class InfinispanBinaryStore
extends AbstractBinaryStore {
    private final Logger logger = Logger.getLogger(this.getClass());
    private LockFactory lockFactory;
    private CacheContainer cacheContainer;
    private boolean dedicatedCacheContainer;
    protected Cache<String, Metadata> metadataCache;
    private Cache<String, byte[]> blobCache;
    private String metadataCacheName;
    private String blobCacheName;

    public InfinispanBinaryStore(CacheContainer cacheContainer, boolean dedicatedCacheContainer, String metadataCacheName, String blobCacheName) {
        this.cacheContainer = cacheContainer;
        this.dedicatedCacheContainer = dedicatedCacheContainer;
        this.metadataCacheName = metadataCacheName;
        this.blobCacheName = blobCacheName;
    }

    @Override
    public void start() {
        this.logger.debug("start()", new Object[0]);
        if (this.metadataCache != null) {
            this.logger.debug("Already started.", new Object[0]);
            return;
        }
        if (this.dedicatedCacheContainer) {
            this.cacheContainer.start();
        }
        this.metadataCache = this.cacheContainer.getCache(this.metadataCacheName);
        this.blobCache = this.cacheContainer.getCache(this.blobCacheName);
        this.lockFactory = new LockFactory(this.metadataCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            if (this.dedicatedCacheContainer) {
                this.cacheContainer.stop();
            }
        }
        finally {
            this.cacheContainer = null;
            this.metadataCache = null;
            this.blobCache = null;
        }
    }

    public List<Cache<?, ?>> getCaches() {
        ArrayList caches = new ArrayList(2);
        if (!this.dedicatedCacheContainer) {
            if (this.metadataCache != null) {
                caches.add(this.metadataCache);
            }
            if (this.blobCache != null) {
                caches.add(this.blobCache);
            }
        }
        return caches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryValue storeValue(InputStream inputStream) throws BinaryStoreException, SystemFailureException {
        try {
            StoredBinaryValue value;
            SecureHash.HashingInputStream hashingStream = SecureHash.createHashingStream((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (InputStream)inputStream);
            File tmpFile = File.createTempFile("ms-ispn-binstore", "hashing");
            IoUtil.write((InputStream)hashingStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), (int)65536);
            final BinaryKey binaryKey = new BinaryKey(hashingStream.getHash());
            Lock lock = this.lockFactory.writeLock(binaryKey.toString());
            try {
                final Metadata checkMetadata = (Metadata)this.metadataCache.get((Object)binaryKey.toString());
                if (checkMetadata != null) {
                    this.logger.debug("Binary value already exist.", new Object[0]);
                    if (checkMetadata.isUnused()) {
                        checkMetadata.setUsed();
                        new RetryOperation(){

                            @Override
                            protected void call() {
                                InfinispanBinaryStore.this.metadataCache.put((Object)binaryKey.toString(), (Object)checkMetadata);
                            }
                        }.doTry();
                    }
                    StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, binaryKey, checkMetadata.getLength());
                    return storedBinaryValue;
                }
                this.logger.debug("Store binary value into chunks.", new Object[0]);
                ChunkOutputStream chunkOutputStream = new ChunkOutputStream(this.blobCache, binaryKey.toString());
                IoUtil.write((InputStream)new FileInputStream(tmpFile), (OutputStream)chunkOutputStream);
                final Metadata metadata = new Metadata();
                metadata.setModificationTime(System.currentTimeMillis());
                metadata.setNumberChunks(chunkOutputStream.getNumberChunks());
                metadata.setLength(tmpFile.length());
                new RetryOperation(){

                    @Override
                    protected void call() {
                        InfinispanBinaryStore.this.metadataCache.put((Object)binaryKey.toString(), (Object)metadata);
                    }
                }.doTry();
                value = new StoredBinaryValue(this, binaryKey, tmpFile.length());
            }
            finally {
                lock.unlock();
            }
            if (this.extractors() != null) {
                this.extractors().extract(this, value, new TextExtractorContext(this.detector()));
            }
            StoredBinaryValue storedBinaryValue = value;
            return storedBinaryValue;
        }
        catch (IOException e) {
            throw new BinaryStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
        finally {
            IoUtil.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey binaryKey) throws BinaryStoreException {
        Metadata metadata = (Metadata)this.metadataCache.get((Object)binaryKey.toString());
        if (metadata == null) {
            throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{binaryKey, "Infinispan cache " + this.metadataCache.getName()}));
        }
        if (metadata.getLength() == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ChunkInputStream(this.blobCache, binaryKey.toString());
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey binaryKey : keys) {
            Lock lock = this.lockFactory.writeLock(binaryKey.toString());
            try {
                Metadata tmpMetadata = (Metadata)this.metadataCache.get((Object)binaryKey.toString());
                final BinaryKey binaryKey1 = binaryKey;
                if (tmpMetadata == null || tmpMetadata.isUnused()) continue;
                final Metadata metadata = tmpMetadata.copy();
                metadata.setUnused();
                new RetryOperation(){

                    @Override
                    protected void call() {
                        InfinispanBinaryStore.this.metadataCache.put((Object)binaryKey1.toString(), (Object)metadata);
                    }
                }.doTry();
            }
            catch (IOException ex) {
                this.logger.debug((Throwable)ex, "Error during mark binary value unused {0}", new Object[]{binaryKey.toString()});
                throw new BinaryStoreException(JcrI18n.errorMarkingBinaryValuesUnused.text(new Object[]{ex.getCause().getMessage()}));
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        Lock lock;
        Metadata metadata;
        CacheLoader cacheLoader = null;
        boolean cacheLoaderShared = false;
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.metadataCache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        if (cacheLoaderManager != null) {
            cacheLoader = cacheLoaderManager.getCacheLoader();
            cacheLoaderShared = cacheLoaderManager.isShared();
        }
        if (!this.metadataCache.getCacheManager().isCoordinator() && cacheLoaderShared) {
            return;
        }
        long minimumAgeInMS = unit.toMillis(minimumAge);
        HashSet<String> processedKeys = new HashSet<String>();
        if (this.metadataCache.getCacheConfiguration().clustering().cacheMode().isDistributed() && this.metadataCache.getCacheManager().isCoordinator()) {
            MapReduceTask task = new MapReduceTask(this.metadataCache);
            task.mappedWith((Mapper)new UnusedMapper(minimumAgeInMS));
            task.reducedWith((Reducer)new Reducer<String, String>(){
                private static final long serialVersionUID = 1L;

                public String reduce(String s, Iterator<String> stringIterator) {
                    return s;
                }
            });
            Map result = task.execute();
            for (String key : result.values()) {
                Lock lock2 = this.lockFactory.writeLock(key);
                try {
                    InfinispanBinaryStore.removeBinaryValue(this.metadataCache, this.blobCache, key);
                }
                finally {
                    lock2.unlock();
                }
            }
        } else {
            for (String key : new ArrayList(this.metadataCache.keySet())) {
                metadata = (Metadata)this.metadataCache.get((Object)key);
                processedKeys.add(key);
                if (!InfinispanBinaryStore.isValueUnused(metadata, minimumAgeInMS)) continue;
                lock = this.lockFactory.writeLock(key);
                try {
                    InfinispanBinaryStore.removeBinaryValue(this.metadataCache, this.blobCache, key);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        if (this.metadataCache.getCacheManager().isCoordinator() && cacheLoader != null) {
            try {
                for (String key : new ArrayList(cacheLoader.loadAllKeys(processedKeys))) {
                    metadata = (Metadata)this.metadataCache.get((Object)key);
                    if (!InfinispanBinaryStore.isValueUnused(metadata, minimumAgeInMS)) continue;
                    lock = this.lockFactory.writeLock(key);
                    try {
                        InfinispanBinaryStore.removeBinaryValue(this.metadataCache, this.blobCache, key);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (CacheLoaderException cle) {
                this.logger.debug("Error during cleanup of cache loader", new Object[]{cle});
                throw new BinaryStoreException(JcrI18n.errorDuringGarbageCollection.text(new Object[]{cle.getMessage()}));
            }
        }
    }

    static boolean isValueUnused(Metadata metadata, long minimumAgeInMS) {
        if (metadata == null || !metadata.isUnused()) {
            return false;
        }
        return System.currentTimeMillis() - metadata.unusedSince() > minimumAgeInMS;
    }

    static void removeBinaryValue(Cache<String, Metadata> metadataCache, Cache<String, byte[]> blobCache, String key) {
        int chunkIndex;
        Metadata metadata = (Metadata)metadataCache.get((Object)key);
        if (metadata == null || !metadata.isUnused()) {
            return;
        }
        metadataCache.remove((Object)key);
        if (metadata.getNumberChunks() > 0) {
            for (chunkIndex = 0; chunkIndex < metadata.getNumberChunks(); ++chunkIndex) {
                blobCache.remove((Object)(key + "-" + chunkIndex));
            }
        }
        if (metadata.getNumberTextChunks() > 0) {
            for (chunkIndex = 0; chunkIndex < metadata.getNumberTextChunks(); ++chunkIndex) {
                blobCache.remove((Object)(key + "-text-" + chunkIndex));
            }
        }
    }

    @Override
    protected String getStoredMimeType(BinaryValue binary) throws BinaryStoreException {
        Metadata metadata = (Metadata)this.metadataCache.get((Object)binary.getKey().toString());
        if (metadata == null) {
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), "Infinispan cache " + this.metadataCache.getName()})}));
        }
        return metadata.getMimeType();
    }

    @Override
    protected void storeMimeType(final BinaryValue binary, String mimeType) throws BinaryStoreException {
        Lock lock = this.lockFactory.writeLock(binary.getKey().toString());
        try {
            Metadata tmpMetadata = (Metadata)this.metadataCache.get((Object)binary.getKey().toString());
            if (tmpMetadata == null) {
                throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), "Infinispan cache " + this.metadataCache.getName()})}));
            }
            final Metadata metadata = tmpMetadata.copy();
            metadata.setMimeType(mimeType);
            new RetryOperation(){

                @Override
                protected void call() {
                    InfinispanBinaryStore.this.metadataCache.put((Object)binary.getKey().toString(), (Object)metadata);
                }
            }.doTry();
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during store of mime type for {0}", new Object[]{binary.getKey().toString()});
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{ex.getCause().getMessage()}));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getExtractedText(BinaryValue binary) throws BinaryStoreException {
        Metadata metadata = (Metadata)this.metadataCache.get((Object)binary.getKey().toString());
        if (metadata == null) {
            throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), "Infinispan cache " + this.metadataCache.getName()})}));
        }
        if (metadata.getNumberTextChunks() == 0) {
            return null;
        }
        try {
            return IoUtil.read((InputStream)new ChunkInputStream(this.blobCache, binary + "-text"), (String)"UTF-8");
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during read of extracted text for {0}", new Object[]{binary.getKey().toString()});
            throw new BinaryStoreException(JcrI18n.errorReadingExtractedText.text(new Object[]{ex.getCause().getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeExtractedText(final BinaryValue binary, String extractedText) throws BinaryStoreException {
        Lock lock = this.lockFactory.writeLock(binary.getKey().toString());
        try {
            final Metadata metadata = (Metadata)this.metadataCache.get((Object)binary.getKey().toString());
            if (metadata == null) {
                throw new BinaryStoreException(JcrI18n.errorStoringMimeType.text(new Object[]{JcrI18n.unableToFindBinaryValue.text(new Object[]{binary.getKey(), "Infinispan cache " + this.metadataCache.getName()})}));
            }
            ChunkOutputStream chunkOutputStream = null;
            try {
                chunkOutputStream = new ChunkOutputStream(this.blobCache, binary.toString() + "-text");
                chunkOutputStream.write(extractedText.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(chunkOutputStream);
                throw throwable;
            }
            IoUtil.closeQuietly((Closeable)chunkOutputStream);
            metadata.setNumberTextChunks(chunkOutputStream.getNumberChunks());
            new RetryOperation(){

                @Override
                protected void call() {
                    InfinispanBinaryStore.this.metadataCache.put((Object)binary.getKey().toString(), (Object)metadata);
                }
            }.doTry();
        }
        catch (IOException ex) {
            this.logger.debug((Throwable)ex, "Error during store of extracted text for {0}", new Object[]{binary.getKey().toString()});
            throw new BinaryStoreException(JcrI18n.errorStoringExtractedText.text(new Object[]{ex.getCause().getMessage()}));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        throw new BinaryStoreException("Not implemented");
    }

    static interface Lock {
        public void unlock() throws BinaryStoreException;
    }

    static class LockFactory {
        private final NamedLocks namedLocks;
        private final boolean infinispanLocks;
        private final Cache<String, Metadata> metadataCache;
        private final Lock DUMMY_LOCK = new Lock(){

            @Override
            public void unlock() {
            }
        };

        public LockFactory(Cache<String, Metadata> metadataCache) {
            this.metadataCache = metadataCache;
            if (this.metadataCache != null) {
                this.infinispanLocks = metadataCache.getCacheConfiguration().transaction().transactionMode() != TransactionMode.NON_TRANSACTIONAL && metadataCache.getCacheConfiguration().transaction().lockingMode() == LockingMode.PESSIMISTIC;
                this.namedLocks = !this.infinispanLocks && !metadataCache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new NamedLocks() : null;
            } else {
                this.namedLocks = null;
                this.infinispanLocks = false;
            }
        }

        public Lock readLock(String key) throws BinaryStoreException {
            if (this.namedLocks != null) {
                return new NamedLock(this.namedLocks.readLock(key));
            }
            if (this.infinispanLocks) {
                return new ISPNLock(this.metadataCache, key);
            }
            return this.DUMMY_LOCK;
        }

        public Lock writeLock(String key) throws BinaryStoreException {
            if (this.namedLocks != null) {
                return new NamedLock(this.namedLocks.writeLock(key));
            }
            if (this.infinispanLocks) {
                return new ISPNLock(this.metadataCache, key);
            }
            return this.DUMMY_LOCK;
        }

        private class ISPNLock
        implements Lock {
            private final Cache<String, Metadata> cache;
            private final String key;

            public ISPNLock(Cache<String, Metadata> cache, String key) throws BinaryStoreException {
                this.cache = cache;
                this.key = key;
                try {
                    cache.getAdvancedCache().getTransactionManager().begin();
                    boolean lockObtained = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock((Object[])new String[]{key});
                    if (!lockObtained) {
                        throw new BinaryStoreException(JcrI18n.errorLockingBinaryValue.text(new Object[]{key}));
                    }
                }
                catch (BinaryStoreException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new BinaryStoreException(JcrI18n.errorStoringBinaryValue.text(new Object[]{key}), ex);
                }
            }

            @Override
            public void unlock() throws BinaryStoreException {
                try {
                    this.cache.getAdvancedCache().getTransactionManager().commit();
                }
                catch (Exception ex) {
                    throw new BinaryStoreException(JcrI18n.errorStoringBinaryValue.text(new Object[]{this.key}), ex);
                }
            }
        }

        private class NamedLock
        implements Lock {
            private final java.util.concurrent.locks.Lock lock;

            public NamedLock(java.util.concurrent.locks.Lock lock) {
                this.lock = lock;
            }

            @Override
            public void unlock() {
                this.lock.unlock();
            }
        }
    }

    private static class UnusedMapper
    implements Mapper<String, Metadata, String, String> {
        private static final long serialVersionUID = 1L;
        private long minimumAgeInMS;

        public UnusedMapper(long minimumAgeInMS) {
            this.minimumAgeInMS = minimumAgeInMS;
        }

        public void map(String key, Metadata metadata, Collector<String, String> stringCollector) {
            if (InfinispanBinaryStore.isValueUnused(metadata, this.minimumAgeInMS)) {
                stringCollector.emit((Object)key, (Object)key);
            }
        }
    }
}

