/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.plan.JoinAlgorithm;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.process.DependentQueryComponent;
import org.modeshape.jcr.query.process.DistinctComponent;
import org.modeshape.jcr.query.process.ExceptComponent;
import org.modeshape.jcr.query.process.IntersectComponent;
import org.modeshape.jcr.query.process.LimitComponent;
import org.modeshape.jcr.query.process.MergeJoinComponent;
import org.modeshape.jcr.query.process.NestedLoopJoinComponent;
import org.modeshape.jcr.query.process.NoResultsComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.process.Processor;
import org.modeshape.jcr.query.process.ProjectComponent;
import org.modeshape.jcr.query.process.QueryResultColumns;
import org.modeshape.jcr.query.process.SelectComponent;
import org.modeshape.jcr.query.process.SortLocationsComponent;
import org.modeshape.jcr.query.process.SortValuesComponent;
import org.modeshape.jcr.query.process.UnionComponent;

public abstract class QueryProcessor<ProcessingContextType>
implements Processor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResults execute(QueryContext context, QueryCommand command, QueryResults.Statistics statistics, PlanNode plan) {
        long nanos = System.nanoTime();
        QueryResults.Columns columns = null;
        List<Object[]> tuples = null;
        try {
            PlanNode project = plan.findAtOrBelow(PlanNode.Type.PROJECT);
            assert (project != null);
            List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            assert (projectedColumns != null);
            assert (!projectedColumns.isEmpty());
            List<String> columnTypes = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            assert (columnTypes != null);
            assert (columnTypes.size() == projectedColumns.size());
            columns = new QueryResultColumns(projectedColumns, columnTypes, context.getHints().hasFullTextSearch);
            ProcessingContextType processingContext = this.createProcessingContext(context);
            try {
                ProcessingComponent component = this.createComponent(command, context, plan, columns, processingContext);
                long nanos2 = System.nanoTime();
                statistics = statistics.withResultsFormulationTime(Math.abs(nanos2 - nanos));
                nanos = nanos2;
                if (component != null) {
                    columns = component.getColumns();
                    tuples = component.execute();
                } else {
                    assert (context.getProblems().hasErrors() || context.isCancelled());
                    tuples = Collections.emptyList();
                }
            }
            finally {
                this.closeProcessingContext(processingContext);
            }
        }
        finally {
            statistics = statistics.withExecutionTime(Math.abs(System.nanoTime() - nanos));
        }
        assert (tuples != null);
        String planDesc = context.getHints().showPlan ? plan.getString() : null;
        return new org.modeshape.jcr.query.process.QueryResults(columns, statistics, tuples, context.getProblems(), planDesc);
    }

    protected ProcessingContextType createProcessingContext(QueryContext queryContext) {
        return null;
    }

    protected void closeProcessingContext(ProcessingContextType processingContext) {
    }

    protected abstract boolean supportsPushDownExistConstraints();

    protected abstract ProcessingComponent createAccessComponent(QueryCommand var1, QueryContext var2, PlanNode var3, QueryResults.Columns var4, ProcessingContextType var5);

    protected ProcessingComponent createComponent(QueryCommand originalQuery, QueryContext context, PlanNode node, QueryResults.Columns columns, ProcessingContextType processingContext) {
        ProcessingComponent component = null;
        switch (node.getType()) {
            case ACCESS: {
                if (node.hasProperty(PlanNode.Property.ACCESS_NO_RESULTS)) {
                    component = new NoResultsComponent(context, columns);
                    break;
                }
                assert (node.getChildCount() == 1);
                component = this.createAccessComponent(originalQuery, context, node, columns, processingContext);
                break;
            }
            case DUP_REMOVE: {
                assert (node.getChildCount() == 1);
                ProcessingComponent distinctDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, processingContext);
                component = new DistinctComponent(distinctDelegate);
                break;
            }
            case GROUP: {
                throw new UnsupportedOperationException();
            }
            case JOIN: {
                assert (node.getChildCount() == 2);
                PlanNode leftPlan = node.getFirstChild();
                PlanNode rightPlan = node.getLastChild();
                QueryResults.Columns leftColumns = this.createColumnsFor(leftPlan, columns);
                QueryResults.Columns rightColumns = this.createColumnsFor(rightPlan, columns);
                ProcessingComponent left = this.createComponent(originalQuery, context, leftPlan, leftColumns, processingContext);
                ProcessingComponent right = this.createComponent(originalQuery, context, rightPlan, rightColumns, processingContext);
                JoinAlgorithm algorithm = node.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class);
                JoinType joinType = node.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class);
                JoinCondition joinCondition = node.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                switch (algorithm) {
                    case MERGE: {
                        JoinCondition condition;
                        if (joinCondition instanceof SameNodeJoinCondition) {
                            condition = (SameNodeJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (SameNodeJoinCondition)condition, joinType);
                            break;
                        }
                        if (joinCondition instanceof ChildNodeJoinCondition) {
                            condition = (ChildNodeJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (ChildNodeJoinCondition)condition, joinType);
                            break;
                        }
                        if (joinCondition instanceof EquiJoinCondition) {
                            condition = (EquiJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (EquiJoinCondition)condition, joinType);
                            break;
                        }
                        assert (false) : "Unable to use merge algorithm with descendant node join conditions";
                        throw new UnsupportedOperationException();
                    }
                    case NESTED_LOOP: {
                        component = new NestedLoopJoinComponent(context, left, right, joinCondition, joinType);
                    }
                }
                List<Constraint> constraints = node.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
                if (constraints == null) break;
                for (Constraint constraint : constraints) {
                    component = new SelectComponent(component, constraint, context.getVariables());
                }
                break;
            }
            case LIMIT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent delegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, processingContext);
                if (context.getHints().isExistsQuery && this.supportsPushDownExistConstraints()) {
                    component = delegate;
                    break;
                }
                Integer rowLimit = node.getProperty(PlanNode.Property.LIMIT_COUNT, Integer.class);
                Integer offset = node.getProperty(PlanNode.Property.LIMIT_OFFSET, Integer.class);
                Limit limit = Limit.NONE;
                if (rowLimit != null) {
                    limit = limit.withRowLimit(rowLimit);
                }
                if (offset != null) {
                    limit = limit.withOffset(offset);
                }
                component = new LimitComponent(delegate, limit);
                break;
            }
            case NULL: {
                component = new NoResultsComponent(context, columns);
                break;
            }
            case PROJECT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent projectDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, processingContext);
                List<Column> projectedColumns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                component = new ProjectComponent(projectDelegate, projectedColumns);
                break;
            }
            case SELECT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent selectDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, processingContext);
                Constraint constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                component = new SelectComponent(selectDelegate, constraint, context.getVariables());
                break;
            }
            case SET_OPERATION: {
                LinkedList<ProcessingComponent> setDelegates = new LinkedList<ProcessingComponent>();
                for (PlanNode child : node) {
                    setDelegates.add(this.createComponent(originalQuery, context, child, columns, processingContext));
                }
                SetQuery.Operation operation = node.getProperty(PlanNode.Property.SET_OPERATION, SetQuery.Operation.class);
                boolean all = node.getProperty(PlanNode.Property.SET_USE_ALL, Boolean.class);
                boolean alreadySorted = false;
                switch (operation) {
                    case EXCEPT: {
                        component = new ExceptComponent(context, columns, setDelegates, alreadySorted, all);
                        break;
                    }
                    case INTERSECT: {
                        component = new IntersectComponent(context, columns, setDelegates, alreadySorted, all);
                        break;
                    }
                    case UNION: {
                        component = new UnionComponent(context, columns, setDelegates, alreadySorted, all);
                    }
                }
                break;
            }
            case SORT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent sortDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, processingContext);
                List<Object> orderBys = node.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class);
                if (orderBys.isEmpty()) {
                    component = sortDelegate;
                    break;
                }
                if (orderBys.get(0) instanceof Ordering) {
                    ArrayList<Ordering> orderings = new ArrayList<Ordering>(orderBys.size());
                    for (Object orderBy : orderBys) {
                        orderings.add((Ordering)orderBy);
                    }
                    HashMap<SelectorName, SelectorName> sourceNamesByAlias = new HashMap<SelectorName, SelectorName>();
                    for (PlanNode source : node.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
                        SelectorName name = source.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                        SelectorName alias = source.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
                        if (alias == null) continue;
                        sourceNamesByAlias.put(alias, name);
                    }
                    component = new SortValuesComponent(sortDelegate, orderings, sourceNamesByAlias);
                    break;
                }
                component = new SortLocationsComponent(sortDelegate);
                break;
            }
            case DEPENDENT_QUERY: {
                assert (node.getChildCount() == 2);
                PlanNode leftPlan = node.getFirstChild();
                PlanNode rightPlan = node.getLastChild();
                QueryResults.Columns leftColumns = this.createColumnsFor(leftPlan, columns);
                QueryResults.Columns rightColumns = this.createColumnsFor(rightPlan, columns);
                ProcessingComponent left = this.createComponent(originalQuery, context, leftPlan, leftColumns, processingContext);
                ProcessingComponent right = this.createComponent(originalQuery, context, rightPlan, rightColumns, processingContext);
                String leftVariableName = leftPlan.getProperty(PlanNode.Property.VARIABLE_NAME, String.class);
                String rightVariableName = rightPlan.getProperty(PlanNode.Property.VARIABLE_NAME, String.class);
                component = new DependentQueryComponent(context, left, right, leftVariableName, rightVariableName);
                break;
            }
            case SOURCE: {
                assert (false) : "Source nodes should always be below ACCESS nodes by the time a plan is executed";
                throw new UnsupportedOperationException();
            }
        }
        assert (component != null);
        return component;
    }

    protected QueryResults.Columns createColumnsFor(PlanNode node, QueryResults.Columns projectedColumns) {
        PlanNode project = node.findAtOrBelow(PlanNode.Type.PROJECT);
        assert (project != null);
        List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
        List<String> columnTypes = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
        assert (columns != null);
        assert (!columns.isEmpty());
        assert (columnTypes != null);
        assert (columnTypes.size() == columns.size());
        return new QueryResultColumns(columns, columnTypes, projectedColumns.hasFullTextSearchScores());
    }
}

