/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;

@Immutable
public class DoubleValueFactory
extends AbstractValueFactory<Double> {
    public DoubleValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.DOUBLE, decoder, stringValueFactory);
    }

    @Override
    public Double create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value.trim());
        }
        catch (NumberFormatException err) {
            throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), Double.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public Double create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public Double create(int value) {
        return value;
    }

    @Override
    public Double create(long value) {
        return new Double(value);
    }

    @Override
    public Double create(boolean value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public Double create(float value) {
        return value;
    }

    @Override
    public Double create(double value) {
        return value;
    }

    @Override
    public Double create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        double result = value.doubleValue();
        if (result == Double.NEGATIVE_INFINITY || result == Double.POSITIVE_INFINITY) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{BigDecimal.class.getSimpleName(), Double.class.getSimpleName(), value}));
        }
        return result;
    }

    @Override
    public Double create(Calendar value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTimeInMillis());
    }

    @Override
    public Double create(Date value) {
        if (value == null) {
            return null;
        }
        return this.create(value.getTime());
    }

    @Override
    public Double create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return this.create(value.getMilliseconds());
    }

    @Override
    public Double create(Name value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public Double create(Path value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public Double create(Path.Segment value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public Double create(Reference value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public Double create(URI value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public Double create(UUID value) {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), UUID.class.getSimpleName(), value}));
    }

    @Override
    public Double create(NodeKey value) throws ValueFormatException {
        throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
    }

    @Override
    public Double create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Double create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public Double create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    protected Double[] createEmptyArray(int length) {
        return new Double[length];
    }
}

