/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.basic.JodaDateTime;

@Immutable
public class StringValueFactory
extends AbstractValueFactory<String> {
    private final TextEncoder encoder;
    private final NamespaceRegistry namespaceRegistry;

    public StringValueFactory(TextDecoder decoder, TextEncoder encoder) {
        super(PropertyType.STRING, decoder, null);
        CheckArg.isNotNull((Object)encoder, (String)"encoder");
        this.encoder = encoder;
        this.namespaceRegistry = null;
    }

    public StringValueFactory(NamespaceRegistry namespaceRegistry, TextDecoder decoder, TextEncoder encoder) {
        super(PropertyType.STRING, decoder, null);
        CheckArg.isNotNull((Object)encoder, (String)"encoder");
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.encoder = encoder;
        this.namespaceRegistry = namespaceRegistry;
    }

    public TextEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    protected ValueFactory<String> getStringValueFactory() {
        return this;
    }

    @Override
    public String create(String value) {
        return value;
    }

    @Override
    public String create(String value, TextDecoder decoder) {
        if (value == null) {
            return value;
        }
        if (decoder == null) {
            decoder = this.getDecoder();
        }
        return decoder.decode(value);
    }

    @Override
    public String create(int value) {
        return Integer.toString(value);
    }

    @Override
    public String create(long value) {
        return Long.toString(value);
    }

    @Override
    public String create(boolean value) {
        return Boolean.toString(value);
    }

    @Override
    public String create(float value) {
        return Float.toString(value);
    }

    @Override
    public String create(double value) {
        return Double.toString(value);
    }

    @Override
    public String create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(Calendar value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value).getString();
    }

    @Override
    public String create(Date value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value).getString();
    }

    @Override
    public String create(DateTime value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    @Override
    public String create(Name value) {
        if (value == null) {
            return null;
        }
        if (this.namespaceRegistry != null) {
            return value.getString(this.namespaceRegistry, this.getEncoder());
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(Path value) {
        if (value == null) {
            return null;
        }
        if (value.isIdentifier()) {
            Path.Segment segment = value.getLastSegment();
            assert (segment.isIdentifier());
            try {
                return segment.getString(this.getEncoder());
            }
            catch (IllegalArgumentException err) {
                throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
            }
        }
        if (this.namespaceRegistry != null) {
            return value.getString(this.namespaceRegistry, this.getEncoder());
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(Path.Segment value) {
        if (value == null) {
            return null;
        }
        if (value.isIdentifier()) {
            try {
                return value.getName().getLocalName();
            }
            catch (IllegalArgumentException err) {
                throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
            }
        }
        if (this.namespaceRegistry != null) {
            return value.getString(this.namespaceRegistry, this.getEncoder());
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(Reference value) {
        if (value == null) {
            return null;
        }
        return value.getString(this.getEncoder());
    }

    @Override
    public String create(URI value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(UUID value) throws IoException {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(NodeKey value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String create(byte[] value) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{byte[].class.getSimpleName(), String.class.getSimpleName(), value}), err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String create(BinaryValue value) throws ValueFormatException, IoException {
        if (value == null) {
            return null;
        }
        try {
            String string;
            InputStream stream = value.getStream();
            try {
                string = this.create(stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).debug((Throwable)e, "Error closing the stream while converting from Binary to String", new Object[0]);
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    throw new IoException(e);
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).debug((Throwable)e, "Error closing the stream while converting from Binary to String", new Object[0]);
            }
            return string;
        }
        finally {
            value.dispose();
        }
    }

    @Override
    public String create(InputStream stream) throws IoException {
        if (stream == null) {
            return null;
        }
        byte[] value = null;
        try {
            value = IoUtil.readBytes((InputStream)stream);
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new ValueFormatException(value, this.getPropertyType(), GraphI18n.errorConvertingType.text(new Object[]{InputStream.class.getSimpleName(), String.class.getSimpleName(), value}), err);
        }
        catch (IOException err) {
            throw new IoException(GraphI18n.errorConvertingIo.text(new Object[]{InputStream.class.getSimpleName(), String.class.getSimpleName()}), err);
        }
    }

    protected String[] createEmptyArray(int length) {
        return new String[length];
    }
}

