/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation.spi;

import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.DocumentChanges;
import org.modeshape.jcr.federation.spi.DocumentReader;

public abstract class ReadOnlyConnector
extends Connector {
    @Override
    public final boolean removeDocument(String id) {
        String msg = JcrI18n.connectorIsReadOnly.text(new Object[]{this.getSourceName(), id});
        throw new DocumentStoreException(id, msg);
    }

    @Override
    public final void storeDocument(Document document) {
        DocumentReader reader = this.readDocument(document);
        String id = reader.getDocumentId();
        String msg = JcrI18n.connectorIsReadOnly.text(new Object[]{this.getSourceName(), id});
        throw new DocumentStoreException(id, msg);
    }

    @Override
    public final void updateDocument(DocumentChanges documentChanges) {
        String documentId = documentChanges.getDocumentId();
        String msg = JcrI18n.connectorIsReadOnly.text(new Object[]{this.getSourceName(), documentId});
        throw new DocumentStoreException(documentId, msg);
    }
}

