/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.util.Version;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.ParsingException;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.jgroups.Channel;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.LocalEnvironment;
import org.modeshape.jcr.clustering.DefaultChannelProvider;
import org.modeshape.jcr.security.AnonymousProvider;
import org.modeshape.jcr.security.JaasProvider;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.DatabaseBinaryStore;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.TransientBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.modeshape.sequencer.cnd.CndSequencer;

@Immutable
public class RepositoryConfiguration {
    public static final String ROOT_NODE_ID = "/";
    public static final String SYSTEM_WORKSPACE_NAME = "system";
    public static final String DEFAULT_JNDI_PREFIX_OF_NAME = "java:jcr/local/";
    private static final String PROJECTION_PATH_EXPRESSION_STRING = "(\\w+):((([/]([^/=]|(\\\\.))+)+)|[/])\\s*=>\\s*((([/]([^/]|(\\\\.))+)+)|[/])";
    public static final Pattern PROJECTION_PATH_EXPRESSION_PATTERN = Pattern.compile("(\\w+):((([/]([^/=]|(\\\\.))+)+)|[/])\\s*=>\\s*((([/]([^/]|(\\\\.))+)+)|[/])");
    static final int LOCK_GARBAGE_COLLECTION_SWEEP_PERIOD = 5;
    private static final TimeUnit LOCK_GARBAGE_COLLECTION_SWEEP_PERIOD_UNIT = TimeUnit.MINUTES;
    static final int LOCK_EXTENSION_INTERVAL_IN_MILLIS = (int)TimeUnit.MILLISECONDS.convert(10L, LOCK_GARBAGE_COLLECTION_SWEEP_PERIOD_UNIT);
    static final int LOCK_EXPIRY_AGE_IN_MILLIS = (int)TimeUnit.MILLISECONDS.convert(10L, LOCK_GARBAGE_COLLECTION_SWEEP_PERIOD_UNIT);
    static final int UNUSED_BINARY_VALUE_AGE_IN_MILLIS = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    static final String INITIAL_TIME_REGEX = "(\\d\\d):(\\d\\d)";
    static final Pattern INITIAL_TIME_PATTERN = Pattern.compile("(\\d\\d):(\\d\\d)");
    protected static final Document EMPTY = Schematic.newDocument();
    protected static final Map<String, String> PROVIDER_ALIASES;
    protected static final Map<String, String> SEQUENCER_ALIASES;
    protected static final Map<String, String> EXTRACTOR_ALIASES;
    protected static final Map<String, String> CONNECTOR_ALIASES;
    protected static SchemaLibrary SCHEMA_LIBRARY;
    public static final String JSON_SCHEMA_URI = "http://modeshape.org/3.0/repository-config#";
    public static final String JSON_SCHEMA_RESOURCE_PATH = "org/modeshape/jcr/repository-config-schema.json";
    private static final Logger LOGGER;
    protected static final Set<List<String>> DEPRECATED_FIELDS;
    protected static final Set<String> COMPONENT_SKIP_PROPERTIES;
    protected static final boolean JGROUPS_PRESENT;
    private final String docName;
    private final Document doc;
    private transient Environment environment = new LocalEnvironment();
    private volatile Problems problems = null;

    protected static Document replaceSystemPropertyVariables(Document doc) {
        if (doc.isEmpty()) {
            return doc;
        }
        Document modified = doc.withVariablesReplacedWithSystemProperties();
        if (modified == doc) {
            return doc;
        }
        return SCHEMA_LIBRARY.convertValues(modified, JSON_SCHEMA_URI);
    }

    public static RepositoryConfiguration read(URL url) throws ParsingException {
        Document doc = Json.read((URL)url);
        return new RepositoryConfiguration(doc, RepositoryConfiguration.withoutExtension(url.getFile()));
    }

    public static RepositoryConfiguration read(File file) throws ParsingException, FileNotFoundException {
        Document doc = Json.read((InputStream)new FileInputStream(file));
        return new RepositoryConfiguration(doc, RepositoryConfiguration.withoutExtension(file.getName()));
    }

    public static RepositoryConfiguration read(InputStream stream, String name) throws ParsingException, FileNotFoundException {
        Document doc = Json.read((InputStream)stream);
        return new RepositoryConfiguration(doc, RepositoryConfiguration.withoutExtension(name));
    }

    public static RepositoryConfiguration read(String resourcePathOrJsonContentString) throws ParsingException, FileNotFoundException {
        FileLookup factory = FileLookupFactory.newInstance();
        InputStream stream = factory.lookupFile(resourcePathOrJsonContentString, Thread.currentThread().getContextClassLoader());
        if (stream == null) {
            stream = factory.lookupFile(resourcePathOrJsonContentString, RepositoryConfiguration.class.getClassLoader());
        }
        if (stream != null) {
            Document doc = Json.read((InputStream)stream);
            return new RepositoryConfiguration(doc, RepositoryConfiguration.withoutExtension(resourcePathOrJsonContentString));
        }
        File file = new File(resourcePathOrJsonContentString);
        if (file.exists() && file.isFile()) {
            return RepositoryConfiguration.read(file);
        }
        String content = resourcePathOrJsonContentString.trim();
        if (content.startsWith("{")) {
            Document doc = Json.read((String)content);
            return new RepositoryConfiguration(doc, null);
        }
        throw new FileNotFoundException(resourcePathOrJsonContentString);
    }

    private static String withoutExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static Document ensureNamed(Document document, String documentName) {
        String name = document.getString("name");
        if (RepositoryConfiguration.isEmpty(name) && documentName != null && documentName.trim().length() != 0) {
            EditableDocument doc = Schematic.newDocument((Document)document);
            doc.setString("name", documentName);
            document = doc;
        }
        return document;
    }

    private static boolean isJGroupsInClasspath() {
        List<String> requiredJGroupsClasses = Arrays.asList("org.jgroups.JChannel", "org.jgroups.ReceiverAdapter", "org.jgroups.ChannelListener");
        try {
            ClassLoader classLoader = RepositoryConfiguration.class.getClassLoader();
            for (String jGroupsClass : requiredJGroupsClasses) {
                Class.forName(jGroupsClass, false, classLoader);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public RepositoryConfiguration() {
        this((Document)Schematic.newDocument(), null);
    }

    public RepositoryConfiguration(String name) {
        this((Document)Schematic.newDocument(), name);
    }

    public RepositoryConfiguration(Document document, String documentName) {
        Document replaced = RepositoryConfiguration.replaceSystemPropertyVariables(document);
        this.doc = RepositoryConfiguration.ensureNamed(replaced, documentName);
        this.docName = documentName;
        this.warnUseOfDeprecatedFields();
    }

    public RepositoryConfiguration(String name, Environment environment) {
        this((Document)Schematic.newDocument(), name != null ? name : "default");
        this.environment = environment;
    }

    public RepositoryConfiguration(Document document, String documentName, Environment environment) {
        Document replaced = RepositoryConfiguration.replaceSystemPropertyVariables(document);
        this.doc = RepositoryConfiguration.ensureNamed(replaced, documentName);
        this.docName = documentName;
        this.environment = environment;
        this.warnUseOfDeprecatedFields();
    }

    protected Environment environment() {
        return this.environment;
    }

    public String getName() {
        return this.doc.getString("name", this.docName);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getJndiName() {
        return this.doc.getString("jndiName", DEFAULT_JNDI_PREFIX_OF_NAME + this.getName());
    }

    public String getStoreName() {
        return this.getCacheName();
    }

    public String getCacheName() {
        Document storage = this.doc.getDocument("storage");
        if (storage != null) {
            return storage.getString("cacheName", this.getName());
        }
        return this.getName();
    }

    public String getCacheConfiguration() {
        Document storage = this.doc.getDocument("storage");
        if (storage != null) {
            return storage.getString("cacheConfiguration");
        }
        return null;
    }

    public String getWorkspaceCacheConfiguration() {
        Document storage = this.doc.getDocument("workspaces");
        if (storage != null) {
            return storage.getString("cacheConfiguration", "org/modeshape/jcr/default-workspace-cache-config.xml");
        }
        return "org/modeshape/jcr/default-workspace-cache-config.xml";
    }

    CacheContainer getContentCacheContainer() throws IOException, NamingException {
        return this.getCacheContainer(null);
    }

    CacheContainer getWorkspaceContentCacheContainer() throws IOException, NamingException {
        String config = this.getWorkspaceCacheConfiguration();
        return this.getCacheContainer(config);
    }

    protected CacheContainer getCacheContainer(String config) throws IOException, NamingException {
        if (config == null) {
            config = this.getCacheConfiguration();
        }
        return this.environment.getCacheContainer(config);
    }

    public BinaryStorage getBinaryStorage() {
        Document storage = this.doc.getDocument("storage");
        if (storage == null) {
            storage = Schematic.newDocument();
        }
        return new BinaryStorage(storage.getDocument("binaryStorage"));
    }

    public Clustering getClustering() {
        return new Clustering(this.doc.getDocument("clustering"));
    }

    public InitialContent getInitialContent() {
        return new InitialContent(this.doc.getDocument("workspaces"));
    }

    public List<String> getNodeTypes() {
        ArrayList<String> result = new ArrayList<String>();
        List configuredNodeTypes = this.doc.getArray("node-types");
        if (configuredNodeTypes != null) {
            for (Object configuredNodeType : configuredNodeTypes) {
                result.add(configuredNodeType.toString());
            }
        }
        return result;
    }

    public static String getBuiltInSequencerClassName(String alias) {
        return SEQUENCER_ALIASES.get(alias);
    }

    public static String getBuiltInTextExtractorClassName(String alias) {
        return EXTRACTOR_ALIASES.get(alias);
    }

    public static String getBuiltInAuthenticationProviderClassName(String alias) {
        return PROVIDER_ALIASES.get(alias);
    }

    public boolean isCreatingWorkspacesAllowed() {
        Document workspaces = this.doc.getDocument("workspaces");
        if (workspaces != null) {
            return workspaces.getBoolean("allowCreation", true);
        }
        return true;
    }

    public TransactionMode getTransactionMode() {
        String mode = this.doc.getString("transactionMode");
        return mode != null ? TransactionMode.valueOf(mode.trim().toUpperCase()) : Default.TRANSACTION_MODE;
    }

    public String getDefaultWorkspaceName() {
        Document workspaces = this.doc.getDocument("workspaces");
        if (workspaces != null) {
            return workspaces.getString("default", "default");
        }
        return "default";
    }

    public Set<String> getPredefinedWorkspaceNames() {
        List predefined;
        HashSet<String> names = new HashSet<String>();
        Document workspaces = this.doc.getDocument("workspaces");
        if (workspaces != null && (predefined = workspaces.getArray("predefined")) != null) {
            for (Object value : predefined) {
                if (!(value instanceof String)) continue;
                names.add((String)value);
            }
        }
        names.add(this.getDefaultWorkspaceName());
        return names;
    }

    public Set<String> getAllWorkspaceNames() {
        Set<String> names = this.getPredefinedWorkspaceNames();
        names.add(this.getDefaultWorkspaceName());
        return names;
    }

    public Security getSecurity() {
        return new Security(this.doc.getDocument("security"));
    }

    public MonitoringSystem getMonitoring() {
        return new MonitoringSystem(this.doc.getDocument("monitoring"));
    }

    public QuerySystem getQuery() {
        return new QuerySystem(this.doc.getDocument("query"));
    }

    public Sequencing getSequencing() {
        return new Sequencing(this.doc.getDocument("sequencing"));
    }

    public Federation getFederation() {
        return new Federation(this.doc);
    }

    public GarbageCollection getGarbageCollection() {
        return new GarbageCollection(this.doc.getDocument("garbageCollection"));
    }

    protected List<Component> readComponents(Document doc, String fieldName, String aliasFieldName, Map<String, String> classnamesByAlias, Problems problems) {
        ArrayList<Component> results = new ArrayList<Component>();
        Document components = doc.getDocument(fieldName);
        if (components != null) {
            boolean isArray = components instanceof List;
            for (Document.Field field : components.fields()) {
                String name;
                Object value = field.getValue();
                if (!(value instanceof Document)) continue;
                Document component = (Document)value;
                String classname = component.getString("classname");
                String classpath = component.getString("classloader");
                String string = name = isArray ? component.getString("name") : field.getName();
                if (classname != null) {
                    String resolvedClassname = classnamesByAlias.get(classname.toLowerCase());
                    if (resolvedClassname != null) {
                        classname = resolvedClassname;
                    }
                } else {
                    String aliases = this.aliasesStringFrom(classnamesByAlias);
                    problems.addError(JcrI18n.missingComponentType, new Object[]{aliases});
                }
                if (classname == null) continue;
                if (name == null) {
                    name = classname;
                }
                results.add(new Component(name, classname, classpath, component));
            }
        }
        return Collections.unmodifiableList(results);
    }

    private String aliasesStringFrom(Map<String, String> classnamesByAlias) {
        StringBuilder aliases = new StringBuilder();
        boolean first = true;
        for (String validAlias : classnamesByAlias.keySet()) {
            if (first) {
                first = false;
            } else {
                aliases.append(", ");
            }
            aliases.append('\"').append(validAlias).append('\"');
        }
        return aliases.toString();
    }

    protected Map<String, Object> readProperties(Document document, String ... skipFieldNames) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        HashSet<String> skipFields = new HashSet<String>(Arrays.asList(skipFieldNames));
        for (Document.Field field : document.fields()) {
            String name = field.getName();
            if (skipFields.contains(name)) continue;
            props.put(name, field.getValue());
        }
        return props;
    }

    protected Context jndiContext() throws NamingException {
        return new InitialContext();
    }

    public String toString() {
        return Json.write((Document)this.doc);
    }

    public Editor edit() {
        return Schematic.editDocument((Document)this.doc, (boolean)true);
    }

    public Problems validate() {
        if (this.problems == null) {
            SimpleProblems problems = new SimpleProblems();
            SchemaLibrary.Results results = SCHEMA_LIBRARY.validate(this.doc, JSON_SCHEMA_URI);
            for (SchemaLibrary.Problem problem : results) {
                switch (problem.getType()) {
                    case ERROR: {
                        problems.addError(JcrI18n.configurationError, new Object[]{problem.getPath(), problem.getReason()});
                        break;
                    }
                    case WARNING: {
                        problems.addWarning(JcrI18n.configurationWarning, new Object[]{problem.getPath(), problem.getReason()});
                    }
                }
            }
            this.getSecurity().validateCustomProviders((Problems)problems);
            this.getSequencing().validateSequencers((Problems)problems);
            this.getQuery().getTextExtracting().validateTextExtractors((Problems)problems);
            this.problems = problems;
        }
        return this.problems;
    }

    public Problems validate(Changes changes) {
        Editor copy = this.edit();
        copy.apply(changes);
        RepositoryConfiguration updated = new RepositoryConfiguration(copy.unwrap(), this.getName());
        return updated.validate();
    }

    public RepositoryConfiguration with(Environment environment) {
        return new RepositoryConfiguration(this.doc.clone(), this.docName, environment);
    }

    public RepositoryConfiguration withName(String docName) {
        return new RepositoryConfiguration(this.doc.clone(), docName, this.environment);
    }

    protected void warnUseOfDeprecatedFields() {
        for (List<String> path : DEPRECATED_FIELDS) {
            String segment;
            Document nested = this.doc;
            Object value = null;
            Iterator<String> i$ = path.iterator();
            while (i$.hasNext() && (value = nested.get(segment = i$.next())) != null) {
                if (!(value instanceof Document)) continue;
                nested = (Document)value;
            }
            if (value == null) continue;
            String p = StringUtil.join(path, (String)".");
            LOGGER.warn((I18nResource)JcrI18n.repositoryConfigurationContainsDeprecatedField, new Object[]{p, this.doc});
        }
    }

    static {
        LOGGER = Logger.getLogger(RepositoryConfiguration.class);
        JGROUPS_PRESENT = RepositoryConfiguration.isJGroupsInClasspath();
        HashSet<String> skipProps = new HashSet<String>();
        skipProps.add("classloader");
        skipProps.add("classname");
        skipProps.add("projections");
        COMPONENT_SKIP_PROPERTIES = Collections.unmodifiableSet(skipProps);
        String jaasProvider = "org.modeshape.jcr.security.JaasProvider";
        String servletProvider = "org.modeshape.jcr.security.ServletProvider";
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("jaas", jaasProvider);
        aliases.put("jaasprovider", jaasProvider);
        aliases.put("servlet", servletProvider);
        aliases.put("servlets", servletProvider);
        aliases.put("servletprovider", servletProvider);
        PROVIDER_ALIASES = Collections.unmodifiableMap(aliases);
        String cndSequencer = CndSequencer.class.getName();
        String classfileSequencer = "org.modeshape.sequencer.classfile.ClassFileSequencer";
        String ddlSequencer = "org.modeshape.sequencer.ddl.DdlSequencer";
        String imageSequencer = "org.modeshape.sequencer.image.ImageMetadataSequencer";
        String javaSequencer = "org.modeshape.sequencer.javafile.JavaFileSequencer";
        String modelSequencer = "org.modeshape.sequencer.teiid.model.ModelSequencer";
        String vdbSequencer = "org.modeshape.sequencer.teiid.VdbSequencer";
        String msofficeSequencer = "org.modeshape.sequencer.msoffice.MSOfficeMetadataSequencer";
        String wsdlSequencer = "org.modeshape.sequencer.wsdl.WsdlSequencer";
        String xsdSequencer = "org.modeshape.sequencer.xsd.XsdSequencer";
        String xmlSequencer = "org.modeshape.sequencer.xml.XmlSequencer";
        String zipSequencer = "org.modeshape.sequencer.zip.ZipSequencer";
        String mp3Sequencer = "org.modeshape.sequencer.mp3.Mp3MetadataSequencer";
        String fixedWidthTextSequencer = "org.modeshape.sequencer.text.FixedWidthTextSequencer";
        String delimitedTextSequencer = "org.modeshape.sequencer.text.DelimitedTextSequencer";
        aliases = new HashMap();
        aliases.put("cnd", cndSequencer);
        aliases.put("cndsequencer", cndSequencer);
        aliases.put("class", classfileSequencer);
        aliases.put("classfile", classfileSequencer);
        aliases.put("classsequencer", classfileSequencer);
        aliases.put("classfilesequencer", classfileSequencer);
        aliases.put("ddl", ddlSequencer);
        aliases.put("ddlsequencer", ddlSequencer);
        aliases.put("image", imageSequencer);
        aliases.put("imagesequencer", imageSequencer);
        aliases.put("java", javaSequencer);
        aliases.put("javasource", javaSequencer);
        aliases.put("javasequencer", javaSequencer);
        aliases.put("javasourcesequencer", javaSequencer);
        aliases.put("model", modelSequencer);
        aliases.put("modelsequencer", modelSequencer);
        aliases.put("vdb", vdbSequencer);
        aliases.put("vdbsequencer", vdbSequencer);
        aliases.put("msoffice", msofficeSequencer);
        aliases.put("msofficesequencer", msofficeSequencer);
        aliases.put("wsdl", wsdlSequencer);
        aliases.put("wsdlsequencer", wsdlSequencer);
        aliases.put("xsd", xsdSequencer);
        aliases.put("xsdsequencer", xsdSequencer);
        aliases.put("xml", xmlSequencer);
        aliases.put("xmlsequencer", xmlSequencer);
        aliases.put("zip", zipSequencer);
        aliases.put("zipsequencer", zipSequencer);
        aliases.put("mp3", mp3Sequencer);
        aliases.put("mp3sequencer", mp3Sequencer);
        aliases.put("fixedwidthtext", fixedWidthTextSequencer);
        aliases.put("fixedwidthtextsequencer", fixedWidthTextSequencer);
        aliases.put("delimitedtext", delimitedTextSequencer);
        aliases.put("delimitedtextsequencer", delimitedTextSequencer);
        SEQUENCER_ALIASES = Collections.unmodifiableMap(aliases);
        String fileSystemConnector = FileSystemConnector.class.getName();
        String gitConnector = "org.modeshape.connector.git.GitConnector";
        String cmisConnector = "org.modeshape.connector.cmis.CmisConnector";
        aliases = new HashMap();
        aliases.put("files", fileSystemConnector);
        aliases.put("filesystem", fileSystemConnector);
        aliases.put("filesystemconnector", fileSystemConnector);
        aliases.put("git", gitConnector);
        aliases.put("gitconnector", gitConnector);
        aliases.put("cmis", cmisConnector);
        aliases.put("cmisconnector", cmisConnector);
        CONNECTOR_ALIASES = Collections.unmodifiableMap(aliases);
        String tikaExtractor = "org.modeshape.extractor.tika.TikaTextExtractor";
        String vdbExtractor = "org.modeshape.extractor.teiid.TeiidVdbTextExtractor";
        aliases = new HashMap();
        aliases.put("tika", tikaExtractor);
        aliases.put("tikaextractor", tikaExtractor);
        aliases.put("tikatextextractor", tikaExtractor);
        aliases.put("vdb", vdbExtractor);
        aliases.put("vdbextractor", vdbExtractor);
        aliases.put("vdbtextextractor", vdbExtractor);
        EXTRACTOR_ALIASES = Collections.unmodifiableMap(aliases);
        SCHEMA_LIBRARY = Schematic.createSchemaLibrary((String)"ModeShape Repository Configuration Schemas");
        FileLookup factory = FileLookupFactory.newInstance();
        InputStream configStream = factory.lookupFile(JSON_SCHEMA_RESOURCE_PATH, RepositoryConfiguration.class.getClassLoader());
        if (configStream == null) {
            LOGGER.error((I18nResource)JcrI18n.unableToFindRepositoryConfigurationSchema, new Object[]{JSON_SCHEMA_RESOURCE_PATH});
        }
        try {
            Document configDoc = Json.read((InputStream)configStream);
            SCHEMA_LIBRARY.put(JSON_SCHEMA_URI, configDoc);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.unableToLoadRepositoryConfigurationSchema, new Object[]{JSON_SCHEMA_RESOURCE_PATH});
        }
        HashSet<List<String>> deprecatedFieldNames = new HashSet<List<String>>();
        deprecatedFieldNames.add(Collections.unmodifiableList(Arrays.asList("storage", "transactionManagerLookup")));
        deprecatedFieldNames.add(Collections.unmodifiableList(Arrays.asList("query", "indexing", "systemContentMode")));
        deprecatedFieldNames.add(Collections.unmodifiableList(Arrays.asList("query", "rebuildUponStartup")));
        DEPRECATED_FIELDS = Collections.unmodifiableSet(deprecatedFieldNames);
    }

    @Immutable
    public class Component {
        private final String name;
        private final String classname;
        private final String classpath;
        private final Document document;

        protected Component(String name, String classname, String classpath, Document document) {
            assert (classname != null);
            this.classname = classname;
            this.classpath = classpath;
            this.name = name != null ? name : classname;
            this.document = document;
        }

        public String getName() {
            return this.name;
        }

        public String getClassname() {
            return this.classname;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public Document getDocument() {
            return this.document;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Component) {
                Component that = (Component)obj;
                if (!this.getClassname().equals(that.getClassname())) {
                    return false;
                }
                if (!this.getName().equals(that.getName())) {
                    return false;
                }
                if (!ObjectUtil.isEqualWithNulls((Object)this.getClasspath(), (Object)that.getClasspath())) {
                    return false;
                }
                return this.getDocument().equals(that.getDocument());
            }
            return false;
        }

        public String toString() {
            return this.document.toString();
        }

        public <Type> Type createInstance(ClassLoader fallbackLoader) throws Exception {
            String classname = this.getClassname();
            if (AnonymousProvider.class.getName().equals(classname)) {
                return this.createAnonymousProvider();
            }
            if (JaasProvider.class.getName().equals(classname)) {
                return this.createJaasProvider();
            }
            ClassLoader classLoader = RepositoryConfiguration.this.environment().getClassLoader(fallbackLoader, this.classpath);
            return this.createGenericComponent(classLoader);
        }

        private <Type> Type createGenericComponent(ClassLoader classLoader) {
            Object instance = Util.getInstance((String)this.getClassname(), (ClassLoader)classLoader);
            if (ReflectionUtil.getField((String)"name", instance.getClass()) != null) {
                ReflectionUtil.setValue((Object)instance, (String)"name", (Object)this.getName());
            }
            this.setTypeFields(instance, this.getDocument());
            return (Type)instance;
        }

        private <Type> Type createJaasProvider() throws LoginException {
            Object value = this.document.get("policyName");
            String policyName = value instanceof String ? value.toString() : "modeshape-jcr";
            return (Type)new JaasProvider(policyName);
        }

        private <Type> Type createAnonymousProvider() {
            Object usernameValue;
            Object roles = this.document.get("roles");
            HashSet<String> roleNames = new HashSet<String>();
            if (roles instanceof Array) {
                Array roleValues = (Array)roles;
                for (Object roleName : roleValues) {
                    if (!(roleName instanceof String)) continue;
                    roleNames.add(roleName.toString());
                }
            }
            String username = (usernameValue = this.document.get("username")) instanceof String ? usernameValue.toString() : "<anonymous>";
            return (Type)new AnonymousProvider(username, roleNames);
        }

        private void setTypeFields(Object instance, Document document) {
            for (Document.Field field : document.fields()) {
                String fieldName = field.getName();
                Object fieldValue = field.getValue();
                if (COMPONENT_SKIP_PROPERTIES.contains(fieldName)) continue;
                try {
                    Field instanceField = this.findField(instance.getClass(), fieldName);
                    if (instanceField == null) {
                        LOGGER.warn((I18nResource)JcrI18n.missingFieldOnInstance, new Object[]{fieldName, this.getClassname()});
                        continue;
                    }
                    Object convertedFieldValue = this.convertValueToType(instanceField.getType(), fieldValue);
                    if (convertedFieldValue instanceof Document) {
                        Object innerInstance = instanceField.getType().newInstance();
                        this.setTypeFields(innerInstance, (Document)convertedFieldValue);
                        convertedFieldValue = innerInstance;
                    }
                    ReflectionUtil.setValue((Object)instance, (String)fieldName, (Object)convertedFieldValue);
                }
                catch (Throwable e) {
                    LOGGER.error(e, (I18nResource)JcrI18n.unableToSetFieldOnInstance, new Object[]{fieldName, fieldValue, this.getClassname()});
                }
            }
        }

        private Object convertValueToType(Class<?> expectedType, Object value) throws Exception {
            if (List.class.isAssignableFrom(expectedType)) {
                return this.valueToCollection(value, new ArrayList<Object>());
            }
            if (Set.class.isAssignableFrom(expectedType)) {
                return this.valueToCollection(value, new HashSet<Object>());
            }
            if (expectedType.isArray()) {
                return this.valueToArray(expectedType.getComponentType(), value);
            }
            if (Map.class.isAssignableFrom(expectedType)) {
                return ((Document)value).toMap();
            }
            if (value instanceof String) {
                String strValue = (String)value;
                if (Short.TYPE.isAssignableFrom(expectedType) || Short.class.isAssignableFrom(expectedType)) {
                    try {
                        return Short.parseShort(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Integer.TYPE.isAssignableFrom(expectedType) || Integer.class.isAssignableFrom(expectedType)) {
                    try {
                        return Integer.parseInt(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Long.TYPE.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType)) {
                    try {
                        return Long.parseLong(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Boolean.TYPE.isAssignableFrom(expectedType) || Boolean.class.isAssignableFrom(expectedType)) {
                    try {
                        return Boolean.parseBoolean(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Float.TYPE.isAssignableFrom(expectedType) || Float.class.isAssignableFrom(expectedType)) {
                    try {
                        return Float.valueOf(Float.parseFloat(strValue));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Double.TYPE.isAssignableFrom(expectedType) || Double.class.isAssignableFrom(expectedType)) {
                    try {
                        return Double.parseDouble(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            return value;
        }

        private Object valueToArray(Class<?> arrayComponentType, Object value) throws Exception {
            String strValue;
            if (value instanceof Array) {
                Array valueArray = (Array)value;
                int arraySize = valueArray.size();
                Object newArray = java.lang.reflect.Array.newInstance(arrayComponentType, arraySize);
                for (int i = 0; i < ((Array)value).size(); ++i) {
                    Object element = valueArray.get(i);
                    element = this.convertValueToType(arrayComponentType, element);
                    java.lang.reflect.Array.set(newArray, i, element);
                }
                return newArray;
            }
            if (value instanceof String && (strValue = (String)value).length() > 0) {
                String[] stringValues = strValue.split(",");
                Object newArray = java.lang.reflect.Array.newInstance(arrayComponentType, stringValues.length);
                for (int i = 0; i < stringValues.length; ++i) {
                    Object element = this.convertValueToType(arrayComponentType, stringValues[i]);
                    java.lang.reflect.Array.set(newArray, i, element);
                }
                return newArray;
            }
            return java.lang.reflect.Array.newInstance(arrayComponentType, 0);
        }

        private Collection<?> valueToCollection(Object value, Collection<Object> collection) throws Exception {
            if (value instanceof Array) {
                collection.addAll((List)value);
            } else {
                collection.add(value);
            }
            return collection;
        }

        private Field findField(Class<?> typeClass, String fieldName) {
            Field field = null;
            if (typeClass != null) {
                try {
                    field = typeClass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    field = this.findField(typeClass.getSuperclass(), fieldName);
                }
            }
            return field;
        }
    }

    @Immutable
    public class Clustering {
        private final Document clusteringDoc;

        public Clustering(Document clusteringDoc) {
            this.clusteringDoc = clusteringDoc != null && JGROUPS_PRESENT ? clusteringDoc : EMPTY;
        }

        public boolean isEnabled() {
            return this.clusteringDoc != EMPTY;
        }

        public String getChannelProviderClassName() {
            return this.clusteringDoc.getString("channelProvider", Default.CHANNEL_PROVIDER);
        }

        public String getClusterName() {
            return this.clusteringDoc.getString("clusterName", "ModeShape-JCR");
        }

        public String getChannelConfiguration() {
            return this.clusteringDoc.getString("channelConfiguration");
        }

        public Document getDocument() {
            return this.clusteringDoc;
        }

        public Channel getChannel() throws Exception {
            Environment env = RepositoryConfiguration.this.environment();
            if (env == null) {
                return null;
            }
            Channel channel = env.getChannel(this.getClusterName());
            return channel;
        }
    }

    @Immutable
    public class ProjectionConfiguration {
        private final String workspaceName;
        private final String externalPath;
        private final String sourceName;
        private final String pathExpression;
        private String projectedPath;

        public ProjectionConfiguration(String sourceName, String pathExpression) {
            Matcher expressionMatcher = PROJECTION_PATH_EXPRESSION_PATTERN.matcher(pathExpression);
            if (expressionMatcher.matches()) {
                this.pathExpression = pathExpression;
                this.sourceName = sourceName;
                this.workspaceName = expressionMatcher.group(1);
                this.projectedPath = expressionMatcher.group(2);
                this.projectedPath = expressionMatcher.group(2);
                if (this.projectedPath.endsWith(RepositoryConfiguration.ROOT_NODE_ID) && this.projectedPath.length() > 1) {
                    this.projectedPath = this.projectedPath.substring(0, this.projectedPath.length() - 1);
                }
            } else {
                throw new IllegalArgumentException(JcrI18n.invalidProjectionExpression.text(new Object[]{pathExpression}));
            }
            this.externalPath = expressionMatcher.group(7);
        }

        public String getExternalPath() {
            return this.externalPath;
        }

        public String getProjectedPath() {
            return this.projectedPath;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public String getAlias() {
            return this.projectedPath.substring(this.projectedPath.lastIndexOf(RepositoryConfiguration.ROOT_NODE_ID) + 1);
        }

        public String getRepositoryPath() {
            return this.projectedPath.substring(0, this.projectedPath.lastIndexOf(RepositoryConfiguration.ROOT_NODE_ID) + 1);
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String toString() {
            return this.pathExpression;
        }
    }

    @Immutable
    public class Federation {
        private final Document federation;

        protected Federation(Document federation) {
            this.federation = federation != null ? federation : EMPTY;
        }

        public List<Component> getConnectors() {
            SimpleProblems problems = new SimpleProblems();
            List<Component> components = RepositoryConfiguration.this.readComponents(this.federation, "externalSources", "classname", CONNECTOR_ALIASES, (Problems)problems);
            assert (!problems.hasErrors());
            return components;
        }

        public Map<String, List<ProjectionConfiguration>> getProjectionsByWorkspace() {
            HashMap<String, List<ProjectionConfiguration>> projectionsByWorkspace = new HashMap<String, List<ProjectionConfiguration>>();
            if (!this.federation.containsField("externalSources")) {
                return projectionsByWorkspace;
            }
            Document externalSources = this.federation.getDocument("externalSources");
            for (String sourceName : externalSources.keySet()) {
                Document externalSource = externalSources.getDocument(sourceName);
                if (!externalSource.containsField("projections")) continue;
                for (Object projectionExpression : externalSource.getArray("projections")) {
                    ProjectionConfiguration projectionConfiguration = new ProjectionConfiguration(sourceName, projectionExpression.toString());
                    String workspaceName = projectionConfiguration.getWorkspaceName();
                    ArrayList<ProjectionConfiguration> projectionsInWorkspace = (ArrayList<ProjectionConfiguration>)projectionsByWorkspace.get(workspaceName);
                    if (projectionsInWorkspace == null) {
                        projectionsInWorkspace = new ArrayList<ProjectionConfiguration>();
                        projectionsByWorkspace.put(workspaceName, projectionsInWorkspace);
                    }
                    projectionsInWorkspace.add(projectionConfiguration);
                }
            }
            return projectionsByWorkspace;
        }
    }

    @Immutable
    public class Sequencing {
        private final Document sequencing;

        protected Sequencing(Document sequencing) {
            this.sequencing = sequencing != null ? sequencing : EMPTY;
        }

        public boolean removeDerivedContentWithOriginal() {
            return this.sequencing.getBoolean("removeDerivedContentWithOriginal", true);
        }

        public String getThreadPoolName() {
            return this.sequencing.getString("threadPool", "modeshape-sequencer");
        }

        public List<Component> getSequencers() {
            SimpleProblems problems = new SimpleProblems();
            List<Component> components = RepositoryConfiguration.this.readComponents(this.sequencing, "sequencers", "classname", SEQUENCER_ALIASES, (Problems)problems);
            assert (!problems.hasErrors());
            return components;
        }

        protected void validateSequencers(Problems problems) {
            RepositoryConfiguration.this.readComponents(this.sequencing, "sequencers", "classname", SEQUENCER_ALIASES, problems);
        }
    }

    @Immutable
    public class GarbageCollection {
        private final Document gc;

        protected GarbageCollection(Document garbageCollection) {
            this.gc = garbageCollection != null ? garbageCollection : EMPTY;
        }

        public String getThreadPoolName() {
            return this.gc.getString("threadPool", "modeshape-gc");
        }

        public String getInitialTimeExpression() {
            return this.gc.getString("initialTime", "00:00");
        }

        public int getIntervalInHours() {
            return this.gc.getInteger("intervalInHours", 24);
        }

        public long getUnusedBinaryValueTimeInMillis() {
            return UNUSED_BINARY_VALUE_AGE_IN_MILLIS;
        }

        public int getLockSweepIntervalInMinutes() {
            return 5;
        }
    }

    @Immutable
    public class TextExtracting {
        private final Document textExtracting;

        public TextExtracting(Document textExtracting) {
            this.textExtracting = textExtracting != null ? textExtracting : EMPTY;
        }

        public String getThreadPoolName() {
            return this.textExtracting.getString("threadPool", "modeshape-text-extractor");
        }

        public List<Component> getTextExtractors() {
            SimpleProblems problems = new SimpleProblems();
            List<Component> components = RepositoryConfiguration.this.readComponents(this.textExtracting, "extractors", "classname", EXTRACTOR_ALIASES, (Problems)problems);
            assert (!problems.hasErrors());
            return components;
        }

        protected void validateTextExtractors(Problems problems) {
            RepositoryConfiguration.this.readComponents(this.textExtracting, "extractors", "classname", EXTRACTOR_ALIASES, problems);
        }
    }

    @Immutable
    public static class IndexRebuildOptions {
        private final QueryRebuild when;
        private final Boolean includeSystemContent;
        private final IndexingMode mode;

        protected IndexRebuildOptions(Document query) {
            assert (query != null);
            QueryRebuild defaultQueryRebuild = QueryRebuild.IF_MISSING;
            if (query.containsField("rebuildUponStartup")) {
                defaultQueryRebuild = QueryRebuild.valueOf(query.getString("rebuildUponStartup").toUpperCase());
            }
            Boolean defaultIncludeSystemContent = false;
            IndexingMode defaultIndexingMode = IndexingMode.ASYNC;
            if (query.containsField("systemContentMode")) {
                defaultIndexingMode = IndexingMode.valueOf(query.getString("systemContentMode").toUpperCase());
                switch (defaultIndexingMode) {
                    case SYNC: {
                        defaultIncludeSystemContent = true;
                        break;
                    }
                    case ASYNC: {
                        defaultIncludeSystemContent = true;
                        break;
                    }
                    case DISABLED: {
                        defaultIndexingMode = IndexingMode.SYNC;
                    }
                }
            }
            Document rebuildOnStartupDocument = null;
            if (query.containsField("indexing")) {
                Document indexingDocument = query.getDocument("indexing");
                rebuildOnStartupDocument = indexingDocument.getDocument("rebuildOnStartup");
            }
            if (rebuildOnStartupDocument == null) {
                this.when = defaultQueryRebuild;
                this.includeSystemContent = defaultIncludeSystemContent;
                this.mode = defaultIndexingMode;
            } else {
                String when = rebuildOnStartupDocument.getString("when", defaultQueryRebuild.name()).toUpperCase();
                this.when = QueryRebuild.valueOf(when);
                this.includeSystemContent = rebuildOnStartupDocument.getBoolean("includeSystemContent", defaultIncludeSystemContent.booleanValue());
                String mode = rebuildOnStartupDocument.getString("mode", defaultIndexingMode.name()).toUpperCase();
                this.mode = IndexingMode.valueOf(mode);
            }
        }

        public boolean includeSystemContent() {
            return this.includeSystemContent;
        }

        public IndexingMode getMode() {
            return this.mode;
        }

        public QueryRebuild getWhen() {
            return this.when;
        }
    }

    @Immutable
    public class QuerySystem {
        private final Document query;

        protected QuerySystem(Document query) {
            this.query = query != null ? query : EMPTY;
        }

        public boolean queriesEnabled() {
            return this.query.getBoolean("enabled", true);
        }

        public boolean fullTextSearchEnabled() {
            return this.queriesEnabled() && this.query.getBoolean("enableFullTextSearch", true);
        }

        public String getThreadPoolName() {
            return this.query.getString("threadPool", "modeshape-indexer");
        }

        public IndexRebuildOptions getIndexRebuildOptions() {
            return new IndexRebuildOptions(this.query);
        }

        public Properties getIndexStorageProperties() {
            Properties props = new Properties();
            Document doc = this.query.getDocument("indexStorage");
            if (doc != null) {
                for (Document.Field field : doc.fields()) {
                    String name = field.getName();
                    String value = field.getValue().toString();
                    props.setProperty(name, value);
                }
            }
            this.setDefProp(props, "type", "ram");
            String type = props.getProperty("type");
            if ("filesystem".equalsIgnoreCase(type)) {
                this.setDefProp(props, "lockingStrategy", Default.INDEX_STORAGE_LOCKING_STRATEGY.toString().toLowerCase());
                this.setDefProp(props, "fileSystemAccessType", Default.INDEX_STORAGE_FILE_SYSTEM_ACCESS_TYPE.toString().toLowerCase());
            } else if ("filesystem-master".equalsIgnoreCase(type)) {
                this.setDefProp(props, "lockingStrategy", Default.INDEX_STORAGE_LOCKING_STRATEGY.toString().toLowerCase());
                this.setDefProp(props, "fileSystemAccessType", Default.INDEX_STORAGE_FILE_SYSTEM_ACCESS_TYPE.toString().toLowerCase());
                this.setDefProp(props, "refreshInSeconds", "3600");
            } else if ("filesystem-slave".equalsIgnoreCase(type)) {
                this.setDefProp(props, "lockingStrategy", Default.INDEX_STORAGE_LOCKING_STRATEGY.toString().toLowerCase());
                this.setDefProp(props, "fileSystemAccessType", Default.INDEX_STORAGE_FILE_SYSTEM_ACCESS_TYPE.toString().toLowerCase());
                this.setDefProp(props, "refreshInSeconds", "3600");
                this.setDefProp(props, "copyBufferSizeInMegabytes", "16");
                this.setDefProp(props, "retryMarkerLookup", "0");
                this.setDefProp(props, "retryInitializePeriodInSeconds", "0");
            } else if ("infinispan".equalsIgnoreCase(type)) {
                this.setDefProp(props, "chunkSizeInBytes", "16834");
                this.setDefProp(props, "cacheConfiguration", RepositoryConfiguration.this.getCacheConfiguration());
            }
            return props;
        }

        public Properties getIndexingProperties() {
            Properties props = new Properties();
            Document doc = this.query.getDocument("indexing");
            if (doc != null) {
                for (Document.Field field : doc.fields()) {
                    String name = field.getName();
                    if ("backend".equals(name) || "threadPool".equals(name)) continue;
                    String value = field.getValue().toString();
                    props.setProperty(name, value);
                }
            }
            this.setDefProp(props, "analyzer", Default.INDEXING_ANALYZER);
            this.setDefProp(props, "similarity", Default.INDEXING_SIMILARITY);
            this.setDefProp(props, "batchSize", "-1");
            this.setDefProp(props, "indexFormat", Default.INDEXING_INDEX_FORMAT);
            this.setDefProp(props, "readerStrategy", Default.INDEXING_READER_STRATEGY.toString().toLowerCase());
            this.setDefProp(props, "mode", Default.INDEXING_MODE.toString().toLowerCase());
            this.setDefProp(props, "asyncThreadPoolSize", "1");
            this.setDefProp(props, "asyncMaxQueueSize", "1");
            return props;
        }

        public Properties getIndexingBackendProperties() {
            Properties props = new Properties();
            Document doc = this.query.getDocument("indexing");
            if (doc != null && (doc = doc.getDocument("backend")) != null) {
                for (Document.Field field : doc.fields()) {
                    String name = field.getName();
                    String value = field.getValue().toString();
                    props.setProperty(name, value);
                }
            }
            this.setDefProp(props, "type", "lucene");
            return props;
        }

        public TextExtracting getTextExtracting() {
            return new TextExtracting(this.query.getDocument("textExtracting"));
        }

        protected void setDefProp(Properties props, String name, String defaultValue) {
            if (!props.containsKey(name) && defaultValue != null) {
                props.setProperty(name, defaultValue);
            }
        }
    }

    public static enum TransactionMode {
        AUTO,
        NONE;

    }

    public static enum QueryRebuild {
        ALWAYS,
        NEVER,
        IF_MISSING;

    }

    @Immutable
    public class MonitoringSystem {
        private final Document monitoring;

        protected MonitoringSystem(Document monitoring) {
            this.monitoring = monitoring != null ? monitoring : EMPTY;
        }

        public boolean enabled() {
            return this.monitoring.getBoolean("enabled", true);
        }
    }

    @Immutable
    public class AnonymousSecurity {
        private final Document anonymous;

        protected AnonymousSecurity(Document anonymous) {
            assert (anonymous != null);
            this.anonymous = anonymous;
        }

        public Set<String> getAnonymousRoles() {
            HashSet<String> names = new HashSet<String>();
            Collection<Object> roles = this.anonymous.getArray("roles");
            if (roles == null) {
                roles = Default.ANONYMOUS_ROLES;
            }
            if (roles != null) {
                for (Object value : roles) {
                    if (!(value instanceof String)) continue;
                    names.add(((String)value).trim().toLowerCase());
                }
            }
            return names;
        }

        public String getAnonymousUsername() {
            return this.anonymous.getString("username", "<anonymous>");
        }

        public boolean useAnonymousOnFailedLogings() {
            return this.anonymous.getBoolean("useOnFailedLogin", false);
        }
    }

    @Immutable
    public class JaasSecurity {
        private final Document jaas;

        protected JaasSecurity(Document jaas) {
            assert (jaas != null);
            this.jaas = jaas;
        }

        public String getPolicyName() {
            String policy = this.jaas.getString("policyName", "modeshape-jcr");
            return policy != null && policy.trim().length() == 0 ? null : policy;
        }
    }

    @Immutable
    public class Security {
        private final Document security;

        protected Security(Document security) {
            this.security = security != null ? security : EMPTY;
        }

        public JaasSecurity getJaas() {
            if (this.isIncludedInCustomProviders(JaasProvider.class.getName())) {
                return null;
            }
            Document jaas = this.security.getDocument("jaas");
            return jaas != null ? new JaasSecurity(jaas) : null;
        }

        public AnonymousSecurity getAnonymous() {
            List roles;
            Document anonymous = this.security.getDocument("anonymous");
            if (anonymous != null && anonymous.size() == 1 && (roles = anonymous.getArray("roles")) != null && roles.isEmpty()) {
                return null;
            }
            if (anonymous == null) {
                anonymous = Schematic.newDocument();
            }
            return new AnonymousSecurity(anonymous);
        }

        public List<Component> getCustomProviders() {
            SimpleProblems problems = new SimpleProblems();
            List<Component> components = RepositoryConfiguration.this.readComponents(this.security, "providers", "classname", PROVIDER_ALIASES, (Problems)problems);
            assert (!problems.hasErrors());
            return components;
        }

        protected void validateCustomProviders(Problems problems) {
            RepositoryConfiguration.this.readComponents(this.security, "providers", "classname", PROVIDER_ALIASES, problems);
        }

        private boolean isIncludedInCustomProviders(String classname) {
            for (Component component : this.getCustomProviders()) {
                if (!classname.equals(component.getClassname())) continue;
                return true;
            }
            return false;
        }
    }

    @Immutable
    public class BinaryStorage {
        private String classname;
        private String classPath;
        private final Document binaryStorage;
        private final Set<String> excludeList = new HashSet<String>();

        protected BinaryStorage(Document binaryStorage) {
            this.binaryStorage = binaryStorage != null ? binaryStorage : EMPTY;
            this.excludeList.add("type");
            this.excludeList.add("classname");
            this.excludeList.add("classloader");
        }

        public long getMinimumBinarySizeInBytes() {
            return this.binaryStorage.getLong("minimumBinarySizeInBytes", 4096L);
        }

        public long getMinimumStringSize() {
            return this.binaryStorage.getLong("minimumStringSize", this.getMinimumBinarySizeInBytes());
        }

        public AbstractBinaryStore getBinaryStore() throws Exception {
            String type = this.binaryStorage.getString("type", "transient");
            AbstractBinaryStore store = null;
            if (type.equalsIgnoreCase("transient")) {
                store = TransientBinaryStore.get();
            } else if (type.equalsIgnoreCase("file")) {
                String directory = this.binaryStorage.getString("directory");
                assert (directory != null);
                File dir = new File(directory);
                store = FileSystemBinaryStore.create(dir);
            } else if (type.equalsIgnoreCase("database")) {
                String driverClass = this.binaryStorage.getString("driverClass");
                String connectionURL = this.binaryStorage.getString("url");
                String username = this.binaryStorage.getString("username");
                String password = this.binaryStorage.getString("password");
                String dataSourceJndi = this.binaryStorage.getString("dataSourceJndiName");
                store = StringUtil.isBlank((String)dataSourceJndi) ? new DatabaseBinaryStore(driverClass, connectionURL, username, password) : new DatabaseBinaryStore(dataSourceJndi);
            } else if (type.equalsIgnoreCase("cache")) {
                String metadataCacheName = this.binaryStorage.getString("metadataCacheName", RepositoryConfiguration.this.getName());
                String blobCacheName = this.binaryStorage.getString("dataCacheName", RepositoryConfiguration.this.getName());
                String cacheConfiguration = this.binaryStorage.getString("cacheConfiguration");
                boolean dedicatedCacheContainer = false;
                if (cacheConfiguration == null) {
                    cacheConfiguration = RepositoryConfiguration.this.getCacheConfiguration();
                } else {
                    dedicatedCacheContainer = true;
                }
                CacheContainer cacheContainer = RepositoryConfiguration.this.getCacheContainer(cacheConfiguration);
                store = new InfinispanBinaryStore(cacheContainer, dedicatedCacheContainer, metadataCacheName, blobCacheName);
            } else if (type.equalsIgnoreCase("custom")) {
                this.classname = this.binaryStorage.getString("classname");
                this.classPath = this.binaryStorage.getString("classloader");
                if (StringUtil.isBlank((String)this.classname)) {
                    throw new BinaryStoreException(JcrI18n.missingVariableValue.text(new Object[]{"classname"}));
                }
                store = this.createInstance();
                this.setTypeFields(store, this.binaryStorage);
            }
            if (store == null) {
                store = TransientBinaryStore.get();
            }
            store.setMinimumBinarySizeInBytes(this.getMinimumBinarySizeInBytes());
            return store;
        }

        private AbstractBinaryStore createInstance() throws Exception {
            ClassLoader classLoader = RepositoryConfiguration.this.environment().getClassLoader(this.getClass().getClassLoader(), this.classPath);
            return (AbstractBinaryStore)classLoader.loadClass(this.classname).newInstance();
        }

        private void setTypeFields(Object instance, Document document) {
            for (Document.Field field : document.fields()) {
                String fieldName = field.getName();
                Object fieldValue = field.getValue();
                if (this.excludeList.contains(fieldName)) continue;
                try {
                    Field instanceField = this.findField(instance.getClass(), fieldName);
                    if (instanceField == null) {
                        LOGGER.warn((I18nResource)JcrI18n.missingFieldOnInstance, new Object[]{fieldName, this.classname});
                        continue;
                    }
                    Object convertedFieldValue = this.convertValueToType(instanceField.getType(), fieldValue);
                    if (convertedFieldValue instanceof Document) {
                        Object innerInstance = instanceField.getType().newInstance();
                        this.setTypeFields(innerInstance, (Document)convertedFieldValue);
                        convertedFieldValue = innerInstance;
                    }
                    ReflectionUtil.setValue((Object)instance, (String)fieldName, (Object)convertedFieldValue);
                }
                catch (Throwable e) {
                    LOGGER.error(e, (I18nResource)JcrI18n.unableToSetFieldOnInstance, new Object[]{fieldName, fieldValue, this.classname});
                }
            }
        }

        private Object convertValueToType(Class<?> expectedType, Object value) throws Exception {
            if (List.class.isAssignableFrom(expectedType)) {
                return this.valueToCollection(value, new ArrayList<Object>());
            }
            if (Set.class.isAssignableFrom(expectedType)) {
                return this.valueToCollection(value, new HashSet<Object>());
            }
            if (expectedType.isArray()) {
                return this.valueToArray(expectedType.getComponentType(), value);
            }
            if (Map.class.isAssignableFrom(expectedType)) {
                return ((Document)value).toMap();
            }
            if (value instanceof String) {
                String strValue = (String)value;
                if (Short.TYPE.isAssignableFrom(expectedType) || Short.class.isAssignableFrom(expectedType)) {
                    try {
                        return Short.parseShort(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Integer.TYPE.isAssignableFrom(expectedType) || Integer.class.isAssignableFrom(expectedType)) {
                    try {
                        return Integer.parseInt(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Long.TYPE.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType)) {
                    try {
                        return Long.parseLong(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Boolean.TYPE.isAssignableFrom(expectedType) || Boolean.class.isAssignableFrom(expectedType)) {
                    try {
                        return Boolean.parseBoolean(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Float.TYPE.isAssignableFrom(expectedType) || Float.class.isAssignableFrom(expectedType)) {
                    try {
                        return Float.valueOf(Float.parseFloat(strValue));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (Double.TYPE.isAssignableFrom(expectedType) || Double.class.isAssignableFrom(expectedType)) {
                    try {
                        return Double.parseDouble(strValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            return value;
        }

        private Object valueToArray(Class<?> arrayComponentType, Object value) throws Exception {
            String strValue;
            if (value instanceof Array) {
                Array valueArray = (Array)value;
                int arraySize = valueArray.size();
                Object newArray = java.lang.reflect.Array.newInstance(arrayComponentType, arraySize);
                for (int i = 0; i < ((Array)value).size(); ++i) {
                    Object element = valueArray.get(i);
                    element = this.convertValueToType(arrayComponentType, element);
                    java.lang.reflect.Array.set(newArray, i, element);
                }
                return newArray;
            }
            if (value instanceof String && (strValue = (String)value).length() > 0) {
                String[] stringValues = strValue.split(",");
                Object newArray = java.lang.reflect.Array.newInstance(arrayComponentType, stringValues.length);
                for (int i = 0; i < stringValues.length; ++i) {
                    Object element = this.convertValueToType(arrayComponentType, stringValues[i]);
                    java.lang.reflect.Array.set(newArray, i, element);
                }
                return newArray;
            }
            return java.lang.reflect.Array.newInstance(arrayComponentType, 0);
        }

        private Collection<?> valueToCollection(Object value, Collection<Object> collection) throws Exception {
            if (value instanceof Array) {
                collection.addAll((List)value);
            } else {
                collection.add(value);
            }
            return collection;
        }

        public Field findField(Class<?> typeClass, String fieldName) {
            Field field = null;
            if (typeClass != null) {
                try {
                    field = typeClass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    field = this.findField(typeClass.getSuperclass(), fieldName);
                }
            }
            return field;
        }
    }

    @Immutable
    public class InitialContent {
        private final Map<String, String> workspacesInitialContentFiles = new HashMap<String, String>();
        private String defaultInitialContentFile = "";

        public InitialContent(Document workspaces) {
            Document initialContent;
            if (workspaces != null && (initialContent = workspaces.getDocument("initialContent")) != null) {
                this.parseInitialContent(initialContent);
            }
        }

        private void parseInitialContent(Document initialContent) {
            for (String workspaceName : initialContent.keySet()) {
                Object value = initialContent.get(workspaceName);
                if (value == null) {
                    value = "";
                }
                if (!(value instanceof String)) {
                    LOGGER.warn((I18nResource)JcrI18n.invalidInitialContentValue, new Object[]{value.toString(), workspaceName});
                    continue;
                }
                String initialContentFilePath = ((String)value).trim();
                if ("*".equals(workspaceName)) {
                    this.defaultInitialContentFile = initialContentFilePath;
                    continue;
                }
                this.workspacesInitialContentFiles.put(workspaceName, initialContentFilePath);
            }
        }

        public boolean hasInitialContentFile(String workspaceName) {
            if (this.workspacesInitialContentFiles.containsKey(workspaceName)) {
                return !StringUtil.isBlank((String)this.workspacesInitialContentFiles.get(workspaceName));
            }
            return !StringUtil.isBlank((String)this.defaultInitialContentFile);
        }

        public String getInitialContentFile(String workspaceName) {
            if (this.workspacesInitialContentFiles.containsKey(workspaceName)) {
                return this.workspacesInitialContentFiles.get(workspaceName);
            }
            return this.defaultInitialContentFile;
        }
    }

    public static enum FileSystemAccessType {
        AUTO,
        SIMPLE,
        NIO,
        MMAP;

    }

    public static enum FileSystemLockingStrategy {
        SIMPLE,
        NATIVE,
        SINGLE,
        NONE;

    }

    public static enum IndexReaderStrategy {
        SHARED,
        NOT_SHARED;

    }

    public static enum IndexingMode {
        SYNC,
        ASYNC,
        DISABLED;

    }

    public static final class FieldValue {
        public static final String INDEX_STORAGE_RAM = "ram";
        public static final String INDEX_STORAGE_FILESYSTEM = "filesystem";
        public static final String INDEX_STORAGE_FILESYSTEM_MASTER = "filesystem-master";
        public static final String INDEX_STORAGE_FILESYSTEM_SLAVE = "filesystem-slave";
        public static final String INDEX_STORAGE_INFINISPAN = "infinispan";
        public static final String INDEX_STORAGE_CUSTOM = "custom";
        public static final String INDEXING_BACKEND_TYPE_LUCENE = "lucene";
        public static final String INDEXING_BACKEND_TYPE_JMS_MASTER = "jms-master";
        public static final String INDEXING_BACKEND_TYPE_JMS_SLAVE = "jms-slave";
        public static final String INDEXING_BACKEND_TYPE_JGROUPS_MASTER = "jgroups-master";
        public static final String INDEXING_BACKEND_TYPE_JGROUPS_SLAVE = "jgroups-slave";
        public static final String INDEXING_BACKEND_TYPE_BLACKHOLE = "blackhole";
        public static final String INDEXING_BACKEND_TYPE_CUSTOM = "custom";
        public static final String BINARY_STORAGE_TYPE_FILE = "file";
        public static final String BINARY_STORAGE_TYPE_CACHE = "cache";
        public static final String BINARY_STORAGE_TYPE_DATABASE = "database";
        public static final String BINARY_STORAGE_TYPE_CUSTOM = "custom";
    }

    public static class Default {
        public static final long MINIMUM_BINARY_SIZE_IN_BYTES = 4096L;
        public static final boolean ALLOW_CREATION = true;
        public static final String DEFAULT = "default";
        public static final TransactionMode TRANSACTION_MODE = TransactionMode.AUTO;
        public static final String JAAS_POLICY_NAME = "modeshape-jcr";
        public static final Set<String> ANONYMOUS_ROLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("admin")));
        public static final String WORKSPACE_CACHE_CONFIGURATION = "org/modeshape/jcr/default-workspace-cache-config.xml";
        public static final boolean USE_ANONYMOUS_ON_FAILED_LOGINS = false;
        public static final String ANONYMOUS_USERNAME = "<anonymous>";
        public static final boolean QUERY_ENABLED = true;
        public static final boolean FULL_TEXT_SEARCH_ENABLED = true;
        public static final boolean MONITORING_ENABLED = true;
        public static final boolean REMOVE_DERIVED_CONTENT_WITH_ORIGINAL = true;
        public static final String SEQUENCING_POOL = "modeshape-sequencer";
        public static final String QUERY_THREAD_POOL = "modeshape-indexer";
        public static final String GARBAGE_COLLECTION_POOL = "modeshape-gc";
        public static final String INDEXING_ANALYZER = StandardAnalyzer.class.getName();
        public static final String INDEXING_SIMILARITY = DefaultSimilarity.class.getName();
        public static final String INDEXING_BATCH_SIZE = "-1";
        public static final String INDEXING_INDEX_FORMAT = Version.LUCENE_CURRENT.name();
        public static final IndexReaderStrategy INDEXING_READER_STRATEGY = IndexReaderStrategy.SHARED;
        public static final IndexingMode INDEXING_MODE = IndexingMode.SYNC;
        public static final IndexingMode INDEXING_MODE_SYSTEM_CONTENT = IndexingMode.DISABLED;
        public static final String INDEXING_ASYNC_THREAD_POOL_SIZE = "1";
        public static final String INDEXING_ASYNC_MAX_QUEUE_SIZE = "1";
        public static final FileSystemLockingStrategy INDEX_STORAGE_LOCKING_STRATEGY = FileSystemLockingStrategy.NATIVE;
        public static final FileSystemAccessType INDEX_STORAGE_FILE_SYSTEM_ACCESS_TYPE = FileSystemAccessType.AUTO;
        public static final String INDEX_STORAGE_REFRESH_IN_SECONDS = "3600";
        public static final String INDEX_STORAGE_COPY_BUFFER_SIZE_IN_MEGABYTES = "16";
        public static final String INDEX_STORAGE_RETRY_MARKER_LOOKUP = "0";
        public static final String INDEX_STORAGE_RETRY_INITIALIZE_PERIOD_IN_SECONDS = "0";
        public static final String INDEX_STORAGE_INFINISPAN_CHUNK_SIZE_IN_BYTES = "16834";
        public static final String INDEXING_BACKEND_TYPE = "lucene";
        public static final String CLUSTER_NAME = "ModeShape-JCR";
        public static final String CHANNEL_PROVIDER = DefaultChannelProvider.class.getName();
        public static final String INITIAL_TIME = "00:00";
        public static final int INTERVAL_IN_HOURS = 24;
    }

    public static class FieldName {
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String JNDI_NAME = "jndiName";
        public static final String TRANSACTION_MODE = "transactionMode";
        public static final String MONITORING = "monitoring";
        public static final String MONITORING_ENABLED = "enabled";
        public static final String STORAGE = "storage";
        public static final String CACHE_NAME = "cacheName";
        public static final String CACHE_CONFIGURATION = "cacheConfiguration";
        @Deprecated
        public static final String CACHE_TRANSACTION_MANAGER_LOOKUP = "transactionManagerLookup";
        public static final String MINIMUM_BINARY_SIZE_IN_BYTES = "minimumBinarySizeInBytes";
        public static final String MINIMUM_STRING_SIZE = "minimumStringSize";
        public static final String WORKSPACES = "workspaces";
        public static final String PREDEFINED = "predefined";
        public static final String ALLOW_CREATION = "allowCreation";
        public static final String INITIAL_CONTENT = "initialContent";
        public static final String NODE_TYPES = "node-types";
        public static final String DEFAULT_INITIAL_CONTENT = "*";
        public static final String DEFAULT = "default";
        public static final String WORKSPACE_CACHE_CONFIGURATION = "cacheConfiguration";
        public static final String BINARY_STORAGE = "binaryStorage";
        public static final String SECURITY = "security";
        public static final String JAAS = "jaas";
        public static final String JAAS_POLICY_NAME = "policyName";
        public static final String ANONYMOUS = "anonymous";
        public static final String ANONYMOUS_ROLES = "roles";
        public static final String ANONYMOUS_USERNAME = "username";
        public static final String USER_NAME = "username";
        public static final String USER_PASSWORD = "password";
        public static final String USE_ANONYMOUS_ON_FAILED_LOGINS = "useOnFailedLogin";
        public static final String PROVIDERS = "providers";
        public static final String TYPE = "type";
        public static final String DIRECTORY = "directory";
        public static final String CLASSLOADER = "classloader";
        public static final String CLASSNAME = "classname";
        public static final String DATA_SOURCE_JNDI_NAME = "dataSourceJndiName";
        public static final String DATA_CACHE_NAME = "dataCacheName";
        public static final String FULL_TEXT_SEARCH_ENABLED = "enableFullTextSearch";
        public static final String METADATA_CACHE_NAME = "metadataCacheName";
        public static final String QUERY = "query";
        public static final String QUERY_ENABLED = "enabled";
        public static final String INDEX_STORAGE = "indexStorage";
        public static final String INDEXING = "indexing";
        public static final String INDEXING_BACKEND = "backend";
        public static final String TABLES_INCLUDE_INHERITED_COLUMNS = "tablesIncludeInheritedColumns";
        public static final String TEXT_EXTRACTING = "textExtracting";
        public static final String EXTRACTORS = "extractors";
        public static final String SEQUENCING = "sequencing";
        public static final String SEQUENCERS = "sequencers";
        public static final String EXTERNAL_SOURCES = "externalSources";
        public static final String PROJECTIONS = "projections";
        public static final String PATH_EXPRESSION = "pathExpression";
        public static final String PATH_EXPRESSIONS = "pathExpressions";
        public static final String JDBC_DRIVER_CLASS = "driverClass";
        public static final String CONNECTION_URL = "url";
        public static final String GARBAGE_COLLECTION = "garbageCollection";
        public static final String INITIAL_TIME = "initialTime";
        public static final String INTERVAL_IN_HOURS = "intervalInHours";
        public static final String THREAD_POOL = "threadPool";
        public static final String REMOVE_DERIVED_CONTENT_WITH_ORIGINAL = "removeDerivedContentWithOriginal";
        public static final String INDEXING_ANALYZER = "analyzer";
        public static final String INDEXING_ANALYZER_CLASSPATH = "analyzerClasspath";
        public static final String INDEXING_SIMILARITY = "similarity";
        public static final String INDEXING_BATCH_SIZE = "batchSize";
        public static final String INDEXING_INDEX_FORMAT = "indexFormat";
        public static final String INDEXING_READER_STRATEGY = "readerStrategy";
        public static final String INDEXING_MODE = "mode";
        public static final String INDEXING_ASYNC_THREAD_POOL_SIZE = "asyncThreadPoolSize";
        public static final String INDEXING_ASYNC_MAX_QUEUE_SIZE = "asyncMaxQueueSize";
        public static final String INDEX_STORAGE_LOCATION = "location";
        public static final String INDEX_STORAGE_SOURCE_LOCATION = "sourceLocation";
        public static final String INDEX_STORAGE_LOCKING_STRATEGY = "lockingStrategy";
        public static final String INDEX_STORAGE_FILE_SYSTEM_ACCESS_TYPE = "fileSystemAccessType";
        public static final String INDEX_STORAGE_REFRESH_IN_SECONDS = "refreshInSeconds";
        public static final String INDEX_STORAGE_COPY_BUFFER_SIZE_IN_MEGABYTES = "copyBufferSizeInMegabytes";
        public static final String INDEX_STORAGE_RETRY_MARKER_LOOKUP = "retryMarkerLookup";
        public static final String INDEX_STORAGE_RETRY_INITIALIZE_PERIOD_IN_SECONDS = "retryInitializePeriodInSeconds";
        public static final String INDEX_STORAGE_INFINISPAN_LOCK_CACHE = "lockCacheName";
        public static final String INDEX_STORAGE_INFINISPAN_DATA_CACHE = "dataCacheName";
        public static final String INDEX_STORAGE_INFINISPAN_META_CACHE = "metadataCacheName";
        public static final String INDEX_STORAGE_INFINISPAN_CONTAINER = "cacheConfiguration";
        public static final String INDEX_STORAGE_INFINISPAN_CHUNK_SIZE_IN_BYTES = "chunkSizeInBytes";
        public static final String INDEXING_BACKEND_JMS_CONNECTION_FACTORY_JNDI_NAME = "connectionFactoryJndiName";
        public static final String INDEXING_BACKEND_JMS_QUEUE_JNDI_NAME = "queueJndiName";
        public static final String INDEXING_BACKEND_JGROUPS_CHANNEL_NAME = "channelName";
        public static final String INDEXING_BACKEND_JGROUPS_CHANNEL_CONFIGURATION = "channelConfiguration";
        @Deprecated
        public static final String REBUILD_UPON_STARTUP = "rebuildUponStartup";
        @Deprecated
        public static final String INDEXING_MODE_SYSTEM_CONTENT = "systemContentMode";
        public static final String REBUILD_ON_STARTUP = "rebuildOnStartup";
        public static final String REBUILD_WHEN = "when";
        public static final String REBUILD_INCLUDE_SYSTEM_CONTENT = "includeSystemContent";
        public static final String REBUILD_MODE = "mode";
        public static final String CLUSTERING = "clustering";
        public static final String CLUSTER_NAME = "clusterName";
        public static final String CHANNEL_PROVIDER = "channelProvider";
        public static final String CHANNEL_CONFIGURATION = "channelConfiguration";
    }
}

