/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.schematic.DocumentFactory;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Null;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.DocumentConstants;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.ImmutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.StringReference;
import org.modeshape.jcr.value.basic.UuidReference;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.EmptyBinaryValue;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;

public class DocumentTranslator
implements DocumentConstants {
    private final DocumentStore documentStore;
    private final AtomicLong largeStringSize = new AtomicLong();
    private final ExecutionContext context;
    private final PropertyFactory propertyFactory;
    private final ValueFactories factories;
    private final PathFactory paths;
    private final NameFactory names;
    private final DateTimeFactory dates;
    private final BinaryFactory binaries;
    private final ValueFactory<Long> longs;
    private final ValueFactory<Double> doubles;
    private final ValueFactory<URI> uris;
    private final ValueFactory<BigDecimal> decimals;
    private final ValueFactory<String> strings;
    private final ReferenceFactory refs;
    private final ReferenceFactory weakrefs;
    private final UuidFactory uuids;
    private final TextEncoder encoder = NoOpEncoder.getInstance();
    private final TextDecoder decoder = NoOpEncoder.getInstance();

    public DocumentTranslator(ExecutionContext context, DocumentStore documentStore, long largeStringSize) {
        this.documentStore = documentStore;
        this.largeStringSize.set(largeStringSize);
        this.context = context;
        this.propertyFactory = this.context.getPropertyFactory();
        this.factories = this.context.getValueFactories();
        this.paths = this.factories.getPathFactory();
        this.names = this.factories.getNameFactory();
        this.dates = this.factories.getDateFactory();
        this.binaries = this.factories.getBinaryFactory();
        this.longs = this.factories.getLongFactory();
        this.doubles = this.factories.getDoubleFactory();
        this.uris = this.factories.getUriFactory();
        this.decimals = this.factories.getDecimalFactory();
        this.refs = this.factories.getReferenceFactory();
        this.weakrefs = this.factories.getWeakReferenceFactory();
        this.uuids = this.factories.getUuidFactory();
        this.strings = this.factories.getStringFactory();
        assert (this.largeStringSize.get() >= 0L);
    }

    public final ValueFactory<String> getStringFactory() {
        return this.strings;
    }

    public final NameFactory getNameFactory() {
        return this.names;
    }

    public final ReferenceFactory getReferenceFactory() {
        return this.refs;
    }

    public final ReferenceFactory getWeakReferenceFactory() {
        return this.weakrefs;
    }

    public final PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    void setMinimumStringLengthForBinaryStorage(long largeValueSize) {
        assert (largeValueSize > -1L);
        this.largeStringSize.set(largeValueSize);
    }

    public NodeKey getParentKey(Document document, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        Object value = document.get("parent");
        return this.keyFrom(value, primaryWorkspaceKey, secondaryWorkspaceKey);
    }

    public Set<NodeKey> getParentKeys(Document document, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        Object value = document.get("parent");
        if (value instanceof String) {
            return Collections.emptySet();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return Collections.emptySet();
            }
            LinkedHashSet<NodeKey> keys = new LinkedHashSet<NodeKey>();
            Iterator iter = values.iterator();
            iter.next();
            while (iter.hasNext()) {
                String key;
                NodeKey nodeKey;
                String workspaceKey;
                Object v = iter.next();
                if (v == null || !(workspaceKey = (nodeKey = new NodeKey(key = (String)v)).getWorkspaceKey()).equals(primaryWorkspaceKey) && !workspaceKey.equals(secondaryWorkspaceKey)) continue;
                keys.add(nodeKey);
            }
            return keys;
        }
        return Collections.emptySet();
    }

    private final NodeKey keyFrom(Object value, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        if (value instanceof String) {
            return new NodeKey((String)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return this.keyFrom(values.get(0), primaryWorkspaceKey, secondaryWorkspaceKey);
            }
            NodeKey keyWithSecondaryWorkspaceKey = null;
            for (Object v : values) {
                if (v == null) continue;
                NodeKey key = new NodeKey((String)v);
                if (key.getWorkspaceKey().equals(primaryWorkspaceKey)) {
                    return key;
                }
                if (keyWithSecondaryWorkspaceKey != null || secondaryWorkspaceKey == null || !key.getWorkspaceKey().equals(secondaryWorkspaceKey)) continue;
                keyWithSecondaryWorkspaceKey = key;
            }
            return keyWithSecondaryWorkspaceKey;
        }
        return null;
    }

    public void getProperties(Document document, Map<Name, Property> result) {
        Document properties = document.getDocument("properties");
        if (properties != null) {
            for (Document.Field nsField : properties.fields()) {
                String namespaceUri = nsField.getName();
                Document nsDoc = nsField.getValueAsDocument();
                for (Document.Field propField : nsDoc.fields()) {
                    String localName = propField.getName();
                    Name propertyName = this.names.create(namespaceUri, localName);
                    if (result.containsKey(propertyName)) continue;
                    Object fieldValue = propField.getValue();
                    Property property = this.propertyFor(propertyName, fieldValue);
                    result.put(propertyName, property);
                }
            }
        }
    }

    public int countProperties(Document document) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return 0;
        }
        int count = 0;
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean hasProperties(Document document) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return false;
        }
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProperty(Document document, Name propertyName) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return false;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return false;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return !Null.matches((Object)fieldValue);
    }

    public Property getProperty(Document document, String propertyName) {
        return this.getProperty(document, (Name)this.names.create(propertyName));
    }

    public Property getProperty(Document document, Name propertyName) {
        Document properties = document.getDocument("properties");
        if (properties == null) {
            return null;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return null;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    public Name getPrimaryType(Document document) {
        return (Name)this.names.create(this.getProperty(document, JcrLexicon.PRIMARY_TYPE).getFirstValue());
    }

    public String getPrimaryTypeName(Document document) {
        return this.strings.create(this.getProperty(document, JcrLexicon.PRIMARY_TYPE).getFirstValue());
    }

    public Set<Name> getMixinTypes(Document document) {
        Property prop = this.getProperty(document, JcrLexicon.MIXIN_TYPES);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        if (prop.size() == 1) {
            Name name = (Name)this.names.create(prop.getFirstValue());
            return Collections.singleton(name);
        }
        HashSet<Name> result = new HashSet<Name>();
        for (Object value : prop) {
            Name name = (Name)this.names.create(value);
            result.add(name);
        }
        return result;
    }

    public Set<String> getMixinTypeNames(Document document) {
        Property prop = this.getProperty(document, JcrLexicon.MIXIN_TYPES);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        if (prop.size() == 1) {
            String name = this.strings.create(prop.getFirstValue());
            return Collections.singleton(name);
        }
        HashSet<String> result = new HashSet<String>();
        for (Object value : prop) {
            String name = this.strings.create(value);
            result.add(name);
        }
        return result;
    }

    protected Property propertyFor(Name propertyName, Object fieldValue) {
        Object value = this.valueFromDocument(fieldValue);
        if (value instanceof List) {
            List values = (List)value;
            return this.propertyFactory.create(propertyName, values);
        }
        return this.propertyFactory.create(propertyName, value);
    }

    public void setProperty(EditableDocument document, Property property, Set<BinaryKey> unusedBinaryKeys) {
        Name propertyName;
        String namespaceUri;
        EditableDocument urlProps;
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            properties = document.setDocument("properties");
        }
        if ((urlProps = properties.getDocument(namespaceUri = (propertyName = property.getName()).getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        String localName = propertyName.getLocalName();
        Object oldValue = urlProps.get(localName);
        this.decrementBinaryReferenceCount(oldValue, unusedBinaryKeys);
        if (property.isEmpty()) {
            urlProps.setArray(localName);
        } else if (property.isMultiple()) {
            EditableArray values = Schematic.newArray((int)property.size());
            for (Object v : property) {
                values.add(this.valueToDocument(v, unusedBinaryKeys));
            }
            urlProps.setArray(localName, (Array)values);
        } else {
            assert (property.isSingle());
            Object value = this.valueToDocument(property.getFirstValue(), unusedBinaryKeys);
            if (value == null) {
                urlProps.remove(localName);
            } else {
                urlProps.set(localName, value);
            }
        }
    }

    public Property removeProperty(EditableDocument document, Name propertyName, Set<BinaryKey> unusedBinaryKeys) {
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            return null;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return null;
        }
        String localName = propertyName.getLocalName();
        Object fieldValue = urlProps.remove(localName);
        this.decrementBinaryReferenceCount(fieldValue, unusedBinaryKeys);
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    public void addPropertyValues(EditableDocument document, Name propertyName, boolean isMultiple, Collection<?> values, Set<BinaryKey> unusedBinaryKeys) {
        String localName;
        Object propValue;
        String namespaceUri;
        EditableDocument urlProps;
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            properties = document.setDocument("properties");
        }
        if ((urlProps = properties.getDocument(namespaceUri = propertyName.getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        if ((propValue = urlProps.get(localName = propertyName.getLocalName())) == null) {
            if (isMultiple || numValues > 1) {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    array.addValue(this.valueToDocument(value, unusedBinaryKeys));
                }
                urlProps.setArray(localName, (Array)array);
            } else {
                urlProps.set(localName, this.valueToDocument(values.iterator().next(), unusedBinaryKeys));
            }
        } else if (propValue instanceof List) {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys);
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, unusedBinaryKeys);
                array.addValueIfAbsent(value);
            }
        } else {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys);
            if (numValues == 1) {
                Object value = this.valueToDocument(values.iterator().next(), unusedBinaryKeys);
                if (!value.equals(propValue)) {
                    EditableArray array = Schematic.newArray((Object[])new Object[]{value, propValue});
                    urlProps.setArray(localName, (Array)array);
                }
            } else {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    if ((value = this.valueToDocument(value, unusedBinaryKeys)).equals(propValue)) continue;
                    array.addValue(value);
                }
                assert (!array.isEmpty());
                urlProps.setArray(localName, (Array)array);
            }
        }
    }

    public void removePropertyValues(EditableDocument document, Name propertyName, Collection<?> values, Set<BinaryKey> unusedBinaryKeys) {
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument("properties");
        if (properties == null) {
            return;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return;
        }
        String localName = propertyName.getLocalName();
        Object propValue = urlProps.get(localName);
        if (propValue instanceof List) {
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, unusedBinaryKeys);
                array.remove(value);
            }
        } else if (propValue != null) {
            for (Object value : values) {
                if (!(value = this.valueToDocument(value, unusedBinaryKeys)).equals(propValue)) continue;
                urlProps.remove(localName);
                break;
            }
        }
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
    }

    public void setParents(EditableDocument document, NodeKey parent, NodeKey oldParent, SessionNode.ChangedAdditionalParents additionalParents) {
        Object existingParent = document.get("parent");
        if (existingParent == null) {
            if (parent != null) {
                if (additionalParents == null || additionalParents.isEmpty()) {
                    document.setString("parent", parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)(additionalParents.additionCount() + 1));
                    parents.add((Object)parent.toString());
                    for (NodeKey added : additionalParents.getAdditions()) {
                        parents.add((Object)added.toString());
                    }
                    document.set("parent", (Object)parents);
                }
            } else if (additionalParents != null && !additionalParents.isEmpty()) {
                EditableArray parents = Schematic.newArray((int)additionalParents.additionCount());
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set("parent", (Object)parents);
            }
            return;
        }
        if (existingParent instanceof List) {
            EditableArray parents = document.getArray("parent");
            if (parent != null && !parent.equals(oldParent)) {
                parents.addStringIfAbsent(parent.toString());
                if (oldParent != null) {
                    parents.remove((Object)oldParent.toString());
                }
            }
            if (additionalParents != null) {
                for (NodeKey removedParent : additionalParents.getRemovals()) {
                    if (removedParent.equals(parent)) continue;
                    parents.remove((Object)removedParent.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.addStringIfAbsent(added.toString());
                }
            }
        } else if (existingParent instanceof String) {
            String existing = (String)existingParent;
            if (parent != null && (additionalParents == null || additionalParents.isEmpty())) {
                String oldParentStr;
                String string = oldParentStr = oldParent != null ? oldParent.toString() : null;
                if (existing.equals(oldParentStr)) {
                    document.set("parent", (Object)parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)2);
                    parents.add((Object)existing);
                    parents.add((Object)parent.toString());
                    document.set("parent", (Object)parents);
                }
            } else {
                int totalNumber = additionalParents.additionCount() - additionalParents.removalCount() + 1;
                assert (totalNumber >= 0);
                EditableArray parents = Schematic.newArray((int)totalNumber);
                if (parent != null && !existingParent.equals(parent.toString())) {
                    parents.add((Object)parent.toString());
                } else {
                    parents.add(existingParent);
                }
                for (NodeKey removed : additionalParents.getRemovals()) {
                    parents.remove((Object)removed.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set("parent", (Object)parents);
            }
        }
    }

    public void setKey(EditableDocument document, NodeKey key) {
        assert (document.getString("key") == null);
        document.setString("key", key.toString());
    }

    public void setKey(EditableDocument document, String key) {
        assert (key != null);
        document.setString("key", key);
    }

    public String getKey(Document document) {
        return document.getString("key");
    }

    public void changeChildren(EditableDocument document, SessionNode.ChangedChildren changedChildren, ChildReferences appended) {
        assert (changedChildren != null || appended != null);
        ChildReferencesInfo info = this.getChildReferencesInfo((Document)document);
        long newTotalSize = 0L;
        EditableDocument doc = document;
        EditableDocument lastDoc = document;
        String lastDocKey = null;
        if (changedChildren != null && !changedChildren.isEmpty()) {
            Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
            Set<NodeKey> removals = changedChildren.getRemovals();
            Map<NodeKey, Name> newNames = changedChildren.getNewNames();
            while (doc != null) {
                ChildReferencesInfo docInfo;
                if (this.isFederatedDocument((Document)doc) && !removals.isEmpty()) {
                    HashSet<String> removalsStrings = new HashSet<String>();
                    for (NodeKey key : removals) {
                        if (key.toString().startsWith(this.documentStore.getLocalSourceKey())) continue;
                        removalsStrings.add(key.toString());
                    }
                    this.removeFederatedSegments(doc, removalsStrings);
                }
                long blockCount = this.insertChildren(doc, insertionsByBeforeKey, removals, newNames);
                newTotalSize += blockCount;
                SchematicEntry nextEntry = null;
                ChildReferencesInfo childReferencesInfo = docInfo = doc == document ? info : this.getChildReferencesInfo((Document)doc);
                if (docInfo != null && docInfo.nextKey != null) {
                    nextEntry = this.documentStore.get(docInfo.nextKey);
                }
                if (nextEntry != null) {
                    doc.getDocument("childrenInfo").setNumber("blockSize", blockCount);
                    lastDoc = doc = nextEntry.editDocumentContent();
                    assert (docInfo != null);
                    lastDocKey = docInfo.nextKey;
                    continue;
                }
                if (doc == document && doc.containsField("childrenInfo")) {
                    EditableDocument childInfo = doc.getDocument("childrenInfo");
                    childInfo.remove("blockSize");
                    childInfo.set("count", (Object)newTotalSize);
                }
                doc = null;
            }
        } else {
            long l = newTotalSize = info != null ? info.totalSize : 0L;
        }
        if (appended != null && appended.size() != 0L) {
            String lastKey;
            String string = lastKey = info != null ? info.lastKey : null;
            if (lastKey != null && !lastKey.equals(lastDocKey)) {
                SchematicEntry lastBlockEntry = this.documentStore.get(lastKey);
                lastDoc = lastBlockEntry.editDocumentContent();
            } else {
                lastKey = null;
            }
            EditableArray lastChildren = lastDoc.getOrCreateArray("children");
            for (ChildReference ref : appended) {
                lastChildren.add((Object)this.fromChildReference(ref));
            }
            if (lastDoc != document) {
                EditableDocument lastDocInfo = lastDoc.getOrCreateDocument("childrenInfo");
                lastDocInfo.setNumber("blockSize", lastChildren.size());
            }
            EditableDocument childInfo = document.getOrCreateDocument("childrenInfo");
            childInfo.setNumber("count", newTotalSize += appended.size());
            if (lastKey != null) {
                childInfo.setString("lastBlock", lastKey);
            }
        }
    }

    protected long insertChildren(EditableDocument document, Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey, Set<NodeKey> removals, Map<NodeKey, Name> newNames) {
        EditableArray children = document.getArray("children");
        if (children == null) {
            return 0L;
        }
        EditableArray newChildren = Schematic.newArray((int)children.size());
        for (Object value : children) {
            ChildReference ref = this.childReferenceFrom(value);
            if (ref == null) continue;
            NodeKey childKey = ref.getKey();
            SessionNode.Insertions insertions = insertionsByBeforeKey.remove(childKey);
            if (insertions != null) {
                for (ChildReference inserted : insertions.inserted()) {
                    newChildren.add((Object)this.fromChildReference(inserted));
                }
            }
            if (removals.remove(childKey)) continue;
            Name newName = newNames.get(childKey);
            if (newName != null) {
                ChildReference newRef = ref.with(newName, 1);
                value = this.fromChildReference(newRef);
            }
            newChildren.add(value);
        }
        document.set("children", (Object)newChildren);
        return newChildren.size();
    }

    public ChildReferences getChildReferences(WorkspaceCache cache, Document document) {
        List children = document.getArray("children");
        List externalSegments = document.getArray("federatedSegments");
        if (children == null && externalSegments == null) {
            return ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        }
        List<ChildReference> internalChildRefsList = this.childReferencesListFromArray(children);
        List<ChildReference> externalChildRefsList = this.childReferencesListFromArray(externalSegments);
        ChildReferencesInfo info = this.getChildReferencesInfo(document);
        if (info != null) {
            ChildReferences internalChildRefs = ImmutableChildReferences.create(internalChildRefsList);
            ChildReferences externalChildRefs = ImmutableChildReferences.create(externalChildRefsList);
            return ImmutableChildReferences.create(internalChildRefs, info, externalChildRefs, cache);
        }
        if (externalSegments != null) {
            internalChildRefsList.addAll(externalChildRefsList);
        }
        return ImmutableChildReferences.create(internalChildRefsList);
    }

    public ChildReferences getChildReferencesFromBlock(Document block) {
        List children = block.getArray("children");
        if (children == null) {
            return ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        }
        return ImmutableChildReferences.create(this.childReferencesListFromArray(children));
    }

    private List<ChildReference> childReferencesListFromArray(List<?> children) {
        if (children == null) {
            return new ArrayList<ChildReference>();
        }
        ArrayList<ChildReference> childRefsList = new ArrayList<ChildReference>(children.size());
        for (Object value : children) {
            ChildReference ref = this.childReferenceFrom(value);
            if (ref == null) continue;
            childRefsList.add(ref);
        }
        return childRefsList;
    }

    public ChildReferencesInfo getChildReferencesInfo(Document document) {
        Document childrenInfo = document.getDocument("childrenInfo");
        if (childrenInfo != null) {
            long totalSize = childrenInfo.getLong("count", 0L);
            long blockSize = childrenInfo.getLong("blockSize", 0L);
            String nextBlockKey = childrenInfo.getString("nextBlock");
            String lastBlockKey = childrenInfo.getString("lastBlock", nextBlockKey);
            return new ChildReferencesInfo(totalSize, blockSize, nextBlockKey, lastBlockKey);
        }
        return null;
    }

    protected ChildReference childReferenceFrom(Object value) {
        if (value instanceof Document) {
            Document doc = (Document)value;
            String keyStr = doc.getString("key");
            NodeKey key = new NodeKey(keyStr);
            String nameStr = doc.getString("name");
            Name name = (Name)this.names.create(nameStr, this.decoder);
            return new ChildReference(key, name, 1);
        }
        return null;
    }

    public EditableDocument fromChildReference(ChildReference ref) {
        return Schematic.newDocument((String)"key", (Object)this.valueToDocument(ref.getKey(), null), (String)"name", (Object)this.strings.create(ref.getName()));
    }

    public Set<NodeKey> getReferrers(Document document, CachedNode.ReferenceType type) {
        Document weak;
        Document strong;
        Document referrers = document.getDocument("referrers");
        if (referrers == null) {
            return new HashSet<NodeKey>();
        }
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        if (type != CachedNode.ReferenceType.WEAK && (strong = referrers.getDocument("strong")) != null) {
            for (String keyString : strong.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        if (type != CachedNode.ReferenceType.STRONG && (weak = referrers.getDocument("weak")) != null) {
            for (String keyString : weak.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        return result;
    }

    public void changeReferrers(EditableDocument document, SessionNode.ReferrerChanges changes) {
        List<NodeKey> weakRemoved;
        Map<NodeKey, Integer> weakCount;
        if (changes.isEmpty()) {
            return;
        }
        EditableDocument referrers = document.getDocument("referrers");
        List<NodeKey> strongAdded = changes.getAddedReferrers(CachedNode.ReferenceType.STRONG);
        List<NodeKey> weakAdded = changes.getAddedReferrers(CachedNode.ReferenceType.WEAK);
        if (referrers == null) {
            referrers = document.setDocument("referrers");
            if (!strongAdded.isEmpty()) {
                HashSet<NodeKey> strongAddedSet = new HashSet<NodeKey>(strongAdded);
                EditableDocument strong = referrers.setDocument("strong");
                for (NodeKey key : strongAddedSet) {
                    strong.set(key.toString(), (Object)Collections.frequency(strongAdded, key));
                }
            }
            if (!weakAdded.isEmpty()) {
                HashSet<NodeKey> weakAddedSet = new HashSet<NodeKey>(weakAdded);
                EditableDocument weak = referrers.setDocument("weak");
                for (NodeKey key : weakAddedSet) {
                    weak.set(key.toString(), (Object)Collections.frequency(weakAdded, key));
                }
            }
            return;
        }
        List<NodeKey> strongRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.STRONG);
        Map<NodeKey, Integer> strongCount = this.computeReferrersCountDelta(strongAdded, strongRemoved);
        if (!strongCount.isEmpty()) {
            EditableDocument strong = referrers.getOrCreateDocument("strong");
            this.updateReferrers(strong, strongCount);
        }
        if (!(weakCount = this.computeReferrersCountDelta(weakAdded, weakRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.WEAK))).isEmpty()) {
            EditableDocument weak = referrers.getOrCreateDocument("weak");
            this.updateReferrers(weak, weakCount);
        }
    }

    private void updateReferrers(EditableDocument owningDocument, Map<NodeKey, Integer> referrersCountDelta) {
        for (NodeKey strongKey : referrersCountDelta.keySet()) {
            int newCount = referrersCountDelta.get(strongKey);
            String keyString = strongKey.toString();
            Integer existingCount = (Integer)owningDocument.get(keyString);
            if (existingCount != null) {
                int actualCount = existingCount + newCount;
                if (actualCount <= 0) {
                    owningDocument.remove(keyString);
                    continue;
                }
                owningDocument.set(keyString, (Object)actualCount);
                continue;
            }
            if (newCount <= 0) continue;
            owningDocument.set(keyString, (Object)newCount);
        }
    }

    private Map<NodeKey, Integer> computeReferrersCountDelta(List<NodeKey> addedReferrers, List<NodeKey> removedReferrers) {
        HashMap<NodeKey, Integer> referrersCountDelta = new HashMap<NodeKey, Integer>(0);
        HashSet<NodeKey> addedReferrersUnique = new HashSet<NodeKey>(addedReferrers);
        for (NodeKey addedReferrer : addedReferrersUnique) {
            int referrersCount = Collections.frequency(addedReferrers, addedReferrer) - Collections.frequency(removedReferrers, addedReferrer);
            referrersCountDelta.put(addedReferrer, referrersCount);
        }
        HashSet<NodeKey> removedReferrersUnique = new HashSet<NodeKey>(removedReferrers);
        for (NodeKey removedReferrer : removedReferrersUnique) {
            if (referrersCountDelta.containsKey(removedReferrer)) continue;
            referrersCountDelta.put(removedReferrer, -1 * Collections.frequency(removedReferrers, removedReferrer));
        }
        return referrersCountDelta;
    }

    protected Object valueToDocument(Object value, Set<BinaryKey> unusedBinaryKeys) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueStr = (String)value;
            if ((long)valueStr.length() < this.largeStringSize.get()) {
                return value;
            }
            value = this.binaries.create(valueStr);
        }
        if (value instanceof NodeKey) {
            return ((NodeKey)value).toString();
        }
        if (value instanceof UUID) {
            return Schematic.newDocument((String)"$uuid", (Object)this.strings.create((UUID)value));
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Name) {
            Name name = (Name)value;
            return Schematic.newDocument((String)"$name", (Object)name.getString(this.encoder));
        }
        if (value instanceof Path) {
            Path path = (Path)value;
            EditableArray segments = Schematic.newArray((int)path.size());
            for (Path.Segment segment : path) {
                String str = segment.getString(this.encoder);
                segments.add(str);
            }
            boolean relative = !path.isAbsolute();
            return Schematic.newDocument((String)"$path", (Object)segments, (String)"$relative", (Object)relative);
        }
        if (value instanceof DateTime) {
            return Schematic.newDocument((String)"$date", (Object)this.strings.create((DateTime)value));
        }
        if (value instanceof BigDecimal) {
            return Schematic.newDocument((String)"$dec", (Object)this.strings.create((BigDecimal)value));
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String key = ref.isWeak() ? "$wref" : "$ref";
            String refString = value instanceof NodeKeyReference ? ((NodeKeyReference)value).getNodeKey().toString() : this.strings.create(ref);
            boolean isForeign = value instanceof NodeKeyReference && ((NodeKeyReference)value).isForeign();
            return Schematic.newDocument((String)key, (Object)refString, (String)"$foreign", (Object)isForeign);
        }
        if (value instanceof URI) {
            return Schematic.newDocument((String)"$uri", (Object)this.strings.create((URI)value));
        }
        if (value instanceof ExternalBinaryValue) {
            ExternalBinaryValue externalBinaryValue = (ExternalBinaryValue)value;
            return Schematic.newDocument((String)"$externalBinaryId", (Object)externalBinaryValue.getId(), (String)"$sourceName", (Object)externalBinaryValue.getSourceName());
        }
        if (value instanceof BinaryValue) {
            BinaryValue binary = (BinaryValue)value;
            if (binary instanceof InMemoryBinaryValue) {
                return new Binary(((InMemoryBinaryValue)binary).getBytes());
            }
            String sha1 = binary.getHexHash();
            long size = binary.getSize();
            EditableDocument ref = Schematic.newDocument((String)"$sha1", (Object)sha1, (String)"$len", (Object)size);
            this.incrementBinaryReferenceCount(binary.getKey(), unusedBinaryKeys);
            return ref;
        }
        assert (false) : "Unexpected property value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    protected final String keyForBinaryReferenceDocument(String sha1) {
        return sha1 + "-ref";
    }

    protected void incrementBinaryReferenceCount(BinaryKey binaryKey, Set<BinaryKey> unusedBinaryKeys) {
        String sha1 = binaryKey.toString();
        String key = this.keyForBinaryReferenceDocument(sha1);
        SchematicEntry entry = this.documentStore.get(key);
        if (entry == null) {
            EditableDocument content = Schematic.newDocument((String)"sha1", (Object)sha1, (String)"refCount", (Object)1L);
            this.documentStore.localStore().put(key, (Document)content);
        } else {
            EditableDocument sha1Usage;
            Long countValue = (sha1Usage = entry.editDocumentContent()).getLong("refCount");
            sha1Usage.setNumber("refCount", countValue != null ? countValue + 1L : 1L);
        }
        if (unusedBinaryKeys != null) {
            unusedBinaryKeys.remove(binaryKey);
        }
    }

    protected boolean decrementBinaryReferenceCount(Object fieldValue, Set<BinaryKey> unusedBinaryKeys) {
        Document docValue;
        String sha1;
        if (fieldValue instanceof List) {
            for (Object value : (List)fieldValue) {
                this.decrementBinaryReferenceCount(value, unusedBinaryKeys);
            }
        } else if (fieldValue instanceof Document && (sha1 = (docValue = (Document)fieldValue).getString("sha1")) != null) {
            SchematicEntry entry = this.documentStore.get(sha1 + "-usage");
            EditableDocument sha1Usage = entry.editDocumentContent();
            Long countValue = sha1Usage.getLong("refCount");
            if (countValue == null) {
                return true;
            }
            long count = countValue - 1L;
            if (count < 0L) {
                count = 0L;
                if (unusedBinaryKeys != null) {
                    unusedBinaryKeys.add(new BinaryKey(sha1));
                }
            }
            sha1Usage.setNumber("refCount", count);
            return count <= 1L;
        }
        return false;
    }

    public Object valueFromDocument(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            return this.binaries.create(binary.getBytes());
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return this.uris.create(uri);
        }
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>(values.size());
            for (Object val : values) {
                result.add(this.valueFromDocument(val));
            }
            return result;
        }
        if (value instanceof Document) {
            Document doc = (Document)value;
            String valueStr = null;
            List array = null;
            valueStr = doc.getString("$name");
            if (!Null.matches((Object)valueStr)) {
                return this.names.create(valueStr, this.decoder);
            }
            array = doc.getArray("$path");
            if (!Null.matches((Object)array)) {
                List<Path.Segment> segments = this.segmentsFrom(array);
                boolean relative = doc.getBoolean("$relative");
                return relative ? this.paths.createRelativePath(segments) : this.paths.createAbsolutePath(segments);
            }
            valueStr = doc.getString("$date");
            if (!Null.matches((Object)valueStr)) {
                return this.dates.create(valueStr);
            }
            valueStr = doc.getString("$dec");
            if (!Null.matches((Object)valueStr)) {
                return this.decimals.create(valueStr);
            }
            valueStr = doc.getString("$ref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.refs, doc, valueStr);
            }
            valueStr = doc.getString("$wref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.weakrefs, doc, valueStr);
            }
            valueStr = doc.getString("$uuid");
            if (!Null.matches((Object)valueStr)) {
                return this.uuids.create(valueStr);
            }
            valueStr = doc.getString("$uri");
            if (!Null.matches((Object)valueStr)) {
                return this.uris.create(valueStr);
            }
            valueStr = doc.getString("$externalBinaryId");
            if (!Null.matches((Object)valueStr)) {
                String sourceName = doc.getString("$sourceName");
                ExternalBinaryValue externalBinaryValue = this.documentStore.getExternalBinary(sourceName, valueStr);
                return externalBinaryValue != null ? externalBinaryValue : EmptyBinaryValue.INSTANCE;
            }
            valueStr = doc.getString("$sha1");
            if (!Null.matches((Object)valueStr)) {
                long size = doc.getLong("$len");
                try {
                    return this.binaries.find(new BinaryKey(valueStr), size);
                }
                catch (BinaryStoreException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }
        if (value instanceof Integer) {
            return this.longs.create(((Integer)value).longValue());
        }
        if (value instanceof Float) {
            return this.doubles.create(((Float)value).doubleValue());
        }
        assert (false) : "Unexpected document value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    private Object createReferenceFromString(ReferenceFactory referenceFactory, Document doc, String valueStr) {
        boolean isForeign = doc.getBoolean("$foreign");
        if (NodeKey.isValidFormat(valueStr)) {
            return referenceFactory.create(new NodeKey(valueStr), isForeign);
        }
        try {
            UUID uuid = UUID.fromString(valueStr);
            return this.refs.create(new UuidReference(uuid));
        }
        catch (IllegalArgumentException e) {
            return this.refs.create(new StringReference(valueStr));
        }
    }

    protected List<Path.Segment> segmentsFrom(List<?> segmentValues) {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentValues.size());
        for (Object value : segmentValues) {
            Path.Segment segment = this.paths.createSegment(value.toString(), this.decoder);
            segments.add(segment);
        }
        return segments;
    }

    protected Object resolveLargeValue(String sha1) {
        SchematicEntry entry = this.documentStore.get(sha1);
        if (entry == null) {
            return null;
        }
        if (entry.hasBinaryContent()) {
            return this.binaries.create(entry.getContentAsBinary().getBytes());
        }
        Document largeValueDoc = entry.getContentAsDocument();
        return largeValueDoc.getString("value");
    }

    public boolean isLocked(EditableDocument doc) {
        return this.hasProperty((Document)doc, JcrLexicon.LOCK_OWNER) || this.hasProperty((Document)doc, JcrLexicon.LOCK_IS_DEEP);
    }

    protected boolean isFederatedDocument(Document document) {
        return document.containsField("federatedSegments");
    }

    protected void removeFederatedSegments(EditableDocument federatedDocument, Set<String> externalNodeKeys) {
        if (!federatedDocument.containsField("federatedSegments")) {
            return;
        }
        EditableArray federatedSegments = federatedDocument.getArray("federatedSegments");
        for (int i = 0; i < federatedSegments.size(); ++i) {
            Object federatedSegment = federatedSegments.get(i);
            assert (federatedSegment instanceof Document);
            String segmentKey = this.getKey((Document)federatedSegment);
            if (!externalNodeKeys.contains(segmentKey)) continue;
            federatedSegments.remove(i);
        }
        if (federatedSegments.isEmpty()) {
            federatedDocument.remove("federatedSegments");
        }
    }

    protected boolean isQueryable(Document document) {
        return document.getBoolean("$queryable", true);
    }

    public void setQueryable(EditableDocument document, boolean queryable) {
        document.set("$queryable", (Object)queryable);
    }

    protected void addFederatedSegment(EditableDocument document, String externalNodeKey, String name) {
        EditableArray federatedSegmentsArray = document.getArray("federatedSegments");
        if (federatedSegmentsArray == null) {
            federatedSegmentsArray = Schematic.newArray();
            document.set("federatedSegments", (Object)federatedSegmentsArray);
        }
        if (!StringUtil.isBlank((String)externalNodeKey)) {
            EditableDocument federatedSegment = DocumentFactory.newDocument((String)"key", (Object)externalNodeKey, (String)"name", (Object)name);
            federatedSegmentsArray.add((Object)federatedSegment);
        }
    }

    protected Integer getCacheTtlSeconds(Document document) {
        return document.getInteger("cacheTtlSeconds");
    }

    @Immutable
    public static class ChildReferencesInfo {
        public final long totalSize;
        public final long blockSize;
        public final String nextKey;
        public final String lastKey;

        public ChildReferencesInfo(long totalSize, long blockSize, String nextKey, String lastKey) {
            this.totalSize = totalSize;
            this.blockSize = blockSize;
            this.nextKey = nextKey;
            this.lastKey = lastKey;
        }

        public String toString() {
            return "totalSize: " + this.totalSize + "; blockSize: " + this.blockSize + "; nextKey: " + this.nextKey + "; lastKey: " + this.lastKey;
        }
    }
}

