/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;

public final class NodeCacheIterator
implements Iterator<NodeKey> {
    private final Queue<NodeKey> keys = new LinkedList<NodeKey>();
    private final NodeCache cache;
    private NodeKey nextNode;

    public NodeCacheIterator(NodeCache cache, NodeKey startingNode) {
        CheckArg.isNotNull((Object)cache, (String)"cache");
        CheckArg.isNotNull((Object)startingNode, (String)"startingNode");
        this.cache = cache;
        this.keys.add(startingNode);
    }

    @Override
    public boolean hasNext() {
        this.nextNode();
        return this.nextNode != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeKey next() {
        if (this.nextNode == null) {
            this.nextNode();
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
        }
        try {
            NodeKey nodeKey = this.nextNode;
            return nodeKey;
        }
        finally {
            this.nextNode = null;
        }
    }

    protected void nextNode() {
        NodeKey nextKey;
        CachedNode node;
        do {
            if ((nextKey = this.keys.poll()) != null) continue;
            this.nextNode = null;
            return;
        } while ((node = this.cache.getNode(nextKey)) == null);
        Iterator<NodeKey> iter = node.getChildReferences(this.cache).getAllKeys();
        while (iter.hasNext()) {
            this.keys.add(iter.next());
        }
        this.nextNode = nextKey;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

