/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.List;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrI18n;

class JMSMasterIndexingListener
implements MessageListener,
ExceptionListener {
    private static final Logger LOGGER = Logger.getLogger(JMSMasterIndexingListener.class);
    private static final String CONNECTION_LOGIN = "worker.jms.login";
    private static final String CONNECTION_PASSWORD = "worker.jms.password";
    private final Properties configuration;
    private QueueConnection queueConnection;
    private IndexManagerHolder allIndexManager;

    JMSMasterIndexingListener(Properties configuration) {
        this.configuration = configuration;
    }

    void start(IndexManagerHolder allIndexManager) {
        this.allIndexManager = allIndexManager;
        QueueConnectionFactory connectionFactory = this.getConnectionFactory();
        Queue queue = this.getQueue();
        try {
            this.queueConnection = this.establishConnection(connectionFactory);
            this.startSession(queue);
        }
        catch (JMSException e) {
            LOGGER.error((Throwable)e.getLinkedException(), (I18nResource)JcrI18n.errorWhileStartingUpListener, new Object[]{e.getErrorCode(), e.getMessage()});
        }
        LOGGER.debug("Started JMS indexing listener on master node...", new Object[0]);
    }

    private void startSession(Queue queue) throws JMSException {
        QueueSession queueSession = this.queueConnection.createQueueSession(false, 1);
        QueueReceiver queueReceiver = queueSession.createReceiver(queue);
        queueReceiver.setMessageListener((MessageListener)this);
        this.queueConnection.setExceptionListener((ExceptionListener)this);
        this.queueConnection.start();
    }

    public void onMessage(Message message) {
        LOGGER.trace("Received JMS message", new Object[0]);
        if (!(message instanceof ObjectMessage)) {
            LOGGER.error((I18nResource)JcrI18n.incorrectJMSMessageType, new Object[]{ObjectMessage.class.getName(), message.getClass().getName()});
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            String indexName = objectMessage.getStringProperty("HSearchIndexName");
            IndexManager indexManager = this.allIndexManager.getIndexManager(indexName);
            if (indexManager == null) {
                LOGGER.warn((I18nResource)JcrI18n.unknownIndexName, new Object[]{indexName});
                return;
            }
            List workQueue = indexManager.getSerializer().toLuceneWorks((byte[])objectMessage.getObject());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Received " + workQueue.size() + " lucene work item(s) from JMS message. Submitting to the index manager", new Object[0]);
            }
            indexManager.performOperations(workQueue, null);
        }
        catch (JMSException e) {
            LOGGER.error((Throwable)e.getLinkedException(), (I18nResource)JcrI18n.cannotReadJMSMessage, new Object[]{e.getErrorCode(), e.getMessage()});
        }
    }

    public void onException(JMSException exception) {
        LOGGER.error((Throwable)exception.getLinkedException(), (I18nResource)JcrI18n.unexpectedJMSException, new Object[]{exception.getErrorCode(), exception.getMessage()});
    }

    void shutdown() {
        LOGGER.debug("Stopping JMS indexing listener on master node...", new Object[0]);
        try {
            this.queueConnection.close();
            this.allIndexManager = null;
            this.queueConnection = null;
        }
        catch (JMSException e) {
            LOGGER.error((Throwable)e.getLinkedException(), (I18nResource)JcrI18n.errorWhileShuttingDownListener, new Object[]{e.getErrorCode(), e.getMessage()});
        }
    }

    private QueueConnectionFactory getConnectionFactory() {
        String connectionFactoryJndiName = this.configuration.getProperty("connectionFactoryJndiName");
        try {
            InitialContext initialContext = new InitialContext(this.configuration);
            return (QueueConnectionFactory)initialContext.lookup(connectionFactoryJndiName);
        }
        catch (NamingException e) {
            throw new ConfigurationException(JcrI18n.cannotLocateConnectionFactory.text(new Object[]{connectionFactoryJndiName}));
        }
    }

    private Queue getQueue() {
        String queueJndiName = this.configuration.getProperty("queueJndiName");
        try {
            InitialContext initialContext = new InitialContext(this.configuration);
            return (Queue)initialContext.lookup(queueJndiName);
        }
        catch (NamingException e) {
            throw new ConfigurationException(JcrI18n.cannotLocateConnectionFactory.text(new Object[]{queueJndiName}));
        }
    }

    private QueueConnection establishConnection(QueueConnectionFactory factory) throws JMSException {
        String login = this.configuration.getProperty(CONNECTION_LOGIN);
        String password = this.configuration.getProperty(CONNECTION_PASSWORD);
        if (StringUtil.isBlank((String)login) && StringUtil.isBlank((String)password)) {
            return factory.createQueueConnection();
        }
        return factory.createQueueConnection(login, password);
    }
}

