/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.lucene.basic.DynamicField;
import org.modeshape.jcr.query.lucene.basic.DynamicFieldBridge;

@Immutable
@Indexed(index="nodeinfo")
public class NodeInfo {
    @DocumentId(name="::id")
    private final String id;
    @Field(name="::wks", analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    private final String workspace;
    @Field(name="::pth", analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    private final String path;
    @Field(name="::nam", analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    private final String name;
    @Field(name="::loc", analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    private final String localName;
    @Field(name="::sns", analyze=Analyze.NO, store=Store.YES, index=Index.YES)
    @NumericField(forField="::sns")
    private final int snsIndex;
    @Field(name="::dep", analyze=Analyze.NO, store=Store.NO, index=Index.YES)
    @NumericField(forField="::dep")
    private final int depth;
    @Field(analyze=Analyze.YES, store=Store.NO)
    @FieldBridge(impl=DynamicFieldBridge.class)
    private final DynamicField firstDynamicField;

    public NodeInfo(String nodeKey, String workspace, String path, String localName, String name, int snsIndex, int depth, DynamicField firstDynamicField) {
        this.id = nodeKey;
        this.workspace = workspace;
        this.path = path;
        this.name = name;
        this.localName = localName;
        this.snsIndex = snsIndex;
        this.depth = depth;
        this.firstDynamicField = firstDynamicField;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getSnsIndex() {
        return this.snsIndex;
    }

    public int getDepth() {
        return this.depth;
    }

    public DynamicField getFirstDynamicField() {
        return this.firstDynamicField;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return this.id + " @ " + this.path + " in '" + this.workspace + "' with " + this.firstDynamicField;
    }
}

