/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.AbstractValueFactory;
import org.modeshape.jcr.value.basic.UuidReference;

@Immutable
public class UuidValueFactory
extends AbstractValueFactory<UUID>
implements UuidFactory {
    public UuidValueFactory(TextDecoder decoder, ValueFactories factories) {
        super(PropertyType.UUID, decoder, factories);
    }

    @Override
    public UuidFactory with(ValueFactories valueFactories) {
        return this.valueFactories == valueFactories ? this : new UuidValueFactory(super.getDecoder(), valueFactories);
    }

    @Override
    public UUID create() {
        return UUID.randomUUID();
    }

    @Override
    public UUID create(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException err) {
            throw new ValueFormatException((Object)value, PropertyType.UUID, GraphI18n.errorConvertingType.text(new Object[]{String.class.getSimpleName(), URI.class.getSimpleName(), value}), err);
        }
    }

    @Override
    public UUID create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public UUID create(int value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Integer.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(long value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Long.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(boolean value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Boolean.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(float value) {
        throw new ValueFormatException(Float.valueOf(value), PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Float.class.getSimpleName(), Float.valueOf(value)}));
    }

    @Override
    public UUID create(double value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Double.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(BigDecimal value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), BigDecimal.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Calendar value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Calendar.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Date value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Date.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(DateTime value) throws ValueFormatException {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), DateTime.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Name value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Name.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Path value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Path.Segment value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(Reference value) {
        if (value instanceof UuidReference) {
            UuidReference ref = (UuidReference)value;
            return ref.getUuid();
        }
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), Reference.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(URI value) {
        throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), URI.class.getSimpleName(), value}));
    }

    @Override
    public UUID create(UUID value) {
        return value;
    }

    @Override
    public UUID create(NodeKey value) throws ValueFormatException {
        if (value == null) {
            return null;
        }
        try {
            return UUID.fromString(value.getIdentifier());
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException(value, PropertyType.UUID, GraphI18n.unableToCreateValue.text(new Object[]{this.getPropertyType().getName(), NodeKey.class.getSimpleName(), value}));
        }
    }

    @Override
    public UUID create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public UUID create(BinaryValue value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public UUID create(InputStream stream) throws IoException {
        return this.create(this.getStringValueFactory().create(stream));
    }

    public UUID[] createEmptyArray(int length) {
        return new UUID[length];
    }
}

