/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.util.HashSet;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.BinaryValueUsed;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class BinaryUsageChangeSetListener
implements ChangeSetListener {
    private final BinaryStore store;
    private final Logger logger;

    public BinaryUsageChangeSetListener(BinaryStore store) {
        this.store = store;
        assert (this.store != null);
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    public void notify(ChangeSet changeSet) {
        HashSet<BinaryKey> unusedKeys = null;
        HashSet<BinaryKey> usedKeys = null;
        for (Change change : changeSet) {
            BinaryKey key;
            if (change instanceof BinaryValueUnused) {
                BinaryValueUnused unused = (BinaryValueUnused)change;
                key = unused.getKey();
                if (usedKeys != null && usedKeys.remove(key)) break;
                if (unusedKeys == null) {
                    unusedKeys = new HashSet<BinaryKey>();
                }
                unusedKeys.add(key);
                continue;
            }
            if (!(change instanceof BinaryValueUsed)) continue;
            BinaryValueUsed used = (BinaryValueUsed)change;
            key = used.getKey();
            if (unusedKeys != null && unusedKeys.remove(key)) break;
            if (usedKeys == null) {
                usedKeys = new HashSet<BinaryKey>();
            }
            usedKeys.add(key);
        }
        if (unusedKeys != null && !unusedKeys.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Marking binary values as unused: ", new Object[]{unusedKeys});
            }
            try {
                this.store.markAsUnused((Iterable<BinaryKey>)unusedKeys);
            }
            catch (BinaryStoreException e) {
                this.logger.error((I18nResource)JcrI18n.errorMarkingBinaryValuesUnused, new Object[]{e.getMessage()});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished marking binary values as unused: ", new Object[]{unusedKeys});
            }
        }
        if (usedKeys != null && !usedKeys.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Marking binary values as used: ", new Object[]{unusedKeys});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished marking binary values as used: ", new Object[]{unusedKeys});
            }
        }
    }
}

