/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.Readable;

@Immutable
public class SelectorName
implements Readable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    public SelectorName(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String getString() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SelectorName) {
            SelectorName that = (SelectorName)obj;
            return this.name.equals(that.name());
        }
        return false;
    }

    public static Set<SelectorName> nameSetFrom(SelectorName name) {
        if (name == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(name);
    }

    public static Set<SelectorName> nameSetFrom(SelectorName firstName, SelectorName ... names) {
        if (firstName == null && (names == null || names.length == 0)) {
            return Collections.emptySet();
        }
        LinkedHashSet<SelectorName> result = new LinkedHashSet<SelectorName>();
        result.add(firstName);
        for (SelectorName name : names) {
            if (name == null) continue;
            result.add(name);
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<SelectorName> nameSetFrom(Set<SelectorName> firstSet, Set<SelectorName> secondSet) {
        if ((firstSet == null || firstSet.isEmpty()) && (secondSet == null || secondSet.isEmpty())) {
            return Collections.emptySet();
        }
        LinkedHashSet<SelectorName> result = new LinkedHashSet<SelectorName>();
        result.addAll(firstSet);
        if (secondSet != null) {
            result.addAll(secondSet);
        }
        return Collections.unmodifiableSet(result);
    }
}

